/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIpSetsResponse extends Wafv2Response implements
        ToCopyableBuilder<ListIpSetsResponse.Builder, ListIpSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListIpSetsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<IPSetSummary>> IP_SETS_FIELD = SdkField
            .<List<IPSetSummary>> builder(MarshallingType.LIST)
            .memberName("IPSets")
            .getter(getter(ListIpSetsResponse::ipSets))
            .setter(setter(Builder::ipSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IPSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            IP_SETS_FIELD));

    private final String nextMarker;

    private final List<IPSetSummary> ipSets;

    private ListIpSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ipSets = builder.ipSets;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
     * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
     * retrieve the next batch of objects, provide the marker from the prior call in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are
     *         still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the
     *         response. To retrieve the next batch of objects, provide the marker from the prior call in your next
     *         request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the IPSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpSets() {
        return ipSets != null && !(ipSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of IPSets. This may not be the full list of IPSets that you have defined. See the <code>Limit</code>
     * specification for this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpSets} method.
     * </p>
     * 
     * @return Array of IPSets. This may not be the full list of IPSets that you have defined. See the
     *         <code>Limit</code> specification for this request.
     */
    public final List<IPSetSummary> ipSets() {
        return ipSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpSets() ? ipSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIpSetsResponse)) {
            return false;
        }
        ListIpSetsResponse other = (ListIpSetsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasIpSets() == other.hasIpSets()
                && Objects.equals(ipSets(), other.ipSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIpSetsResponse").add("NextMarker", nextMarker())
                .add("IPSets", hasIpSets() ? ipSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "IPSets":
            return Optional.ofNullable(clazz.cast(ipSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIpSetsResponse, T> g) {
        return obj -> g.apply((ListIpSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListIpSetsResponse> {
        /**
         * <p>
         * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
         * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
         * retrieve the next batch of objects, provide the marker from the prior call in your next request.
         * </p>
         * 
         * @param nextMarker
         *        When you request a list of objects with a <code>Limit</code> setting, if the number of objects that
         *        are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in
         *        the response. To retrieve the next batch of objects, provide the marker from the prior call in your
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * Array of IPSets. This may not be the full list of IPSets that you have defined. See the <code>Limit</code>
         * specification for this request.
         * </p>
         * 
         * @param ipSets
         *        Array of IPSets. This may not be the full list of IPSets that you have defined. See the
         *        <code>Limit</code> specification for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(Collection<IPSetSummary> ipSets);

        /**
         * <p>
         * Array of IPSets. This may not be the full list of IPSets that you have defined. See the <code>Limit</code>
         * specification for this request.
         * </p>
         * 
         * @param ipSets
         *        Array of IPSets. This may not be the full list of IPSets that you have defined. See the
         *        <code>Limit</code> specification for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(IPSetSummary... ipSets);

        /**
         * <p>
         * Array of IPSets. This may not be the full list of IPSets that you have defined. See the <code>Limit</code>
         * specification for this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<IPSetSummary>.Builder} avoiding the
         * need to create one manually via {@link List<IPSetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IPSetSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipSets(List<IPSetSummary>)}.
         * 
         * @param ipSets
         *        a consumer that will call methods on {@link List<IPSetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSets(List<IPSetSummary>)
         */
        Builder ipSets(Consumer<IPSetSummary.Builder>... ipSets);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String nextMarker;

        private List<IPSetSummary> ipSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIpSetsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            ipSets(model.ipSets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<IPSetSummary.Builder> getIpSets() {
            List<IPSetSummary.Builder> result = IPSetSummariesCopier.copyToBuilder(this.ipSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpSets(Collection<IPSetSummary.BuilderImpl> ipSets) {
            this.ipSets = IPSetSummariesCopier.copyFromBuilder(ipSets);
        }

        @Override
        public final Builder ipSets(Collection<IPSetSummary> ipSets) {
            this.ipSets = IPSetSummariesCopier.copy(ipSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(IPSetSummary... ipSets) {
            ipSets(Arrays.asList(ipSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(Consumer<IPSetSummary.Builder>... ipSets) {
            ipSets(Stream.of(ipSets).map(c -> IPSetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIpSetsResponse build() {
            return new ListIpSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
