/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutManagedRuleSetVersionsRequest extends Wafv2Request implements
        ToCopyableBuilder<PutManagedRuleSetVersionsRequest.Builder, PutManagedRuleSetVersionsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutManagedRuleSetVersionsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(PutManagedRuleSetVersionsRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PutManagedRuleSetVersionsRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockToken").getter(getter(PutManagedRuleSetVersionsRequest::lockToken))
            .setter(setter(Builder::lockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()).build();

    private static final SdkField<String> RECOMMENDED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendedVersion").getter(getter(PutManagedRuleSetVersionsRequest::recommendedVersion))
            .setter(setter(Builder::recommendedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedVersion").build())
            .build();

    private static final SdkField<Map<String, VersionToPublish>> VERSIONS_TO_PUBLISH_FIELD = SdkField
            .<Map<String, VersionToPublish>> builder(MarshallingType.MAP)
            .memberName("VersionsToPublish")
            .getter(getter(PutManagedRuleSetVersionsRequest::versionsToPublish))
            .setter(setter(Builder::versionsToPublish))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionsToPublish").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<VersionToPublish> builder(MarshallingType.SDK_POJO)
                                            .constructor(VersionToPublish::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD,
            ID_FIELD, LOCK_TOKEN_FIELD, RECOMMENDED_VERSION_FIELD, VERSIONS_TO_PUBLISH_FIELD));

    private final String name;

    private final String scope;

    private final String id;

    private final String lockToken;

    private final String recommendedVersion;

    private final Map<String, VersionToPublish> versionsToPublish;

    private PutManagedRuleSetVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.id = builder.id;
        this.lockToken = builder.lockToken;
        this.recommendedVersion = builder.recommendedVersion;
        this.versionsToPublish = builder.versionsToPublish;
    }

    /**
     * <p>
     * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
     * </p>
     * <p>
     * This name is assigned to the corresponding managed rule group, which your customers can access and use.
     * </p>
     * 
     * @return The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
     *         <p>
     *         This name is assigned to the corresponding managed rule group, which your customers can access and use.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync
     *         GraphQL API. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync
     *         GraphQL API. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * A unique identifier for the managed rule set. The ID is returned in the responses to commands like
     * <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.
     * </p>
     * 
     * @return A unique identifier for the managed rule set. The ID is returned in the responses to commands like
     *         <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String lockToken() {
        return lockToken;
    }

    /**
     * <p>
     * The version of the named managed rule group that you'd like your customers to choose, from among your version
     * offerings.
     * </p>
     * 
     * @return The version of the named managed rule group that you'd like your customers to choose, from among your
     *         version offerings.
     */
    public final String recommendedVersion() {
        return recommendedVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the VersionsToPublish property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVersionsToPublish() {
        return versionsToPublish != null && !(versionsToPublish instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The versions of the named managed rule group that you want to offer to your customers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersionsToPublish} method.
     * </p>
     * 
     * @return The versions of the named managed rule group that you want to offer to your customers.
     */
    public final Map<String, VersionToPublish> versionsToPublish() {
        return versionsToPublish;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lockToken());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasVersionsToPublish() ? versionsToPublish() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutManagedRuleSetVersionsRequest)) {
            return false;
        }
        PutManagedRuleSetVersionsRequest other = (PutManagedRuleSetVersionsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(lockToken(), other.lockToken())
                && Objects.equals(recommendedVersion(), other.recommendedVersion())
                && hasVersionsToPublish() == other.hasVersionsToPublish()
                && Objects.equals(versionsToPublish(), other.versionsToPublish());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutManagedRuleSetVersionsRequest").add("Name", name()).add("Scope", scopeAsString())
                .add("Id", id()).add("LockToken", lockToken()).add("RecommendedVersion", recommendedVersion())
                .add("VersionsToPublish", hasVersionsToPublish() ? versionsToPublish() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LockToken":
            return Optional.ofNullable(clazz.cast(lockToken()));
        case "RecommendedVersion":
            return Optional.ofNullable(clazz.cast(recommendedVersion()));
        case "VersionsToPublish":
            return Optional.ofNullable(clazz.cast(versionsToPublish()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutManagedRuleSetVersionsRequest, T> g) {
        return obj -> g.apply((PutManagedRuleSetVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutManagedRuleSetVersionsRequest> {
        /**
         * <p>
         * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
         * </p>
         * <p>
         * This name is assigned to the corresponding managed rule group, which your customers can access and use.
         * </p>
         * 
         * @param name
         *        The name of the managed rule set. You use this, along with the rule set ID, to identify the rule
         *        set.</p>
         *        <p>
         *        This name is assigned to the corresponding managed rule group, which your customers can access and
         *        use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL
         * API.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A
         *        regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an
         *        AppSync GraphQL API. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL
         * API.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A
         *        regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an
         *        AppSync GraphQL API. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * A unique identifier for the managed rule set. The ID is returned in the responses to commands like
         * <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.
         * </p>
         * 
         * @param id
         *        A unique identifier for the managed rule set. The ID is returned in the responses to commands like
         *        <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param lockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockToken(String lockToken);

        /**
         * <p>
         * The version of the named managed rule group that you'd like your customers to choose, from among your version
         * offerings.
         * </p>
         * 
         * @param recommendedVersion
         *        The version of the named managed rule group that you'd like your customers to choose, from among your
         *        version offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedVersion(String recommendedVersion);

        /**
         * <p>
         * The versions of the named managed rule group that you want to offer to your customers.
         * </p>
         * 
         * @param versionsToPublish
         *        The versions of the named managed rule group that you want to offer to your customers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionsToPublish(Map<String, VersionToPublish> versionsToPublish);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String name;

        private String scope;

        private String id;

        private String lockToken;

        private String recommendedVersion;

        private Map<String, VersionToPublish> versionsToPublish = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutManagedRuleSetVersionsRequest model) {
            super(model);
            name(model.name);
            scope(model.scope);
            id(model.id);
            lockToken(model.lockToken);
            recommendedVersion(model.recommendedVersion);
            versionsToPublish(model.versionsToPublish);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLockToken() {
            return lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final String getRecommendedVersion() {
            return recommendedVersion;
        }

        public final void setRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
        }

        @Override
        public final Builder recommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        public final Map<String, VersionToPublish.Builder> getVersionsToPublish() {
            Map<String, VersionToPublish.Builder> result = VersionsToPublishCopier.copyToBuilder(this.versionsToPublish);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVersionsToPublish(Map<String, VersionToPublish.BuilderImpl> versionsToPublish) {
            this.versionsToPublish = VersionsToPublishCopier.copyFromBuilder(versionsToPublish);
        }

        @Override
        public final Builder versionsToPublish(Map<String, VersionToPublish> versionsToPublish) {
            this.versionsToPublish = VersionsToPublishCopier.copy(versionsToPublish);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutManagedRuleSetVersionsRequest build() {
            return new PutManagedRuleSetVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
