/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action that WAF should take on a web request when it matches a rule's statement. Settings at the web ACL level
 * can override the rule action setting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleAction implements SdkPojo, Serializable, ToCopyableBuilder<RuleAction.Builder, RuleAction> {
    private static final SdkField<BlockAction> BLOCK_FIELD = SdkField.<BlockAction> builder(MarshallingType.SDK_POJO)
            .memberName("Block").getter(getter(RuleAction::block)).setter(setter(Builder::block))
            .constructor(BlockAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()).build();

    private static final SdkField<AllowAction> ALLOW_FIELD = SdkField.<AllowAction> builder(MarshallingType.SDK_POJO)
            .memberName("Allow").getter(getter(RuleAction::allow)).setter(setter(Builder::allow))
            .constructor(AllowAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()).build();

    private static final SdkField<CountAction> COUNT_FIELD = SdkField.<CountAction> builder(MarshallingType.SDK_POJO)
            .memberName("Count").getter(getter(RuleAction::count)).setter(setter(Builder::count))
            .constructor(CountAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<CaptchaAction> CAPTCHA_FIELD = SdkField.<CaptchaAction> builder(MarshallingType.SDK_POJO)
            .memberName("Captcha").getter(getter(RuleAction::captcha)).setter(setter(Builder::captcha))
            .constructor(CaptchaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Captcha").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_FIELD, ALLOW_FIELD,
            COUNT_FIELD, CAPTCHA_FIELD));

    private static final long serialVersionUID = 1L;

    private final BlockAction block;

    private final AllowAction allow;

    private final CountAction count;

    private final CaptchaAction captcha;

    private RuleAction(BuilderImpl builder) {
        this.block = builder.block;
        this.allow = builder.allow;
        this.count = builder.count;
        this.captcha = builder.captcha;
    }

    /**
     * <p>
     * Instructs WAF to block the web request.
     * </p>
     * 
     * @return Instructs WAF to block the web request.
     */
    public final BlockAction block() {
        return block;
    }

    /**
     * <p>
     * Instructs WAF to allow the web request.
     * </p>
     * 
     * @return Instructs WAF to allow the web request.
     */
    public final AllowAction allow() {
        return allow;
    }

    /**
     * <p>
     * Instructs WAF to count the web request and allow it.
     * </p>
     * 
     * @return Instructs WAF to count the web request and allow it.
     */
    public final CountAction count() {
        return count;
    }

    /**
     * <p>
     * Instructs WAF to run a <code>CAPTCHA</code> check against the web request.
     * </p>
     * 
     * @return Instructs WAF to run a <code>CAPTCHA</code> check against the web request.
     */
    public final CaptchaAction captcha() {
        return captcha;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(block());
        hashCode = 31 * hashCode + Objects.hashCode(allow());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(captcha());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleAction)) {
            return false;
        }
        RuleAction other = (RuleAction) obj;
        return Objects.equals(block(), other.block()) && Objects.equals(allow(), other.allow())
                && Objects.equals(count(), other.count()) && Objects.equals(captcha(), other.captcha());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleAction").add("Block", block()).add("Allow", allow()).add("Count", count())
                .add("Captcha", captcha()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "Allow":
            return Optional.ofNullable(clazz.cast(allow()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Captcha":
            return Optional.ofNullable(clazz.cast(captcha()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleAction, T> g) {
        return obj -> g.apply((RuleAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleAction> {
        /**
         * <p>
         * Instructs WAF to block the web request.
         * </p>
         * 
         * @param block
         *        Instructs WAF to block the web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(BlockAction block);

        /**
         * <p>
         * Instructs WAF to block the web request.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockAction.Builder} avoiding the need to
         * create one manually via {@link BlockAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlockAction.Builder#build()} is called immediately and its result
         * is passed to {@link #block(BlockAction)}.
         * 
         * @param block
         *        a consumer that will call methods on {@link BlockAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(BlockAction)
         */
        default Builder block(Consumer<BlockAction.Builder> block) {
            return block(BlockAction.builder().applyMutation(block).build());
        }

        /**
         * <p>
         * Instructs WAF to allow the web request.
         * </p>
         * 
         * @param allow
         *        Instructs WAF to allow the web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allow(AllowAction allow);

        /**
         * <p>
         * Instructs WAF to allow the web request.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllowAction.Builder} avoiding the need to
         * create one manually via {@link AllowAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link AllowAction.Builder#build()} is called immediately and its result
         * is passed to {@link #allow(AllowAction)}.
         * 
         * @param allow
         *        a consumer that will call methods on {@link AllowAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allow(AllowAction)
         */
        default Builder allow(Consumer<AllowAction.Builder> allow) {
            return allow(AllowAction.builder().applyMutation(allow).build());
        }

        /**
         * <p>
         * Instructs WAF to count the web request and allow it.
         * </p>
         * 
         * @param count
         *        Instructs WAF to count the web request and allow it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(CountAction count);

        /**
         * <p>
         * Instructs WAF to count the web request and allow it.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountAction.Builder} avoiding the need to
         * create one manually via {@link CountAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CountAction.Builder#build()} is called immediately and its result
         * is passed to {@link #count(CountAction)}.
         * 
         * @param count
         *        a consumer that will call methods on {@link CountAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #count(CountAction)
         */
        default Builder count(Consumer<CountAction.Builder> count) {
            return count(CountAction.builder().applyMutation(count).build());
        }

        /**
         * <p>
         * Instructs WAF to run a <code>CAPTCHA</code> check against the web request.
         * </p>
         * 
         * @param captcha
         *        Instructs WAF to run a <code>CAPTCHA</code> check against the web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captcha(CaptchaAction captcha);

        /**
         * <p>
         * Instructs WAF to run a <code>CAPTCHA</code> check against the web request.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaptchaAction.Builder} avoiding the need
         * to create one manually via {@link CaptchaAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CaptchaAction.Builder#build()} is called immediately and its
         * result is passed to {@link #captcha(CaptchaAction)}.
         * 
         * @param captcha
         *        a consumer that will call methods on {@link CaptchaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captcha(CaptchaAction)
         */
        default Builder captcha(Consumer<CaptchaAction.Builder> captcha) {
            return captcha(CaptchaAction.builder().applyMutation(captcha).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlockAction block;

        private AllowAction allow;

        private CountAction count;

        private CaptchaAction captcha;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleAction model) {
            block(model.block);
            allow(model.allow);
            count(model.count);
            captcha(model.captcha);
        }

        public final BlockAction.Builder getBlock() {
            return block != null ? block.toBuilder() : null;
        }

        public final void setBlock(BlockAction.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        @Override
        public final Builder block(BlockAction block) {
            this.block = block;
            return this;
        }

        public final AllowAction.Builder getAllow() {
            return allow != null ? allow.toBuilder() : null;
        }

        public final void setAllow(AllowAction.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public final Builder allow(AllowAction allow) {
            this.allow = allow;
            return this;
        }

        public final CountAction.Builder getCount() {
            return count != null ? count.toBuilder() : null;
        }

        public final void setCount(CountAction.BuilderImpl count) {
            this.count = count != null ? count.build() : null;
        }

        @Override
        public final Builder count(CountAction count) {
            this.count = count;
            return this;
        }

        public final CaptchaAction.Builder getCaptcha() {
            return captcha != null ? captcha.toBuilder() : null;
        }

        public final void setCaptcha(CaptchaAction.BuilderImpl captcha) {
            this.captcha = captcha != null ? captcha.build() : null;
        }

        @Override
        public final Builder captcha(CaptchaAction captcha) {
            this.captcha = captcha;
            return this;
        }

        @Override
        public RuleAction build() {
            return new RuleAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
