/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The processing guidance for a <a>Rule</a>, used by WAF to determine whether a web request matches the rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Statement implements SdkPojo, Serializable, ToCopyableBuilder<Statement.Builder, Statement> {
    private static final SdkField<ByteMatchStatement> BYTE_MATCH_STATEMENT_FIELD = SdkField
            .<ByteMatchStatement> builder(MarshallingType.SDK_POJO).memberName("ByteMatchStatement")
            .getter(getter(Statement::byteMatchStatement)).setter(setter(Builder::byteMatchStatement))
            .constructor(ByteMatchStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchStatement").build())
            .build();

    private static final SdkField<SqliMatchStatement> SQLI_MATCH_STATEMENT_FIELD = SdkField
            .<SqliMatchStatement> builder(MarshallingType.SDK_POJO).memberName("SqliMatchStatement")
            .getter(getter(Statement::sqliMatchStatement)).setter(setter(Builder::sqliMatchStatement))
            .constructor(SqliMatchStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqliMatchStatement").build())
            .build();

    private static final SdkField<XssMatchStatement> XSS_MATCH_STATEMENT_FIELD = SdkField
            .<XssMatchStatement> builder(MarshallingType.SDK_POJO).memberName("XssMatchStatement")
            .getter(getter(Statement::xssMatchStatement)).setter(setter(Builder::xssMatchStatement))
            .constructor(XssMatchStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchStatement").build()).build();

    private static final SdkField<SizeConstraintStatement> SIZE_CONSTRAINT_STATEMENT_FIELD = SdkField
            .<SizeConstraintStatement> builder(MarshallingType.SDK_POJO).memberName("SizeConstraintStatement")
            .getter(getter(Statement::sizeConstraintStatement)).setter(setter(Builder::sizeConstraintStatement))
            .constructor(SizeConstraintStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintStatement").build())
            .build();

    private static final SdkField<GeoMatchStatement> GEO_MATCH_STATEMENT_FIELD = SdkField
            .<GeoMatchStatement> builder(MarshallingType.SDK_POJO).memberName("GeoMatchStatement")
            .getter(getter(Statement::geoMatchStatement)).setter(setter(Builder::geoMatchStatement))
            .constructor(GeoMatchStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchStatement").build()).build();

    private static final SdkField<RuleGroupReferenceStatement> RULE_GROUP_REFERENCE_STATEMENT_FIELD = SdkField
            .<RuleGroupReferenceStatement> builder(MarshallingType.SDK_POJO)
            .memberName("RuleGroupReferenceStatement")
            .getter(getter(Statement::ruleGroupReferenceStatement))
            .setter(setter(Builder::ruleGroupReferenceStatement))
            .constructor(RuleGroupReferenceStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupReferenceStatement")
                    .build()).build();

    private static final SdkField<IPSetReferenceStatement> IP_SET_REFERENCE_STATEMENT_FIELD = SdkField
            .<IPSetReferenceStatement> builder(MarshallingType.SDK_POJO).memberName("IPSetReferenceStatement")
            .getter(getter(Statement::ipSetReferenceStatement)).setter(setter(Builder::ipSetReferenceStatement))
            .constructor(IPSetReferenceStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetReferenceStatement").build())
            .build();

    private static final SdkField<RegexPatternSetReferenceStatement> REGEX_PATTERN_SET_REFERENCE_STATEMENT_FIELD = SdkField
            .<RegexPatternSetReferenceStatement> builder(MarshallingType.SDK_POJO)
            .memberName("RegexPatternSetReferenceStatement")
            .getter(getter(Statement::regexPatternSetReferenceStatement))
            .setter(setter(Builder::regexPatternSetReferenceStatement))
            .constructor(RegexPatternSetReferenceStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSetReferenceStatement")
                    .build()).build();

    private static final SdkField<RateBasedStatement> RATE_BASED_STATEMENT_FIELD = SdkField
            .<RateBasedStatement> builder(MarshallingType.SDK_POJO).memberName("RateBasedStatement")
            .getter(getter(Statement::rateBasedStatement)).setter(setter(Builder::rateBasedStatement))
            .constructor(RateBasedStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateBasedStatement").build())
            .build();

    private static final SdkField<AndStatement> AND_STATEMENT_FIELD = SdkField.<AndStatement> builder(MarshallingType.SDK_POJO)
            .memberName("AndStatement").getter(getter(Statement::andStatement)).setter(setter(Builder::andStatement))
            .constructor(AndStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndStatement").build()).build();

    private static final SdkField<OrStatement> OR_STATEMENT_FIELD = SdkField.<OrStatement> builder(MarshallingType.SDK_POJO)
            .memberName("OrStatement").getter(getter(Statement::orStatement)).setter(setter(Builder::orStatement))
            .constructor(OrStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrStatement").build()).build();

    private static final SdkField<NotStatement> NOT_STATEMENT_FIELD = SdkField.<NotStatement> builder(MarshallingType.SDK_POJO)
            .memberName("NotStatement").getter(getter(Statement::notStatement)).setter(setter(Builder::notStatement))
            .constructor(NotStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotStatement").build()).build();

    private static final SdkField<ManagedRuleGroupStatement> MANAGED_RULE_GROUP_STATEMENT_FIELD = SdkField
            .<ManagedRuleGroupStatement> builder(MarshallingType.SDK_POJO).memberName("ManagedRuleGroupStatement")
            .getter(getter(Statement::managedRuleGroupStatement)).setter(setter(Builder::managedRuleGroupStatement))
            .constructor(ManagedRuleGroupStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRuleGroupStatement").build())
            .build();

    private static final SdkField<LabelMatchStatement> LABEL_MATCH_STATEMENT_FIELD = SdkField
            .<LabelMatchStatement> builder(MarshallingType.SDK_POJO).memberName("LabelMatchStatement")
            .getter(getter(Statement::labelMatchStatement)).setter(setter(Builder::labelMatchStatement))
            .constructor(LabelMatchStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelMatchStatement").build())
            .build();

    private static final SdkField<RegexMatchStatement> REGEX_MATCH_STATEMENT_FIELD = SdkField
            .<RegexMatchStatement> builder(MarshallingType.SDK_POJO).memberName("RegexMatchStatement")
            .getter(getter(Statement::regexMatchStatement)).setter(setter(Builder::regexMatchStatement))
            .constructor(RegexMatchStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchStatement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_MATCH_STATEMENT_FIELD,
            SQLI_MATCH_STATEMENT_FIELD, XSS_MATCH_STATEMENT_FIELD, SIZE_CONSTRAINT_STATEMENT_FIELD, GEO_MATCH_STATEMENT_FIELD,
            RULE_GROUP_REFERENCE_STATEMENT_FIELD, IP_SET_REFERENCE_STATEMENT_FIELD, REGEX_PATTERN_SET_REFERENCE_STATEMENT_FIELD,
            RATE_BASED_STATEMENT_FIELD, AND_STATEMENT_FIELD, OR_STATEMENT_FIELD, NOT_STATEMENT_FIELD,
            MANAGED_RULE_GROUP_STATEMENT_FIELD, LABEL_MATCH_STATEMENT_FIELD, REGEX_MATCH_STATEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ByteMatchStatement byteMatchStatement;

    private final SqliMatchStatement sqliMatchStatement;

    private final XssMatchStatement xssMatchStatement;

    private final SizeConstraintStatement sizeConstraintStatement;

    private final GeoMatchStatement geoMatchStatement;

    private final RuleGroupReferenceStatement ruleGroupReferenceStatement;

    private final IPSetReferenceStatement ipSetReferenceStatement;

    private final RegexPatternSetReferenceStatement regexPatternSetReferenceStatement;

    private final RateBasedStatement rateBasedStatement;

    private final AndStatement andStatement;

    private final OrStatement orStatement;

    private final NotStatement notStatement;

    private final ManagedRuleGroupStatement managedRuleGroupStatement;

    private final LabelMatchStatement labelMatchStatement;

    private final RegexMatchStatement regexMatchStatement;

    private Statement(BuilderImpl builder) {
        this.byteMatchStatement = builder.byteMatchStatement;
        this.sqliMatchStatement = builder.sqliMatchStatement;
        this.xssMatchStatement = builder.xssMatchStatement;
        this.sizeConstraintStatement = builder.sizeConstraintStatement;
        this.geoMatchStatement = builder.geoMatchStatement;
        this.ruleGroupReferenceStatement = builder.ruleGroupReferenceStatement;
        this.ipSetReferenceStatement = builder.ipSetReferenceStatement;
        this.regexPatternSetReferenceStatement = builder.regexPatternSetReferenceStatement;
        this.rateBasedStatement = builder.rateBasedStatement;
        this.andStatement = builder.andStatement;
        this.orStatement = builder.orStatement;
        this.notStatement = builder.notStatement;
        this.managedRuleGroupStatement = builder.managedRuleGroupStatement;
        this.labelMatchStatement = builder.labelMatchStatement;
        this.regexMatchStatement = builder.regexMatchStatement;
    }

    /**
     * <p>
     * A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement
     * provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The
     * bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the
     * developer guide, this is refered to as a string match statement.
     * </p>
     * 
     * @return A rule statement that defines a string match search for WAF to apply to web requests. The byte match
     *         statement provides the bytes to search for, the location in requests that you want WAF to search, and
     *         other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In
     *         the WAF console and the developer guide, this is refered to as a string match statement.
     */
    public final ByteMatchStatement byteMatchStatement() {
        return byteMatchStatement;
    }

    /**
     * <p>
     * Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your database.
     * To allow or block web requests that appear to contain malicious SQL code, create one or more SQL injection match
     * conditions. An SQL injection match condition identifies the part of web requests, such as the URI or the query
     * string, that you want WAF to inspect. Later in the process, when you create a web ACL, you specify whether to
     * allow or block requests that appear to contain malicious SQL code.
     * </p>
     * 
     * @return Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your
     *         database. To allow or block web requests that appear to contain malicious SQL code, create one or more
     *         SQL injection match conditions. An SQL injection match condition identifies the part of web requests,
     *         such as the URI or the query string, that you want WAF to inspect. Later in the process, when you create
     *         a web ACL, you specify whether to allow or block requests that appear to contain malicious SQL code.
     */
    public final SqliMatchStatement sqliMatchStatement() {
        return sqliMatchStatement;
    }

    /**
     * <p>
     * A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests. XSS
     * attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious
     * client-site scripts into other legitimate web browsers. The XSS match statement provides the location in requests
     * that you want WAF to search and text transformations to use on the search area before WAF searches for character
     * sequences that are likely to be malicious strings.
     * </p>
     * 
     * @return A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests.
     *         XSS attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject
     *         malicious client-site scripts into other legitimate web browsers. The XSS match statement provides the
     *         location in requests that you want WAF to search and text transformations to use on the search area
     *         before WAF searches for character sequences that are likely to be malicious strings.
     */
    public final XssMatchStatement xssMatchStatement() {
        return xssMatchStatement;
    }

    /**
     * <p>
     * A rule statement that compares a number of bytes against the size of a request component, using a comparison
     * operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size constraint statement
     * to look for query strings that are longer than 100 bytes.
     * </p>
     * <p>
     * If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the request
     * body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and block
     * requests that have a request body greater than 8192 bytes.
     * </p>
     * <p>
     * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one
     * character. For example, the URI <code>/logo.jpg</code> is nine characters long.
     * </p>
     * 
     * @return A rule statement that compares a number of bytes against the size of a request component, using a
     *         comparison operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size
     *         constraint statement to look for query strings that are longer than 100 bytes. </p>
     *         <p>
     *         If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the
     *         request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition
     *         and block requests that have a request body greater than 8192 bytes.
     *         </p>
     *         <p>
     *         If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as
     *         one character. For example, the URI <code>/logo.jpg</code> is nine characters long.
     */
    public final SizeConstraintStatement sizeConstraintStatement() {
        return sizeConstraintStatement;
    }

    /**
     * <p>
     * A rule statement used to identify web requests based on country of origin.
     * </p>
     * 
     * @return A rule statement used to identify web requests based on country of origin.
     */
    public final GeoMatchStatement geoMatchStatement() {
        return geoMatchStatement;
    }

    /**
     * <p>
     * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group
     * with your rules, then provide the ARN of the rule group in this statement.
     * </p>
     * <p>
     * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
     * <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at the
     * top level inside a web ACL.
     * </p>
     * 
     * @return A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule
     *         group with your rules, then provide the ARN of the rule group in this statement.</p>
     *         <p>
     *         You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
     *         <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement
     *         at the top level inside a web ACL.
     */
    public final RuleGroupReferenceStatement ruleGroupReferenceStatement() {
        return ruleGroupReferenceStatement;
    }

    /**
     * <p>
     * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this,
     * create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in this
     * statement. To create an IP set, see <a>CreateIPSet</a>.
     * </p>
     * <p>
     * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This
     * allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates
     * all rules that reference it.
     * </p>
     * 
     * @return A rule statement used to detect web requests coming from particular IP addresses or address ranges. To
     *         use this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of
     *         that set in this statement. To create an IP set, see <a>CreateIPSet</a>.</p>
     *         <p>
     *         Each IP set rule statement references an IP set. You create and maintain the set independent of your
     *         rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF
     *         automatically updates all rules that reference it.
     */
    public final IPSetReferenceStatement ipSetReferenceStatement() {
        return ipSetReferenceStatement;
    }

    /**
     * <p>
     * A rule statement used to search web request components for matches with regular expressions. To use this, create
     * a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of that set in
     * this statement. A web request matches the pattern set rule statement if the request component matches any of the
     * patterns in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.
     * </p>
     * <p>
     * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent
     * of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF
     * automatically updates all rules that reference it.
     * </p>
     * 
     * @return A rule statement used to search web request components for matches with regular expressions. To use this,
     *         create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN
     *         of that set in this statement. A web request matches the pattern set rule statement if the request
     *         component matches any of the patterns in the set. To create a regex pattern set, see
     *         <a>CreateRegexPatternSet</a>.</p>
     *         <p>
     *         Each regex pattern set rule statement references a regex pattern set. You create and maintain the set
     *         independent of your rules. This allows you to use the single set in multiple rules. When you update the
     *         referenced set, WAF automatically updates all rules that reference it.
     */
    public final RegexPatternSetReferenceStatement regexPatternSetReferenceStatement() {
        return regexPatternSetReferenceStatement;
    }

    /**
     * <p>
     * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when
     * the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this
     * to put a temporary block on requests from an IP address that is sending excessive requests.
     * </p>
     * <p>
     * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example,
     * if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a
     * separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a
     * rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate
     * instance of the rate-based rule that gets its own tracking and management by WAF.
     * </p>
     * <p>
     * When the rule action triggers, WAF blocks additional requests from the IP address until the request rate falls
     * below the limit.
     * </p>
     * <p>
     * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so
     * that it only counts requests that match the nested statement. For example, based on recent requests that you have
     * seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the
     * following nested statements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An IP match statement with an IP set that specified the address 192.0.2.44.
     * </p>
     * </li>
     * <li>
     * <p>
     * A string match statement that searches in the User-Agent header for the string BadBot.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that
     * meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five minutes,
     * the rule action triggers. Requests that do not meet both conditions are not counted towards the rate limit and
     * are not affected by this rule.
     * </p>
     * <p>
     * You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a
     * <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code> inside a
     * web ACL and inside a rule group.
     * </p>
     * 
     * @return A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule
     *         action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time
     *         span. You can use this to put a temporary block on requests from an IP address that is sending excessive
     *         requests. </p>
     *         <p>
     *         WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For
     *         example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule
     *         statements represents a separate instance of the rate-based rule and gets its own tracking and management
     *         by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple
     *         places, each use creates a separate instance of the rate-based rule that gets its own tracking and
     *         management by WAF.
     *         </p>
     *         <p>
     *         When the rule action triggers, WAF blocks additional requests from the IP address until the request rate
     *         falls below the limit.
     *         </p>
     *         <p>
     *         You can optionally nest another statement inside the rate-based statement, to narrow the scope of the
     *         rule so that it only counts requests that match the nested statement. For example, based on recent
     *         requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule
     *         statement that contains the following nested statements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An IP match statement with an IP set that specified the address 192.0.2.44.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A string match statement that searches in the User-Agent header for the string BadBot.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000.
     *         Requests that meet both of the conditions in the statements are counted. If the count exceeds 1,000
     *         requests per five minutes, the rule action triggers. Requests that do not meet both conditions are not
     *         counted towards the rate limit and are not affected by this rule.
     *         </p>
     *         <p>
     *         You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a
     *         <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code>
     *         inside a web ACL and inside a rule group.
     */
    public final RateBasedStatement rateBasedStatement() {
        return rateBasedStatement;
    }

    /**
     * <p>
     * A logical rule statement used to combine other rule statements with AND logic. You provide more than one
     * <a>Statement</a> within the <code>AndStatement</code>.
     * </p>
     * 
     * @return A logical rule statement used to combine other rule statements with AND logic. You provide more than one
     *         <a>Statement</a> within the <code>AndStatement</code>.
     */
    public final AndStatement andStatement() {
        return andStatement;
    }

    /**
     * <p>
     * A logical rule statement used to combine other rule statements with OR logic. You provide more than one
     * <a>Statement</a> within the <code>OrStatement</code>.
     * </p>
     * 
     * @return A logical rule statement used to combine other rule statements with OR logic. You provide more than one
     *         <a>Statement</a> within the <code>OrStatement</code>.
     */
    public final OrStatement orStatement() {
        return orStatement;
    }

    /**
     * <p>
     * A logical rule statement used to negate the results of another rule statement. You provide one <a>Statement</a>
     * within the <code>NotStatement</code>.
     * </p>
     * 
     * @return A logical rule statement used to negate the results of another rule statement. You provide one
     *         <a>Statement</a> within the <code>NotStatement</code>.
     */
    public final NotStatement notStatement() {
        return notStatement;
    }

    /**
     * <p>
     * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor
     * name and the name of the rule group in this statement. You can retrieve the required names by calling
     * <a>ListAvailableManagedRuleGroups</a>.
     * </p>
     * <p>
     * You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a <code>NotStatement</code>
     * or <code>OrStatement</code>. It can only be referenced as a top-level statement within a rule.
     * </p>
     * 
     * @return A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the
     *         vendor name and the name of the rule group in this statement. You can retrieve the required names by
     *         calling <a>ListAvailableManagedRuleGroups</a>.</p>
     *         <p>
     *         You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
     *         <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement
     *         within a rule.
     */
    public final ManagedRuleGroupStatement managedRuleGroupStatement() {
        return managedRuleGroupStatement;
    }

    /**
     * <p>
     * A rule statement that defines a string match search against labels that have been added to the web request by
     * rules that have already run in the web ACL.
     * </p>
     * <p>
     * The label match statement provides the label or namespace string to search for. The label string can represent a
     * part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have
     * a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the
     * rule that added the label. If you do not provide the fully qualified name in your label match string, WAF
     * performs the search for labels that were added in the same context as the label match statement.
     * </p>
     * 
     * @return A rule statement that defines a string match search against labels that have been added to the web
     *         request by rules that have already run in the web ACL. </p>
     *         <p>
     *         The label match statement provides the label or namespace string to search for. The label string can
     *         represent a part or all of the fully qualified label name that had been added to the web request. Fully
     *         qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group
     *         or web ACL context of the rule that added the label. If you do not provide the fully qualified name in
     *         your label match string, WAF performs the search for labels that were added in the same context as the
     *         label match statement.
     */
    public final LabelMatchStatement labelMatchStatement() {
        return labelMatchStatement;
    }

    /**
     * <p>
     * A rule statement used to search web request components for a match against a single regular expression.
     * </p>
     * 
     * @return A rule statement used to search web request components for a match against a single regular expression.
     */
    public final RegexMatchStatement regexMatchStatement() {
        return regexMatchStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(sqliMatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(xssMatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(sizeConstraintStatement());
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupReferenceStatement());
        hashCode = 31 * hashCode + Objects.hashCode(ipSetReferenceStatement());
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternSetReferenceStatement());
        hashCode = 31 * hashCode + Objects.hashCode(rateBasedStatement());
        hashCode = 31 * hashCode + Objects.hashCode(andStatement());
        hashCode = 31 * hashCode + Objects.hashCode(orStatement());
        hashCode = 31 * hashCode + Objects.hashCode(notStatement());
        hashCode = 31 * hashCode + Objects.hashCode(managedRuleGroupStatement());
        hashCode = 31 * hashCode + Objects.hashCode(labelMatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(regexMatchStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement) obj;
        return Objects.equals(byteMatchStatement(), other.byteMatchStatement())
                && Objects.equals(sqliMatchStatement(), other.sqliMatchStatement())
                && Objects.equals(xssMatchStatement(), other.xssMatchStatement())
                && Objects.equals(sizeConstraintStatement(), other.sizeConstraintStatement())
                && Objects.equals(geoMatchStatement(), other.geoMatchStatement())
                && Objects.equals(ruleGroupReferenceStatement(), other.ruleGroupReferenceStatement())
                && Objects.equals(ipSetReferenceStatement(), other.ipSetReferenceStatement())
                && Objects.equals(regexPatternSetReferenceStatement(), other.regexPatternSetReferenceStatement())
                && Objects.equals(rateBasedStatement(), other.rateBasedStatement())
                && Objects.equals(andStatement(), other.andStatement()) && Objects.equals(orStatement(), other.orStatement())
                && Objects.equals(notStatement(), other.notStatement())
                && Objects.equals(managedRuleGroupStatement(), other.managedRuleGroupStatement())
                && Objects.equals(labelMatchStatement(), other.labelMatchStatement())
                && Objects.equals(regexMatchStatement(), other.regexMatchStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Statement").add("ByteMatchStatement", byteMatchStatement())
                .add("SqliMatchStatement", sqliMatchStatement()).add("XssMatchStatement", xssMatchStatement())
                .add("SizeConstraintStatement", sizeConstraintStatement()).add("GeoMatchStatement", geoMatchStatement())
                .add("RuleGroupReferenceStatement", ruleGroupReferenceStatement())
                .add("IPSetReferenceStatement", ipSetReferenceStatement())
                .add("RegexPatternSetReferenceStatement", regexPatternSetReferenceStatement())
                .add("RateBasedStatement", rateBasedStatement()).add("AndStatement", andStatement())
                .add("OrStatement", orStatement()).add("NotStatement", notStatement())
                .add("ManagedRuleGroupStatement", managedRuleGroupStatement()).add("LabelMatchStatement", labelMatchStatement())
                .add("RegexMatchStatement", regexMatchStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByteMatchStatement":
            return Optional.ofNullable(clazz.cast(byteMatchStatement()));
        case "SqliMatchStatement":
            return Optional.ofNullable(clazz.cast(sqliMatchStatement()));
        case "XssMatchStatement":
            return Optional.ofNullable(clazz.cast(xssMatchStatement()));
        case "SizeConstraintStatement":
            return Optional.ofNullable(clazz.cast(sizeConstraintStatement()));
        case "GeoMatchStatement":
            return Optional.ofNullable(clazz.cast(geoMatchStatement()));
        case "RuleGroupReferenceStatement":
            return Optional.ofNullable(clazz.cast(ruleGroupReferenceStatement()));
        case "IPSetReferenceStatement":
            return Optional.ofNullable(clazz.cast(ipSetReferenceStatement()));
        case "RegexPatternSetReferenceStatement":
            return Optional.ofNullable(clazz.cast(regexPatternSetReferenceStatement()));
        case "RateBasedStatement":
            return Optional.ofNullable(clazz.cast(rateBasedStatement()));
        case "AndStatement":
            return Optional.ofNullable(clazz.cast(andStatement()));
        case "OrStatement":
            return Optional.ofNullable(clazz.cast(orStatement()));
        case "NotStatement":
            return Optional.ofNullable(clazz.cast(notStatement()));
        case "ManagedRuleGroupStatement":
            return Optional.ofNullable(clazz.cast(managedRuleGroupStatement()));
        case "LabelMatchStatement":
            return Optional.ofNullable(clazz.cast(labelMatchStatement()));
        case "RegexMatchStatement":
            return Optional.ofNullable(clazz.cast(regexMatchStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Statement, T> g) {
        return obj -> g.apply((Statement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Statement> {
        /**
         * <p>
         * A rule statement that defines a string match search for WAF to apply to web requests. The byte match
         * statement provides the bytes to search for, the location in requests that you want WAF to search, and other
         * settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF
         * console and the developer guide, this is refered to as a string match statement.
         * </p>
         * 
         * @param byteMatchStatement
         *        A rule statement that defines a string match search for WAF to apply to web requests. The byte match
         *        statement provides the bytes to search for, the location in requests that you want WAF to search, and
         *        other settings. The bytes to search for are typically a string that corresponds with ASCII characters.
         *        In the WAF console and the developer guide, this is refered to as a string match statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchStatement(ByteMatchStatement byteMatchStatement);

        /**
         * <p>
         * A rule statement that defines a string match search for WAF to apply to web requests. The byte match
         * statement provides the bytes to search for, the location in requests that you want WAF to search, and other
         * settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF
         * console and the developer guide, this is refered to as a string match statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByteMatchStatement.Builder} avoiding the
         * need to create one manually via {@link ByteMatchStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link ByteMatchStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #byteMatchStatement(ByteMatchStatement)}.
         * 
         * @param byteMatchStatement
         *        a consumer that will call methods on {@link ByteMatchStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteMatchStatement(ByteMatchStatement)
         */
        default Builder byteMatchStatement(Consumer<ByteMatchStatement.Builder> byteMatchStatement) {
            return byteMatchStatement(ByteMatchStatement.builder().applyMutation(byteMatchStatement).build());
        }

        /**
         * <p>
         * Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your
         * database. To allow or block web requests that appear to contain malicious SQL code, create one or more SQL
         * injection match conditions. An SQL injection match condition identifies the part of web requests, such as the
         * URI or the query string, that you want WAF to inspect. Later in the process, when you create a web ACL, you
         * specify whether to allow or block requests that appear to contain malicious SQL code.
         * </p>
         * 
         * @param sqliMatchStatement
         *        Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your
         *        database. To allow or block web requests that appear to contain malicious SQL code, create one or more
         *        SQL injection match conditions. An SQL injection match condition identifies the part of web requests,
         *        such as the URI or the query string, that you want WAF to inspect. Later in the process, when you
         *        create a web ACL, you specify whether to allow or block requests that appear to contain malicious SQL
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqliMatchStatement(SqliMatchStatement sqliMatchStatement);

        /**
         * <p>
         * Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your
         * database. To allow or block web requests that appear to contain malicious SQL code, create one or more SQL
         * injection match conditions. An SQL injection match condition identifies the part of web requests, such as the
         * URI or the query string, that you want WAF to inspect. Later in the process, when you create a web ACL, you
         * specify whether to allow or block requests that appear to contain malicious SQL code.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqliMatchStatement.Builder} avoiding the
         * need to create one manually via {@link SqliMatchStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqliMatchStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #sqliMatchStatement(SqliMatchStatement)}.
         * 
         * @param sqliMatchStatement
         *        a consumer that will call methods on {@link SqliMatchStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqliMatchStatement(SqliMatchStatement)
         */
        default Builder sqliMatchStatement(Consumer<SqliMatchStatement.Builder> sqliMatchStatement) {
            return sqliMatchStatement(SqliMatchStatement.builder().applyMutation(sqliMatchStatement).build());
        }

        /**
         * <p>
         * A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests. XSS
         * attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject
         * malicious client-site scripts into other legitimate web browsers. The XSS match statement provides the
         * location in requests that you want WAF to search and text transformations to use on the search area before
         * WAF searches for character sequences that are likely to be malicious strings.
         * </p>
         * 
         * @param xssMatchStatement
         *        A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web
         *        requests. XSS attacks are those where the attacker uses vulnerabilities in a benign website as a
         *        vehicle to inject malicious client-site scripts into other legitimate web browsers. The XSS match
         *        statement provides the location in requests that you want WAF to search and text transformations to
         *        use on the search area before WAF searches for character sequences that are likely to be malicious
         *        strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xssMatchStatement(XssMatchStatement xssMatchStatement);

        /**
         * <p>
         * A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests. XSS
         * attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject
         * malicious client-site scripts into other legitimate web browsers. The XSS match statement provides the
         * location in requests that you want WAF to search and text transformations to use on the search area before
         * WAF searches for character sequences that are likely to be malicious strings.
         * </p>
         * This is a convenience method that creates an instance of the {@link XssMatchStatement.Builder} avoiding the
         * need to create one manually via {@link XssMatchStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link XssMatchStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #xssMatchStatement(XssMatchStatement)}.
         * 
         * @param xssMatchStatement
         *        a consumer that will call methods on {@link XssMatchStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xssMatchStatement(XssMatchStatement)
         */
        default Builder xssMatchStatement(Consumer<XssMatchStatement.Builder> xssMatchStatement) {
            return xssMatchStatement(XssMatchStatement.builder().applyMutation(xssMatchStatement).build());
        }

        /**
         * <p>
         * A rule statement that compares a number of bytes against the size of a request component, using a comparison
         * operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size constraint
         * statement to look for query strings that are longer than 100 bytes.
         * </p>
         * <p>
         * If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the
         * request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and
         * block requests that have a request body greater than 8192 bytes.
         * </p>
         * <p>
         * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one
         * character. For example, the URI <code>/logo.jpg</code> is nine characters long.
         * </p>
         * 
         * @param sizeConstraintStatement
         *        A rule statement that compares a number of bytes against the size of a request component, using a
         *        comparison operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size
         *        constraint statement to look for query strings that are longer than 100 bytes. </p>
         *        <p>
         *        If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If
         *        the request body for your web requests never exceeds 8192 bytes, you can create a size constraint
         *        condition and block requests that have a request body greater than 8192 bytes.
         *        </p>
         *        <p>
         *        If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts
         *        as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraintStatement(SizeConstraintStatement sizeConstraintStatement);

        /**
         * <p>
         * A rule statement that compares a number of bytes against the size of a request component, using a comparison
         * operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size constraint
         * statement to look for query strings that are longer than 100 bytes.
         * </p>
         * <p>
         * If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the
         * request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and
         * block requests that have a request body greater than 8192 bytes.
         * </p>
         * <p>
         * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one
         * character. For example, the URI <code>/logo.jpg</code> is nine characters long.
         * </p>
         * This is a convenience method that creates an instance of the {@link SizeConstraintStatement.Builder} avoiding
         * the need to create one manually via {@link SizeConstraintStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link SizeConstraintStatement.Builder#build()} is called immediately
         * and its result is passed to {@link #sizeConstraintStatement(SizeConstraintStatement)}.
         * 
         * @param sizeConstraintStatement
         *        a consumer that will call methods on {@link SizeConstraintStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeConstraintStatement(SizeConstraintStatement)
         */
        default Builder sizeConstraintStatement(Consumer<SizeConstraintStatement.Builder> sizeConstraintStatement) {
            return sizeConstraintStatement(SizeConstraintStatement.builder().applyMutation(sizeConstraintStatement).build());
        }

        /**
         * <p>
         * A rule statement used to identify web requests based on country of origin.
         * </p>
         * 
         * @param geoMatchStatement
         *        A rule statement used to identify web requests based on country of origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchStatement(GeoMatchStatement geoMatchStatement);

        /**
         * <p>
         * A rule statement used to identify web requests based on country of origin.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeoMatchStatement.Builder} avoiding the
         * need to create one manually via {@link GeoMatchStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link GeoMatchStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #geoMatchStatement(GeoMatchStatement)}.
         * 
         * @param geoMatchStatement
         *        a consumer that will call methods on {@link GeoMatchStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoMatchStatement(GeoMatchStatement)
         */
        default Builder geoMatchStatement(Consumer<GeoMatchStatement.Builder> geoMatchStatement) {
            return geoMatchStatement(GeoMatchStatement.builder().applyMutation(geoMatchStatement).build());
        }

        /**
         * <p>
         * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule
         * group with your rules, then provide the ARN of the rule group in this statement.
         * </p>
         * <p>
         * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at
         * the top level inside a web ACL.
         * </p>
         * 
         * @param ruleGroupReferenceStatement
         *        A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a
         *        rule group with your rules, then provide the ARN of the rule group in this statement.</p>
         *        <p>
         *        You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
         *        <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference
         *        statement at the top level inside a web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupReferenceStatement(RuleGroupReferenceStatement ruleGroupReferenceStatement);

        /**
         * <p>
         * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule
         * group with your rules, then provide the ARN of the rule group in this statement.
         * </p>
         * <p>
         * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at
         * the top level inside a web ACL.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroupReferenceStatement.Builder}
         * avoiding the need to create one manually via {@link RuleGroupReferenceStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroupReferenceStatement.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleGroupReferenceStatement(RuleGroupReferenceStatement)}.
         * 
         * @param ruleGroupReferenceStatement
         *        a consumer that will call methods on {@link RuleGroupReferenceStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroupReferenceStatement(RuleGroupReferenceStatement)
         */
        default Builder ruleGroupReferenceStatement(Consumer<RuleGroupReferenceStatement.Builder> ruleGroupReferenceStatement) {
            return ruleGroupReferenceStatement(RuleGroupReferenceStatement.builder().applyMutation(ruleGroupReferenceStatement)
                    .build());
        }

        /**
         * <p>
         * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use
         * this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in
         * this statement. To create an IP set, see <a>CreateIPSet</a>.
         * </p>
         * <p>
         * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules.
         * This allows you to use the single set in multiple rules. When you update the referenced set, WAF
         * automatically updates all rules that reference it.
         * </p>
         * 
         * @param ipSetReferenceStatement
         *        A rule statement used to detect web requests coming from particular IP addresses or address ranges. To
         *        use this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of
         *        that set in this statement. To create an IP set, see <a>CreateIPSet</a>.</p>
         *        <p>
         *        Each IP set rule statement references an IP set. You create and maintain the set independent of your
         *        rules. This allows you to use the single set in multiple rules. When you update the referenced set,
         *        WAF automatically updates all rules that reference it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetReferenceStatement(IPSetReferenceStatement ipSetReferenceStatement);

        /**
         * <p>
         * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use
         * this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in
         * this statement. To create an IP set, see <a>CreateIPSet</a>.
         * </p>
         * <p>
         * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules.
         * This allows you to use the single set in multiple rules. When you update the referenced set, WAF
         * automatically updates all rules that reference it.
         * </p>
         * This is a convenience method that creates an instance of the {@link IPSetReferenceStatement.Builder} avoiding
         * the need to create one manually via {@link IPSetReferenceStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link IPSetReferenceStatement.Builder#build()} is called immediately
         * and its result is passed to {@link #ipSetReferenceStatement(IPSetReferenceStatement)}.
         * 
         * @param ipSetReferenceStatement
         *        a consumer that will call methods on {@link IPSetReferenceStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSetReferenceStatement(IPSetReferenceStatement)
         */
        default Builder ipSetReferenceStatement(Consumer<IPSetReferenceStatement.Builder> ipSetReferenceStatement) {
            return ipSetReferenceStatement(IPSetReferenceStatement.builder().applyMutation(ipSetReferenceStatement).build());
        }

        /**
         * <p>
         * A rule statement used to search web request components for matches with regular expressions. To use this,
         * create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of
         * that set in this statement. A web request matches the pattern set rule statement if the request component
         * matches any of the patterns in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.
         * </p>
         * <p>
         * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set
         * independent of your rules. This allows you to use the single set in multiple rules. When you update the
         * referenced set, WAF automatically updates all rules that reference it.
         * </p>
         * 
         * @param regexPatternSetReferenceStatement
         *        A rule statement used to search web request components for matches with regular expressions. To use
         *        this, create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use
         *        the ARN of that set in this statement. A web request matches the pattern set rule statement if the
         *        request component matches any of the patterns in the set. To create a regex pattern set, see
         *        <a>CreateRegexPatternSet</a>.</p>
         *        <p>
         *        Each regex pattern set rule statement references a regex pattern set. You create and maintain the set
         *        independent of your rules. This allows you to use the single set in multiple rules. When you update
         *        the referenced set, WAF automatically updates all rules that reference it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSetReferenceStatement(RegexPatternSetReferenceStatement regexPatternSetReferenceStatement);

        /**
         * <p>
         * A rule statement used to search web request components for matches with regular expressions. To use this,
         * create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of
         * that set in this statement. A web request matches the pattern set rule statement if the request component
         * matches any of the patterns in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.
         * </p>
         * <p>
         * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set
         * independent of your rules. This allows you to use the single set in multiple rules. When you update the
         * referenced set, WAF automatically updates all rules that reference it.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RegexPatternSetReferenceStatement.Builder} avoiding the need to create one manually via
         * {@link RegexPatternSetReferenceStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegexPatternSetReferenceStatement.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #regexPatternSetReferenceStatement(RegexPatternSetReferenceStatement)}.
         * 
         * @param regexPatternSetReferenceStatement
         *        a consumer that will call methods on {@link RegexPatternSetReferenceStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexPatternSetReferenceStatement(RegexPatternSetReferenceStatement)
         */
        default Builder regexPatternSetReferenceStatement(
                Consumer<RegexPatternSetReferenceStatement.Builder> regexPatternSetReferenceStatement) {
            return regexPatternSetReferenceStatement(RegexPatternSetReferenceStatement.builder()
                    .applyMutation(regexPatternSetReferenceStatement).build());
        }

        /**
         * <p>
         * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action
         * when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can
         * use this to put a temporary block on requests from an IP address that is sending excessive requests.
         * </p>
         * <p>
         * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For
         * example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements
         * represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you
         * define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use
         * creates a separate instance of the rate-based rule that gets its own tracking and management by WAF.
         * </p>
         * <p>
         * When the rule action triggers, WAF blocks additional requests from the IP address until the request rate
         * falls below the limit.
         * </p>
         * <p>
         * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so
         * that it only counts requests that match the nested statement. For example, based on recent requests that you
         * have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains
         * the following nested statements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An IP match statement with an IP set that specified the address 192.0.2.44.
         * </p>
         * </li>
         * <li>
         * <p>
         * A string match statement that searches in the User-Agent header for the string BadBot.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests
         * that meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five
         * minutes, the rule action triggers. Requests that do not meet both conditions are not counted towards the rate
         * limit and are not affected by this rule.
         * </p>
         * <p>
         * You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code>
         * inside a web ACL and inside a rule group.
         * </p>
         * 
         * @param rateBasedStatement
         *        A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule
         *        action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time
         *        span. You can use this to put a temporary block on requests from an IP address that is sending
         *        excessive requests. </p>
         *        <p>
         *        WAF tracks and manages web requests separately for each instance of a rate-based rule that you use.
         *        For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule
         *        statements represents a separate instance of the rate-based rule and gets its own tracking and
         *        management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group
         *        in multiple places, each use creates a separate instance of the rate-based rule that gets its own
         *        tracking and management by WAF.
         *        </p>
         *        <p>
         *        When the rule action triggers, WAF blocks additional requests from the IP address until the request
         *        rate falls below the limit.
         *        </p>
         *        <p>
         *        You can optionally nest another statement inside the rate-based statement, to narrow the scope of the
         *        rule so that it only counts requests that match the nested statement. For example, based on recent
         *        requests that you have seen from an attacker, you might create a rate-based rule with a nested AND
         *        rule statement that contains the following nested statements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An IP match statement with an IP set that specified the address 192.0.2.44.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A string match statement that searches in the User-Agent header for the string BadBot.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000.
         *        Requests that meet both of the conditions in the statements are counted. If the count exceeds 1,000
         *        requests per five minutes, the rule action triggers. Requests that do not meet both conditions are not
         *        counted towards the rate limit and are not affected by this rule.
         *        </p>
         *        <p>
         *        You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a
         *        <code>NotStatement</code> or <code>OrStatement</code>. You can define a
         *        <code>RateBasedStatement</code> inside a web ACL and inside a rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateBasedStatement(RateBasedStatement rateBasedStatement);

        /**
         * <p>
         * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action
         * when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can
         * use this to put a temporary block on requests from an IP address that is sending excessive requests.
         * </p>
         * <p>
         * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For
         * example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements
         * represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you
         * define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use
         * creates a separate instance of the rate-based rule that gets its own tracking and management by WAF.
         * </p>
         * <p>
         * When the rule action triggers, WAF blocks additional requests from the IP address until the request rate
         * falls below the limit.
         * </p>
         * <p>
         * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so
         * that it only counts requests that match the nested statement. For example, based on recent requests that you
         * have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains
         * the following nested statements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An IP match statement with an IP set that specified the address 192.0.2.44.
         * </p>
         * </li>
         * <li>
         * <p>
         * A string match statement that searches in the User-Agent header for the string BadBot.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests
         * that meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five
         * minutes, the rule action triggers. Requests that do not meet both conditions are not counted towards the rate
         * limit and are not affected by this rule.
         * </p>
         * <p>
         * You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code>
         * inside a web ACL and inside a rule group.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateBasedStatement.Builder} avoiding the
         * need to create one manually via {@link RateBasedStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link RateBasedStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #rateBasedStatement(RateBasedStatement)}.
         * 
         * @param rateBasedStatement
         *        a consumer that will call methods on {@link RateBasedStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rateBasedStatement(RateBasedStatement)
         */
        default Builder rateBasedStatement(Consumer<RateBasedStatement.Builder> rateBasedStatement) {
            return rateBasedStatement(RateBasedStatement.builder().applyMutation(rateBasedStatement).build());
        }

        /**
         * <p>
         * A logical rule statement used to combine other rule statements with AND logic. You provide more than one
         * <a>Statement</a> within the <code>AndStatement</code>.
         * </p>
         * 
         * @param andStatement
         *        A logical rule statement used to combine other rule statements with AND logic. You provide more than
         *        one <a>Statement</a> within the <code>AndStatement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andStatement(AndStatement andStatement);

        /**
         * <p>
         * A logical rule statement used to combine other rule statements with AND logic. You provide more than one
         * <a>Statement</a> within the <code>AndStatement</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AndStatement.Builder} avoiding the need
         * to create one manually via {@link AndStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link AndStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #andStatement(AndStatement)}.
         * 
         * @param andStatement
         *        a consumer that will call methods on {@link AndStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andStatement(AndStatement)
         */
        default Builder andStatement(Consumer<AndStatement.Builder> andStatement) {
            return andStatement(AndStatement.builder().applyMutation(andStatement).build());
        }

        /**
         * <p>
         * A logical rule statement used to combine other rule statements with OR logic. You provide more than one
         * <a>Statement</a> within the <code>OrStatement</code>.
         * </p>
         * 
         * @param orStatement
         *        A logical rule statement used to combine other rule statements with OR logic. You provide more than
         *        one <a>Statement</a> within the <code>OrStatement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orStatement(OrStatement orStatement);

        /**
         * <p>
         * A logical rule statement used to combine other rule statements with OR logic. You provide more than one
         * <a>Statement</a> within the <code>OrStatement</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrStatement.Builder} avoiding the need to
         * create one manually via {@link OrStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrStatement.Builder#build()} is called immediately and its result
         * is passed to {@link #orStatement(OrStatement)}.
         * 
         * @param orStatement
         *        a consumer that will call methods on {@link OrStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orStatement(OrStatement)
         */
        default Builder orStatement(Consumer<OrStatement.Builder> orStatement) {
            return orStatement(OrStatement.builder().applyMutation(orStatement).build());
        }

        /**
         * <p>
         * A logical rule statement used to negate the results of another rule statement. You provide one
         * <a>Statement</a> within the <code>NotStatement</code>.
         * </p>
         * 
         * @param notStatement
         *        A logical rule statement used to negate the results of another rule statement. You provide one
         *        <a>Statement</a> within the <code>NotStatement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notStatement(NotStatement notStatement);

        /**
         * <p>
         * A logical rule statement used to negate the results of another rule statement. You provide one
         * <a>Statement</a> within the <code>NotStatement</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotStatement.Builder} avoiding the need
         * to create one manually via {@link NotStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #notStatement(NotStatement)}.
         * 
         * @param notStatement
         *        a consumer that will call methods on {@link NotStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notStatement(NotStatement)
         */
        default Builder notStatement(Consumer<NotStatement.Builder> notStatement) {
            return notStatement(NotStatement.builder().applyMutation(notStatement).build());
        }

        /**
         * <p>
         * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the
         * vendor name and the name of the rule group in this statement. You can retrieve the required names by calling
         * <a>ListAvailableManagedRuleGroups</a>.
         * </p>
         * <p>
         * You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement
         * within a rule.
         * </p>
         * 
         * @param managedRuleGroupStatement
         *        A rule statement used to run the rules that are defined in a managed rule group. To use this, provide
         *        the vendor name and the name of the rule group in this statement. You can retrieve the required names
         *        by calling <a>ListAvailableManagedRuleGroups</a>.</p>
         *        <p>
         *        You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
         *        <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level
         *        statement within a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRuleGroupStatement(ManagedRuleGroupStatement managedRuleGroupStatement);

        /**
         * <p>
         * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the
         * vendor name and the name of the rule group in this statement. You can retrieve the required names by calling
         * <a>ListAvailableManagedRuleGroups</a>.
         * </p>
         * <p>
         * You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement
         * within a rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedRuleGroupStatement.Builder}
         * avoiding the need to create one manually via {@link ManagedRuleGroupStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManagedRuleGroupStatement.Builder#build()} is called immediately
         * and its result is passed to {@link #managedRuleGroupStatement(ManagedRuleGroupStatement)}.
         * 
         * @param managedRuleGroupStatement
         *        a consumer that will call methods on {@link ManagedRuleGroupStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedRuleGroupStatement(ManagedRuleGroupStatement)
         */
        default Builder managedRuleGroupStatement(Consumer<ManagedRuleGroupStatement.Builder> managedRuleGroupStatement) {
            return managedRuleGroupStatement(ManagedRuleGroupStatement.builder().applyMutation(managedRuleGroupStatement).build());
        }

        /**
         * <p>
         * A rule statement that defines a string match search against labels that have been added to the web request by
         * rules that have already run in the web ACL.
         * </p>
         * <p>
         * The label match statement provides the label or namespace string to search for. The label string can
         * represent a part or all of the fully qualified label name that had been added to the web request. Fully
         * qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or
         * web ACL context of the rule that added the label. If you do not provide the fully qualified name in your
         * label match string, WAF performs the search for labels that were added in the same context as the label match
         * statement.
         * </p>
         * 
         * @param labelMatchStatement
         *        A rule statement that defines a string match search against labels that have been added to the web
         *        request by rules that have already run in the web ACL. </p>
         *        <p>
         *        The label match statement provides the label or namespace string to search for. The label string can
         *        represent a part or all of the fully qualified label name that had been added to the web request.
         *        Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the
         *        rule group or web ACL context of the rule that added the label. If you do not provide the fully
         *        qualified name in your label match string, WAF performs the search for labels that were added in the
         *        same context as the label match statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelMatchStatement(LabelMatchStatement labelMatchStatement);

        /**
         * <p>
         * A rule statement that defines a string match search against labels that have been added to the web request by
         * rules that have already run in the web ACL.
         * </p>
         * <p>
         * The label match statement provides the label or namespace string to search for. The label string can
         * represent a part or all of the fully qualified label name that had been added to the web request. Fully
         * qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or
         * web ACL context of the rule that added the label. If you do not provide the fully qualified name in your
         * label match string, WAF performs the search for labels that were added in the same context as the label match
         * statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelMatchStatement.Builder} avoiding the
         * need to create one manually via {@link LabelMatchStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelMatchStatement.Builder#build()} is called immediately and
         * its result is passed to {@link #labelMatchStatement(LabelMatchStatement)}.
         * 
         * @param labelMatchStatement
         *        a consumer that will call methods on {@link LabelMatchStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelMatchStatement(LabelMatchStatement)
         */
        default Builder labelMatchStatement(Consumer<LabelMatchStatement.Builder> labelMatchStatement) {
            return labelMatchStatement(LabelMatchStatement.builder().applyMutation(labelMatchStatement).build());
        }

        /**
         * <p>
         * A rule statement used to search web request components for a match against a single regular expression.
         * </p>
         * 
         * @param regexMatchStatement
         *        A rule statement used to search web request components for a match against a single regular
         *        expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchStatement(RegexMatchStatement regexMatchStatement);

        /**
         * <p>
         * A rule statement used to search web request components for a match against a single regular expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegexMatchStatement.Builder} avoiding the
         * need to create one manually via {@link RegexMatchStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegexMatchStatement.Builder#build()} is called immediately and
         * its result is passed to {@link #regexMatchStatement(RegexMatchStatement)}.
         * 
         * @param regexMatchStatement
         *        a consumer that will call methods on {@link RegexMatchStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexMatchStatement(RegexMatchStatement)
         */
        default Builder regexMatchStatement(Consumer<RegexMatchStatement.Builder> regexMatchStatement) {
            return regexMatchStatement(RegexMatchStatement.builder().applyMutation(regexMatchStatement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ByteMatchStatement byteMatchStatement;

        private SqliMatchStatement sqliMatchStatement;

        private XssMatchStatement xssMatchStatement;

        private SizeConstraintStatement sizeConstraintStatement;

        private GeoMatchStatement geoMatchStatement;

        private RuleGroupReferenceStatement ruleGroupReferenceStatement;

        private IPSetReferenceStatement ipSetReferenceStatement;

        private RegexPatternSetReferenceStatement regexPatternSetReferenceStatement;

        private RateBasedStatement rateBasedStatement;

        private AndStatement andStatement;

        private OrStatement orStatement;

        private NotStatement notStatement;

        private ManagedRuleGroupStatement managedRuleGroupStatement;

        private LabelMatchStatement labelMatchStatement;

        private RegexMatchStatement regexMatchStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            byteMatchStatement(model.byteMatchStatement);
            sqliMatchStatement(model.sqliMatchStatement);
            xssMatchStatement(model.xssMatchStatement);
            sizeConstraintStatement(model.sizeConstraintStatement);
            geoMatchStatement(model.geoMatchStatement);
            ruleGroupReferenceStatement(model.ruleGroupReferenceStatement);
            ipSetReferenceStatement(model.ipSetReferenceStatement);
            regexPatternSetReferenceStatement(model.regexPatternSetReferenceStatement);
            rateBasedStatement(model.rateBasedStatement);
            andStatement(model.andStatement);
            orStatement(model.orStatement);
            notStatement(model.notStatement);
            managedRuleGroupStatement(model.managedRuleGroupStatement);
            labelMatchStatement(model.labelMatchStatement);
            regexMatchStatement(model.regexMatchStatement);
        }

        public final ByteMatchStatement.Builder getByteMatchStatement() {
            return byteMatchStatement != null ? byteMatchStatement.toBuilder() : null;
        }

        public final void setByteMatchStatement(ByteMatchStatement.BuilderImpl byteMatchStatement) {
            this.byteMatchStatement = byteMatchStatement != null ? byteMatchStatement.build() : null;
        }

        @Override
        public final Builder byteMatchStatement(ByteMatchStatement byteMatchStatement) {
            this.byteMatchStatement = byteMatchStatement;
            return this;
        }

        public final SqliMatchStatement.Builder getSqliMatchStatement() {
            return sqliMatchStatement != null ? sqliMatchStatement.toBuilder() : null;
        }

        public final void setSqliMatchStatement(SqliMatchStatement.BuilderImpl sqliMatchStatement) {
            this.sqliMatchStatement = sqliMatchStatement != null ? sqliMatchStatement.build() : null;
        }

        @Override
        public final Builder sqliMatchStatement(SqliMatchStatement sqliMatchStatement) {
            this.sqliMatchStatement = sqliMatchStatement;
            return this;
        }

        public final XssMatchStatement.Builder getXssMatchStatement() {
            return xssMatchStatement != null ? xssMatchStatement.toBuilder() : null;
        }

        public final void setXssMatchStatement(XssMatchStatement.BuilderImpl xssMatchStatement) {
            this.xssMatchStatement = xssMatchStatement != null ? xssMatchStatement.build() : null;
        }

        @Override
        public final Builder xssMatchStatement(XssMatchStatement xssMatchStatement) {
            this.xssMatchStatement = xssMatchStatement;
            return this;
        }

        public final SizeConstraintStatement.Builder getSizeConstraintStatement() {
            return sizeConstraintStatement != null ? sizeConstraintStatement.toBuilder() : null;
        }

        public final void setSizeConstraintStatement(SizeConstraintStatement.BuilderImpl sizeConstraintStatement) {
            this.sizeConstraintStatement = sizeConstraintStatement != null ? sizeConstraintStatement.build() : null;
        }

        @Override
        public final Builder sizeConstraintStatement(SizeConstraintStatement sizeConstraintStatement) {
            this.sizeConstraintStatement = sizeConstraintStatement;
            return this;
        }

        public final GeoMatchStatement.Builder getGeoMatchStatement() {
            return geoMatchStatement != null ? geoMatchStatement.toBuilder() : null;
        }

        public final void setGeoMatchStatement(GeoMatchStatement.BuilderImpl geoMatchStatement) {
            this.geoMatchStatement = geoMatchStatement != null ? geoMatchStatement.build() : null;
        }

        @Override
        public final Builder geoMatchStatement(GeoMatchStatement geoMatchStatement) {
            this.geoMatchStatement = geoMatchStatement;
            return this;
        }

        public final RuleGroupReferenceStatement.Builder getRuleGroupReferenceStatement() {
            return ruleGroupReferenceStatement != null ? ruleGroupReferenceStatement.toBuilder() : null;
        }

        public final void setRuleGroupReferenceStatement(RuleGroupReferenceStatement.BuilderImpl ruleGroupReferenceStatement) {
            this.ruleGroupReferenceStatement = ruleGroupReferenceStatement != null ? ruleGroupReferenceStatement.build() : null;
        }

        @Override
        public final Builder ruleGroupReferenceStatement(RuleGroupReferenceStatement ruleGroupReferenceStatement) {
            this.ruleGroupReferenceStatement = ruleGroupReferenceStatement;
            return this;
        }

        public final IPSetReferenceStatement.Builder getIpSetReferenceStatement() {
            return ipSetReferenceStatement != null ? ipSetReferenceStatement.toBuilder() : null;
        }

        public final void setIpSetReferenceStatement(IPSetReferenceStatement.BuilderImpl ipSetReferenceStatement) {
            this.ipSetReferenceStatement = ipSetReferenceStatement != null ? ipSetReferenceStatement.build() : null;
        }

        @Override
        public final Builder ipSetReferenceStatement(IPSetReferenceStatement ipSetReferenceStatement) {
            this.ipSetReferenceStatement = ipSetReferenceStatement;
            return this;
        }

        public final RegexPatternSetReferenceStatement.Builder getRegexPatternSetReferenceStatement() {
            return regexPatternSetReferenceStatement != null ? regexPatternSetReferenceStatement.toBuilder() : null;
        }

        public final void setRegexPatternSetReferenceStatement(
                RegexPatternSetReferenceStatement.BuilderImpl regexPatternSetReferenceStatement) {
            this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement != null ? regexPatternSetReferenceStatement
                    .build() : null;
        }

        @Override
        public final Builder regexPatternSetReferenceStatement(RegexPatternSetReferenceStatement regexPatternSetReferenceStatement) {
            this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
            return this;
        }

        public final RateBasedStatement.Builder getRateBasedStatement() {
            return rateBasedStatement != null ? rateBasedStatement.toBuilder() : null;
        }

        public final void setRateBasedStatement(RateBasedStatement.BuilderImpl rateBasedStatement) {
            this.rateBasedStatement = rateBasedStatement != null ? rateBasedStatement.build() : null;
        }

        @Override
        public final Builder rateBasedStatement(RateBasedStatement rateBasedStatement) {
            this.rateBasedStatement = rateBasedStatement;
            return this;
        }

        public final AndStatement.Builder getAndStatement() {
            return andStatement != null ? andStatement.toBuilder() : null;
        }

        public final void setAndStatement(AndStatement.BuilderImpl andStatement) {
            this.andStatement = andStatement != null ? andStatement.build() : null;
        }

        @Override
        public final Builder andStatement(AndStatement andStatement) {
            this.andStatement = andStatement;
            return this;
        }

        public final OrStatement.Builder getOrStatement() {
            return orStatement != null ? orStatement.toBuilder() : null;
        }

        public final void setOrStatement(OrStatement.BuilderImpl orStatement) {
            this.orStatement = orStatement != null ? orStatement.build() : null;
        }

        @Override
        public final Builder orStatement(OrStatement orStatement) {
            this.orStatement = orStatement;
            return this;
        }

        public final NotStatement.Builder getNotStatement() {
            return notStatement != null ? notStatement.toBuilder() : null;
        }

        public final void setNotStatement(NotStatement.BuilderImpl notStatement) {
            this.notStatement = notStatement != null ? notStatement.build() : null;
        }

        @Override
        public final Builder notStatement(NotStatement notStatement) {
            this.notStatement = notStatement;
            return this;
        }

        public final ManagedRuleGroupStatement.Builder getManagedRuleGroupStatement() {
            return managedRuleGroupStatement != null ? managedRuleGroupStatement.toBuilder() : null;
        }

        public final void setManagedRuleGroupStatement(ManagedRuleGroupStatement.BuilderImpl managedRuleGroupStatement) {
            this.managedRuleGroupStatement = managedRuleGroupStatement != null ? managedRuleGroupStatement.build() : null;
        }

        @Override
        public final Builder managedRuleGroupStatement(ManagedRuleGroupStatement managedRuleGroupStatement) {
            this.managedRuleGroupStatement = managedRuleGroupStatement;
            return this;
        }

        public final LabelMatchStatement.Builder getLabelMatchStatement() {
            return labelMatchStatement != null ? labelMatchStatement.toBuilder() : null;
        }

        public final void setLabelMatchStatement(LabelMatchStatement.BuilderImpl labelMatchStatement) {
            this.labelMatchStatement = labelMatchStatement != null ? labelMatchStatement.build() : null;
        }

        @Override
        public final Builder labelMatchStatement(LabelMatchStatement labelMatchStatement) {
            this.labelMatchStatement = labelMatchStatement;
            return this;
        }

        public final RegexMatchStatement.Builder getRegexMatchStatement() {
            return regexMatchStatement != null ? regexMatchStatement.toBuilder() : null;
        }

        public final void setRegexMatchStatement(RegexMatchStatement.BuilderImpl regexMatchStatement) {
            this.regexMatchStatement = regexMatchStatement != null ? regexMatchStatement.build() : null;
        }

        @Override
        public final Builder regexMatchStatement(RegexMatchStatement regexMatchStatement) {
            this.regexMatchStatement = regexMatchStatement;
            return this;
        }

        @Override
        public Statement build() {
            return new Statement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
