/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it can only
 * contain a rule group reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallManagerStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallManagerStatement.Builder, FirewallManagerStatement> {
    private static final SdkField<ManagedRuleGroupStatement> MANAGED_RULE_GROUP_STATEMENT_FIELD = SdkField
            .<ManagedRuleGroupStatement> builder(MarshallingType.SDK_POJO).memberName("ManagedRuleGroupStatement")
            .getter(getter(FirewallManagerStatement::managedRuleGroupStatement))
            .setter(setter(Builder::managedRuleGroupStatement)).constructor(ManagedRuleGroupStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRuleGroupStatement").build())
            .build();

    private static final SdkField<RuleGroupReferenceStatement> RULE_GROUP_REFERENCE_STATEMENT_FIELD = SdkField
            .<RuleGroupReferenceStatement> builder(MarshallingType.SDK_POJO)
            .memberName("RuleGroupReferenceStatement")
            .getter(getter(FirewallManagerStatement::ruleGroupReferenceStatement))
            .setter(setter(Builder::ruleGroupReferenceStatement))
            .constructor(RuleGroupReferenceStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupReferenceStatement")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MANAGED_RULE_GROUP_STATEMENT_FIELD, RULE_GROUP_REFERENCE_STATEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ManagedRuleGroupStatement managedRuleGroupStatement;

    private final RuleGroupReferenceStatement ruleGroupReferenceStatement;

    private FirewallManagerStatement(BuilderImpl builder) {
        this.managedRuleGroupStatement = builder.managedRuleGroupStatement;
        this.ruleGroupReferenceStatement = builder.ruleGroupReferenceStatement;
    }

    /**
     * <p>
     * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor
     * name and the name of the rule group in this statement. You can retrieve the required names by calling
     * <a>ListAvailableManagedRuleGroups</a>.
     * </p>
     * <p>
     * You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a <code>NotStatement</code>
     * or <code>OrStatement</code>. It can only be referenced as a top-level statement within a rule.
     * </p>
     * <note>
     * <p>
     * You are charged additional fees when you use the WAF Bot Control managed rule group
     * <code>AWSManagedRulesBotControlRuleSet</code> or the WAF Fraud Control account takeover prevention (ATP) managed
     * rule group <code>AWSManagedRulesATPRuleSet</code>. For more information, see <a
     * href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     * </p>
     * </note>
     * 
     * @return A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the
     *         vendor name and the name of the rule group in this statement. You can retrieve the required names by
     *         calling <a>ListAvailableManagedRuleGroups</a>.</p>
     *         <p>
     *         You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
     *         <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement
     *         within a rule.
     *         </p>
     *         <note>
     *         <p>
     *         You are charged additional fees when you use the WAF Bot Control managed rule group
     *         <code>AWSManagedRulesBotControlRuleSet</code> or the WAF Fraud Control account takeover prevention (ATP)
     *         managed rule group <code>AWSManagedRulesATPRuleSet</code>. For more information, see <a
     *         href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     *         </p>
     */
    public final ManagedRuleGroupStatement managedRuleGroupStatement() {
        return managedRuleGroupStatement;
    }

    /**
     * <p>
     * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group
     * with your rules, then provide the ARN of the rule group in this statement.
     * </p>
     * <p>
     * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
     * <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at the
     * top level inside a web ACL.
     * </p>
     * 
     * @return A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule
     *         group with your rules, then provide the ARN of the rule group in this statement.</p>
     *         <p>
     *         You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
     *         <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement
     *         at the top level inside a web ACL.
     */
    public final RuleGroupReferenceStatement ruleGroupReferenceStatement() {
        return ruleGroupReferenceStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(managedRuleGroupStatement());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupReferenceStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallManagerStatement)) {
            return false;
        }
        FirewallManagerStatement other = (FirewallManagerStatement) obj;
        return Objects.equals(managedRuleGroupStatement(), other.managedRuleGroupStatement())
                && Objects.equals(ruleGroupReferenceStatement(), other.ruleGroupReferenceStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallManagerStatement").add("ManagedRuleGroupStatement", managedRuleGroupStatement())
                .add("RuleGroupReferenceStatement", ruleGroupReferenceStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedRuleGroupStatement":
            return Optional.ofNullable(clazz.cast(managedRuleGroupStatement()));
        case "RuleGroupReferenceStatement":
            return Optional.ofNullable(clazz.cast(ruleGroupReferenceStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallManagerStatement, T> g) {
        return obj -> g.apply((FirewallManagerStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallManagerStatement> {
        /**
         * <p>
         * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the
         * vendor name and the name of the rule group in this statement. You can retrieve the required names by calling
         * <a>ListAvailableManagedRuleGroups</a>.
         * </p>
         * <p>
         * You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement
         * within a rule.
         * </p>
         * <note>
         * <p>
         * You are charged additional fees when you use the WAF Bot Control managed rule group
         * <code>AWSManagedRulesBotControlRuleSet</code> or the WAF Fraud Control account takeover prevention (ATP)
         * managed rule group <code>AWSManagedRulesATPRuleSet</code>. For more information, see <a
         * href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         * </p>
         * </note>
         * 
         * @param managedRuleGroupStatement
         *        A rule statement used to run the rules that are defined in a managed rule group. To use this, provide
         *        the vendor name and the name of the rule group in this statement. You can retrieve the required names
         *        by calling <a>ListAvailableManagedRuleGroups</a>.</p>
         *        <p>
         *        You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
         *        <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level
         *        statement within a rule.
         *        </p>
         *        <note>
         *        <p>
         *        You are charged additional fees when you use the WAF Bot Control managed rule group
         *        <code>AWSManagedRulesBotControlRuleSet</code> or the WAF Fraud Control account takeover prevention
         *        (ATP) managed rule group <code>AWSManagedRulesATPRuleSet</code>. For more information, see <a
         *        href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRuleGroupStatement(ManagedRuleGroupStatement managedRuleGroupStatement);

        /**
         * <p>
         * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the
         * vendor name and the name of the rule group in this statement. You can retrieve the required names by calling
         * <a>ListAvailableManagedRuleGroups</a>.
         * </p>
         * <p>
         * You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement
         * within a rule.
         * </p>
         * <note>
         * <p>
         * You are charged additional fees when you use the WAF Bot Control managed rule group
         * <code>AWSManagedRulesBotControlRuleSet</code> or the WAF Fraud Control account takeover prevention (ATP)
         * managed rule group <code>AWSManagedRulesATPRuleSet</code>. For more information, see <a
         * href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link ManagedRuleGroupStatement.Builder} avoiding the need to create one manually via
         * {@link ManagedRuleGroupStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedRuleGroupStatement.Builder#build()} is called immediately
         * and its result is passed to {@link #managedRuleGroupStatement(ManagedRuleGroupStatement)}.
         * 
         * @param managedRuleGroupStatement
         *        a consumer that will call methods on {@link ManagedRuleGroupStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedRuleGroupStatement(ManagedRuleGroupStatement)
         */
        default Builder managedRuleGroupStatement(Consumer<ManagedRuleGroupStatement.Builder> managedRuleGroupStatement) {
            return managedRuleGroupStatement(ManagedRuleGroupStatement.builder().applyMutation(managedRuleGroupStatement).build());
        }

        /**
         * <p>
         * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule
         * group with your rules, then provide the ARN of the rule group in this statement.
         * </p>
         * <p>
         * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at
         * the top level inside a web ACL.
         * </p>
         * 
         * @param ruleGroupReferenceStatement
         *        A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a
         *        rule group with your rules, then provide the ARN of the rule group in this statement.</p>
         *        <p>
         *        You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
         *        <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference
         *        statement at the top level inside a web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupReferenceStatement(RuleGroupReferenceStatement ruleGroupReferenceStatement);

        /**
         * <p>
         * A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule
         * group with your rules, then provide the ARN of the rule group in this statement.
         * </p>
         * <p>
         * You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a
         * <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at
         * the top level inside a web ACL.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroupReferenceStatement.Builder}
         * avoiding the need to create one manually via {@link RuleGroupReferenceStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupReferenceStatement.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleGroupReferenceStatement(RuleGroupReferenceStatement)}.
         * 
         * @param ruleGroupReferenceStatement
         *        a consumer that will call methods on {@link RuleGroupReferenceStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroupReferenceStatement(RuleGroupReferenceStatement)
         */
        default Builder ruleGroupReferenceStatement(Consumer<RuleGroupReferenceStatement.Builder> ruleGroupReferenceStatement) {
            return ruleGroupReferenceStatement(RuleGroupReferenceStatement.builder().applyMutation(ruleGroupReferenceStatement)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ManagedRuleGroupStatement managedRuleGroupStatement;

        private RuleGroupReferenceStatement ruleGroupReferenceStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallManagerStatement model) {
            managedRuleGroupStatement(model.managedRuleGroupStatement);
            ruleGroupReferenceStatement(model.ruleGroupReferenceStatement);
        }

        public final ManagedRuleGroupStatement.Builder getManagedRuleGroupStatement() {
            return managedRuleGroupStatement != null ? managedRuleGroupStatement.toBuilder() : null;
        }

        public final void setManagedRuleGroupStatement(ManagedRuleGroupStatement.BuilderImpl managedRuleGroupStatement) {
            this.managedRuleGroupStatement = managedRuleGroupStatement != null ? managedRuleGroupStatement.build() : null;
        }

        @Override
        public final Builder managedRuleGroupStatement(ManagedRuleGroupStatement managedRuleGroupStatement) {
            this.managedRuleGroupStatement = managedRuleGroupStatement;
            return this;
        }

        public final RuleGroupReferenceStatement.Builder getRuleGroupReferenceStatement() {
            return ruleGroupReferenceStatement != null ? ruleGroupReferenceStatement.toBuilder() : null;
        }

        public final void setRuleGroupReferenceStatement(RuleGroupReferenceStatement.BuilderImpl ruleGroupReferenceStatement) {
            this.ruleGroupReferenceStatement = ruleGroupReferenceStatement != null ? ruleGroupReferenceStatement.build() : null;
        }

        @Override
        public final Builder ruleGroupReferenceStatement(RuleGroupReferenceStatement ruleGroupReferenceStatement) {
            this.ruleGroupReferenceStatement = ruleGroupReferenceStatement;
            return this;
        }

        @Override
        public FirewallManagerStatement build() {
            return new FirewallManagerStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
