/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule statement that defines a string match search against labels that have been added to the web request by rules
 * that have already run in the web ACL.
 * </p>
 * <p>
 * The label match statement provides the label or namespace string to search for. The label string can represent a part
 * or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a
 * prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that
 * added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search
 * for labels that were added in the same context as the label match statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelMatchStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelMatchStatement.Builder, LabelMatchStatement> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(LabelMatchStatement::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(LabelMatchStatement::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scope;

    private final String key;

    private LabelMatchStatement(BuilderImpl builder) {
        this.scope = builder.scope;
        this.key = builder.key;
    }

    /**
     * <p>
     * Specify whether you want to match using the label name or just the namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link LabelMatchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specify whether you want to match using the label name or just the namespace.
     * @see LabelMatchScope
     */
    public final LabelMatchScope scope() {
        return LabelMatchScope.fromValue(scope);
    }

    /**
     * <p>
     * Specify whether you want to match using the label name or just the namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link LabelMatchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specify whether you want to match using the label name or just the namespace.
     * @see LabelMatchScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The string to match against. The setting you provide for this depends on the match statement's <code>Scope</code>
     * setting:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the <code>Scope</code> indicates <code>LABEL</code>, then this specification must include the name and can
     * include any number of preceding namespace specifications and prefix up to providing the fully qualified label
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>Scope</code> indicates <code>NAMESPACE</code>, then this specification can include any number of
     * contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL
     * where the label originates.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Labels are case sensitive and components of a label must be separated by colon, for example
     * <code>NS1:NS2:name</code>.
     * </p>
     * 
     * @return The string to match against. The setting you provide for this depends on the match statement's
     *         <code>Scope</code> setting: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the <code>Scope</code> indicates <code>LABEL</code>, then this specification must include the name and
     *         can include any number of preceding namespace specifications and prefix up to providing the fully
     *         qualified label name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the <code>Scope</code> indicates <code>NAMESPACE</code>, then this specification can include any
     *         number of contiguous namespace strings, and can include the entire label namespace prefix from the rule
     *         group or web ACL where the label originates.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Labels are case sensitive and components of a label must be separated by colon, for example
     *         <code>NS1:NS2:name</code>.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelMatchStatement)) {
            return false;
        }
        LabelMatchStatement other = (LabelMatchStatement) obj;
        return Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelMatchStatement").add("Scope", scopeAsString()).add("Key", key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelMatchStatement, T> g) {
        return obj -> g.apply((LabelMatchStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelMatchStatement> {
        /**
         * <p>
         * Specify whether you want to match using the label name or just the namespace.
         * </p>
         * 
         * @param scope
         *        Specify whether you want to match using the label name or just the namespace.
         * @see LabelMatchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelMatchScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specify whether you want to match using the label name or just the namespace.
         * </p>
         * 
         * @param scope
         *        Specify whether you want to match using the label name or just the namespace.
         * @see LabelMatchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelMatchScope
         */
        Builder scope(LabelMatchScope scope);

        /**
         * <p>
         * The string to match against. The setting you provide for this depends on the match statement's
         * <code>Scope</code> setting:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the <code>Scope</code> indicates <code>LABEL</code>, then this specification must include the name and can
         * include any number of preceding namespace specifications and prefix up to providing the fully qualified label
         * name.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the <code>Scope</code> indicates <code>NAMESPACE</code>, then this specification can include any number of
         * contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web
         * ACL where the label originates.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Labels are case sensitive and components of a label must be separated by colon, for example
         * <code>NS1:NS2:name</code>.
         * </p>
         * 
         * @param key
         *        The string to match against. The setting you provide for this depends on the match statement's
         *        <code>Scope</code> setting: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the <code>Scope</code> indicates <code>LABEL</code>, then this specification must include the name
         *        and can include any number of preceding namespace specifications and prefix up to providing the fully
         *        qualified label name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the <code>Scope</code> indicates <code>NAMESPACE</code>, then this specification can include any
         *        number of contiguous namespace strings, and can include the entire label namespace prefix from the
         *        rule group or web ACL where the label originates.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Labels are case sensitive and components of a label must be separated by colon, for example
         *        <code>NS1:NS2:name</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);
    }

    static final class BuilderImpl implements Builder {
        private String scope;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelMatchStatement model) {
            scope(model.scope);
            key(model.key);
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(LabelMatchScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public LabelMatchStatement build() {
            return new LabelMatchStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
