/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response body to use in a custom response to a web request. This is referenced by key from <a>CustomResponse</a>
 * <code>CustomResponseBodyKey</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomResponseBody implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomResponseBody.Builder, CustomResponseBody> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(CustomResponseBody::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(CustomResponseBody::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentType;

    private final String content;

    private CustomResponseBody(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.content = builder.content;
    }

    /**
     * <p>
     * The type of content in the payload that you are defining in the <code>Content</code> string.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ResponseContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The type of content in the payload that you are defining in the <code>Content</code> string.
     * @see ResponseContentType
     */
    public final ResponseContentType contentType() {
        return ResponseContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The type of content in the payload that you are defining in the <code>Content</code> string.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ResponseContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The type of content in the payload that you are defining in the <code>Content</code> string.
     * @see ResponseContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * The payload of the custom response.
     * </p>
     * <p>
     * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the
     * <code>ContentType</code> setting.
     * </p>
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
     * </p>
     * 
     * @return The payload of the custom response. </p>
     *         <p>
     *         You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the
     *         <code>ContentType</code> setting.
     *         </p>
     *         <p>
     *         For information about the limits on count and size for custom request and response settings, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomResponseBody)) {
            return false;
        }
        CustomResponseBody other = (CustomResponseBody) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomResponseBody").add("ContentType", contentTypeAsString()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomResponseBody, T> g) {
        return obj -> g.apply((CustomResponseBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomResponseBody> {
        /**
         * <p>
         * The type of content in the payload that you are defining in the <code>Content</code> string.
         * </p>
         * 
         * @param contentType
         *        The type of content in the payload that you are defining in the <code>Content</code> string.
         * @see ResponseContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The type of content in the payload that you are defining in the <code>Content</code> string.
         * </p>
         * 
         * @param contentType
         *        The type of content in the payload that you are defining in the <code>Content</code> string.
         * @see ResponseContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseContentType
         */
        Builder contentType(ResponseContentType contentType);

        /**
         * <p>
         * The payload of the custom response.
         * </p>
         * <p>
         * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the
         * <code>ContentType</code> setting.
         * </p>
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
         * </p>
         * 
         * @param content
         *        The payload of the custom response. </p>
         *        <p>
         *        You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the
         *        <code>ContentType</code> setting.
         *        </p>
         *        <p>
         *        For information about the limits on count and size for custom request and response settings, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private String contentType;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomResponseBody model) {
            contentType(model.contentType);
            content(model.content);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentType(ResponseContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public CustomResponseBody build() {
            return new CustomResponseBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
