/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRateBasedStatementManagedKeysResponse extends Wafv2Response implements
        ToCopyableBuilder<GetRateBasedStatementManagedKeysResponse.Builder, GetRateBasedStatementManagedKeysResponse> {
    private static final SdkField<RateBasedStatementManagedKeysIPSet> MANAGED_KEYS_IPV4_FIELD = SdkField
            .<RateBasedStatementManagedKeysIPSet> builder(MarshallingType.SDK_POJO).memberName("ManagedKeysIPV4")
            .getter(getter(GetRateBasedStatementManagedKeysResponse::managedKeysIPV4)).setter(setter(Builder::managedKeysIPV4))
            .constructor(RateBasedStatementManagedKeysIPSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedKeysIPV4").build()).build();

    private static final SdkField<RateBasedStatementManagedKeysIPSet> MANAGED_KEYS_IPV6_FIELD = SdkField
            .<RateBasedStatementManagedKeysIPSet> builder(MarshallingType.SDK_POJO).memberName("ManagedKeysIPV6")
            .getter(getter(GetRateBasedStatementManagedKeysResponse::managedKeysIPV6)).setter(setter(Builder::managedKeysIPV6))
            .constructor(RateBasedStatementManagedKeysIPSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedKeysIPV6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_KEYS_IPV4_FIELD,
            MANAGED_KEYS_IPV6_FIELD));

    private final RateBasedStatementManagedKeysIPSet managedKeysIPV4;

    private final RateBasedStatementManagedKeysIPSet managedKeysIPV6;

    private GetRateBasedStatementManagedKeysResponse(BuilderImpl builder) {
        super(builder);
        this.managedKeysIPV4 = builder.managedKeysIPV4;
        this.managedKeysIPV6 = builder.managedKeysIPV6;
    }

    /**
     * <p>
     * The keys that are of Internet Protocol version 4 (IPv4).
     * </p>
     * 
     * @return The keys that are of Internet Protocol version 4 (IPv4).
     */
    public final RateBasedStatementManagedKeysIPSet managedKeysIPV4() {
        return managedKeysIPV4;
    }

    /**
     * <p>
     * The keys that are of Internet Protocol version 6 (IPv6).
     * </p>
     * 
     * @return The keys that are of Internet Protocol version 6 (IPv6).
     */
    public final RateBasedStatementManagedKeysIPSet managedKeysIPV6() {
        return managedKeysIPV6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedKeysIPV4());
        hashCode = 31 * hashCode + Objects.hashCode(managedKeysIPV6());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedStatementManagedKeysResponse)) {
            return false;
        }
        GetRateBasedStatementManagedKeysResponse other = (GetRateBasedStatementManagedKeysResponse) obj;
        return Objects.equals(managedKeysIPV4(), other.managedKeysIPV4())
                && Objects.equals(managedKeysIPV6(), other.managedKeysIPV6());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRateBasedStatementManagedKeysResponse").add("ManagedKeysIPV4", managedKeysIPV4())
                .add("ManagedKeysIPV6", managedKeysIPV6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedKeysIPV4":
            return Optional.ofNullable(clazz.cast(managedKeysIPV4()));
        case "ManagedKeysIPV6":
            return Optional.ofNullable(clazz.cast(managedKeysIPV6()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRateBasedStatementManagedKeysResponse, T> g) {
        return obj -> g.apply((GetRateBasedStatementManagedKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRateBasedStatementManagedKeysResponse> {
        /**
         * <p>
         * The keys that are of Internet Protocol version 4 (IPv4).
         * </p>
         * 
         * @param managedKeysIPV4
         *        The keys that are of Internet Protocol version 4 (IPv4).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedKeysIPV4(RateBasedStatementManagedKeysIPSet managedKeysIPV4);

        /**
         * <p>
         * The keys that are of Internet Protocol version 4 (IPv4).
         * </p>
         * This is a convenience that creates an instance of the {@link RateBasedStatementManagedKeysIPSet.Builder}
         * avoiding the need to create one manually via {@link RateBasedStatementManagedKeysIPSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link RateBasedStatementManagedKeysIPSet.Builder#build()} is called
         * immediately and its result is passed to {@link #managedKeysIPV4(RateBasedStatementManagedKeysIPSet)}.
         * 
         * @param managedKeysIPV4
         *        a consumer that will call methods on {@link RateBasedStatementManagedKeysIPSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedKeysIPV4(RateBasedStatementManagedKeysIPSet)
         */
        default Builder managedKeysIPV4(Consumer<RateBasedStatementManagedKeysIPSet.Builder> managedKeysIPV4) {
            return managedKeysIPV4(RateBasedStatementManagedKeysIPSet.builder().applyMutation(managedKeysIPV4).build());
        }

        /**
         * <p>
         * The keys that are of Internet Protocol version 6 (IPv6).
         * </p>
         * 
         * @param managedKeysIPV6
         *        The keys that are of Internet Protocol version 6 (IPv6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedKeysIPV6(RateBasedStatementManagedKeysIPSet managedKeysIPV6);

        /**
         * <p>
         * The keys that are of Internet Protocol version 6 (IPv6).
         * </p>
         * This is a convenience that creates an instance of the {@link RateBasedStatementManagedKeysIPSet.Builder}
         * avoiding the need to create one manually via {@link RateBasedStatementManagedKeysIPSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link RateBasedStatementManagedKeysIPSet.Builder#build()} is called
         * immediately and its result is passed to {@link #managedKeysIPV6(RateBasedStatementManagedKeysIPSet)}.
         * 
         * @param managedKeysIPV6
         *        a consumer that will call methods on {@link RateBasedStatementManagedKeysIPSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedKeysIPV6(RateBasedStatementManagedKeysIPSet)
         */
        default Builder managedKeysIPV6(Consumer<RateBasedStatementManagedKeysIPSet.Builder> managedKeysIPV6) {
            return managedKeysIPV6(RateBasedStatementManagedKeysIPSet.builder().applyMutation(managedKeysIPV6).build());
        }
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private RateBasedStatementManagedKeysIPSet managedKeysIPV4;

        private RateBasedStatementManagedKeysIPSet managedKeysIPV6;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedStatementManagedKeysResponse model) {
            super(model);
            managedKeysIPV4(model.managedKeysIPV4);
            managedKeysIPV6(model.managedKeysIPV6);
        }

        public final RateBasedStatementManagedKeysIPSet.Builder getManagedKeysIPV4() {
            return managedKeysIPV4 != null ? managedKeysIPV4.toBuilder() : null;
        }

        public final void setManagedKeysIPV4(RateBasedStatementManagedKeysIPSet.BuilderImpl managedKeysIPV4) {
            this.managedKeysIPV4 = managedKeysIPV4 != null ? managedKeysIPV4.build() : null;
        }

        @Override
        @Transient
        public final Builder managedKeysIPV4(RateBasedStatementManagedKeysIPSet managedKeysIPV4) {
            this.managedKeysIPV4 = managedKeysIPV4;
            return this;
        }

        public final RateBasedStatementManagedKeysIPSet.Builder getManagedKeysIPV6() {
            return managedKeysIPV6 != null ? managedKeysIPV6.toBuilder() : null;
        }

        public final void setManagedKeysIPV6(RateBasedStatementManagedKeysIPSet.BuilderImpl managedKeysIPV6) {
            this.managedKeysIPV6 = managedKeysIPV6 != null ? managedKeysIPV6.build() : null;
        }

        @Override
        @Transient
        public final Builder managedKeysIPV6(RateBasedStatementManagedKeysIPSet managedKeysIPV6) {
            this.managedKeysIPV6 = managedKeysIPV6;
            return this;
        }

        @Override
        public GetRateBasedStatementManagedKeysResponse build() {
            return new GetRateBasedStatementManagedKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
