/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A logical rule statement used to negate the results of another rule statement. You provide one <a>Statement</a>
 * within the <code>NotStatement</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotStatement implements SdkPojo, Serializable, ToCopyableBuilder<NotStatement.Builder, NotStatement> {
    private static final SdkField<Statement> STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .memberName("Statement").getter(getter(NotStatement::statement)).setter(setter(Builder::statement))
            .constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Statement statement;

    private NotStatement(BuilderImpl builder) {
        this.statement = builder.statement;
    }

    /**
     * <p>
     * The statement to negate. You can use any statement that can be nested.
     * </p>
     * 
     * @return The statement to negate. You can use any statement that can be nested.
     */
    public final Statement statement() {
        return statement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotStatement)) {
            return false;
        }
        NotStatement other = (NotStatement) obj;
        return Objects.equals(statement(), other.statement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotStatement").add("Statement", statement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statement":
            return Optional.ofNullable(clazz.cast(statement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotStatement, T> g) {
        return obj -> g.apply((NotStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotStatement> {
        /**
         * <p>
         * The statement to negate. You can use any statement that can be nested.
         * </p>
         * 
         * @param statement
         *        The statement to negate. You can use any statement that can be nested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statement(Statement statement);

        /**
         * <p>
         * The statement to negate. You can use any statement that can be nested.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #statement(Statement)}.
         * 
         * @param statement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statement(Statement)
         */
        default Builder statement(Consumer<Statement.Builder> statement) {
            return statement(Statement.builder().applyMutation(statement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Statement statement;

        private BuilderImpl() {
        }

        private BuilderImpl(NotStatement model) {
            statement(model.statement);
        }

        public final Statement.Builder getStatement() {
            return statement != null ? statement.toBuilder() : null;
        }

        public final void setStatement(Statement.BuilderImpl statement) {
            this.statement = statement != null ? statement.build() : null;
        }

        @Override
        @Transient
        public final Builder statement(Statement statement) {
            this.statement = statement;
            return this;
        }

        @Override
        public NotStatement build() {
            return new NotStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
