/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.IPAddressVersion;
import software.amazon.awssdk.services.wafv2.model.IPAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPSet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(IPSet.getter(IPSet::name)).setter(IPSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(IPSet.getter(IPSet::id)).setter(IPSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(IPSet.getter(IPSet::arn)).setter(IPSet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(IPSet.getter(IPSet::description)).setter(IPSet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IP_ADDRESS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPAddressVersion").getter(IPSet.getter(IPSet::ipAddressVersionAsString)).setter(IPSet.setter(Builder::ipAddressVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressVersion").build()}).build();
    private static final SdkField<List<String>> ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Addresses").getter(IPSet.getter(IPSet::addresses)).setter(IPSet.setter(Builder::addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, DESCRIPTION_FIELD, IP_ADDRESS_VERSION_FIELD, ADDRESSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final String description;
    private final String ipAddressVersion;
    private final List<String> addresses;

    private IPSet(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.ipAddressVersion = builder.ipAddressVersion;
        this.addresses = builder.addresses;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final IPAddressVersion ipAddressVersion() {
        return IPAddressVersion.fromValue(this.ipAddressVersion);
    }

    public final String ipAddressVersionAsString() {
        return this.ipAddressVersion;
    }

    public final boolean hasAddresses() {
        return this.addresses != null && !(this.addresses instanceof SdkAutoConstructList);
    }

    public final List<String> addresses() {
        return this.addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddresses() ? this.addresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSet)) {
            return false;
        }
        IPSet other = (IPSet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ipAddressVersionAsString(), other.ipAddressVersionAsString()) && this.hasAddresses() == other.hasAddresses() && Objects.equals(this.addresses(), other.addresses());
    }

    public final String toString() {
        return ToString.builder((String)"IPSet").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Description", (Object)this.description()).add("IPAddressVersion", (Object)this.ipAddressVersionAsString()).add("Addresses", this.hasAddresses() ? this.addresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IPAddressVersion": {
                return Optional.ofNullable(clazz.cast(this.ipAddressVersionAsString()));
            }
            case "Addresses": {
                return Optional.ofNullable(clazz.cast(this.addresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPSet, T> g) {
        return obj -> g.apply((IPSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private String description;
        private String ipAddressVersion;
        private List<String> addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IPSet model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.description(model.description);
            this.ipAddressVersion(model.ipAddressVersion);
            this.addresses(model.addresses);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIpAddressVersion() {
            return this.ipAddressVersion;
        }

        public final void setIpAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
        }

        @Override
        public final Builder ipAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
            return this;
        }

        @Override
        public final Builder ipAddressVersion(IPAddressVersion ipAddressVersion) {
            this.ipAddressVersion(ipAddressVersion == null ? null : ipAddressVersion.toString());
            return this;
        }

        public final Collection<String> getAddresses() {
            if (this.addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addresses;
        }

        public final void setAddresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
        }

        @Override
        public final Builder addresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(String ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        public IPSet build() {
            return new IPSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPSet> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder ipAddressVersion(String var1);

        public Builder ipAddressVersion(IPAddressVersion var1);

        public Builder addresses(Collection<String> var1);

        public Builder addresses(String ... var1);
    }
}

