/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for your use of the Bot Control managed rule group, <code>AWSManagedRulesBotControlRuleSet</code>. This
 * configuration is used in <code>ManagedRuleGroupConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AWSManagedRulesBotControlRuleSet implements SdkPojo, Serializable,
        ToCopyableBuilder<AWSManagedRulesBotControlRuleSet.Builder, AWSManagedRulesBotControlRuleSet> {
    private static final SdkField<String> INSPECTION_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InspectionLevel").getter(getter(AWSManagedRulesBotControlRuleSet::inspectionLevelAsString))
            .setter(setter(Builder::inspectionLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InspectionLevel").build()).build();

    private static final SdkField<Boolean> ENABLE_MACHINE_LEARNING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableMachineLearning").getter(getter(AWSManagedRulesBotControlRuleSet::enableMachineLearning))
            .setter(setter(Builder::enableMachineLearning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMachineLearning").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSPECTION_LEVEL_FIELD,
            ENABLE_MACHINE_LEARNING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inspectionLevel;

    private final Boolean enableMachineLearning;

    private AWSManagedRulesBotControlRuleSet(BuilderImpl builder) {
        this.inspectionLevel = builder.inspectionLevel;
        this.enableMachineLearning = builder.enableMachineLearning;
    }

    /**
     * <p>
     * The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted
     * level includes all common level rules and adds rules with more advanced inspection criteria. For details, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control
     * rule group</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inspectionLevel}
     * will return {@link InspectionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inspectionLevelAsString}.
     * </p>
     * 
     * @return The inspection level to use for the Bot Control rule group. The common level is the least expensive. The
     *         targeted level includes all common level rules and adds rules with more advanced inspection criteria. For
     *         details, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot
     *         Control rule group</a> in the <i>WAF Developer Guide</i>.
     * @see InspectionLevel
     */
    public final InspectionLevel inspectionLevel() {
        return InspectionLevel.fromValue(inspectionLevel);
    }

    /**
     * <p>
     * The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted
     * level includes all common level rules and adds rules with more advanced inspection criteria. For details, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control
     * rule group</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inspectionLevel}
     * will return {@link InspectionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inspectionLevelAsString}.
     * </p>
     * 
     * @return The inspection level to use for the Bot Control rule group. The common level is the least expensive. The
     *         targeted level includes all common level rules and adds rules with more advanced inspection criteria. For
     *         details, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot
     *         Control rule group</a> in the <i>WAF Developer Guide</i>.
     * @see InspectionLevel
     */
    public final String inspectionLevelAsString() {
        return inspectionLevel;
    }

    /**
     * <p>
     * Applies only to the targeted inspection level.
     * </p>
     * <p>
     * Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine
     * learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and
     * <code>TGT_ML_CoordinatedActivityMedium</code>, which inspect for anomalous behavior that might indicate
     * distributed, coordinated bot activity.
     * </p>
     * <p>
     * For more information about this choice, see the listing for these rules in the table at <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules"
     * >Bot Control rules listing</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * Default: <code>TRUE</code>
     * </p>
     * 
     * @return Applies only to the targeted inspection level. </p>
     *         <p>
     *         Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity.
     *         Machine learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and
     *         <code>TGT_ML_CoordinatedActivityMedium</code>, which inspect for anomalous behavior that might indicate
     *         distributed, coordinated bot activity.
     *         </p>
     *         <p>
     *         For more information about this choice, see the listing for these rules in the table at <a href=
     *         "https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules"
     *         >Bot Control rules listing</a> in the <i>WAF Developer Guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>TRUE</code>
     */
    public final Boolean enableMachineLearning() {
        return enableMachineLearning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inspectionLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableMachineLearning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSManagedRulesBotControlRuleSet)) {
            return false;
        }
        AWSManagedRulesBotControlRuleSet other = (AWSManagedRulesBotControlRuleSet) obj;
        return Objects.equals(inspectionLevelAsString(), other.inspectionLevelAsString())
                && Objects.equals(enableMachineLearning(), other.enableMachineLearning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AWSManagedRulesBotControlRuleSet").add("InspectionLevel", inspectionLevelAsString())
                .add("EnableMachineLearning", enableMachineLearning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InspectionLevel":
            return Optional.ofNullable(clazz.cast(inspectionLevelAsString()));
        case "EnableMachineLearning":
            return Optional.ofNullable(clazz.cast(enableMachineLearning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AWSManagedRulesBotControlRuleSet, T> g) {
        return obj -> g.apply((AWSManagedRulesBotControlRuleSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AWSManagedRulesBotControlRuleSet> {
        /**
         * <p>
         * The inspection level to use for the Bot Control rule group. The common level is the least expensive. The
         * targeted level includes all common level rules and adds rules with more advanced inspection criteria. For
         * details, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control
         * rule group</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param inspectionLevel
         *        The inspection level to use for the Bot Control rule group. The common level is the least expensive.
         *        The targeted level includes all common level rules and adds rules with more advanced inspection
         *        criteria. For details, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot
         *        Control rule group</a> in the <i>WAF Developer Guide</i>.
         * @see InspectionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectionLevel
         */
        Builder inspectionLevel(String inspectionLevel);

        /**
         * <p>
         * The inspection level to use for the Bot Control rule group. The common level is the least expensive. The
         * targeted level includes all common level rules and adds rules with more advanced inspection criteria. For
         * details, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control
         * rule group</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param inspectionLevel
         *        The inspection level to use for the Bot Control rule group. The common level is the least expensive.
         *        The targeted level includes all common level rules and adds rules with more advanced inspection
         *        criteria. For details, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot
         *        Control rule group</a> in the <i>WAF Developer Guide</i>.
         * @see InspectionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectionLevel
         */
        Builder inspectionLevel(InspectionLevel inspectionLevel);

        /**
         * <p>
         * Applies only to the targeted inspection level.
         * </p>
         * <p>
         * Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine
         * learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and
         * <code>TGT_ML_CoordinatedActivityMedium</code>, which inspect for anomalous behavior that might indicate
         * distributed, coordinated bot activity.
         * </p>
         * <p>
         * For more information about this choice, see the listing for these rules in the table at <a href=
         * "https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules"
         * >Bot Control rules listing</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * <p>
         * Default: <code>TRUE</code>
         * </p>
         * 
         * @param enableMachineLearning
         *        Applies only to the targeted inspection level. </p>
         *        <p>
         *        Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity.
         *        Machine learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and
         *        <code>TGT_ML_CoordinatedActivityMedium</code>, which inspect for anomalous behavior that might
         *        indicate distributed, coordinated bot activity.
         *        </p>
         *        <p>
         *        For more information about this choice, see the listing for these rules in the table at <a href=
         *        "https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules"
         *        >Bot Control rules listing</a> in the <i>WAF Developer Guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>TRUE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMachineLearning(Boolean enableMachineLearning);
    }

    static final class BuilderImpl implements Builder {
        private String inspectionLevel;

        private Boolean enableMachineLearning;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSManagedRulesBotControlRuleSet model) {
            inspectionLevel(model.inspectionLevel);
            enableMachineLearning(model.enableMachineLearning);
        }

        public final String getInspectionLevel() {
            return inspectionLevel;
        }

        public final void setInspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
        }

        @Override
        public final Builder inspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
            return this;
        }

        @Override
        public final Builder inspectionLevel(InspectionLevel inspectionLevel) {
            this.inspectionLevel(inspectionLevel == null ? null : inspectionLevel.toString());
            return this;
        }

        public final Boolean getEnableMachineLearning() {
            return enableMachineLearning;
        }

        public final void setEnableMachineLearning(Boolean enableMachineLearning) {
            this.enableMachineLearning = enableMachineLearning;
        }

        @Override
        public final Builder enableMachineLearning(Boolean enableMachineLearning) {
            this.enableMachineLearning = enableMachineLearning;
            return this;
        }

        @Override
        public AWSManagedRulesBotControlRuleSet build() {
            return new AWSManagedRulesBotControlRuleSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
