/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies that WAF should count the request. Optionally defines additional custom handling for the request.
 * </p>
 * <p>
 * This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL
 * <a>DefaultAction</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountAction implements SdkPojo, Serializable, ToCopyableBuilder<CountAction.Builder, CountAction> {
    private static final SdkField<CustomRequestHandling> CUSTOM_REQUEST_HANDLING_FIELD = SdkField
            .<CustomRequestHandling> builder(MarshallingType.SDK_POJO).memberName("CustomRequestHandling")
            .getter(getter(CountAction::customRequestHandling)).setter(setter(Builder::customRequestHandling))
            .constructor(CustomRequestHandling::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRequestHandling").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CUSTOM_REQUEST_HANDLING_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomRequestHandling customRequestHandling;

    private CountAction(BuilderImpl builder) {
        this.customRequestHandling = builder.customRequestHandling;
    }

    /**
     * <p>
     * Defines custom handling for the web request.
     * </p>
     * <p>
     * For information about customizing web requests and responses, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
     * requests and responses in WAF</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
     * </p>
     * 
     * @return Defines custom handling for the web request.</p>
     *         <p>
     *         For information about customizing web requests and responses, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing
     *         web requests and responses in WAF</a> in the <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
     */
    public final CustomRequestHandling customRequestHandling() {
        return customRequestHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customRequestHandling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountAction)) {
            return false;
        }
        CountAction other = (CountAction) obj;
        return Objects.equals(customRequestHandling(), other.customRequestHandling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CountAction").add("CustomRequestHandling", customRequestHandling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomRequestHandling":
            return Optional.ofNullable(clazz.cast(customRequestHandling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CountAction, T> g) {
        return obj -> g.apply((CountAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CountAction> {
        /**
         * <p>
         * Defines custom handling for the web request.
         * </p>
         * <p>
         * For information about customizing web requests and responses, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
         * requests and responses in WAF</a> in the <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
         * </p>
         * 
         * @param customRequestHandling
         *        Defines custom handling for the web request.</p>
         *        <p>
         *        For information about customizing web requests and responses, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html"
         *        >Customizing web requests and responses in WAF</a> in the <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRequestHandling(CustomRequestHandling customRequestHandling);

        /**
         * <p>
         * Defines custom handling for the web request.
         * </p>
         * <p>
         * For information about customizing web requests and responses, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
         * requests and responses in WAF</a> in the <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomRequestHandling.Builder} avoiding
         * the need to create one manually via {@link CustomRequestHandling#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomRequestHandling.Builder#build()} is called immediately and
         * its result is passed to {@link #customRequestHandling(CustomRequestHandling)}.
         * 
         * @param customRequestHandling
         *        a consumer that will call methods on {@link CustomRequestHandling.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRequestHandling(CustomRequestHandling)
         */
        default Builder customRequestHandling(Consumer<CustomRequestHandling.Builder> customRequestHandling) {
            return customRequestHandling(CustomRequestHandling.builder().applyMutation(customRequestHandling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomRequestHandling customRequestHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(CountAction model) {
            customRequestHandling(model.customRequestHandling);
        }

        public final CustomRequestHandling.Builder getCustomRequestHandling() {
            return customRequestHandling != null ? customRequestHandling.toBuilder() : null;
        }

        public final void setCustomRequestHandling(CustomRequestHandling.BuilderImpl customRequestHandling) {
            this.customRequestHandling = customRequestHandling != null ? customRequestHandling.build() : null;
        }

        @Override
        public final Builder customRequestHandling(CustomRequestHandling customRequestHandling) {
            this.customRequestHandling = customRequestHandling;
            return this;
        }

        @Override
        public CountAction build() {
            return new CountAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
