/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The part of the web request that you want WAF to inspect. Include the single <code>FieldToMatch</code> type that you
 * want to inspect, with additional specifications as needed, according to the type. You specify a single request
 * component in <code>FieldToMatch</code> for each rule statement that requires it. To inspect more than one component
 * of the web request, create a separate rule statement for each component.
 * </p>
 * <p>
 * Example JSON for a <code>QueryString</code> field to match:
 * </p>
 * <p>
 * <code> "FieldToMatch": { "QueryString": {} }</code>
 * </p>
 * <p>
 * Example JSON for a <code>Method</code> field to match specification:
 * </p>
 * <p>
 * <code> "FieldToMatch": { "Method": { "Name": "DELETE" } }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldToMatch implements SdkPojo, Serializable, ToCopyableBuilder<FieldToMatch.Builder, FieldToMatch> {
    private static final SdkField<SingleHeader> SINGLE_HEADER_FIELD = SdkField.<SingleHeader> builder(MarshallingType.SDK_POJO)
            .memberName("SingleHeader").getter(getter(FieldToMatch::singleHeader)).setter(setter(Builder::singleHeader))
            .constructor(SingleHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleHeader").build()).build();

    private static final SdkField<SingleQueryArgument> SINGLE_QUERY_ARGUMENT_FIELD = SdkField
            .<SingleQueryArgument> builder(MarshallingType.SDK_POJO).memberName("SingleQueryArgument")
            .getter(getter(FieldToMatch::singleQueryArgument)).setter(setter(Builder::singleQueryArgument))
            .constructor(SingleQueryArgument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleQueryArgument").build())
            .build();

    private static final SdkField<AllQueryArguments> ALL_QUERY_ARGUMENTS_FIELD = SdkField
            .<AllQueryArguments> builder(MarshallingType.SDK_POJO).memberName("AllQueryArguments")
            .getter(getter(FieldToMatch::allQueryArguments)).setter(setter(Builder::allQueryArguments))
            .constructor(AllQueryArguments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllQueryArguments").build()).build();

    private static final SdkField<UriPath> URI_PATH_FIELD = SdkField.<UriPath> builder(MarshallingType.SDK_POJO)
            .memberName("UriPath").getter(getter(FieldToMatch::uriPath)).setter(setter(Builder::uriPath))
            .constructor(UriPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPath").build()).build();

    private static final SdkField<QueryString> QUERY_STRING_FIELD = SdkField.<QueryString> builder(MarshallingType.SDK_POJO)
            .memberName("QueryString").getter(getter(FieldToMatch::queryString)).setter(setter(Builder::queryString))
            .constructor(QueryString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Body> BODY_FIELD = SdkField.<Body> builder(MarshallingType.SDK_POJO).memberName("Body")
            .getter(getter(FieldToMatch::body)).setter(setter(Builder::body)).constructor(Body::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<Method> METHOD_FIELD = SdkField.<Method> builder(MarshallingType.SDK_POJO).memberName("Method")
            .getter(getter(FieldToMatch::method)).setter(setter(Builder::method)).constructor(Method::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()).build();

    private static final SdkField<JsonBody> JSON_BODY_FIELD = SdkField.<JsonBody> builder(MarshallingType.SDK_POJO)
            .memberName("JsonBody").getter(getter(FieldToMatch::jsonBody)).setter(setter(Builder::jsonBody))
            .constructor(JsonBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonBody").build()).build();

    private static final SdkField<Headers> HEADERS_FIELD = SdkField.<Headers> builder(MarshallingType.SDK_POJO)
            .memberName("Headers").getter(getter(FieldToMatch::headers)).setter(setter(Builder::headers))
            .constructor(Headers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build()).build();

    private static final SdkField<Cookies> COOKIES_FIELD = SdkField.<Cookies> builder(MarshallingType.SDK_POJO)
            .memberName("Cookies").getter(getter(FieldToMatch::cookies)).setter(setter(Builder::cookies))
            .constructor(Cookies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cookies").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINGLE_HEADER_FIELD,
            SINGLE_QUERY_ARGUMENT_FIELD, ALL_QUERY_ARGUMENTS_FIELD, URI_PATH_FIELD, QUERY_STRING_FIELD, BODY_FIELD, METHOD_FIELD,
            JSON_BODY_FIELD, HEADERS_FIELD, COOKIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final SingleHeader singleHeader;

    private final SingleQueryArgument singleQueryArgument;

    private final AllQueryArguments allQueryArguments;

    private final UriPath uriPath;

    private final QueryString queryString;

    private final Body body;

    private final Method method;

    private final JsonBody jsonBody;

    private final Headers headers;

    private final Cookies cookies;

    private FieldToMatch(BuilderImpl builder) {
        this.singleHeader = builder.singleHeader;
        this.singleQueryArgument = builder.singleQueryArgument;
        this.allQueryArguments = builder.allQueryArguments;
        this.uriPath = builder.uriPath;
        this.queryString = builder.queryString;
        this.body = builder.body;
        this.method = builder.method;
        this.jsonBody = builder.jsonBody;
        this.headers = builder.headers;
        this.cookies = builder.cookies;
    }

    /**
     * <p>
     * Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or
     * <code>Referer</code>. This setting isn't case sensitive.
     * </p>
     * <p>
     * Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
     * </p>
     * <p>
     * Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code>
     * setting.
     * </p>
     * 
     * @return Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code>
     *         or <code>Referer</code>. This setting isn't case sensitive.</p>
     *         <p>
     *         Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
     *         </p>
     *         <p>
     *         Alternately, you can filter and inspect all headers with the <code>Headers</code>
     *         <code>FieldToMatch</code> setting.
     */
    public final SingleHeader singleHeader() {
        return singleHeader;
    }

    /**
     * <p>
     * Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i> or
     * <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
     * </p>
     * <p>
     * Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
     * </p>
     * 
     * @return Inspect a single query argument. Provide the name of the query argument to inspect, such as
     *         <i>UserName</i> or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
     *         </p>
     *         <p>
     *         Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
     */
    public final SingleQueryArgument singleQueryArgument() {
        return singleQueryArgument;
    }

    /**
     * <p>
     * Inspect all query arguments.
     * </p>
     * 
     * @return Inspect all query arguments.
     */
    public final AllQueryArguments allQueryArguments() {
        return allQueryArguments;
    }

    /**
     * <p>
     * Inspect the request URI path. This is the part of the web request that identifies a resource, for example,
     * <code>/images/daily-ad.jpg</code>.
     * </p>
     * 
     * @return Inspect the request URI path. This is the part of the web request that identifies a resource, for
     *         example, <code>/images/daily-ad.jpg</code>.
     */
    public final UriPath uriPath() {
        return uriPath;
    }

    /**
     * <p>
     * Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.
     * </p>
     * 
     * @return Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if
     *         any.
     */
    public final QueryString queryString() {
        return queryString;
    }

    /**
     * <p>
     * Inspect the request body as plain text. The request body immediately follows the request headers. This is the
     * part of a request that contains any additional data that you want to send to your web server as the HTTP request
     * body, such as data from a form.
     * </p>
     * <p>
     * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host
     * service. For information about how to handle oversized request bodies, see the <code>Body</code> object
     * configuration.
     * </p>
     * 
     * @return Inspect the request body as plain text. The request body immediately follows the request headers. This is
     *         the part of a request that contains any additional data that you want to send to your web server as the
     *         HTTP request body, such as data from a form. </p>
     *         <p>
     *         Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the
     *         underlying host service. For information about how to handle oversized request bodies, see the
     *         <code>Body</code> object configuration.
     */
    public final Body body() {
        return body;
    }

    /**
     * <p>
     * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to
     * perform.
     * </p>
     * 
     * @return Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin
     *         to perform.
     */
    public final Method method() {
        return method;
    }

    /**
     * <p>
     * Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a
     * request that contains any additional data that you want to send to your web server as the HTTP request body, such
     * as data from a form.
     * </p>
     * <p>
     * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host
     * service. For information about how to handle oversized request bodies, see the <code>JsonBody</code> object
     * configuration.
     * </p>
     * 
     * @return Inspect the request body as JSON. The request body immediately follows the request headers. This is the
     *         part of a request that contains any additional data that you want to send to your web server as the HTTP
     *         request body, such as data from a form. </p>
     *         <p>
     *         Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the
     *         underlying host service. For information about how to handle oversized request bodies, see the
     *         <code>JsonBody</code> object configuration.
     */
    public final JsonBody jsonBody() {
        return jsonBody;
    }

    /**
     * <p>
     * Inspect the request headers. You must configure scope and pattern matching filters in the <code>Headers</code>
     * object, to define the set of headers to and the parts of the headers that WAF inspects.
     * </p>
     * <p>
     * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to WAF for
     * inspection by the underlying host service. You must configure how to handle any oversize header content in the
     * <code>Headers</code> object. WAF applies the pattern matching filters to the headers that it receives from the
     * underlying host service.
     * </p>
     * 
     * @return Inspect the request headers. You must configure scope and pattern matching filters in the
     *         <code>Headers</code> object, to define the set of headers to and the parts of the headers that WAF
     *         inspects. </p>
     *         <p>
     *         Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to
     *         WAF for inspection by the underlying host service. You must configure how to handle any oversize header
     *         content in the <code>Headers</code> object. WAF applies the pattern matching filters to the headers that
     *         it receives from the underlying host service.
     */
    public final Headers headers() {
        return headers;
    }

    /**
     * <p>
     * Inspect the request cookies. You must configure scope and pattern matching filters in the <code>Cookies</code>
     * object, to define the set of cookies and the parts of the cookies that WAF inspects.
     * </p>
     * <p>
     * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to WAF for
     * inspection by the underlying host service. You must configure how to handle any oversize cookie content in the
     * <code>Cookies</code> object. WAF applies the pattern matching filters to the cookies that it receives from the
     * underlying host service.
     * </p>
     * 
     * @return Inspect the request cookies. You must configure scope and pattern matching filters in the
     *         <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that WAF inspects.
     *         </p>
     *         <p>
     *         Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to
     *         WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie
     *         content in the <code>Cookies</code> object. WAF applies the pattern matching filters to the cookies that
     *         it receives from the underlying host service.
     */
    public final Cookies cookies() {
        return cookies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(singleHeader());
        hashCode = 31 * hashCode + Objects.hashCode(singleQueryArgument());
        hashCode = 31 * hashCode + Objects.hashCode(allQueryArguments());
        hashCode = 31 * hashCode + Objects.hashCode(uriPath());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(method());
        hashCode = 31 * hashCode + Objects.hashCode(jsonBody());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        hashCode = 31 * hashCode + Objects.hashCode(cookies());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldToMatch)) {
            return false;
        }
        FieldToMatch other = (FieldToMatch) obj;
        return Objects.equals(singleHeader(), other.singleHeader())
                && Objects.equals(singleQueryArgument(), other.singleQueryArgument())
                && Objects.equals(allQueryArguments(), other.allQueryArguments()) && Objects.equals(uriPath(), other.uriPath())
                && Objects.equals(queryString(), other.queryString()) && Objects.equals(body(), other.body())
                && Objects.equals(method(), other.method()) && Objects.equals(jsonBody(), other.jsonBody())
                && Objects.equals(headers(), other.headers()) && Objects.equals(cookies(), other.cookies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldToMatch").add("SingleHeader", singleHeader())
                .add("SingleQueryArgument", singleQueryArgument()).add("AllQueryArguments", allQueryArguments())
                .add("UriPath", uriPath()).add("QueryString", queryString()).add("Body", body()).add("Method", method())
                .add("JsonBody", jsonBody()).add("Headers", headers()).add("Cookies", cookies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SingleHeader":
            return Optional.ofNullable(clazz.cast(singleHeader()));
        case "SingleQueryArgument":
            return Optional.ofNullable(clazz.cast(singleQueryArgument()));
        case "AllQueryArguments":
            return Optional.ofNullable(clazz.cast(allQueryArguments()));
        case "UriPath":
            return Optional.ofNullable(clazz.cast(uriPath()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Method":
            return Optional.ofNullable(clazz.cast(method()));
        case "JsonBody":
            return Optional.ofNullable(clazz.cast(jsonBody()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "Cookies":
            return Optional.ofNullable(clazz.cast(cookies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldToMatch, T> g) {
        return obj -> g.apply((FieldToMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldToMatch> {
        /**
         * <p>
         * Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or
         * <code>Referer</code>. This setting isn't case sensitive.
         * </p>
         * <p>
         * Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
         * </p>
         * <p>
         * Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code>
         * setting.
         * </p>
         * 
         * @param singleHeader
         *        Inspect a single header. Provide the name of the header to inspect, for example,
         *        <code>User-Agent</code> or <code>Referer</code>. This setting isn't case sensitive.</p>
         *        <p>
         *        Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
         *        </p>
         *        <p>
         *        Alternately, you can filter and inspect all headers with the <code>Headers</code>
         *        <code>FieldToMatch</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleHeader(SingleHeader singleHeader);

        /**
         * <p>
         * Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or
         * <code>Referer</code>. This setting isn't case sensitive.
         * </p>
         * <p>
         * Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
         * </p>
         * <p>
         * Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code>
         * setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link SingleHeader.Builder} avoiding the need
         * to create one manually via {@link SingleHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #singleHeader(SingleHeader)}.
         * 
         * @param singleHeader
         *        a consumer that will call methods on {@link SingleHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleHeader(SingleHeader)
         */
        default Builder singleHeader(Consumer<SingleHeader.Builder> singleHeader) {
            return singleHeader(SingleHeader.builder().applyMutation(singleHeader).build());
        }

        /**
         * <p>
         * Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i>
         * or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
         * </p>
         * <p>
         * Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
         * </p>
         * 
         * @param singleQueryArgument
         *        Inspect a single query argument. Provide the name of the query argument to inspect, such as
         *        <i>UserName</i> or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case
         *        sensitive. </p>
         *        <p>
         *        Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleQueryArgument(SingleQueryArgument singleQueryArgument);

        /**
         * <p>
         * Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i>
         * or <i>SalesRegion</i>. The name can be up to 30 characters long and isn't case sensitive.
         * </p>
         * <p>
         * Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link SingleQueryArgument.Builder} avoiding the
         * need to create one manually via {@link SingleQueryArgument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleQueryArgument.Builder#build()} is called immediately and
         * its result is passed to {@link #singleQueryArgument(SingleQueryArgument)}.
         * 
         * @param singleQueryArgument
         *        a consumer that will call methods on {@link SingleQueryArgument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleQueryArgument(SingleQueryArgument)
         */
        default Builder singleQueryArgument(Consumer<SingleQueryArgument.Builder> singleQueryArgument) {
            return singleQueryArgument(SingleQueryArgument.builder().applyMutation(singleQueryArgument).build());
        }

        /**
         * <p>
         * Inspect all query arguments.
         * </p>
         * 
         * @param allQueryArguments
         *        Inspect all query arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allQueryArguments(AllQueryArguments allQueryArguments);

        /**
         * <p>
         * Inspect all query arguments.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllQueryArguments.Builder} avoiding the
         * need to create one manually via {@link AllQueryArguments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllQueryArguments.Builder#build()} is called immediately and its
         * result is passed to {@link #allQueryArguments(AllQueryArguments)}.
         * 
         * @param allQueryArguments
         *        a consumer that will call methods on {@link AllQueryArguments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allQueryArguments(AllQueryArguments)
         */
        default Builder allQueryArguments(Consumer<AllQueryArguments.Builder> allQueryArguments) {
            return allQueryArguments(AllQueryArguments.builder().applyMutation(allQueryArguments).build());
        }

        /**
         * <p>
         * Inspect the request URI path. This is the part of the web request that identifies a resource, for example,
         * <code>/images/daily-ad.jpg</code>.
         * </p>
         * 
         * @param uriPath
         *        Inspect the request URI path. This is the part of the web request that identifies a resource, for
         *        example, <code>/images/daily-ad.jpg</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uriPath(UriPath uriPath);

        /**
         * <p>
         * Inspect the request URI path. This is the part of the web request that identifies a resource, for example,
         * <code>/images/daily-ad.jpg</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UriPath.Builder} avoiding the need to
         * create one manually via {@link UriPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UriPath.Builder#build()} is called immediately and its result is
         * passed to {@link #uriPath(UriPath)}.
         * 
         * @param uriPath
         *        a consumer that will call methods on {@link UriPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uriPath(UriPath)
         */
        default Builder uriPath(Consumer<UriPath.Builder> uriPath) {
            return uriPath(UriPath.builder().applyMutation(uriPath).build());
        }

        /**
         * <p>
         * Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.
         * </p>
         * 
         * @param queryString
         *        Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if
         *        any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(QueryString queryString);

        /**
         * <p>
         * Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryString.Builder} avoiding the need to
         * create one manually via {@link QueryString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryString.Builder#build()} is called immediately and its result
         * is passed to {@link #queryString(QueryString)}.
         * 
         * @param queryString
         *        a consumer that will call methods on {@link QueryString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryString(QueryString)
         */
        default Builder queryString(Consumer<QueryString.Builder> queryString) {
            return queryString(QueryString.builder().applyMutation(queryString).build());
        }

        /**
         * <p>
         * Inspect the request body as plain text. The request body immediately follows the request headers. This is the
         * part of a request that contains any additional data that you want to send to your web server as the HTTP
         * request body, such as data from a form.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying
         * host service. For information about how to handle oversized request bodies, see the <code>Body</code> object
         * configuration.
         * </p>
         * 
         * @param body
         *        Inspect the request body as plain text. The request body immediately follows the request headers. This
         *        is the part of a request that contains any additional data that you want to send to your web server as
         *        the HTTP request body, such as data from a form. </p>
         *        <p>
         *        Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the
         *        underlying host service. For information about how to handle oversized request bodies, see the
         *        <code>Body</code> object configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(Body body);

        /**
         * <p>
         * Inspect the request body as plain text. The request body immediately follows the request headers. This is the
         * part of a request that contains any additional data that you want to send to your web server as the HTTP
         * request body, such as data from a form.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying
         * host service. For information about how to handle oversized request bodies, see the <code>Body</code> object
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Body.Builder} avoiding the need to create
         * one manually via {@link Body#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Body.Builder#build()} is called immediately and its result is
         * passed to {@link #body(Body)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link Body.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(Body)
         */
        default Builder body(Consumer<Body.Builder> body) {
            return body(Body.builder().applyMutation(body).build());
        }

        /**
         * <p>
         * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to
         * perform.
         * </p>
         * 
         * @param method
         *        Inspect the HTTP method. The method indicates the type of operation that the request is asking the
         *        origin to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(Method method);

        /**
         * <p>
         * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to
         * perform.
         * </p>
         * This is a convenience method that creates an instance of the {@link Method.Builder} avoiding the need to
         * create one manually via {@link Method#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Method.Builder#build()} is called immediately and its result is
         * passed to {@link #method(Method)}.
         * 
         * @param method
         *        a consumer that will call methods on {@link Method.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #method(Method)
         */
        default Builder method(Consumer<Method.Builder> method) {
            return method(Method.builder().applyMutation(method).build());
        }

        /**
         * <p>
         * Inspect the request body as JSON. The request body immediately follows the request headers. This is the part
         * of a request that contains any additional data that you want to send to your web server as the HTTP request
         * body, such as data from a form.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying
         * host service. For information about how to handle oversized request bodies, see the <code>JsonBody</code>
         * object configuration.
         * </p>
         * 
         * @param jsonBody
         *        Inspect the request body as JSON. The request body immediately follows the request headers. This is
         *        the part of a request that contains any additional data that you want to send to your web server as
         *        the HTTP request body, such as data from a form. </p>
         *        <p>
         *        Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the
         *        underlying host service. For information about how to handle oversized request bodies, see the
         *        <code>JsonBody</code> object configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonBody(JsonBody jsonBody);

        /**
         * <p>
         * Inspect the request body as JSON. The request body immediately follows the request headers. This is the part
         * of a request that contains any additional data that you want to send to your web server as the HTTP request
         * body, such as data from a form.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying
         * host service. For information about how to handle oversized request bodies, see the <code>JsonBody</code>
         * object configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JsonBody.Builder} avoiding the need to
         * create one manually via {@link JsonBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JsonBody.Builder#build()} is called immediately and its result is
         * passed to {@link #jsonBody(JsonBody)}.
         * 
         * @param jsonBody
         *        a consumer that will call methods on {@link JsonBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonBody(JsonBody)
         */
        default Builder jsonBody(Consumer<JsonBody.Builder> jsonBody) {
            return jsonBody(JsonBody.builder().applyMutation(jsonBody).build());
        }

        /**
         * <p>
         * Inspect the request headers. You must configure scope and pattern matching filters in the
         * <code>Headers</code> object, to define the set of headers to and the parts of the headers that WAF inspects.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to WAF
         * for inspection by the underlying host service. You must configure how to handle any oversize header content
         * in the <code>Headers</code> object. WAF applies the pattern matching filters to the headers that it receives
         * from the underlying host service.
         * </p>
         * 
         * @param headers
         *        Inspect the request headers. You must configure scope and pattern matching filters in the
         *        <code>Headers</code> object, to define the set of headers to and the parts of the headers that WAF
         *        inspects. </p>
         *        <p>
         *        Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded
         *        to WAF for inspection by the underlying host service. You must configure how to handle any oversize
         *        header content in the <code>Headers</code> object. WAF applies the pattern matching filters to the
         *        headers that it receives from the underlying host service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Headers headers);

        /**
         * <p>
         * Inspect the request headers. You must configure scope and pattern matching filters in the
         * <code>Headers</code> object, to define the set of headers to and the parts of the headers that WAF inspects.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to WAF
         * for inspection by the underlying host service. You must configure how to handle any oversize header content
         * in the <code>Headers</code> object. WAF applies the pattern matching filters to the headers that it receives
         * from the underlying host service.
         * </p>
         * This is a convenience method that creates an instance of the {@link Headers.Builder} avoiding the need to
         * create one manually via {@link Headers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Headers.Builder#build()} is called immediately and its result is
         * passed to {@link #headers(Headers)}.
         * 
         * @param headers
         *        a consumer that will call methods on {@link Headers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(Headers)
         */
        default Builder headers(Consumer<Headers.Builder> headers) {
            return headers(Headers.builder().applyMutation(headers).build());
        }

        /**
         * <p>
         * Inspect the request cookies. You must configure scope and pattern matching filters in the
         * <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that WAF inspects.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to WAF
         * for inspection by the underlying host service. You must configure how to handle any oversize cookie content
         * in the <code>Cookies</code> object. WAF applies the pattern matching filters to the cookies that it receives
         * from the underlying host service.
         * </p>
         * 
         * @param cookies
         *        Inspect the request cookies. You must configure scope and pattern matching filters in the
         *        <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that WAF
         *        inspects. </p>
         *        <p>
         *        Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded
         *        to WAF for inspection by the underlying host service. You must configure how to handle any oversize
         *        cookie content in the <code>Cookies</code> object. WAF applies the pattern matching filters to the
         *        cookies that it receives from the underlying host service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookies(Cookies cookies);

        /**
         * <p>
         * Inspect the request cookies. You must configure scope and pattern matching filters in the
         * <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that WAF inspects.
         * </p>
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to WAF
         * for inspection by the underlying host service. You must configure how to handle any oversize cookie content
         * in the <code>Cookies</code> object. WAF applies the pattern matching filters to the cookies that it receives
         * from the underlying host service.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cookies.Builder} avoiding the need to
         * create one manually via {@link Cookies#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cookies.Builder#build()} is called immediately and its result is
         * passed to {@link #cookies(Cookies)}.
         * 
         * @param cookies
         *        a consumer that will call methods on {@link Cookies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cookies(Cookies)
         */
        default Builder cookies(Consumer<Cookies.Builder> cookies) {
            return cookies(Cookies.builder().applyMutation(cookies).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SingleHeader singleHeader;

        private SingleQueryArgument singleQueryArgument;

        private AllQueryArguments allQueryArguments;

        private UriPath uriPath;

        private QueryString queryString;

        private Body body;

        private Method method;

        private JsonBody jsonBody;

        private Headers headers;

        private Cookies cookies;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldToMatch model) {
            singleHeader(model.singleHeader);
            singleQueryArgument(model.singleQueryArgument);
            allQueryArguments(model.allQueryArguments);
            uriPath(model.uriPath);
            queryString(model.queryString);
            body(model.body);
            method(model.method);
            jsonBody(model.jsonBody);
            headers(model.headers);
            cookies(model.cookies);
        }

        public final SingleHeader.Builder getSingleHeader() {
            return singleHeader != null ? singleHeader.toBuilder() : null;
        }

        public final void setSingleHeader(SingleHeader.BuilderImpl singleHeader) {
            this.singleHeader = singleHeader != null ? singleHeader.build() : null;
        }

        @Override
        public final Builder singleHeader(SingleHeader singleHeader) {
            this.singleHeader = singleHeader;
            return this;
        }

        public final SingleQueryArgument.Builder getSingleQueryArgument() {
            return singleQueryArgument != null ? singleQueryArgument.toBuilder() : null;
        }

        public final void setSingleQueryArgument(SingleQueryArgument.BuilderImpl singleQueryArgument) {
            this.singleQueryArgument = singleQueryArgument != null ? singleQueryArgument.build() : null;
        }

        @Override
        public final Builder singleQueryArgument(SingleQueryArgument singleQueryArgument) {
            this.singleQueryArgument = singleQueryArgument;
            return this;
        }

        public final AllQueryArguments.Builder getAllQueryArguments() {
            return allQueryArguments != null ? allQueryArguments.toBuilder() : null;
        }

        public final void setAllQueryArguments(AllQueryArguments.BuilderImpl allQueryArguments) {
            this.allQueryArguments = allQueryArguments != null ? allQueryArguments.build() : null;
        }

        @Override
        public final Builder allQueryArguments(AllQueryArguments allQueryArguments) {
            this.allQueryArguments = allQueryArguments;
            return this;
        }

        public final UriPath.Builder getUriPath() {
            return uriPath != null ? uriPath.toBuilder() : null;
        }

        public final void setUriPath(UriPath.BuilderImpl uriPath) {
            this.uriPath = uriPath != null ? uriPath.build() : null;
        }

        @Override
        public final Builder uriPath(UriPath uriPath) {
            this.uriPath = uriPath;
            return this;
        }

        public final QueryString.Builder getQueryString() {
            return queryString != null ? queryString.toBuilder() : null;
        }

        public final void setQueryString(QueryString.BuilderImpl queryString) {
            this.queryString = queryString != null ? queryString.build() : null;
        }

        @Override
        public final Builder queryString(QueryString queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Body.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(Body.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public final Method.Builder getMethod() {
            return method != null ? method.toBuilder() : null;
        }

        public final void setMethod(Method.BuilderImpl method) {
            this.method = method != null ? method.build() : null;
        }

        @Override
        public final Builder method(Method method) {
            this.method = method;
            return this;
        }

        public final JsonBody.Builder getJsonBody() {
            return jsonBody != null ? jsonBody.toBuilder() : null;
        }

        public final void setJsonBody(JsonBody.BuilderImpl jsonBody) {
            this.jsonBody = jsonBody != null ? jsonBody.build() : null;
        }

        @Override
        public final Builder jsonBody(JsonBody jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public final Headers.Builder getHeaders() {
            return headers != null ? headers.toBuilder() : null;
        }

        public final void setHeaders(Headers.BuilderImpl headers) {
            this.headers = headers != null ? headers.build() : null;
        }

        @Override
        public final Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public final Cookies.Builder getCookies() {
            return cookies != null ? cookies.toBuilder() : null;
        }

        public final void setCookies(Cookies.BuilderImpl cookies) {
            this.cookies = cookies != null ? cookies.build() : null;
        }

        @Override
        public final Builder cookies(Cookies cookies) {
            this.cookies = cookies;
            return this;
        }

        @Override
        public FieldToMatch build() {
            return new FieldToMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
