/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebAclResponse extends Wafv2Response implements
        ToCopyableBuilder<GetWebAclResponse.Builder, GetWebAclResponse> {
    private static final SdkField<WebACL> WEB_ACL_FIELD = SdkField.<WebACL> builder(MarshallingType.SDK_POJO)
            .memberName("WebACL").getter(getter(GetWebAclResponse::webACL)).setter(setter(Builder::webACL))
            .constructor(WebACL::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACL").build()).build();

    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockToken").getter(getter(GetWebAclResponse::lockToken)).setter(setter(Builder::lockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()).build();

    private static final SdkField<String> APPLICATION_INTEGRATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIntegrationURL").getter(getter(GetWebAclResponse::applicationIntegrationURL))
            .setter(setter(Builder::applicationIntegrationURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIntegrationURL").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD,
            LOCK_TOKEN_FIELD, APPLICATION_INTEGRATION_URL_FIELD));

    private final WebACL webACL;

    private final String lockToken;

    private final String applicationIntegrationURL;

    private GetWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.webACL = builder.webACL;
        this.lockToken = builder.lockToken;
        this.applicationIntegrationURL = builder.applicationIntegrationURL;
    }

    /**
     * <p>
     * The web ACL specification. You can modify the settings in this web ACL and use it to update this web ACL or
     * create a new one.
     * </p>
     * 
     * @return The web ACL specification. You can modify the settings in this web ACL and use it to update this web ACL
     *         or create a new one.
     */
    public final WebACL webACL() {
        return webACL;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String lockToken() {
        return lockToken;
    }

    /**
     * <p>
     * The URL to use in SDK integrations with Amazon Web Services managed rule groups. For example, you can use the
     * integration SDKs with the account takeover prevention managed rule group <code>AWSManagedRulesATPRuleSet</code>.
     * This is only populated if you are using a rule group in your web ACL that integrates with your applications in
     * this way. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     * application integration</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * 
     * @return The URL to use in SDK integrations with Amazon Web Services managed rule groups. For example, you can use
     *         the integration SDKs with the account takeover prevention managed rule group
     *         <code>AWSManagedRulesATPRuleSet</code>. This is only populated if you are using a rule group in your web
     *         ACL that integrates with your applications in this way. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
     *         application integration</a> in the <i>WAF Developer Guide</i>.
     */
    public final String applicationIntegrationURL() {
        return applicationIntegrationURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACL());
        hashCode = 31 * hashCode + Objects.hashCode(lockToken());
        hashCode = 31 * hashCode + Objects.hashCode(applicationIntegrationURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebAclResponse)) {
            return false;
        }
        GetWebAclResponse other = (GetWebAclResponse) obj;
        return Objects.equals(webACL(), other.webACL()) && Objects.equals(lockToken(), other.lockToken())
                && Objects.equals(applicationIntegrationURL(), other.applicationIntegrationURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWebAclResponse").add("WebACL", webACL()).add("LockToken", lockToken())
                .add("ApplicationIntegrationURL", applicationIntegrationURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACL":
            return Optional.ofNullable(clazz.cast(webACL()));
        case "LockToken":
            return Optional.ofNullable(clazz.cast(lockToken()));
        case "ApplicationIntegrationURL":
            return Optional.ofNullable(clazz.cast(applicationIntegrationURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebAclResponse, T> g) {
        return obj -> g.apply((GetWebAclResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetWebAclResponse> {
        /**
         * <p>
         * The web ACL specification. You can modify the settings in this web ACL and use it to update this web ACL or
         * create a new one.
         * </p>
         * 
         * @param webACL
         *        The web ACL specification. You can modify the settings in this web ACL and use it to update this web
         *        ACL or create a new one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACL(WebACL webACL);

        /**
         * <p>
         * The web ACL specification. You can modify the settings in this web ACL and use it to update this web ACL or
         * create a new one.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebACL.Builder} avoiding the need to
         * create one manually via {@link WebACL#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebACL.Builder#build()} is called immediately and its result is
         * passed to {@link #webACL(WebACL)}.
         * 
         * @param webACL
         *        a consumer that will call methods on {@link WebACL.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webACL(WebACL)
         */
        default Builder webACL(Consumer<WebACL.Builder> webACL) {
            return webACL(WebACL.builder().applyMutation(webACL).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param lockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockToken(String lockToken);

        /**
         * <p>
         * The URL to use in SDK integrations with Amazon Web Services managed rule groups. For example, you can use the
         * integration SDKs with the account takeover prevention managed rule group
         * <code>AWSManagedRulesATPRuleSet</code>. This is only populated if you are using a rule group in your web ACL
         * that integrates with your applications in this way. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client
         * application integration</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param applicationIntegrationURL
         *        The URL to use in SDK integrations with Amazon Web Services managed rule groups. For example, you can
         *        use the integration SDKs with the account takeover prevention managed rule group
         *        <code>AWSManagedRulesATPRuleSet</code>. This is only populated if you are using a rule group in your
         *        web ACL that integrates with your applications in this way. For more information, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF
         *        client application integration</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIntegrationURL(String applicationIntegrationURL);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private WebACL webACL;

        private String lockToken;

        private String applicationIntegrationURL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebAclResponse model) {
            super(model);
            webACL(model.webACL);
            lockToken(model.lockToken);
            applicationIntegrationURL(model.applicationIntegrationURL);
        }

        public final WebACL.Builder getWebACL() {
            return webACL != null ? webACL.toBuilder() : null;
        }

        public final void setWebACL(WebACL.BuilderImpl webACL) {
            this.webACL = webACL != null ? webACL.build() : null;
        }

        @Override
        public final Builder webACL(WebACL webACL) {
            this.webACL = webACL;
            return this;
        }

        public final String getLockToken() {
            return lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final String getApplicationIntegrationURL() {
            return applicationIntegrationURL;
        }

        public final void setApplicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
        }

        @Override
        public final Builder applicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
            return this;
        }

        @Override
        public GetWebAclResponse build() {
            return new GetWebAclResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
