/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App
 * Runner, and Verified Access resources forward to WAF for inspection. The default size is 16 KB (16,384 bytes). You
 * can change the setting for any of the available resource types.
 * </p>
 * <note>
 * <p>
 * You are charged additional fees when your protected resources forward body sizes that are larger than the default.
 * For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
 * </p>
 * </note>
 * <p>
 * Example JSON: <code> { "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }</code>
 * </p>
 * <p>
 * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
 * </p>
 * <p>
 * This is used in the <code>AssociationConfig</code> of the web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestBodyAssociatedResourceTypeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestBodyAssociatedResourceTypeConfig.Builder, RequestBodyAssociatedResourceTypeConfig> {
    private static final SdkField<String> DEFAULT_SIZE_INSPECTION_LIMIT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultSizeInspectionLimit")
            .getter(getter(RequestBodyAssociatedResourceTypeConfig::defaultSizeInspectionLimitAsString))
            .setter(setter(Builder::defaultSizeInspectionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSizeInspectionLimit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DEFAULT_SIZE_INSPECTION_LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultSizeInspectionLimit;

    private RequestBodyAssociatedResourceTypeConfig(BuilderImpl builder) {
        this.defaultSizeInspectionLimit = builder.defaultSizeInspectionLimit;
    }

    /**
     * <p>
     * Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway, Amazon
     * Cognito, App Runner, or Verified Access resource should send to WAF for inspection. This applies to statements in
     * the web ACL that inspect the body or JSON body.
     * </p>
     * <p>
     * Default: <code>16 KB (16,384 bytes)</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultSizeInspectionLimit} will return {@link SizeInspectionLimit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultSizeInspectionLimitAsString}.
     * </p>
     * 
     * @return Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway,
     *         Amazon Cognito, App Runner, or Verified Access resource should send to WAF for inspection. This applies
     *         to statements in the web ACL that inspect the body or JSON body. </p>
     *         <p>
     *         Default: <code>16 KB (16,384 bytes)</code>
     * @see SizeInspectionLimit
     */
    public final SizeInspectionLimit defaultSizeInspectionLimit() {
        return SizeInspectionLimit.fromValue(defaultSizeInspectionLimit);
    }

    /**
     * <p>
     * Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway, Amazon
     * Cognito, App Runner, or Verified Access resource should send to WAF for inspection. This applies to statements in
     * the web ACL that inspect the body or JSON body.
     * </p>
     * <p>
     * Default: <code>16 KB (16,384 bytes)</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultSizeInspectionLimit} will return {@link SizeInspectionLimit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultSizeInspectionLimitAsString}.
     * </p>
     * 
     * @return Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway,
     *         Amazon Cognito, App Runner, or Verified Access resource should send to WAF for inspection. This applies
     *         to statements in the web ACL that inspect the body or JSON body. </p>
     *         <p>
     *         Default: <code>16 KB (16,384 bytes)</code>
     * @see SizeInspectionLimit
     */
    public final String defaultSizeInspectionLimitAsString() {
        return defaultSizeInspectionLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultSizeInspectionLimitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestBodyAssociatedResourceTypeConfig)) {
            return false;
        }
        RequestBodyAssociatedResourceTypeConfig other = (RequestBodyAssociatedResourceTypeConfig) obj;
        return Objects.equals(defaultSizeInspectionLimitAsString(), other.defaultSizeInspectionLimitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestBodyAssociatedResourceTypeConfig")
                .add("DefaultSizeInspectionLimit", defaultSizeInspectionLimitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultSizeInspectionLimit":
            return Optional.ofNullable(clazz.cast(defaultSizeInspectionLimitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestBodyAssociatedResourceTypeConfig, T> g) {
        return obj -> g.apply((RequestBodyAssociatedResourceTypeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestBodyAssociatedResourceTypeConfig> {
        /**
         * <p>
         * Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway,
         * Amazon Cognito, App Runner, or Verified Access resource should send to WAF for inspection. This applies to
         * statements in the web ACL that inspect the body or JSON body.
         * </p>
         * <p>
         * Default: <code>16 KB (16,384 bytes)</code>
         * </p>
         * 
         * @param defaultSizeInspectionLimit
         *        Specifies the maximum size of the web request body component that an associated CloudFront, API
         *        Gateway, Amazon Cognito, App Runner, or Verified Access resource should send to WAF for inspection.
         *        This applies to statements in the web ACL that inspect the body or JSON body. </p>
         *        <p>
         *        Default: <code>16 KB (16,384 bytes)</code>
         * @see SizeInspectionLimit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SizeInspectionLimit
         */
        Builder defaultSizeInspectionLimit(String defaultSizeInspectionLimit);

        /**
         * <p>
         * Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway,
         * Amazon Cognito, App Runner, or Verified Access resource should send to WAF for inspection. This applies to
         * statements in the web ACL that inspect the body or JSON body.
         * </p>
         * <p>
         * Default: <code>16 KB (16,384 bytes)</code>
         * </p>
         * 
         * @param defaultSizeInspectionLimit
         *        Specifies the maximum size of the web request body component that an associated CloudFront, API
         *        Gateway, Amazon Cognito, App Runner, or Verified Access resource should send to WAF for inspection.
         *        This applies to statements in the web ACL that inspect the body or JSON body. </p>
         *        <p>
         *        Default: <code>16 KB (16,384 bytes)</code>
         * @see SizeInspectionLimit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SizeInspectionLimit
         */
        Builder defaultSizeInspectionLimit(SizeInspectionLimit defaultSizeInspectionLimit);
    }

    static final class BuilderImpl implements Builder {
        private String defaultSizeInspectionLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestBodyAssociatedResourceTypeConfig model) {
            defaultSizeInspectionLimit(model.defaultSizeInspectionLimit);
        }

        public final String getDefaultSizeInspectionLimit() {
            return defaultSizeInspectionLimit;
        }

        public final void setDefaultSizeInspectionLimit(String defaultSizeInspectionLimit) {
            this.defaultSizeInspectionLimit = defaultSizeInspectionLimit;
        }

        @Override
        public final Builder defaultSizeInspectionLimit(String defaultSizeInspectionLimit) {
            this.defaultSizeInspectionLimit = defaultSizeInspectionLimit;
            return this;
        }

        @Override
        public final Builder defaultSizeInspectionLimit(SizeInspectionLimit defaultSizeInspectionLimit) {
            this.defaultSizeInspectionLimit(defaultSizeInspectionLimit == null ? null : defaultSizeInspectionLimit.toString());
            return this;
        }

        @Override
        public RequestBodyAssociatedResourceTypeConfig build() {
            return new RequestBodyAssociatedResourceTypeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
