/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inspect a string containing the list of the request's header names, ordered as they appear in the web request that
 * WAF receives for inspection. WAF generates the string and then uses that as the field to match component in its
 * inspection. WAF separates the header names in the string using colons and no added spaces, for example
 * <code>host:user-agent:accept:authorization:referer</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeaderOrder implements SdkPojo, Serializable, ToCopyableBuilder<HeaderOrder.Builder, HeaderOrder> {
    private static final SdkField<String> OVERSIZE_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OversizeHandling").getter(getter(HeaderOrder::oversizeHandlingAsString))
            .setter(setter(Builder::oversizeHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OversizeHandling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERSIZE_HANDLING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String oversizeHandling;

    private HeaderOrder(BuilderImpl builder) {
        this.oversizeHandling = builder.oversizeHandling;
    }

    /**
     * <p>
     * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not
     * support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total
     * headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to
     * WAF.
     * </p>
     * <p>
     * The options for oversize handling are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oversizeHandling}
     * will return {@link OversizeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oversizeHandlingAsString}.
     * </p>
     * 
     * @return What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF
     *         does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or
     *         200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of
     *         header contents to WAF. </p>
     *         <p>
     *         The options for oversize handling are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection
     *         criteria.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see OversizeHandling
     */
    public final OversizeHandling oversizeHandling() {
        return OversizeHandling.fromValue(oversizeHandling);
    }

    /**
     * <p>
     * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not
     * support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total
     * headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to
     * WAF.
     * </p>
     * <p>
     * The options for oversize handling are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oversizeHandling}
     * will return {@link OversizeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oversizeHandlingAsString}.
     * </p>
     * 
     * @return What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF
     *         does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or
     *         200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of
     *         header contents to WAF. </p>
     *         <p>
     *         The options for oversize handling are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection
     *         criteria.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see OversizeHandling
     */
    public final String oversizeHandlingAsString() {
        return oversizeHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oversizeHandlingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderOrder)) {
            return false;
        }
        HeaderOrder other = (HeaderOrder) obj;
        return Objects.equals(oversizeHandlingAsString(), other.oversizeHandlingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeaderOrder").add("OversizeHandling", oversizeHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OversizeHandling":
            return Optional.ofNullable(clazz.cast(oversizeHandlingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HeaderOrder, T> g) {
        return obj -> g.apply((HeaderOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeaderOrder> {
        /**
         * <p>
         * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does
         * not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total
         * headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to
         * WAF.
         * </p>
         * <p>
         * The options for oversize handling are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param oversizeHandling
         *        What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF
         *        does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes)
         *        or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB
         *        of header contents to WAF. </p>
         *        <p>
         *        The options for oversize handling are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection
         *        criteria.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see OversizeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OversizeHandling
         */
        Builder oversizeHandling(String oversizeHandling);

        /**
         * <p>
         * What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does
         * not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total
         * headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to
         * WAF.
         * </p>
         * <p>
         * The options for oversize handling are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param oversizeHandling
         *        What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF
         *        does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes)
         *        or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB
         *        of header contents to WAF. </p>
         *        <p>
         *        The options for oversize handling are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection
         *        criteria.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see OversizeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OversizeHandling
         */
        Builder oversizeHandling(OversizeHandling oversizeHandling);
    }

    static final class BuilderImpl implements Builder {
        private String oversizeHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(HeaderOrder model) {
            oversizeHandling(model.oversizeHandling);
        }

        public final String getOversizeHandling() {
            return oversizeHandling;
        }

        public final void setOversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
        }

        @Override
        public final Builder oversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
            return this;
        }

        @Override
        public final Builder oversizeHandling(OversizeHandling oversizeHandling) {
            this.oversizeHandling(oversizeHandling == null ? null : oversizeHandling.toString());
            return this;
        }

        @Override
        public HeaderOrder build() {
            return new HeaderOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
