/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's
 * JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request.
 * This fingerprint serves as a unique identifier for the client's TLS configuration. WAF calculates and logs this
 * fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web
 * requests include this information.
 * </p>
 * <note>
 * <p>
 * You can use this choice only with a string match <code>ByteMatchStatement</code> with the
 * <code>PositionalConstraint</code> set to <code>EXACTLY</code>.
 * </p>
 * </note>
 * <p>
 * You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the
 * fingerprint, it includes it in the logs. For information about the logging fields, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <i>WAF
 * Developer Guide</i>.
 * </p>
 * <p>
 * Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any
 * future requests that have the same TLS configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JA3Fingerprint implements SdkPojo, Serializable, ToCopyableBuilder<JA3Fingerprint.Builder, JA3Fingerprint> {
    private static final SdkField<String> FALLBACK_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallbackBehavior").getter(getter(JA3Fingerprint::fallbackBehaviorAsString))
            .setter(setter(Builder::fallbackBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallbackBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FALLBACK_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fallbackBehavior;

    private JA3Fingerprint(BuilderImpl builder) {
        this.fallbackBehavior = builder.fallbackBehavior;
    }

    /**
     * <p>
     * The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
     * </p>
     * <p>
     * You can specify the following fallback behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return The match status to assign to the web request if the request doesn't have a JA3 fingerprint. </p>
     *         <p>
     *         You can specify the following fallback behaviors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see FallbackBehavior
     */
    public final FallbackBehavior fallbackBehavior() {
        return FallbackBehavior.fromValue(fallbackBehavior);
    }

    /**
     * <p>
     * The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
     * </p>
     * <p>
     * You can specify the following fallback behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return The match status to assign to the web request if the request doesn't have a JA3 fingerprint. </p>
     *         <p>
     *         You can specify the following fallback behaviors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see FallbackBehavior
     */
    public final String fallbackBehaviorAsString() {
        return fallbackBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fallbackBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JA3Fingerprint)) {
            return false;
        }
        JA3Fingerprint other = (JA3Fingerprint) obj;
        return Objects.equals(fallbackBehaviorAsString(), other.fallbackBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JA3Fingerprint").add("FallbackBehavior", fallbackBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FallbackBehavior":
            return Optional.ofNullable(clazz.cast(fallbackBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JA3Fingerprint, T> g) {
        return obj -> g.apply((JA3Fingerprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JA3Fingerprint> {
        /**
         * <p>
         * The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
         * </p>
         * <p>
         * You can specify the following fallback behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fallbackBehavior
         *        The match status to assign to the web request if the request doesn't have a JA3 fingerprint. </p>
         *        <p>
         *        You can specify the following fallback behaviors:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(String fallbackBehavior);

        /**
         * <p>
         * The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
         * </p>
         * <p>
         * You can specify the following fallback behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fallbackBehavior
         *        The match status to assign to the web request if the request doesn't have a JA3 fingerprint. </p>
         *        <p>
         *        You can specify the following fallback behaviors:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(FallbackBehavior fallbackBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String fallbackBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(JA3Fingerprint model) {
            fallbackBehavior(model.fallbackBehavior);
        }

        public final String getFallbackBehavior() {
            return fallbackBehavior;
        }

        public final void setFallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
        }

        @Override
        public final Builder fallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
            return this;
        }

        @Override
        public final Builder fallbackBehavior(FallbackBehavior fallbackBehavior) {
            this.fallbackBehavior(fallbackBehavior == null ? null : fallbackBehavior.toString());
            return this;
        }

        @Override
        public JA3Fingerprint build() {
            return new JA3Fingerprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
