/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class RequestBodyCopier {
    static Map<String, RequestBodyAssociatedResourceTypeConfig> copy(
            Map<String, ? extends RequestBodyAssociatedResourceTypeConfig> requestBodyParam) {
        Map<String, RequestBodyAssociatedResourceTypeConfig> map;
        if (requestBodyParam == null || requestBodyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RequestBodyAssociatedResourceTypeConfig> modifiableMap = new LinkedHashMap<>(requestBodyParam.size());
            requestBodyParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RequestBodyAssociatedResourceTypeConfig> copyFromBuilder(
            Map<String, ? extends RequestBodyAssociatedResourceTypeConfig.Builder> requestBodyParam) {
        Map<String, RequestBodyAssociatedResourceTypeConfig> map;
        if (requestBodyParam == null || requestBodyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RequestBodyAssociatedResourceTypeConfig> modifiableMap = new LinkedHashMap<>(requestBodyParam.size());
            requestBodyParam.forEach((key, value) -> {
                RequestBodyAssociatedResourceTypeConfig member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RequestBodyAssociatedResourceTypeConfig.Builder> copyToBuilder(
            Map<String, ? extends RequestBodyAssociatedResourceTypeConfig> requestBodyParam) {
        Map<String, RequestBodyAssociatedResourceTypeConfig.Builder> map;
        if (requestBodyParam == null || requestBodyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RequestBodyAssociatedResourceTypeConfig.Builder> modifiableMap = new LinkedHashMap<>(
                    requestBodyParam.size());
            requestBodyParam.forEach((key, value) -> {
                RequestBodyAssociatedResourceTypeConfig.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RequestBodyAssociatedResourceTypeConfig> copyEnumToString(
            Map<AssociatedResourceType, ? extends RequestBodyAssociatedResourceTypeConfig> requestBodyParam) {
        Map<String, RequestBodyAssociatedResourceTypeConfig> map;
        if (requestBodyParam == null || requestBodyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RequestBodyAssociatedResourceTypeConfig> modifiableMap = new LinkedHashMap<>(requestBodyParam.size());
            requestBodyParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> copyStringToEnum(
            Map<String, ? extends RequestBodyAssociatedResourceTypeConfig> requestBodyParam) {
        Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> map;
        if (requestBodyParam == null || requestBodyParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> modifiableMap = new LinkedHashMap<>(
                    requestBodyParam.size());
            requestBodyParam.forEach((key, value) -> {
                AssociatedResourceType result = AssociatedResourceType.fromValue(key);
                if (result != AssociatedResourceType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
