/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.CustomHTTPHeader;
import software.amazon.awssdk.services.wafv2.model.CustomHTTPHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomRequestHandling
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomRequestHandling> {
    private static final SdkField<List<CustomHTTPHeader>> INSERT_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsertHeaders").getter(CustomRequestHandling.getter(CustomRequestHandling::insertHeaders)).setter(CustomRequestHandling.setter(Builder::insertHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsertHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomHTTPHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSERT_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InsertHeaders", INSERT_HEADERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<CustomHTTPHeader> insertHeaders;

    private CustomRequestHandling(BuilderImpl builder) {
        this.insertHeaders = builder.insertHeaders;
    }

    public final boolean hasInsertHeaders() {
        return this.insertHeaders != null && !(this.insertHeaders instanceof SdkAutoConstructList);
    }

    public final List<CustomHTTPHeader> insertHeaders() {
        return this.insertHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsertHeaders() ? this.insertHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRequestHandling)) {
            return false;
        }
        CustomRequestHandling other = (CustomRequestHandling)obj;
        return this.hasInsertHeaders() == other.hasInsertHeaders() && Objects.equals(this.insertHeaders(), other.insertHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"CustomRequestHandling").add("InsertHeaders", this.hasInsertHeaders() ? this.insertHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsertHeaders": {
                return Optional.ofNullable(clazz.cast(this.insertHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomRequestHandling, T> g) {
        return obj -> g.apply((CustomRequestHandling)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CustomHTTPHeader> insertHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRequestHandling model) {
            this.insertHeaders(model.insertHeaders);
        }

        public final List<CustomHTTPHeader.Builder> getInsertHeaders() {
            List<CustomHTTPHeader.Builder> result = CustomHTTPHeadersCopier.copyToBuilder(this.insertHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsertHeaders(Collection<CustomHTTPHeader.BuilderImpl> insertHeaders) {
            this.insertHeaders = CustomHTTPHeadersCopier.copyFromBuilder(insertHeaders);
        }

        @Override
        public final Builder insertHeaders(Collection<CustomHTTPHeader> insertHeaders) {
            this.insertHeaders = CustomHTTPHeadersCopier.copy(insertHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertHeaders(CustomHTTPHeader ... insertHeaders) {
            this.insertHeaders(Arrays.asList(insertHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertHeaders(Consumer<CustomHTTPHeader.Builder> ... insertHeaders) {
            this.insertHeaders(Stream.of(insertHeaders).map(c -> (CustomHTTPHeader)((CustomHTTPHeader.Builder)CustomHTTPHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CustomRequestHandling build() {
            return new CustomRequestHandling(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomRequestHandling> {
        public Builder insertHeaders(Collection<CustomHTTPHeader> var1);

        public Builder insertHeaders(CustomHTTPHeader ... var1);

        public Builder insertHeaders(Consumer<CustomHTTPHeader.Builder> ... var1);
    }
}

