/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wafv2.model.Scope;
import software.amazon.awssdk.services.wafv2.model.VersionToPublish;
import software.amazon.awssdk.services.wafv2.model.VersionsToPublishCopier;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutManagedRuleSetVersionsRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, PutManagedRuleSetVersionsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutManagedRuleSetVersionsRequest.getter(PutManagedRuleSetVersionsRequest::name)).setter(PutManagedRuleSetVersionsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(PutManagedRuleSetVersionsRequest.getter(PutManagedRuleSetVersionsRequest::scopeAsString)).setter(PutManagedRuleSetVersionsRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(PutManagedRuleSetVersionsRequest.getter(PutManagedRuleSetVersionsRequest::id)).setter(PutManagedRuleSetVersionsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockToken").getter(PutManagedRuleSetVersionsRequest.getter(PutManagedRuleSetVersionsRequest::lockToken)).setter(PutManagedRuleSetVersionsRequest.setter(Builder::lockToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()}).build();
    private static final SdkField<String> RECOMMENDED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendedVersion").getter(PutManagedRuleSetVersionsRequest.getter(PutManagedRuleSetVersionsRequest::recommendedVersion)).setter(PutManagedRuleSetVersionsRequest.setter(Builder::recommendedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedVersion").build()}).build();
    private static final SdkField<Map<String, VersionToPublish>> VERSIONS_TO_PUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("VersionsToPublish").getter(PutManagedRuleSetVersionsRequest.getter(PutManagedRuleSetVersionsRequest::versionsToPublish)).setter(PutManagedRuleSetVersionsRequest.setter(Builder::versionsToPublish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionsToPublish").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VersionToPublish::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD, ID_FIELD, LOCK_TOKEN_FIELD, RECOMMENDED_VERSION_FIELD, VERSIONS_TO_PUBLISH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Scope", SCOPE_FIELD);
            this.put("Id", ID_FIELD);
            this.put("LockToken", LOCK_TOKEN_FIELD);
            this.put("RecommendedVersion", RECOMMENDED_VERSION_FIELD);
            this.put("VersionsToPublish", VERSIONS_TO_PUBLISH_FIELD);
        }
    });
    private final String name;
    private final String scope;
    private final String id;
    private final String lockToken;
    private final String recommendedVersion;
    private final Map<String, VersionToPublish> versionsToPublish;

    private PutManagedRuleSetVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.id = builder.id;
        this.lockToken = builder.lockToken;
        this.recommendedVersion = builder.recommendedVersion;
        this.versionsToPublish = builder.versionsToPublish;
    }

    public final String name() {
        return this.name;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String id() {
        return this.id;
    }

    public final String lockToken() {
        return this.lockToken;
    }

    public final String recommendedVersion() {
        return this.recommendedVersion;
    }

    public final boolean hasVersionsToPublish() {
        return this.versionsToPublish != null && !(this.versionsToPublish instanceof SdkAutoConstructMap);
    }

    public final Map<String, VersionToPublish> versionsToPublish() {
        return this.versionsToPublish;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersionsToPublish() ? this.versionsToPublish() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutManagedRuleSetVersionsRequest)) {
            return false;
        }
        PutManagedRuleSetVersionsRequest other = (PutManagedRuleSetVersionsRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lockToken(), other.lockToken()) && Objects.equals(this.recommendedVersion(), other.recommendedVersion()) && this.hasVersionsToPublish() == other.hasVersionsToPublish() && Objects.equals(this.versionsToPublish(), other.versionsToPublish());
    }

    public final String toString() {
        return ToString.builder((String)"PutManagedRuleSetVersionsRequest").add("Name", (Object)this.name()).add("Scope", (Object)this.scopeAsString()).add("Id", (Object)this.id()).add("LockToken", (Object)this.lockToken()).add("RecommendedVersion", (Object)this.recommendedVersion()).add("VersionsToPublish", this.hasVersionsToPublish() ? this.versionsToPublish() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LockToken": {
                return Optional.ofNullable(clazz.cast(this.lockToken()));
            }
            case "RecommendedVersion": {
                return Optional.ofNullable(clazz.cast(this.recommendedVersion()));
            }
            case "VersionsToPublish": {
                return Optional.ofNullable(clazz.cast(this.versionsToPublish()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutManagedRuleSetVersionsRequest, T> g) {
        return obj -> g.apply((PutManagedRuleSetVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String name;
        private String scope;
        private String id;
        private String lockToken;
        private String recommendedVersion;
        private Map<String, VersionToPublish> versionsToPublish = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutManagedRuleSetVersionsRequest model) {
            super(model);
            this.name(model.name);
            this.scope(model.scope);
            this.id(model.id);
            this.lockToken(model.lockToken);
            this.recommendedVersion(model.recommendedVersion);
            this.versionsToPublish(model.versionsToPublish);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLockToken() {
            return this.lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final String getRecommendedVersion() {
            return this.recommendedVersion;
        }

        public final void setRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
        }

        @Override
        public final Builder recommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        public final Map<String, VersionToPublish.Builder> getVersionsToPublish() {
            Map<String, VersionToPublish.Builder> result = VersionsToPublishCopier.copyToBuilder(this.versionsToPublish);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVersionsToPublish(Map<String, VersionToPublish.BuilderImpl> versionsToPublish) {
            this.versionsToPublish = VersionsToPublishCopier.copyFromBuilder(versionsToPublish);
        }

        @Override
        public final Builder versionsToPublish(Map<String, VersionToPublish> versionsToPublish) {
            this.versionsToPublish = VersionsToPublishCopier.copy(versionsToPublish);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutManagedRuleSetVersionsRequest build() {
            return new PutManagedRuleSetVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutManagedRuleSetVersionsRequest> {
        public Builder name(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder id(String var1);

        public Builder lockToken(String var1);

        public Builder recommendedVersion(String var1);

        public Builder versionsToPublish(Map<String, VersionToPublish> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

