/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoggingConfigurationRequest extends Wafv2Request implements
        ToCopyableBuilder<GetLoggingConfigurationRequest.Builder, GetLoggingConfigurationRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(GetLoggingConfigurationRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogType").getter(getter(GetLoggingConfigurationRequest::logTypeAsString))
            .setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()).build();

    private static final SdkField<String> LOG_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogScope").getter(getter(GetLoggingConfigurationRequest::logScopeAsString))
            .setter(setter(Builder::logScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            LOG_TYPE_FIELD, LOG_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String logType;

    private final String logScope;

    private GetLoggingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.logType = builder.logType;
        this.logScope = builder.logScope;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the web ACL for which you want to get the <a>LoggingConfiguration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the web ACL for which you want to get the <a>LoggingConfiguration</a>.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Used to distinguish between various logging options. Currently, there is one option.
     * </p>
     * <p>
     * Default: <code>WAF_LOGS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Used to distinguish between various logging options. Currently, there is one option.</p>
     *         <p>
     *         Default: <code>WAF_LOGS</code>
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * Used to distinguish between various logging options. Currently, there is one option.
     * </p>
     * <p>
     * Default: <code>WAF_LOGS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Used to distinguish between various logging options. Currently, there is one option.</p>
     *         <p>
     *         Default: <code>WAF_LOGS</code>
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations that
     * you manage.
     * </p>
     * <p>
     * The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security Lake.
     * You can use Security Lake to collect log and event data from various sources for normalization, analysis, and
     * management. For information, see <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from
     * Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
     * </p>
     * <p>
     * Default: <code>CUSTOMER</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logScope} will
     * return {@link LogScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logScopeAsString}.
     * </p>
     * 
     * @return The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations
     *         that you manage. </p>
     *         <p>
     *         The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon
     *         Security Lake. You can use Security Lake to collect log and event data from various sources for
     *         normalization, analysis, and management. For information, see <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data
     *         from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>CUSTOMER</code>
     * @see LogScope
     */
    public final LogScope logScope() {
        return LogScope.fromValue(logScope);
    }

    /**
     * <p>
     * The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations that
     * you manage.
     * </p>
     * <p>
     * The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security Lake.
     * You can use Security Lake to collect log and event data from various sources for normalization, analysis, and
     * management. For information, see <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from
     * Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
     * </p>
     * <p>
     * Default: <code>CUSTOMER</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logScope} will
     * return {@link LogScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logScopeAsString}.
     * </p>
     * 
     * @return The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations
     *         that you manage. </p>
     *         <p>
     *         The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon
     *         Security Lake. You can use Security Lake to collect log and event data from various sources for
     *         normalization, analysis, and management. For information, see <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data
     *         from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>CUSTOMER</code>
     * @see LogScope
     */
    public final String logScopeAsString() {
        return logScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoggingConfigurationRequest)) {
            return false;
        }
        GetLoggingConfigurationRequest other = (GetLoggingConfigurationRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(logScopeAsString(), other.logScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLoggingConfigurationRequest").add("ResourceArn", resourceArn())
                .add("LogType", logTypeAsString()).add("LogScope", logScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "LogType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "LogScope":
            return Optional.ofNullable(clazz.cast(logScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("LogType", LOG_TYPE_FIELD);
        map.put("LogScope", LOG_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLoggingConfigurationRequest, T> g) {
        return obj -> g.apply((GetLoggingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetLoggingConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the web ACL for which you want to get the <a>LoggingConfiguration</a>.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the web ACL for which you want to get the
         *        <a>LoggingConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Used to distinguish between various logging options. Currently, there is one option.
         * </p>
         * <p>
         * Default: <code>WAF_LOGS</code>
         * </p>
         * 
         * @param logType
         *        Used to distinguish between various logging options. Currently, there is one option.</p>
         *        <p>
         *        Default: <code>WAF_LOGS</code>
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * Used to distinguish between various logging options. Currently, there is one option.
         * </p>
         * <p>
         * Default: <code>WAF_LOGS</code>
         * </p>
         * 
         * @param logType
         *        Used to distinguish between various logging options. Currently, there is one option.</p>
         *        <p>
         *        Default: <code>WAF_LOGS</code>
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations
         * that you manage.
         * </p>
         * <p>
         * The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security
         * Lake. You can use Security Lake to collect log and event data from various sources for normalization,
         * analysis, and management. For information, see <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from
         * Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
         * </p>
         * <p>
         * Default: <code>CUSTOMER</code>
         * </p>
         * 
         * @param logScope
         *        The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the
         *        configurations that you manage. </p>
         *        <p>
         *        The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon
         *        Security Lake. You can use Security Lake to collect log and event data from various sources for
         *        normalization, analysis, and management. For information, see <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting
         *        data from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>CUSTOMER</code>
         * @see LogScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogScope
         */
        Builder logScope(String logScope);

        /**
         * <p>
         * The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations
         * that you manage.
         * </p>
         * <p>
         * The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security
         * Lake. You can use Security Lake to collect log and event data from various sources for normalization,
         * analysis, and management. For information, see <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from
         * Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
         * </p>
         * <p>
         * Default: <code>CUSTOMER</code>
         * </p>
         * 
         * @param logScope
         *        The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the
         *        configurations that you manage. </p>
         *        <p>
         *        The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon
         *        Security Lake. You can use Security Lake to collect log and event data from various sources for
         *        normalization, analysis, and management. For information, see <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting
         *        data from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>CUSTOMER</code>
         * @see LogScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogScope
         */
        Builder logScope(LogScope logScope);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String resourceArn;

        private String logType;

        private String logScope;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoggingConfigurationRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            logType(model.logType);
            logScope(model.logScope);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getLogScope() {
            return logScope;
        }

        public final void setLogScope(String logScope) {
            this.logScope = logScope;
        }

        @Override
        public final Builder logScope(String logScope) {
            this.logScope = logScope;
            return this;
        }

        @Override
        public final Builder logScope(LogScope logScope) {
            this.logScope(logScope == null ? null : logScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLoggingConfigurationRequest build() {
            return new GetLoggingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
