/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this,
 * create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in this
 * statement. To create an IP set, see <a>CreateIPSet</a>.
 * </p>
 * <p>
 * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This
 * allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all
 * rules that reference it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPSetReferenceStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<IPSetReferenceStatement.Builder, IPSetReferenceStatement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(IPSetReferenceStatement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<IPSetForwardedIPConfig> IP_SET_FORWARDED_IP_CONFIG_FIELD = SdkField
            .<IPSetForwardedIPConfig> builder(MarshallingType.SDK_POJO).memberName("IPSetForwardedIPConfig")
            .getter(getter(IPSetReferenceStatement::ipSetForwardedIPConfig)).setter(setter(Builder::ipSetForwardedIPConfig))
            .constructor(IPSetForwardedIPConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetForwardedIPConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            IP_SET_FORWARDED_IP_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final IPSetForwardedIPConfig ipSetForwardedIPConfig;

    private IPSetReferenceStatement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.ipSetForwardedIPConfig = builder.ipSetForwardedIPConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a>IPSet</a> that this statement references.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a>IPSet</a> that this statement references.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address
     * that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can
     * specify any header name.
     * </p>
     * <note>
     * <p>
     * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
     * </p>
     * </note>
     * 
     * @return The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP
     *         address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header,
     *         but you can specify any header name. </p> <note>
     *         <p>
     *         If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at
     *         all.
     *         </p>
     */
    public final IPSetForwardedIPConfig ipSetForwardedIPConfig() {
        return ipSetForwardedIPConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ipSetForwardedIPConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetReferenceStatement)) {
            return false;
        }
        IPSetReferenceStatement other = (IPSetReferenceStatement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(ipSetForwardedIPConfig(), other.ipSetForwardedIPConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IPSetReferenceStatement").add("ARN", arn())
                .add("IPSetForwardedIPConfig", ipSetForwardedIPConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "IPSetForwardedIPConfig":
            return Optional.ofNullable(clazz.cast(ipSetForwardedIPConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ARN", ARN_FIELD);
        map.put("IPSetForwardedIPConfig", IP_SET_FORWARDED_IP_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IPSetReferenceStatement, T> g) {
        return obj -> g.apply((IPSetReferenceStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPSetReferenceStatement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a>IPSet</a> that this statement references.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the <a>IPSet</a> that this statement references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP
         * address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but
         * you can specify any header name.
         * </p>
         * <note>
         * <p>
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         * </p>
         * </note>
         * 
         * @param ipSetForwardedIPConfig
         *        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the
         *        IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF)
         *        header, but you can specify any header name. </p> <note>
         *        <p>
         *        If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at
         *        all.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetForwardedIPConfig(IPSetForwardedIPConfig ipSetForwardedIPConfig);

        /**
         * <p>
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP
         * address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but
         * you can specify any header name.
         * </p>
         * <note>
         * <p>
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link IPSetForwardedIPConfig.Builder}
         * avoiding the need to create one manually via {@link IPSetForwardedIPConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IPSetForwardedIPConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #ipSetForwardedIPConfig(IPSetForwardedIPConfig)}.
         * 
         * @param ipSetForwardedIPConfig
         *        a consumer that will call methods on {@link IPSetForwardedIPConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSetForwardedIPConfig(IPSetForwardedIPConfig)
         */
        default Builder ipSetForwardedIPConfig(Consumer<IPSetForwardedIPConfig.Builder> ipSetForwardedIPConfig) {
            return ipSetForwardedIPConfig(IPSetForwardedIPConfig.builder().applyMutation(ipSetForwardedIPConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private IPSetForwardedIPConfig ipSetForwardedIPConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetReferenceStatement model) {
            arn(model.arn);
            ipSetForwardedIPConfig(model.ipSetForwardedIPConfig);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final IPSetForwardedIPConfig.Builder getIpSetForwardedIPConfig() {
            return ipSetForwardedIPConfig != null ? ipSetForwardedIPConfig.toBuilder() : null;
        }

        public final void setIpSetForwardedIPConfig(IPSetForwardedIPConfig.BuilderImpl ipSetForwardedIPConfig) {
            this.ipSetForwardedIPConfig = ipSetForwardedIPConfig != null ? ipSetForwardedIPConfig.build() : null;
        }

        @Override
        public final Builder ipSetForwardedIPConfig(IPSetForwardedIPConfig ipSetForwardedIPConfig) {
            this.ipSetForwardedIPConfig = ipSetForwardedIPConfig;
            return this;
        }

        @Override
        public IPSetReferenceStatement build() {
            return new IPSetReferenceStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
