/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single label name condition for a <a>Condition</a> in a logging filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelNameCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelNameCondition.Builder, LabelNameCondition> {
    private static final SdkField<String> LABEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelName").getter(getter(LabelNameCondition::labelName)).setter(setter(Builder::labelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String labelName;

    private LabelNameCondition(BuilderImpl builder) {
        this.labelName = builder.labelName;
    }

    /**
     * <p>
     * The label name that a log record must contain in order to meet the condition. This must be a fully qualified
     * label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the
     * rule group or web ACL context of the rule that added the label.
     * </p>
     * 
     * @return The label name that a log record must contain in order to meet the condition. This must be a fully
     *         qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The
     *         prefix identifies the rule group or web ACL context of the rule that added the label.
     */
    public final String labelName() {
        return labelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelNameCondition)) {
            return false;
        }
        LabelNameCondition other = (LabelNameCondition) obj;
        return Objects.equals(labelName(), other.labelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelNameCondition").add("LabelName", labelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelName":
            return Optional.ofNullable(clazz.cast(labelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelName", LABEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LabelNameCondition, T> g) {
        return obj -> g.apply((LabelNameCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelNameCondition> {
        /**
         * <p>
         * The label name that a log record must contain in order to meet the condition. This must be a fully qualified
         * label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies
         * the rule group or web ACL context of the rule that added the label.
         * </p>
         * 
         * @param labelName
         *        The label name that a log record must contain in order to meet the condition. This must be a fully
         *        qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The
         *        prefix identifies the rule group or web ACL context of the rule that added the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelName(String labelName);
    }

    static final class BuilderImpl implements Builder {
        private String labelName;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelNameCondition model) {
            labelName(model.labelName);
        }

        public final String getLabelName() {
            return labelName;
        }

        public final void setLabelName(String labelName) {
            this.labelName = labelName;
        }

        @Override
        public final Builder labelName(String labelName) {
            this.labelName = labelName;
            return this;
        }

        @Override
        public LabelNameCondition build() {
            return new LabelNameCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
