/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * High-level information about a managed rule group, returned by <a>ListAvailableManagedRuleGroups</a>. This provides
 * information like the name and vendor name, that you provide when you add a <a>ManagedRuleGroupStatement</a> to a web
 * ACL. Managed rule groups include Amazon Web Services Managed Rules rule groups and Amazon Web Services Marketplace
 * managed rule groups. To use any Amazon Web Services Marketplace managed rule group, first subscribe to the rule group
 * through Amazon Web Services Marketplace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedRuleGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedRuleGroupSummary.Builder, ManagedRuleGroupSummary> {
    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorName").getter(getter(ManagedRuleGroupSummary::vendorName)).setter(setter(Builder::vendorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ManagedRuleGroupSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> VERSIONING_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VersioningSupported").getter(getter(ManagedRuleGroupSummary::versioningSupported))
            .setter(setter(Builder::versioningSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersioningSupported").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ManagedRuleGroupSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_NAME_FIELD, NAME_FIELD,
            VERSIONING_SUPPORTED_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vendorName;

    private final String name;

    private final Boolean versioningSupported;

    private final String description;

    private ManagedRuleGroupSummary(BuilderImpl builder) {
        this.vendorName = builder.vendorName;
        this.name = builder.name;
        this.versioningSupported = builder.versioningSupported;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule
     * group.
     * </p>
     * 
     * @return The name of the managed rule group vendor. You use this, along with the rule group name, to identify a
     *         rule group.
     */
    public final String vendorName() {
        return vendorName;
    }

    /**
     * <p>
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     * </p>
     * 
     * @return The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates whether the managed rule group is versioned. If it is, you can retrieve the versions list by calling
     * <a>ListAvailableManagedRuleGroupVersions</a>.
     * </p>
     * 
     * @return Indicates whether the managed rule group is versioned. If it is, you can retrieve the versions list by
     *         calling <a>ListAvailableManagedRuleGroupVersions</a>.
     */
    public final Boolean versioningSupported() {
        return versioningSupported;
    }

    /**
     * <p>
     * The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon Web
     * Services Marketplace seller who manages it.
     * </p>
     * 
     * @return The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon
     *         Web Services Marketplace seller who manages it.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versioningSupported());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleGroupSummary)) {
            return false;
        }
        ManagedRuleGroupSummary other = (ManagedRuleGroupSummary) obj;
        return Objects.equals(vendorName(), other.vendorName()) && Objects.equals(name(), other.name())
                && Objects.equals(versioningSupported(), other.versioningSupported())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedRuleGroupSummary").add("VendorName", vendorName()).add("Name", name())
                .add("VersioningSupported", versioningSupported()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VendorName":
            return Optional.ofNullable(clazz.cast(vendorName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VersioningSupported":
            return Optional.ofNullable(clazz.cast(versioningSupported()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VendorName", VENDOR_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("VersioningSupported", VERSIONING_SUPPORTED_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedRuleGroupSummary, T> g) {
        return obj -> g.apply((ManagedRuleGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedRuleGroupSummary> {
        /**
         * <p>
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule
         * group.
         * </p>
         * 
         * @param vendorName
         *        The name of the managed rule group vendor. You use this, along with the rule group name, to identify a
         *        rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorName(String vendorName);

        /**
         * <p>
         * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
         * </p>
         * 
         * @param name
         *        The name of the managed rule group. You use this, along with the vendor name, to identify the rule
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates whether the managed rule group is versioned. If it is, you can retrieve the versions list by
         * calling <a>ListAvailableManagedRuleGroupVersions</a>.
         * </p>
         * 
         * @param versioningSupported
         *        Indicates whether the managed rule group is versioned. If it is, you can retrieve the versions list by
         *        calling <a>ListAvailableManagedRuleGroupVersions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versioningSupported(Boolean versioningSupported);

        /**
         * <p>
         * The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon Web
         * Services Marketplace seller who manages it.
         * </p>
         * 
         * @param description
         *        The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon
         *        Web Services Marketplace seller who manages it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String vendorName;

        private String name;

        private Boolean versioningSupported;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedRuleGroupSummary model) {
            vendorName(model.vendorName);
            name(model.name);
            versioningSupported(model.versioningSupported);
            description(model.description);
        }

        public final String getVendorName() {
            return vendorName;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getVersioningSupported() {
            return versioningSupported;
        }

        public final void setVersioningSupported(Boolean versioningSupported) {
            this.versioningSupported = versioningSupported;
        }

        @Override
        public final Builder versioningSupported(Boolean versioningSupported) {
            this.versioningSupported = versioningSupported;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ManagedRuleGroupSummary build() {
            return new ManagedRuleGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
