/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a single custom aggregate key for a rate-base rule.
 * </p>
 * <note>
 * <p>
 * Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based
 * rule evaluation and handling.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RateBasedStatementCustomKey implements SdkPojo, Serializable,
        ToCopyableBuilder<RateBasedStatementCustomKey.Builder, RateBasedStatementCustomKey> {
    private static final SdkField<RateLimitHeader> HEADER_FIELD = SdkField.<RateLimitHeader> builder(MarshallingType.SDK_POJO)
            .memberName("Header").getter(getter(RateBasedStatementCustomKey::header)).setter(setter(Builder::header))
            .constructor(RateLimitHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()).build();

    private static final SdkField<RateLimitCookie> COOKIE_FIELD = SdkField.<RateLimitCookie> builder(MarshallingType.SDK_POJO)
            .memberName("Cookie").getter(getter(RateBasedStatementCustomKey::cookie)).setter(setter(Builder::cookie))
            .constructor(RateLimitCookie::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cookie").build()).build();

    private static final SdkField<RateLimitQueryArgument> QUERY_ARGUMENT_FIELD = SdkField
            .<RateLimitQueryArgument> builder(MarshallingType.SDK_POJO).memberName("QueryArgument")
            .getter(getter(RateBasedStatementCustomKey::queryArgument)).setter(setter(Builder::queryArgument))
            .constructor(RateLimitQueryArgument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArgument").build()).build();

    private static final SdkField<RateLimitQueryString> QUERY_STRING_FIELD = SdkField
            .<RateLimitQueryString> builder(MarshallingType.SDK_POJO).memberName("QueryString")
            .getter(getter(RateBasedStatementCustomKey::queryString)).setter(setter(Builder::queryString))
            .constructor(RateLimitQueryString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<RateLimitHTTPMethod> HTTP_METHOD_FIELD = SdkField
            .<RateLimitHTTPMethod> builder(MarshallingType.SDK_POJO).memberName("HTTPMethod")
            .getter(getter(RateBasedStatementCustomKey::httpMethod)).setter(setter(Builder::httpMethod))
            .constructor(RateLimitHTTPMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPMethod").build()).build();

    private static final SdkField<RateLimitForwardedIP> FORWARDED_IP_FIELD = SdkField
            .<RateLimitForwardedIP> builder(MarshallingType.SDK_POJO).memberName("ForwardedIP")
            .getter(getter(RateBasedStatementCustomKey::forwardedIP)).setter(setter(Builder::forwardedIP))
            .constructor(RateLimitForwardedIP::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedIP").build()).build();

    private static final SdkField<RateLimitIP> IP_FIELD = SdkField.<RateLimitIP> builder(MarshallingType.SDK_POJO)
            .memberName("IP").getter(getter(RateBasedStatementCustomKey::ip)).setter(setter(Builder::ip))
            .constructor(RateLimitIP::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IP").build()).build();

    private static final SdkField<RateLimitLabelNamespace> LABEL_NAMESPACE_FIELD = SdkField
            .<RateLimitLabelNamespace> builder(MarshallingType.SDK_POJO).memberName("LabelNamespace")
            .getter(getter(RateBasedStatementCustomKey::labelNamespace)).setter(setter(Builder::labelNamespace))
            .constructor(RateLimitLabelNamespace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelNamespace").build()).build();

    private static final SdkField<RateLimitUriPath> URI_PATH_FIELD = SdkField
            .<RateLimitUriPath> builder(MarshallingType.SDK_POJO).memberName("UriPath")
            .getter(getter(RateBasedStatementCustomKey::uriPath)).setter(setter(Builder::uriPath))
            .constructor(RateLimitUriPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD, COOKIE_FIELD,
            QUERY_ARGUMENT_FIELD, QUERY_STRING_FIELD, HTTP_METHOD_FIELD, FORWARDED_IP_FIELD, IP_FIELD, LABEL_NAMESPACE_FIELD,
            URI_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RateLimitHeader header;

    private final RateLimitCookie cookie;

    private final RateLimitQueryArgument queryArgument;

    private final RateLimitQueryString queryString;

    private final RateLimitHTTPMethod httpMethod;

    private final RateLimitForwardedIP forwardedIP;

    private final RateLimitIP ip;

    private final RateLimitLabelNamespace labelNamespace;

    private final RateLimitUriPath uriPath;

    private RateBasedStatementCustomKey(BuilderImpl builder) {
        this.header = builder.header;
        this.cookie = builder.cookie;
        this.queryArgument = builder.queryArgument;
        this.queryString = builder.queryString;
        this.httpMethod = builder.httpMethod;
        this.forwardedIP = builder.forwardedIP;
        this.ip = builder.ip;
        this.labelNamespace = builder.labelNamespace;
        this.uriPath = builder.uriPath;
    }

    /**
     * <p>
     * Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to
     * the aggregation instance. If you use a single header as your custom key, then each value fully defines an
     * aggregation instance.
     * </p>
     * 
     * @return Use the value of a header in the request as an aggregate key. Each distinct value in the header
     *         contributes to the aggregation instance. If you use a single header as your custom key, then each value
     *         fully defines an aggregation instance.
     */
    public final RateLimitHeader header() {
        return header;
    }

    /**
     * <p>
     * Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to
     * the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an
     * aggregation instance.
     * </p>
     * 
     * @return Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie
     *         contributes to the aggregation instance. If you use a single cookie as your custom key, then each value
     *         fully defines an aggregation instance.
     */
    public final RateLimitCookie cookie() {
        return cookie;
    }

    /**
     * <p>
     * Use the specified query argument as an aggregate key. Each distinct value for the named query argument
     * contributes to the aggregation instance. If you use a single query argument as your custom key, then each value
     * fully defines an aggregation instance.
     * </p>
     * 
     * @return Use the specified query argument as an aggregate key. Each distinct value for the named query argument
     *         contributes to the aggregation instance. If you use a single query argument as your custom key, then each
     *         value fully defines an aggregation instance.
     */
    public final RateLimitQueryArgument queryArgument() {
        return queryArgument;
    }

    /**
     * <p>
     * Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance.
     * If you use just the query string as your custom key, then each string fully defines an aggregation instance.
     * </p>
     * 
     * @return Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation
     *         instance. If you use just the query string as your custom key, then each string fully defines an
     *         aggregation instance.
     */
    public final RateLimitQueryString queryString() {
        return queryString;
    }

    /**
     * <p>
     * Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation
     * instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation
     * instance.
     * </p>
     * 
     * @return Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the
     *         aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines
     *         an aggregation instance.
     */
    public final RateLimitHTTPMethod httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to
     * the aggregation instance.
     * </p>
     * <p>
     * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key
     * to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in your
     * rate-based statement's <code>AggregateKeyType</code>.
     * </p>
     * <p>
     * With this option, you must specify the header to use in the rate-based rule's <code>ForwardedIPConfig</code>
     * property.
     * </p>
     * 
     * @return Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address
     *         contributes to the aggregation instance.</p>
     *         <p>
     *         When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one
     *         other key to use. You can aggregate on only the forwarded IP address by specifying
     *         <code>FORWARDED_IP</code> in your rate-based statement's <code>AggregateKeyType</code>.
     *         </p>
     *         <p>
     *         With this option, you must specify the header to use in the rate-based rule's
     *         <code>ForwardedIPConfig</code> property.
     */
    public final RateLimitForwardedIP forwardedIP() {
        return forwardedIP;
    }

    /**
     * <p>
     * Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the
     * aggregation instance.
     * </p>
     * <p>
     * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key
     * to use. You can aggregate on only the IP address by specifying <code>IP</code> in your rate-based statement's
     * <code>AggregateKeyType</code>.
     * </p>
     * 
     * @return Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the
     *         aggregation instance.</p>
     *         <p>
     *         When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one
     *         other key to use. You can aggregate on only the IP address by specifying <code>IP</code> in your
     *         rate-based statement's <code>AggregateKeyType</code>.
     */
    public final RateLimitIP ip() {
        return ip;
    }

    /**
     * <p>
     * Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the
     * specified label namespace contributes to the aggregation instance. If you use just one label namespace as your
     * custom key, then each label name fully defines an aggregation instance.
     * </p>
     * <p>
     * This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule
     * in the web ACL.
     * </p>
     * <p>
     * For information about label namespaces and names, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax and
     * naming requirements</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * 
     * @return Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has
     *         the specified label namespace contributes to the aggregation instance. If you use just one label
     *         namespace as your custom key, then each label name fully defines an aggregation instance. </p>
     *         <p>
     *         This uses only labels that have been added to the request by rules that are evaluated before this
     *         rate-based rule in the web ACL.
     *         </p>
     *         <p>
     *         For information about label namespaces and names, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label
     *         syntax and naming requirements</a> in the <i>WAF Developer Guide</i>.
     */
    public final RateLimitLabelNamespace labelNamespace() {
        return labelNamespace;
    }

    /**
     * <p>
     * Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance.
     * If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
     * </p>
     * 
     * @return Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation
     *         instance. If you use just the URI path as your custom key, then each URI path fully defines an
     *         aggregation instance.
     */
    public final RateLimitUriPath uriPath() {
        return uriPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(cookie());
        hashCode = 31 * hashCode + Objects.hashCode(queryArgument());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(forwardedIP());
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(labelNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(uriPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedStatementCustomKey)) {
            return false;
        }
        RateBasedStatementCustomKey other = (RateBasedStatementCustomKey) obj;
        return Objects.equals(header(), other.header()) && Objects.equals(cookie(), other.cookie())
                && Objects.equals(queryArgument(), other.queryArgument()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(forwardedIP(), other.forwardedIP())
                && Objects.equals(ip(), other.ip()) && Objects.equals(labelNamespace(), other.labelNamespace())
                && Objects.equals(uriPath(), other.uriPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RateBasedStatementCustomKey").add("Header", header()).add("Cookie", cookie())
                .add("QueryArgument", queryArgument()).add("QueryString", queryString()).add("HTTPMethod", httpMethod())
                .add("ForwardedIP", forwardedIP()).add("IP", ip()).add("LabelNamespace", labelNamespace())
                .add("UriPath", uriPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        case "Cookie":
            return Optional.ofNullable(clazz.cast(cookie()));
        case "QueryArgument":
            return Optional.ofNullable(clazz.cast(queryArgument()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "HTTPMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "ForwardedIP":
            return Optional.ofNullable(clazz.cast(forwardedIP()));
        case "IP":
            return Optional.ofNullable(clazz.cast(ip()));
        case "LabelNamespace":
            return Optional.ofNullable(clazz.cast(labelNamespace()));
        case "UriPath":
            return Optional.ofNullable(clazz.cast(uriPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Header", HEADER_FIELD);
        map.put("Cookie", COOKIE_FIELD);
        map.put("QueryArgument", QUERY_ARGUMENT_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("HTTPMethod", HTTP_METHOD_FIELD);
        map.put("ForwardedIP", FORWARDED_IP_FIELD);
        map.put("IP", IP_FIELD);
        map.put("LabelNamespace", LABEL_NAMESPACE_FIELD);
        map.put("UriPath", URI_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RateBasedStatementCustomKey, T> g) {
        return obj -> g.apply((RateBasedStatementCustomKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RateBasedStatementCustomKey> {
        /**
         * <p>
         * Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes
         * to the aggregation instance. If you use a single header as your custom key, then each value fully defines an
         * aggregation instance.
         * </p>
         * 
         * @param header
         *        Use the value of a header in the request as an aggregate key. Each distinct value in the header
         *        contributes to the aggregation instance. If you use a single header as your custom key, then each
         *        value fully defines an aggregation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(RateLimitHeader header);

        /**
         * <p>
         * Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes
         * to the aggregation instance. If you use a single header as your custom key, then each value fully defines an
         * aggregation instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitHeader.Builder} avoiding the
         * need to create one manually via {@link RateLimitHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #header(RateLimitHeader)}.
         * 
         * @param header
         *        a consumer that will call methods on {@link RateLimitHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #header(RateLimitHeader)
         */
        default Builder header(Consumer<RateLimitHeader.Builder> header) {
            return header(RateLimitHeader.builder().applyMutation(header).build());
        }

        /**
         * <p>
         * Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes
         * to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an
         * aggregation instance.
         * </p>
         * 
         * @param cookie
         *        Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie
         *        contributes to the aggregation instance. If you use a single cookie as your custom key, then each
         *        value fully defines an aggregation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookie(RateLimitCookie cookie);

        /**
         * <p>
         * Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes
         * to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an
         * aggregation instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitCookie.Builder} avoiding the
         * need to create one manually via {@link RateLimitCookie#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitCookie.Builder#build()} is called immediately and its
         * result is passed to {@link #cookie(RateLimitCookie)}.
         * 
         * @param cookie
         *        a consumer that will call methods on {@link RateLimitCookie.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cookie(RateLimitCookie)
         */
        default Builder cookie(Consumer<RateLimitCookie.Builder> cookie) {
            return cookie(RateLimitCookie.builder().applyMutation(cookie).build());
        }

        /**
         * <p>
         * Use the specified query argument as an aggregate key. Each distinct value for the named query argument
         * contributes to the aggregation instance. If you use a single query argument as your custom key, then each
         * value fully defines an aggregation instance.
         * </p>
         * 
         * @param queryArgument
         *        Use the specified query argument as an aggregate key. Each distinct value for the named query argument
         *        contributes to the aggregation instance. If you use a single query argument as your custom key, then
         *        each value fully defines an aggregation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryArgument(RateLimitQueryArgument queryArgument);

        /**
         * <p>
         * Use the specified query argument as an aggregate key. Each distinct value for the named query argument
         * contributes to the aggregation instance. If you use a single query argument as your custom key, then each
         * value fully defines an aggregation instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitQueryArgument.Builder} avoiding
         * the need to create one manually via {@link RateLimitQueryArgument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitQueryArgument.Builder#build()} is called immediately and
         * its result is passed to {@link #queryArgument(RateLimitQueryArgument)}.
         * 
         * @param queryArgument
         *        a consumer that will call methods on {@link RateLimitQueryArgument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryArgument(RateLimitQueryArgument)
         */
        default Builder queryArgument(Consumer<RateLimitQueryArgument.Builder> queryArgument) {
            return queryArgument(RateLimitQueryArgument.builder().applyMutation(queryArgument).build());
        }

        /**
         * <p>
         * Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation
         * instance. If you use just the query string as your custom key, then each string fully defines an aggregation
         * instance.
         * </p>
         * 
         * @param queryString
         *        Use the request's query string as an aggregate key. Each distinct string contributes to the
         *        aggregation instance. If you use just the query string as your custom key, then each string fully
         *        defines an aggregation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(RateLimitQueryString queryString);

        /**
         * <p>
         * Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation
         * instance. If you use just the query string as your custom key, then each string fully defines an aggregation
         * instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitQueryString.Builder} avoiding
         * the need to create one manually via {@link RateLimitQueryString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitQueryString.Builder#build()} is called immediately and
         * its result is passed to {@link #queryString(RateLimitQueryString)}.
         * 
         * @param queryString
         *        a consumer that will call methods on {@link RateLimitQueryString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryString(RateLimitQueryString)
         */
        default Builder queryString(Consumer<RateLimitQueryString.Builder> queryString) {
            return queryString(RateLimitQueryString.builder().applyMutation(queryString).build());
        }

        /**
         * <p>
         * Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation
         * instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation
         * instance.
         * </p>
         * 
         * @param httpMethod
         *        Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the
         *        aggregation instance. If you use just the HTTP method as your custom key, then each method fully
         *        defines an aggregation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(RateLimitHTTPMethod httpMethod);

        /**
         * <p>
         * Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation
         * instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation
         * instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitHTTPMethod.Builder} avoiding the
         * need to create one manually via {@link RateLimitHTTPMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitHTTPMethod.Builder#build()} is called immediately and
         * its result is passed to {@link #httpMethod(RateLimitHTTPMethod)}.
         * 
         * @param httpMethod
         *        a consumer that will call methods on {@link RateLimitHTTPMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpMethod(RateLimitHTTPMethod)
         */
        default Builder httpMethod(Consumer<RateLimitHTTPMethod.Builder> httpMethod) {
            return httpMethod(RateLimitHTTPMethod.builder().applyMutation(httpMethod).build());
        }

        /**
         * <p>
         * Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address
         * contributes to the aggregation instance.
         * </p>
         * <p>
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other
         * key to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in
         * your rate-based statement's <code>AggregateKeyType</code>.
         * </p>
         * <p>
         * With this option, you must specify the header to use in the rate-based rule's <code>ForwardedIPConfig</code>
         * property.
         * </p>
         * 
         * @param forwardedIP
         *        Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address
         *        contributes to the aggregation instance.</p>
         *        <p>
         *        When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one
         *        other key to use. You can aggregate on only the forwarded IP address by specifying
         *        <code>FORWARDED_IP</code> in your rate-based statement's <code>AggregateKeyType</code>.
         *        </p>
         *        <p>
         *        With this option, you must specify the header to use in the rate-based rule's
         *        <code>ForwardedIPConfig</code> property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardedIP(RateLimitForwardedIP forwardedIP);

        /**
         * <p>
         * Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address
         * contributes to the aggregation instance.
         * </p>
         * <p>
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other
         * key to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in
         * your rate-based statement's <code>AggregateKeyType</code>.
         * </p>
         * <p>
         * With this option, you must specify the header to use in the rate-based rule's <code>ForwardedIPConfig</code>
         * property.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitForwardedIP.Builder} avoiding
         * the need to create one manually via {@link RateLimitForwardedIP#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitForwardedIP.Builder#build()} is called immediately and
         * its result is passed to {@link #forwardedIP(RateLimitForwardedIP)}.
         * 
         * @param forwardedIP
         *        a consumer that will call methods on {@link RateLimitForwardedIP.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forwardedIP(RateLimitForwardedIP)
         */
        default Builder forwardedIP(Consumer<RateLimitForwardedIP.Builder> forwardedIP) {
            return forwardedIP(RateLimitForwardedIP.builder().applyMutation(forwardedIP).build());
        }

        /**
         * <p>
         * Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the
         * aggregation instance.
         * </p>
         * <p>
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other
         * key to use. You can aggregate on only the IP address by specifying <code>IP</code> in your rate-based
         * statement's <code>AggregateKeyType</code>.
         * </p>
         * 
         * @param ip
         *        Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to
         *        the aggregation instance.</p>
         *        <p>
         *        When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one
         *        other key to use. You can aggregate on only the IP address by specifying <code>IP</code> in your
         *        rate-based statement's <code>AggregateKeyType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(RateLimitIP ip);

        /**
         * <p>
         * Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the
         * aggregation instance.
         * </p>
         * <p>
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other
         * key to use. You can aggregate on only the IP address by specifying <code>IP</code> in your rate-based
         * statement's <code>AggregateKeyType</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitIP.Builder} avoiding the need to
         * create one manually via {@link RateLimitIP#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitIP.Builder#build()} is called immediately and its result
         * is passed to {@link #ip(RateLimitIP)}.
         * 
         * @param ip
         *        a consumer that will call methods on {@link RateLimitIP.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ip(RateLimitIP)
         */
        default Builder ip(Consumer<RateLimitIP.Builder> ip) {
            return ip(RateLimitIP.builder().applyMutation(ip).build());
        }

        /**
         * <p>
         * Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the
         * specified label namespace contributes to the aggregation instance. If you use just one label namespace as
         * your custom key, then each label name fully defines an aggregation instance.
         * </p>
         * <p>
         * This uses only labels that have been added to the request by rules that are evaluated before this rate-based
         * rule in the web ACL.
         * </p>
         * <p>
         * For information about label namespaces and names, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax
         * and naming requirements</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param labelNamespace
         *        Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that
         *        has the specified label namespace contributes to the aggregation instance. If you use just one label
         *        namespace as your custom key, then each label name fully defines an aggregation instance. </p>
         *        <p>
         *        This uses only labels that have been added to the request by rules that are evaluated before this
         *        rate-based rule in the web ACL.
         *        </p>
         *        <p>
         *        For information about label namespaces and names, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label
         *        syntax and naming requirements</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelNamespace(RateLimitLabelNamespace labelNamespace);

        /**
         * <p>
         * Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the
         * specified label namespace contributes to the aggregation instance. If you use just one label namespace as
         * your custom key, then each label name fully defines an aggregation instance.
         * </p>
         * <p>
         * This uses only labels that have been added to the request by rules that are evaluated before this rate-based
         * rule in the web ACL.
         * </p>
         * <p>
         * For information about label namespaces and names, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax
         * and naming requirements</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitLabelNamespace.Builder} avoiding
         * the need to create one manually via {@link RateLimitLabelNamespace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitLabelNamespace.Builder#build()} is called immediately
         * and its result is passed to {@link #labelNamespace(RateLimitLabelNamespace)}.
         * 
         * @param labelNamespace
         *        a consumer that will call methods on {@link RateLimitLabelNamespace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelNamespace(RateLimitLabelNamespace)
         */
        default Builder labelNamespace(Consumer<RateLimitLabelNamespace.Builder> labelNamespace) {
            return labelNamespace(RateLimitLabelNamespace.builder().applyMutation(labelNamespace).build());
        }

        /**
         * <p>
         * Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation
         * instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation
         * instance.
         * </p>
         * 
         * @param uriPath
         *        Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation
         *        instance. If you use just the URI path as your custom key, then each URI path fully defines an
         *        aggregation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uriPath(RateLimitUriPath uriPath);

        /**
         * <p>
         * Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation
         * instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation
         * instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimitUriPath.Builder} avoiding the
         * need to create one manually via {@link RateLimitUriPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimitUriPath.Builder#build()} is called immediately and its
         * result is passed to {@link #uriPath(RateLimitUriPath)}.
         * 
         * @param uriPath
         *        a consumer that will call methods on {@link RateLimitUriPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uriPath(RateLimitUriPath)
         */
        default Builder uriPath(Consumer<RateLimitUriPath.Builder> uriPath) {
            return uriPath(RateLimitUriPath.builder().applyMutation(uriPath).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RateLimitHeader header;

        private RateLimitCookie cookie;

        private RateLimitQueryArgument queryArgument;

        private RateLimitQueryString queryString;

        private RateLimitHTTPMethod httpMethod;

        private RateLimitForwardedIP forwardedIP;

        private RateLimitIP ip;

        private RateLimitLabelNamespace labelNamespace;

        private RateLimitUriPath uriPath;

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedStatementCustomKey model) {
            header(model.header);
            cookie(model.cookie);
            queryArgument(model.queryArgument);
            queryString(model.queryString);
            httpMethod(model.httpMethod);
            forwardedIP(model.forwardedIP);
            ip(model.ip);
            labelNamespace(model.labelNamespace);
            uriPath(model.uriPath);
        }

        public final RateLimitHeader.Builder getHeader() {
            return header != null ? header.toBuilder() : null;
        }

        public final void setHeader(RateLimitHeader.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        public final Builder header(RateLimitHeader header) {
            this.header = header;
            return this;
        }

        public final RateLimitCookie.Builder getCookie() {
            return cookie != null ? cookie.toBuilder() : null;
        }

        public final void setCookie(RateLimitCookie.BuilderImpl cookie) {
            this.cookie = cookie != null ? cookie.build() : null;
        }

        @Override
        public final Builder cookie(RateLimitCookie cookie) {
            this.cookie = cookie;
            return this;
        }

        public final RateLimitQueryArgument.Builder getQueryArgument() {
            return queryArgument != null ? queryArgument.toBuilder() : null;
        }

        public final void setQueryArgument(RateLimitQueryArgument.BuilderImpl queryArgument) {
            this.queryArgument = queryArgument != null ? queryArgument.build() : null;
        }

        @Override
        public final Builder queryArgument(RateLimitQueryArgument queryArgument) {
            this.queryArgument = queryArgument;
            return this;
        }

        public final RateLimitQueryString.Builder getQueryString() {
            return queryString != null ? queryString.toBuilder() : null;
        }

        public final void setQueryString(RateLimitQueryString.BuilderImpl queryString) {
            this.queryString = queryString != null ? queryString.build() : null;
        }

        @Override
        public final Builder queryString(RateLimitQueryString queryString) {
            this.queryString = queryString;
            return this;
        }

        public final RateLimitHTTPMethod.Builder getHttpMethod() {
            return httpMethod != null ? httpMethod.toBuilder() : null;
        }

        public final void setHttpMethod(RateLimitHTTPMethod.BuilderImpl httpMethod) {
            this.httpMethod = httpMethod != null ? httpMethod.build() : null;
        }

        @Override
        public final Builder httpMethod(RateLimitHTTPMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final RateLimitForwardedIP.Builder getForwardedIP() {
            return forwardedIP != null ? forwardedIP.toBuilder() : null;
        }

        public final void setForwardedIP(RateLimitForwardedIP.BuilderImpl forwardedIP) {
            this.forwardedIP = forwardedIP != null ? forwardedIP.build() : null;
        }

        @Override
        public final Builder forwardedIP(RateLimitForwardedIP forwardedIP) {
            this.forwardedIP = forwardedIP;
            return this;
        }

        public final RateLimitIP.Builder getIp() {
            return ip != null ? ip.toBuilder() : null;
        }

        public final void setIp(RateLimitIP.BuilderImpl ip) {
            this.ip = ip != null ? ip.build() : null;
        }

        @Override
        public final Builder ip(RateLimitIP ip) {
            this.ip = ip;
            return this;
        }

        public final RateLimitLabelNamespace.Builder getLabelNamespace() {
            return labelNamespace != null ? labelNamespace.toBuilder() : null;
        }

        public final void setLabelNamespace(RateLimitLabelNamespace.BuilderImpl labelNamespace) {
            this.labelNamespace = labelNamespace != null ? labelNamespace.build() : null;
        }

        @Override
        public final Builder labelNamespace(RateLimitLabelNamespace labelNamespace) {
            this.labelNamespace = labelNamespace;
            return this;
        }

        public final RateLimitUriPath.Builder getUriPath() {
            return uriPath != null ? uriPath.toBuilder() : null;
        }

        public final void setUriPath(RateLimitUriPath.BuilderImpl uriPath) {
            this.uriPath = uriPath != null ? uriPath.build() : null;
        }

        @Override
        public final Builder uriPath(RateLimitUriPath uriPath) {
            this.uriPath = uriPath;
            return this;
        }

        @Override
        public RateBasedStatementCustomKey build() {
            return new RateBasedStatementCustomKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
