/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a cookie as an aggregate key for a rate-based rule. Each distinct value in the cookie contributes to the
 * aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation
 * instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RateLimitCookie implements SdkPojo, Serializable, ToCopyableBuilder<RateLimitCookie.Builder, RateLimitCookie> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RateLimitCookie::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<TextTransformation>> TEXT_TRANSFORMATIONS_FIELD = SdkField
            .<List<TextTransformation>> builder(MarshallingType.LIST)
            .memberName("TextTransformations")
            .getter(getter(RateLimitCookie::textTransformations))
            .setter(setter(Builder::textTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TEXT_TRANSFORMATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<TextTransformation> textTransformations;

    private RateLimitCookie(BuilderImpl builder) {
        this.name = builder.name;
        this.textTransformations = builder.textTransformations;
    }

    /**
     * <p>
     * The name of the cookie to use.
     * </p>
     * 
     * @return The name of the cookie to use.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextTransformations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTextTransformations() {
        return textTransformations != null && !(textTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to
     * bypass detection. Text transformations are used in rule match statements, to transform the
     * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements,
     * to transform request components before using them as custom aggregation keys. If you specify one or more
     * transformations to apply, WAF performs all transformations on the specified content, starting from the lowest
     * priority setting, and then uses the transformed component contents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextTransformations} method.
     * </p>
     * 
     * @return Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
     *         effort to bypass detection. Text transformations are used in rule match statements, to transform the
     *         <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
     *         statements, to transform request components before using them as custom aggregation keys. If you specify
     *         one or more transformations to apply, WAF performs all transformations on the specified content, starting
     *         from the lowest priority setting, and then uses the transformed component contents.
     */
    public final List<TextTransformation> textTransformations() {
        return textTransformations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTextTransformations() ? textTransformations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateLimitCookie)) {
            return false;
        }
        RateLimitCookie other = (RateLimitCookie) obj;
        return Objects.equals(name(), other.name()) && hasTextTransformations() == other.hasTextTransformations()
                && Objects.equals(textTransformations(), other.textTransformations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RateLimitCookie").add("Name", name())
                .add("TextTransformations", hasTextTransformations() ? textTransformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TextTransformations":
            return Optional.ofNullable(clazz.cast(textTransformations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("TextTransformations", TEXT_TRANSFORMATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RateLimitCookie, T> g) {
        return obj -> g.apply((RateLimitCookie) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RateLimitCookie> {
        /**
         * <p>
         * The name of the cookie to use.
         * </p>
         * 
         * @param name
         *        The name of the cookie to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. Text transformations are used in rule match statements, to transform the
         * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         * statements, to transform request components before using them as custom aggregation keys. If you specify one
         * or more transformations to apply, WAF performs all transformations on the specified content, starting from
         * the lowest priority setting, and then uses the transformed component contents.
         * </p>
         * 
         * @param textTransformations
         *        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
         *        effort to bypass detection. Text transformations are used in rule match statements, to transform the
         *        <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         *        statements, to transform request components before using them as custom aggregation keys. If you
         *        specify one or more transformations to apply, WAF performs all transformations on the specified
         *        content, starting from the lowest priority setting, and then uses the transformed component contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textTransformations(Collection<TextTransformation> textTransformations);

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. Text transformations are used in rule match statements, to transform the
         * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         * statements, to transform request components before using them as custom aggregation keys. If you specify one
         * or more transformations to apply, WAF performs all transformations on the specified content, starting from
         * the lowest priority setting, and then uses the transformed component contents.
         * </p>
         * 
         * @param textTransformations
         *        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
         *        effort to bypass detection. Text transformations are used in rule match statements, to transform the
         *        <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         *        statements, to transform request components before using them as custom aggregation keys. If you
         *        specify one or more transformations to apply, WAF performs all transformations on the specified
         *        content, starting from the lowest priority setting, and then uses the transformed component contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textTransformations(TextTransformation... textTransformations);

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. Text transformations are used in rule match statements, to transform the
         * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         * statements, to transform request components before using them as custom aggregation keys. If you specify one
         * or more transformations to apply, WAF performs all transformations on the specified content, starting from
         * the lowest priority setting, and then uses the transformed component contents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.TextTransformation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.wafv2.model.TextTransformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.TextTransformation.Builder#build()} is called immediately
         * and its result is passed to {@link #textTransformations(List<TextTransformation>)}.
         * 
         * @param textTransformations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.TextTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textTransformations(java.util.Collection<TextTransformation>)
         */
        Builder textTransformations(Consumer<TextTransformation.Builder>... textTransformations);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<TextTransformation> textTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RateLimitCookie model) {
            name(model.name);
            textTransformations(model.textTransformations);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<TextTransformation.Builder> getTextTransformations() {
            List<TextTransformation.Builder> result = TextTransformationsCopier.copyToBuilder(this.textTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextTransformations(Collection<TextTransformation.BuilderImpl> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copyFromBuilder(textTransformations);
        }

        @Override
        public final Builder textTransformations(Collection<TextTransformation> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copy(textTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(TextTransformation... textTransformations) {
            textTransformations(Arrays.asList(textTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(Consumer<TextTransformation.Builder>... textTransformations) {
            textTransformations(Stream.of(textTransformations).map(c -> TextTransformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RateLimitCookie build() {
            return new RateLimitCookie(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
