/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule statement used to search web request components for a match against a single regular expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexMatchStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<RegexMatchStatement.Builder, RegexMatchStatement> {
    private static final SdkField<String> REGEX_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexString").getter(getter(RegexMatchStatement::regexString)).setter(setter(Builder::regexString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexString").build()).build();

    private static final SdkField<FieldToMatch> FIELD_TO_MATCH_FIELD = SdkField.<FieldToMatch> builder(MarshallingType.SDK_POJO)
            .memberName("FieldToMatch").getter(getter(RegexMatchStatement::fieldToMatch)).setter(setter(Builder::fieldToMatch))
            .constructor(FieldToMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldToMatch").build()).build();

    private static final SdkField<List<TextTransformation>> TEXT_TRANSFORMATIONS_FIELD = SdkField
            .<List<TextTransformation>> builder(MarshallingType.LIST)
            .memberName("TextTransformations")
            .getter(getter(RegexMatchStatement::textTransformations))
            .setter(setter(Builder::textTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_STRING_FIELD,
            FIELD_TO_MATCH_FIELD, TEXT_TRANSFORMATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regexString;

    private final FieldToMatch fieldToMatch;

    private final List<TextTransformation> textTransformations;

    private RegexMatchStatement(BuilderImpl builder) {
        this.regexString = builder.regexString;
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformations = builder.textTransformations;
    }

    /**
     * <p>
     * The string representing the regular expression.
     * </p>
     * 
     * @return The string representing the regular expression.
     */
    public final String regexString() {
        return regexString;
    }

    /**
     * <p>
     * The part of the web request that you want WAF to inspect.
     * </p>
     * 
     * @return The part of the web request that you want WAF to inspect.
     */
    public final FieldToMatch fieldToMatch() {
        return fieldToMatch;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextTransformations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTextTransformations() {
        return textTransformations != null && !(textTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to
     * bypass detection. Text transformations are used in rule match statements, to transform the
     * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements,
     * to transform request components before using them as custom aggregation keys. If you specify one or more
     * transformations to apply, WAF performs all transformations on the specified content, starting from the lowest
     * priority setting, and then uses the transformed component contents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextTransformations} method.
     * </p>
     * 
     * @return Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
     *         effort to bypass detection. Text transformations are used in rule match statements, to transform the
     *         <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
     *         statements, to transform request components before using them as custom aggregation keys. If you specify
     *         one or more transformations to apply, WAF performs all transformations on the specified content, starting
     *         from the lowest priority setting, and then uses the transformed component contents.
     */
    public final List<TextTransformation> textTransformations() {
        return textTransformations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regexString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(hasTextTransformations() ? textTransformations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchStatement)) {
            return false;
        }
        RegexMatchStatement other = (RegexMatchStatement) obj;
        return Objects.equals(regexString(), other.regexString()) && Objects.equals(fieldToMatch(), other.fieldToMatch())
                && hasTextTransformations() == other.hasTextTransformations()
                && Objects.equals(textTransformations(), other.textTransformations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegexMatchStatement").add("RegexString", regexString()).add("FieldToMatch", fieldToMatch())
                .add("TextTransformations", hasTextTransformations() ? textTransformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexString":
            return Optional.ofNullable(clazz.cast(regexString()));
        case "FieldToMatch":
            return Optional.ofNullable(clazz.cast(fieldToMatch()));
        case "TextTransformations":
            return Optional.ofNullable(clazz.cast(textTransformations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegexString", REGEX_STRING_FIELD);
        map.put("FieldToMatch", FIELD_TO_MATCH_FIELD);
        map.put("TextTransformations", TEXT_TRANSFORMATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegexMatchStatement, T> g) {
        return obj -> g.apply((RegexMatchStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexMatchStatement> {
        /**
         * <p>
         * The string representing the regular expression.
         * </p>
         * 
         * @param regexString
         *        The string representing the regular expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexString(String regexString);

        /**
         * <p>
         * The part of the web request that you want WAF to inspect.
         * </p>
         * 
         * @param fieldToMatch
         *        The part of the web request that you want WAF to inspect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldToMatch(FieldToMatch fieldToMatch);

        /**
         * <p>
         * The part of the web request that you want WAF to inspect.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldToMatch.Builder} avoiding the need
         * to create one manually via {@link FieldToMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldToMatch.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldToMatch(FieldToMatch)}.
         * 
         * @param fieldToMatch
         *        a consumer that will call methods on {@link FieldToMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldToMatch(FieldToMatch)
         */
        default Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return fieldToMatch(FieldToMatch.builder().applyMutation(fieldToMatch).build());
        }

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. Text transformations are used in rule match statements, to transform the
         * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         * statements, to transform request components before using them as custom aggregation keys. If you specify one
         * or more transformations to apply, WAF performs all transformations on the specified content, starting from
         * the lowest priority setting, and then uses the transformed component contents.
         * </p>
         * 
         * @param textTransformations
         *        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
         *        effort to bypass detection. Text transformations are used in rule match statements, to transform the
         *        <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         *        statements, to transform request components before using them as custom aggregation keys. If you
         *        specify one or more transformations to apply, WAF performs all transformations on the specified
         *        content, starting from the lowest priority setting, and then uses the transformed component contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textTransformations(Collection<TextTransformation> textTransformations);

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. Text transformations are used in rule match statements, to transform the
         * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         * statements, to transform request components before using them as custom aggregation keys. If you specify one
         * or more transformations to apply, WAF performs all transformations on the specified content, starting from
         * the lowest priority setting, and then uses the transformed component contents.
         * </p>
         * 
         * @param textTransformations
         *        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
         *        effort to bypass detection. Text transformations are used in rule match statements, to transform the
         *        <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         *        statements, to transform request components before using them as custom aggregation keys. If you
         *        specify one or more transformations to apply, WAF performs all transformations on the specified
         *        content, starting from the lowest priority setting, and then uses the transformed component contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textTransformations(TextTransformation... textTransformations);

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. Text transformations are used in rule match statements, to transform the
         * <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule
         * statements, to transform request components before using them as custom aggregation keys. If you specify one
         * or more transformations to apply, WAF performs all transformations on the specified content, starting from
         * the lowest priority setting, and then uses the transformed component contents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.TextTransformation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.wafv2.model.TextTransformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.TextTransformation.Builder#build()} is called immediately
         * and its result is passed to {@link #textTransformations(List<TextTransformation>)}.
         * 
         * @param textTransformations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.TextTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textTransformations(java.util.Collection<TextTransformation>)
         */
        Builder textTransformations(Consumer<TextTransformation.Builder>... textTransformations);
    }

    static final class BuilderImpl implements Builder {
        private String regexString;

        private FieldToMatch fieldToMatch;

        private List<TextTransformation> textTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchStatement model) {
            regexString(model.regexString);
            fieldToMatch(model.fieldToMatch);
            textTransformations(model.textTransformations);
        }

        public final String getRegexString() {
            return regexString;
        }

        public final void setRegexString(String regexString) {
            this.regexString = regexString;
        }

        @Override
        public final Builder regexString(String regexString) {
            this.regexString = regexString;
            return this;
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return fieldToMatch != null ? fieldToMatch.toBuilder() : null;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final List<TextTransformation.Builder> getTextTransformations() {
            List<TextTransformation.Builder> result = TextTransformationsCopier.copyToBuilder(this.textTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextTransformations(Collection<TextTransformation.BuilderImpl> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copyFromBuilder(textTransformations);
        }

        @Override
        public final Builder textTransformations(Collection<TextTransformation> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copy(textTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(TextTransformation... textTransformations) {
            textTransformations(Arrays.asList(textTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(Consumer<TextTransformation.Builder>... textTransformations) {
            textTransformations(Stream.of(textTransformations).map(c -> TextTransformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegexMatchStatement build() {
            return new RegexMatchStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
