/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account
 * creation attempts.
 * </p>
 * <p>
 * This is part of the <code>AWSManagedRulesACFPRuleSet</code> configuration in <code>ManagedRuleGroupConfig</code>.
 * </p>
 * <p>
 * In these settings, you specify how your application accepts account creation attempts by providing the request
 * payload type and the names of the fields within the request body where the username, password, email, and primary
 * address and phone number fields are provided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestInspectionACFP implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestInspectionACFP.Builder, RequestInspectionACFP> {
    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadType").getter(getter(RequestInspectionACFP::payloadTypeAsString))
            .setter(setter(Builder::payloadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()).build();

    private static final SdkField<UsernameField> USERNAME_FIELD_FIELD = SdkField
            .<UsernameField> builder(MarshallingType.SDK_POJO).memberName("UsernameField")
            .getter(getter(RequestInspectionACFP::usernameField)).setter(setter(Builder::usernameField))
            .constructor(UsernameField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameField").build()).build();

    private static final SdkField<PasswordField> PASSWORD_FIELD_FIELD = SdkField
            .<PasswordField> builder(MarshallingType.SDK_POJO).memberName("PasswordField")
            .getter(getter(RequestInspectionACFP::passwordField)).setter(setter(Builder::passwordField))
            .constructor(PasswordField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordField").build()).build();

    private static final SdkField<EmailField> EMAIL_FIELD_FIELD = SdkField.<EmailField> builder(MarshallingType.SDK_POJO)
            .memberName("EmailField").getter(getter(RequestInspectionACFP::emailField)).setter(setter(Builder::emailField))
            .constructor(EmailField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailField").build()).build();

    private static final SdkField<List<PhoneNumberField>> PHONE_NUMBER_FIELDS_FIELD = SdkField
            .<List<PhoneNumberField>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberFields")
            .getter(getter(RequestInspectionACFP::phoneNumberFields))
            .setter(setter(Builder::phoneNumberFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberField> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddressField>> ADDRESS_FIELDS_FIELD = SdkField
            .<List<AddressField>> builder(MarshallingType.LIST)
            .memberName("AddressFields")
            .getter(getter(RequestInspectionACFP::addressFields))
            .setter(setter(Builder::addressFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddressField> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddressField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_TYPE_FIELD,
            USERNAME_FIELD_FIELD, PASSWORD_FIELD_FIELD, EMAIL_FIELD_FIELD, PHONE_NUMBER_FIELDS_FIELD, ADDRESS_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String payloadType;

    private final UsernameField usernameField;

    private final PasswordField passwordField;

    private final EmailField emailField;

    private final List<PhoneNumberField> phoneNumberFields;

    private final List<AddressField> addressFields;

    private RequestInspectionACFP(BuilderImpl builder) {
        this.payloadType = builder.payloadType;
        this.usernameField = builder.usernameField;
        this.passwordField = builder.passwordField;
        this.emailField = builder.emailField;
        this.phoneNumberFields = builder.phoneNumberFields;
        this.addressFields = builder.addressFields;
    }

    /**
     * <p>
     * The payload type for your account creation endpoint, either JSON or form encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The payload type for your account creation endpoint, either JSON or form encoded.
     * @see PayloadType
     */
    public final PayloadType payloadType() {
        return PayloadType.fromValue(payloadType);
    }

    /**
     * <p>
     * The payload type for your account creation endpoint, either JSON or form encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The payload type for your account creation endpoint, either JSON or form encoded.
     * @see PayloadType
     */
    public final String payloadTypeAsString() {
        return payloadType;
    }

    /**
     * <p>
     * The name of the field in the request payload that contains your customer's username.
     * </p>
     * <p>
     * How you specify this depends on the request inspection payload type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax,
     * see the Internet Engineering Task Force (IETF) documentation <a
     * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field
     * specification is <code>/form/username</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For form encoded payload types, use the HTML form names.
     * </p>
     * <p>
     * For example, for an HTML form with the input element named <code>username1</code>, the username field
     * specification is <code>username1</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the field in the request payload that contains your customer's username. </p>
     *         <p>
     *         How you specify this depends on the request inspection payload type.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
     *         syntax, see the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username
     *         field specification is <code>/form/username</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For form encoded payload types, use the HTML form names.
     *         </p>
     *         <p>
     *         For example, for an HTML form with the input element named <code>username1</code>, the username field
     *         specification is <code>username1</code>
     *         </p>
     *         </li>
     */
    public final UsernameField usernameField() {
        return usernameField;
    }

    /**
     * <p>
     * The name of the field in the request payload that contains your customer's password.
     * </p>
     * <p>
     * How you specify this depends on the request inspection payload type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax,
     * see the Internet Engineering Task Force (IETF) documentation <a
     * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field
     * specification is <code>/form/password</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For form encoded payload types, use the HTML form names.
     * </p>
     * <p>
     * For example, for an HTML form with the input element named <code>password1</code>, the password field
     * specification is <code>password1</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the field in the request payload that contains your customer's password. </p>
     *         <p>
     *         How you specify this depends on the request inspection payload type.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
     *         syntax, see the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password
     *         field specification is <code>/form/password</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For form encoded payload types, use the HTML form names.
     *         </p>
     *         <p>
     *         For example, for an HTML form with the input element named <code>password1</code>, the password field
     *         specification is <code>password1</code>.
     *         </p>
     *         </li>
     */
    public final PasswordField passwordField() {
        return passwordField;
    }

    /**
     * <p>
     * The name of the field in the request payload that contains your customer's email.
     * </p>
     * <p>
     * How you specify this depends on the request inspection payload type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax,
     * see the Internet Engineering Task Force (IETF) documentation <a
     * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code>, the email field
     * specification is <code>/form/email</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For form encoded payload types, use the HTML form names.
     * </p>
     * <p>
     * For example, for an HTML form with the input element named <code>email1</code>, the email field specification is
     * <code>email1</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the field in the request payload that contains your customer's email. </p>
     *         <p>
     *         How you specify this depends on the request inspection payload type.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
     *         syntax, see the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code>, the email field
     *         specification is <code>/form/email</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For form encoded payload types, use the HTML form names.
     *         </p>
     *         <p>
     *         For example, for an HTML form with the input element named <code>email1</code>, the email field
     *         specification is <code>email1</code>.
     *         </p>
     *         </li>
     */
    public final EmailField emailField() {
        return emailField;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumberFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhoneNumberFields() {
        return phoneNumberFields != null && !(phoneNumberFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the fields in the request payload that contain your customer's primary phone number.
     * </p>
     * <p>
     * Order the phone number fields in the array exactly as they are ordered in the request payload.
     * </p>
     * <p>
     * How you specify the phone number fields depends on the request inspection payload type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer
     * syntax, see the Internet Engineering Task Force (IETF) documentation <a
     * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * For example, for the JSON payload
     * <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>
     * , the phone number field identifiers are <code>/form/primaryphoneline1</code>,
     * <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For form encoded payload types, use the HTML form names.
     * </p>
     * <p>
     * For example, for an HTML form with input elements named <code>primaryphoneline1</code>,
     * <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers are
     * <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumberFields} method.
     * </p>
     * 
     * @return The names of the fields in the request payload that contain your customer's primary phone number. </p>
     *         <p>
     *         Order the phone number fields in the array exactly as they are ordered in the request payload.
     *         </p>
     *         <p>
     *         How you specify the phone number fields depends on the request inspection payload type.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
     *         Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         For example, for the JSON payload
     *         <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>
     *         , the phone number field identifiers are <code>/form/primaryphoneline1</code>,
     *         <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For form encoded payload types, use the HTML form names.
     *         </p>
     *         <p>
     *         For example, for an HTML form with input elements named <code>primaryphoneline1</code>,
     *         <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers
     *         are <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>.
     *         </p>
     *         </li>
     */
    public final List<PhoneNumberField> phoneNumberFields() {
        return phoneNumberFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddressFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddressFields() {
        return addressFields != null && !(addressFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the fields in the request payload that contain your customer's primary physical address.
     * </p>
     * <p>
     * Order the address fields in the array exactly as they are ordered in the request payload.
     * </p>
     * <p>
     * How you specify the address fields depends on the request inspection payload type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer
     * syntax, see the Internet Engineering Task Force (IETF) documentation <a
     * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     * </p>
     * <p>
     * For example, for the JSON payload
     * <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>
     * , the address field idenfiers are <code>/form/primaryaddressline1</code>, <code>/form/primaryaddressline2</code>,
     * and <code>/form/primaryaddressline3</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For form encoded payload types, use the HTML form names.
     * </p>
     * <p>
     * For example, for an HTML form with input elements named <code>primaryaddressline1</code>,
     * <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers are
     * <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressFields} method.
     * </p>
     * 
     * @return The names of the fields in the request payload that contain your customer's primary physical address.
     *         </p>
     *         <p>
     *         Order the address fields in the array exactly as they are ordered in the request payload.
     *         </p>
     *         <p>
     *         How you specify the address fields depends on the request inspection payload type.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
     *         Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
     *         href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
     *         </p>
     *         <p>
     *         For example, for the JSON payload
     *         <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>
     *         , the address field idenfiers are <code>/form/primaryaddressline1</code>,
     *         <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For form encoded payload types, use the HTML form names.
     *         </p>
     *         <p>
     *         For example, for an HTML form with input elements named <code>primaryaddressline1</code>,
     *         <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers
     *         are <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and
     *         <code>primaryaddressline3</code>.
     *         </p>
     *         </li>
     */
    public final List<AddressField> addressFields() {
        return addressFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usernameField());
        hashCode = 31 * hashCode + Objects.hashCode(passwordField());
        hashCode = 31 * hashCode + Objects.hashCode(emailField());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberFields() ? phoneNumberFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddressFields() ? addressFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestInspectionACFP)) {
            return false;
        }
        RequestInspectionACFP other = (RequestInspectionACFP) obj;
        return Objects.equals(payloadTypeAsString(), other.payloadTypeAsString())
                && Objects.equals(usernameField(), other.usernameField())
                && Objects.equals(passwordField(), other.passwordField()) && Objects.equals(emailField(), other.emailField())
                && hasPhoneNumberFields() == other.hasPhoneNumberFields()
                && Objects.equals(phoneNumberFields(), other.phoneNumberFields())
                && hasAddressFields() == other.hasAddressFields() && Objects.equals(addressFields(), other.addressFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestInspectionACFP").add("PayloadType", payloadTypeAsString())
                .add("UsernameField", usernameField()).add("PasswordField", passwordField()).add("EmailField", emailField())
                .add("PhoneNumberFields", hasPhoneNumberFields() ? phoneNumberFields() : null)
                .add("AddressFields", hasAddressFields() ? addressFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadType":
            return Optional.ofNullable(clazz.cast(payloadTypeAsString()));
        case "UsernameField":
            return Optional.ofNullable(clazz.cast(usernameField()));
        case "PasswordField":
            return Optional.ofNullable(clazz.cast(passwordField()));
        case "EmailField":
            return Optional.ofNullable(clazz.cast(emailField()));
        case "PhoneNumberFields":
            return Optional.ofNullable(clazz.cast(phoneNumberFields()));
        case "AddressFields":
            return Optional.ofNullable(clazz.cast(addressFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        map.put("UsernameField", USERNAME_FIELD_FIELD);
        map.put("PasswordField", PASSWORD_FIELD_FIELD);
        map.put("EmailField", EMAIL_FIELD_FIELD);
        map.put("PhoneNumberFields", PHONE_NUMBER_FIELDS_FIELD);
        map.put("AddressFields", ADDRESS_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestInspectionACFP, T> g) {
        return obj -> g.apply((RequestInspectionACFP) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestInspectionACFP> {
        /**
         * <p>
         * The payload type for your account creation endpoint, either JSON or form encoded.
         * </p>
         * 
         * @param payloadType
         *        The payload type for your account creation endpoint, either JSON or form encoded.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder payloadType(String payloadType);

        /**
         * <p>
         * The payload type for your account creation endpoint, either JSON or form encoded.
         * </p>
         * 
         * @param payloadType
         *        The payload type for your account creation endpoint, either JSON or form encoded.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder payloadType(PayloadType payloadType);

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's username.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field
         * specification is <code>/form/username</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>username1</code>, the username field
         * specification is <code>username1</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param usernameField
         *        The name of the field in the request payload that contains your customer's username. </p>
         *        <p>
         *        How you specify this depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON
         *        Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the
         *        username field specification is <code>/form/username</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with the input element named <code>username1</code>, the username field
         *        specification is <code>username1</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameField(UsernameField usernameField);

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's username.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field
         * specification is <code>/form/username</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>username1</code>, the username field
         * specification is <code>username1</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link UsernameField.Builder} avoiding the need
         * to create one manually via {@link UsernameField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsernameField.Builder#build()} is called immediately and its
         * result is passed to {@link #usernameField(UsernameField)}.
         * 
         * @param usernameField
         *        a consumer that will call methods on {@link UsernameField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usernameField(UsernameField)
         */
        default Builder usernameField(Consumer<UsernameField.Builder> usernameField) {
            return usernameField(UsernameField.builder().applyMutation(usernameField).build());
        }

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's password.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field
         * specification is <code>/form/password</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>password1</code>, the password field
         * specification is <code>password1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param passwordField
         *        The name of the field in the request payload that contains your customer's password. </p>
         *        <p>
         *        How you specify this depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON
         *        Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the
         *        password field specification is <code>/form/password</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with the input element named <code>password1</code>, the password field
         *        specification is <code>password1</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordField(PasswordField passwordField);

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's password.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field
         * specification is <code>/form/password</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>password1</code>, the password field
         * specification is <code>password1</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link PasswordField.Builder} avoiding the need
         * to create one manually via {@link PasswordField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PasswordField.Builder#build()} is called immediately and its
         * result is passed to {@link #passwordField(PasswordField)}.
         * 
         * @param passwordField
         *        a consumer that will call methods on {@link PasswordField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordField(PasswordField)
         */
        default Builder passwordField(Consumer<PasswordField.Builder> passwordField) {
            return passwordField(PasswordField.builder().applyMutation(passwordField).build());
        }

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's email.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code>, the email field
         * specification is <code>/form/email</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>email1</code>, the email field specification
         * is <code>email1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param emailField
         *        The name of the field in the request payload that contains your customer's email. </p>
         *        <p>
         *        How you specify this depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON
         *        Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code>, the email field
         *        specification is <code>/form/email</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with the input element named <code>email1</code>, the email field
         *        specification is <code>email1</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailField(EmailField emailField);

        /**
         * <p>
         * The name of the field in the request payload that contains your customer's email.
         * </p>
         * <p>
         * How you specify this depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer
         * syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code>, the email field
         * specification is <code>/form/email</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with the input element named <code>email1</code>, the email field specification
         * is <code>email1</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link EmailField.Builder} avoiding the need to
         * create one manually via {@link EmailField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailField.Builder#build()} is called immediately and its result
         * is passed to {@link #emailField(EmailField)}.
         * 
         * @param emailField
         *        a consumer that will call methods on {@link EmailField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailField(EmailField)
         */
        default Builder emailField(Consumer<EmailField.Builder> emailField) {
            return emailField(EmailField.builder().applyMutation(emailField).build());
        }

        /**
         * <p>
         * The names of the fields in the request payload that contain your customer's primary phone number.
         * </p>
         * <p>
         * Order the phone number fields in the array exactly as they are ordered in the request payload.
         * </p>
         * <p>
         * How you specify the phone number fields depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
         * Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload
         * <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>
         * , the phone number field identifiers are <code>/form/primaryphoneline1</code>,
         * <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryphoneline1</code>,
         * <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers are
         * <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param phoneNumberFields
         *        The names of the fields in the request payload that contain your customer's primary phone number. </p>
         *        <p>
         *        Order the phone number fields in the array exactly as they are ordered in the request payload.
         *        </p>
         *        <p>
         *        How you specify the phone number fields depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the
         *        JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload
         *        <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>
         *        , the phone number field identifiers are <code>/form/primaryphoneline1</code>,
         *        <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with input elements named <code>primaryphoneline1</code>,
         *        <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers
         *        are <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>
         *        .
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberFields(Collection<PhoneNumberField> phoneNumberFields);

        /**
         * <p>
         * The names of the fields in the request payload that contain your customer's primary phone number.
         * </p>
         * <p>
         * Order the phone number fields in the array exactly as they are ordered in the request payload.
         * </p>
         * <p>
         * How you specify the phone number fields depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
         * Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload
         * <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>
         * , the phone number field identifiers are <code>/form/primaryphoneline1</code>,
         * <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryphoneline1</code>,
         * <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers are
         * <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param phoneNumberFields
         *        The names of the fields in the request payload that contain your customer's primary phone number. </p>
         *        <p>
         *        Order the phone number fields in the array exactly as they are ordered in the request payload.
         *        </p>
         *        <p>
         *        How you specify the phone number fields depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the
         *        JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload
         *        <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>
         *        , the phone number field identifiers are <code>/form/primaryphoneline1</code>,
         *        <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with input elements named <code>primaryphoneline1</code>,
         *        <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers
         *        are <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>
         *        .
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberFields(PhoneNumberField... phoneNumberFields);

        /**
         * <p>
         * The names of the fields in the request payload that contain your customer's primary phone number.
         * </p>
         * <p>
         * Order the phone number fields in the array exactly as they are ordered in the request payload.
         * </p>
         * <p>
         * How you specify the phone number fields depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
         * Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload
         * <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>
         * , the phone number field identifiers are <code>/form/primaryphoneline1</code>,
         * <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryphoneline1</code>,
         * <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers are
         * <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.PhoneNumberField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.PhoneNumberField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.PhoneNumberField.Builder#build()} is called immediately
         * and its result is passed to {@link #phoneNumberFields(List<PhoneNumberField>)}.
         * 
         * @param phoneNumberFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.PhoneNumberField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumberFields(java.util.Collection<PhoneNumberField>)
         */
        Builder phoneNumberFields(Consumer<PhoneNumberField.Builder>... phoneNumberFields);

        /**
         * <p>
         * The names of the fields in the request payload that contain your customer's primary physical address.
         * </p>
         * <p>
         * Order the address fields in the array exactly as they are ordered in the request payload.
         * </p>
         * <p>
         * How you specify the address fields depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
         * Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload
         * <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>
         * , the address field idenfiers are <code>/form/primaryaddressline1</code>,
         * <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryaddressline1</code>,
         * <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers are
         * <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param addressFields
         *        The names of the fields in the request payload that contain your customer's primary physical address.
         *        </p>
         *        <p>
         *        Order the address fields in the array exactly as they are ordered in the request payload.
         *        </p>
         *        <p>
         *        How you specify the address fields depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the
         *        JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload
         *        <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>
         *        , the address field idenfiers are <code>/form/primaryaddressline1</code>,
         *        <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with input elements named <code>primaryaddressline1</code>,
         *        <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers
         *        are <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and
         *        <code>primaryaddressline3</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressFields(Collection<AddressField> addressFields);

        /**
         * <p>
         * The names of the fields in the request payload that contain your customer's primary physical address.
         * </p>
         * <p>
         * Order the address fields in the array exactly as they are ordered in the request payload.
         * </p>
         * <p>
         * How you specify the address fields depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
         * Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload
         * <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>
         * , the address field idenfiers are <code>/form/primaryaddressline1</code>,
         * <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryaddressline1</code>,
         * <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers are
         * <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param addressFields
         *        The names of the fields in the request payload that contain your customer's primary physical address.
         *        </p>
         *        <p>
         *        Order the address fields in the array exactly as they are ordered in the request payload.
         *        </p>
         *        <p>
         *        How you specify the address fields depends on the request inspection payload type.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the
         *        JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         *        href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         *        </p>
         *        <p>
         *        For example, for the JSON payload
         *        <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>
         *        , the address field idenfiers are <code>/form/primaryaddressline1</code>,
         *        <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For form encoded payload types, use the HTML form names.
         *        </p>
         *        <p>
         *        For example, for an HTML form with input elements named <code>primaryaddressline1</code>,
         *        <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers
         *        are <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and
         *        <code>primaryaddressline3</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressFields(AddressField... addressFields);

        /**
         * <p>
         * The names of the fields in the request payload that contain your customer's primary physical address.
         * </p>
         * <p>
         * Order the address fields in the array exactly as they are ordered in the request payload.
         * </p>
         * <p>
         * How you specify the address fields depends on the request inspection payload type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON
         * Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a
         * href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>.
         * </p>
         * <p>
         * For example, for the JSON payload
         * <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>
         * , the address field idenfiers are <code>/form/primaryaddressline1</code>,
         * <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For form encoded payload types, use the HTML form names.
         * </p>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryaddressline1</code>,
         * <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers are
         * <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.AddressField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.AddressField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.AddressField.Builder#build()} is called immediately and
         * its result is passed to {@link #addressFields(List<AddressField>)}.
         * 
         * @param addressFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.AddressField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressFields(java.util.Collection<AddressField>)
         */
        Builder addressFields(Consumer<AddressField.Builder>... addressFields);
    }

    static final class BuilderImpl implements Builder {
        private String payloadType;

        private UsernameField usernameField;

        private PasswordField passwordField;

        private EmailField emailField;

        private List<PhoneNumberField> phoneNumberFields = DefaultSdkAutoConstructList.getInstance();

        private List<AddressField> addressFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestInspectionACFP model) {
            payloadType(model.payloadType);
            usernameField(model.usernameField);
            passwordField(model.passwordField);
            emailField(model.emailField);
            phoneNumberFields(model.phoneNumberFields);
            addressFields(model.addressFields);
        }

        public final String getPayloadType() {
            return payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(PayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final UsernameField.Builder getUsernameField() {
            return usernameField != null ? usernameField.toBuilder() : null;
        }

        public final void setUsernameField(UsernameField.BuilderImpl usernameField) {
            this.usernameField = usernameField != null ? usernameField.build() : null;
        }

        @Override
        public final Builder usernameField(UsernameField usernameField) {
            this.usernameField = usernameField;
            return this;
        }

        public final PasswordField.Builder getPasswordField() {
            return passwordField != null ? passwordField.toBuilder() : null;
        }

        public final void setPasswordField(PasswordField.BuilderImpl passwordField) {
            this.passwordField = passwordField != null ? passwordField.build() : null;
        }

        @Override
        public final Builder passwordField(PasswordField passwordField) {
            this.passwordField = passwordField;
            return this;
        }

        public final EmailField.Builder getEmailField() {
            return emailField != null ? emailField.toBuilder() : null;
        }

        public final void setEmailField(EmailField.BuilderImpl emailField) {
            this.emailField = emailField != null ? emailField.build() : null;
        }

        @Override
        public final Builder emailField(EmailField emailField) {
            this.emailField = emailField;
            return this;
        }

        public final List<PhoneNumberField.Builder> getPhoneNumberFields() {
            List<PhoneNumberField.Builder> result = PhoneNumberFieldsCopier.copyToBuilder(this.phoneNumberFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumberFields(Collection<PhoneNumberField.BuilderImpl> phoneNumberFields) {
            this.phoneNumberFields = PhoneNumberFieldsCopier.copyFromBuilder(phoneNumberFields);
        }

        @Override
        public final Builder phoneNumberFields(Collection<PhoneNumberField> phoneNumberFields) {
            this.phoneNumberFields = PhoneNumberFieldsCopier.copy(phoneNumberFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberFields(PhoneNumberField... phoneNumberFields) {
            phoneNumberFields(Arrays.asList(phoneNumberFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberFields(Consumer<PhoneNumberField.Builder>... phoneNumberFields) {
            phoneNumberFields(Stream.of(phoneNumberFields).map(c -> PhoneNumberField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AddressField.Builder> getAddressFields() {
            List<AddressField.Builder> result = AddressFieldsCopier.copyToBuilder(this.addressFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressFields(Collection<AddressField.BuilderImpl> addressFields) {
            this.addressFields = AddressFieldsCopier.copyFromBuilder(addressFields);
        }

        @Override
        public final Builder addressFields(Collection<AddressField> addressFields) {
            this.addressFields = AddressFieldsCopier.copy(addressFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressFields(AddressField... addressFields) {
            addressFields(Arrays.asList(addressFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressFields(Consumer<AddressField.Builder>... addressFields) {
            addressFields(Stream.of(addressFields).map(c -> AddressField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RequestInspectionACFP build() {
            return new RequestInspectionACFP(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
