/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures inspection of the response body. WAF can inspect the first 65,536 bytes (64 KB) of the response body. This
 * is part of the <code>ResponseInspection</code> configuration for <code>AWSManagedRulesATPRuleSet</code> and
 * <code>AWSManagedRulesACFPRuleSet</code>.
 * </p>
 * <note>
 * <p>
 * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseInspectionBodyContains implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseInspectionBodyContains.Builder, ResponseInspectionBodyContains> {
    private static final SdkField<List<String>> SUCCESS_STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SuccessStrings")
            .getter(getter(ResponseInspectionBodyContains::successStrings))
            .setter(setter(Builder::successStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FAILURE_STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FailureStrings")
            .getter(getter(ResponseInspectionBodyContains::failureStrings))
            .setter(setter(Builder::failureStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_STRINGS_FIELD,
            FAILURE_STRINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> successStrings;

    private final List<String> failureStrings;

    private ResponseInspectionBodyContains(BuilderImpl builder) {
        this.successStrings = builder.successStrings;
        this.failureStrings = builder.failureStrings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessStrings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessStrings() {
        return successStrings != null && !(successStrings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Strings in the body of the response that indicate a successful login or account creation attempt. To be counted
     * as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must
     * be unique among the success and failure strings.
     * </p>
     * <p>
     * JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and
     * <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessStrings} method.
     * </p>
     * 
     * @return Strings in the body of the response that indicate a successful login or account creation attempt. To be
     *         counted as a success, the string can be anywhere in the body and must be an exact match, including case.
     *         Each string must be unique among the success and failure strings. </p>
     *         <p>
     *         JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and
     *         <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
     */
    public final List<String> successStrings() {
        return successStrings;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureStrings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureStrings() {
        return failureStrings != null && !(failureStrings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Strings in the body of the response that indicate a failed login or account creation attempt. To be counted as a
     * failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be
     * unique among the success and failure strings.
     * </p>
     * <p>
     * JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureStrings} method.
     * </p>
     * 
     * @return Strings in the body of the response that indicate a failed login or account creation attempt. To be
     *         counted as a failure, the string can be anywhere in the body and must be an exact match, including case.
     *         Each string must be unique among the success and failure strings. </p>
     *         <p>
     *         JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
     */
    public final List<String> failureStrings() {
        return failureStrings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessStrings() ? successStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureStrings() ? failureStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseInspectionBodyContains)) {
            return false;
        }
        ResponseInspectionBodyContains other = (ResponseInspectionBodyContains) obj;
        return hasSuccessStrings() == other.hasSuccessStrings() && Objects.equals(successStrings(), other.successStrings())
                && hasFailureStrings() == other.hasFailureStrings() && Objects.equals(failureStrings(), other.failureStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseInspectionBodyContains")
                .add("SuccessStrings", hasSuccessStrings() ? successStrings() : null)
                .add("FailureStrings", hasFailureStrings() ? failureStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessStrings":
            return Optional.ofNullable(clazz.cast(successStrings()));
        case "FailureStrings":
            return Optional.ofNullable(clazz.cast(failureStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuccessStrings", SUCCESS_STRINGS_FIELD);
        map.put("FailureStrings", FAILURE_STRINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseInspectionBodyContains, T> g) {
        return obj -> g.apply((ResponseInspectionBodyContains) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseInspectionBodyContains> {
        /**
         * <p>
         * Strings in the body of the response that indicate a successful login or account creation attempt. To be
         * counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each
         * string must be unique among the success and failure strings.
         * </p>
         * <p>
         * JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and
         * <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
         * </p>
         * 
         * @param successStrings
         *        Strings in the body of the response that indicate a successful login or account creation attempt. To
         *        be counted as a success, the string can be anywhere in the body and must be an exact match, including
         *        case. Each string must be unique among the success and failure strings. </p>
         *        <p>
         *        JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and
         *        <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successStrings(Collection<String> successStrings);

        /**
         * <p>
         * Strings in the body of the response that indicate a successful login or account creation attempt. To be
         * counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each
         * string must be unique among the success and failure strings.
         * </p>
         * <p>
         * JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and
         * <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
         * </p>
         * 
         * @param successStrings
         *        Strings in the body of the response that indicate a successful login or account creation attempt. To
         *        be counted as a success, the string can be anywhere in the body and must be an exact match, including
         *        case. Each string must be unique among the success and failure strings. </p>
         *        <p>
         *        JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and
         *        <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successStrings(String... successStrings);

        /**
         * <p>
         * Strings in the body of the response that indicate a failed login or account creation attempt. To be counted
         * as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string
         * must be unique among the success and failure strings.
         * </p>
         * <p>
         * JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
         * </p>
         * 
         * @param failureStrings
         *        Strings in the body of the response that indicate a failed login or account creation attempt. To be
         *        counted as a failure, the string can be anywhere in the body and must be an exact match, including
         *        case. Each string must be unique among the success and failure strings. </p>
         *        <p>
         *        JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureStrings(Collection<String> failureStrings);

        /**
         * <p>
         * Strings in the body of the response that indicate a failed login or account creation attempt. To be counted
         * as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string
         * must be unique among the success and failure strings.
         * </p>
         * <p>
         * JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
         * </p>
         * 
         * @param failureStrings
         *        Strings in the body of the response that indicate a failed login or account creation attempt. To be
         *        counted as a failure, the string can be anywhere in the body and must be an exact match, including
         *        case. Each string must be unique among the success and failure strings. </p>
         *        <p>
         *        JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureStrings(String... failureStrings);
    }

    static final class BuilderImpl implements Builder {
        private List<String> successStrings = DefaultSdkAutoConstructList.getInstance();

        private List<String> failureStrings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseInspectionBodyContains model) {
            successStrings(model.successStrings);
            failureStrings(model.failureStrings);
        }

        public final Collection<String> getSuccessStrings() {
            if (successStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return successStrings;
        }

        public final void setSuccessStrings(Collection<String> successStrings) {
            this.successStrings = ResponseInspectionBodyContainsSuccessStringsCopier.copy(successStrings);
        }

        @Override
        public final Builder successStrings(Collection<String> successStrings) {
            this.successStrings = ResponseInspectionBodyContainsSuccessStringsCopier.copy(successStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successStrings(String... successStrings) {
            successStrings(Arrays.asList(successStrings));
            return this;
        }

        public final Collection<String> getFailureStrings() {
            if (failureStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return failureStrings;
        }

        public final void setFailureStrings(Collection<String> failureStrings) {
            this.failureStrings = ResponseInspectionBodyContainsFailureStringsCopier.copy(failureStrings);
        }

        @Override
        public final Builder failureStrings(Collection<String> failureStrings) {
            this.failureStrings = ResponseInspectionBodyContainsFailureStringsCopier.copy(failureStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureStrings(String... failureStrings) {
            failureStrings(Arrays.asList(failureStrings));
            return this;
        }

        @Override
        public ResponseInspectionBodyContains build() {
            return new ResponseInspectionBodyContains(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
