/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebAclRequest extends Wafv2Request implements
        ToCopyableBuilder<UpdateWebAclRequest.Builder, UpdateWebAclRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateWebAclRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(UpdateWebAclRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateWebAclRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<DefaultAction> DEFAULT_ACTION_FIELD = SdkField
            .<DefaultAction> builder(MarshallingType.SDK_POJO).memberName("DefaultAction")
            .getter(getter(UpdateWebAclRequest::defaultAction)).setter(setter(Builder::defaultAction))
            .constructor(DefaultAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWebAclRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(UpdateWebAclRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VisibilityConfig> VISIBILITY_CONFIG_FIELD = SdkField
            .<VisibilityConfig> builder(MarshallingType.SDK_POJO).memberName("VisibilityConfig")
            .getter(getter(UpdateWebAclRequest::visibilityConfig)).setter(setter(Builder::visibilityConfig))
            .constructor(VisibilityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()).build();

    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockToken").getter(getter(UpdateWebAclRequest::lockToken)).setter(setter(Builder::lockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()).build();

    private static final SdkField<Map<String, CustomResponseBody>> CUSTOM_RESPONSE_BODIES_FIELD = SdkField
            .<Map<String, CustomResponseBody>> builder(MarshallingType.MAP)
            .memberName("CustomResponseBodies")
            .getter(getter(UpdateWebAclRequest::customResponseBodies))
            .setter(setter(Builder::customResponseBodies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponseBodies").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CustomResponseBody> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomResponseBody::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<CaptchaConfig> CAPTCHA_CONFIG_FIELD = SdkField
            .<CaptchaConfig> builder(MarshallingType.SDK_POJO).memberName("CaptchaConfig")
            .getter(getter(UpdateWebAclRequest::captchaConfig)).setter(setter(Builder::captchaConfig))
            .constructor(CaptchaConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptchaConfig").build()).build();

    private static final SdkField<ChallengeConfig> CHALLENGE_CONFIG_FIELD = SdkField
            .<ChallengeConfig> builder(MarshallingType.SDK_POJO).memberName("ChallengeConfig")
            .getter(getter(UpdateWebAclRequest::challengeConfig)).setter(setter(Builder::challengeConfig))
            .constructor(ChallengeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeConfig").build()).build();

    private static final SdkField<List<String>> TOKEN_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TokenDomains")
            .getter(getter(UpdateWebAclRequest::tokenDomains))
            .setter(setter(Builder::tokenDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AssociationConfig> ASSOCIATION_CONFIG_FIELD = SdkField
            .<AssociationConfig> builder(MarshallingType.SDK_POJO).memberName("AssociationConfig")
            .getter(getter(UpdateWebAclRequest::associationConfig)).setter(setter(Builder::associationConfig))
            .constructor(AssociationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD,
            ID_FIELD, DEFAULT_ACTION_FIELD, DESCRIPTION_FIELD, RULES_FIELD, VISIBILITY_CONFIG_FIELD, LOCK_TOKEN_FIELD,
            CUSTOM_RESPONSE_BODIES_FIELD, CAPTCHA_CONFIG_FIELD, CHALLENGE_CONFIG_FIELD, TOKEN_DOMAINS_FIELD,
            ASSOCIATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String scope;

    private final String id;

    private final DefaultAction defaultAction;

    private final String description;

    private final List<Rule> rules;

    private final VisibilityConfig visibilityConfig;

    private final String lockToken;

    private final Map<String, CustomResponseBody> customResponseBodies;

    private final CaptchaConfig captchaConfig;

    private final ChallengeConfig challengeConfig;

    private final List<String> tokenDomains;

    private final AssociationConfig associationConfig;

    private UpdateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.id = builder.id;
        this.defaultAction = builder.defaultAction;
        this.description = builder.description;
        this.rules = builder.rules;
        this.visibilityConfig = builder.visibilityConfig;
        this.lockToken = builder.lockToken;
        this.customResponseBodies = builder.customResponseBodies;
        this.captchaConfig = builder.captchaConfig;
        this.challengeConfig = builder.challengeConfig;
        this.tokenDomains = builder.tokenDomains;
        this.associationConfig = builder.associationConfig;
    }

    /**
     * <p>
     * The name of the web ACL. You cannot change the name of a web ACL after you create it.
     * </p>
     * 
     * @return The name of the web ACL. You cannot change the name of a web ACL after you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an
     * Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
     *         API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access
     *         instance. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an
     * Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
     *         API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access
     *         instance. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You
     * provide it to operations like update and delete.
     * </p>
     * 
     * @return The unique identifier for the web ACL. This ID is returned in the responses to create and list commands.
     *         You provide it to operations like update and delete.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
     * </p>
     * 
     * @return The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
     */
    public final DefaultAction defaultAction() {
        return defaultAction;
    }

    /**
     * <p>
     * A description of the web ACL that helps with identification.
     * </p>
     * 
     * @return A description of the web ACL that helps with identification.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one
     * top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles
     * them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes
     *         one top-level statement that WAF uses to identify matching web requests, and parameters that govern how
     *         WAF handles them.
     */
    public final List<Rule> rules() {
        return rules;
    }

    /**
     * <p>
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * </p>
     * 
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public final VisibilityConfig visibilityConfig() {
        return visibilityConfig;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String lockToken() {
        return lockToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomResponseBodies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomResponseBodies() {
        return customResponseBodies != null && !(customResponseBodies instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a
     * custom response to the web request. You define these for the web ACL, and then use them in the rules and default
     * actions that you define in the web ACL.
     * </p>
     * <p>
     * For information about customizing web requests and responses, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
     * requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomResponseBodies} method.
     * </p>
     * 
     * @return A map of custom response keys and content bodies. When you create a rule with a block action, you can
     *         send a custom response to the web request. You define these for the web ACL, and then use them in the
     *         rules and default actions that you define in the web ACL. </p>
     *         <p>
     *         For information about customizing web requests and responses, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing
     *         web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about the limits on count and size for custom request and response settings, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
     *         Developer Guide</i>.
     */
    public final Map<String, CustomResponseBody> customResponseBodies() {
        return customResponseBodies;
    }

    /**
     * <p>
     * Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own
     * <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for
     * <code>CaptchaConfig</code>.
     * </p>
     * 
     * @return Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own
     *         <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for
     *         <code>CaptchaConfig</code>.
     */
    public final CaptchaConfig captchaConfig() {
        return captchaConfig;
    }

    /**
     * <p>
     * Specifies how WAF should handle challenge evaluations for rules that don't have their own
     * <code>ChallengeConfig</code> settings. If you don't specify this, WAF uses its default settings for
     * <code>ChallengeConfig</code>.
     * </p>
     * 
     * @return Specifies how WAF should handle challenge evaluations for rules that don't have their own
     *         <code>ChallengeConfig</code> settings. If you don't specify this, WAF uses its default settings for
     *         <code>ChallengeConfig</code>.
     */
    public final ChallengeConfig challengeConfig() {
        return challengeConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the TokenDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTokenDomains() {
        return tokenDomains != null && !(tokenDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across
     * multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource
     * that the web ACL is protecting. If you don't specify a list of token domains, WAF accepts tokens only for the
     * domain of the protected resource. With a token domain list, WAF accepts the resource's host domain plus all
     * domains in the token domain list, including their prefixed subdomains.
     * </p>
     * <p>
     * Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code>
     * </p>
     * <p>
     * Public suffixes aren't allowed. For example, you can't use <code>gov.au</code> or <code>co.uk</code> as token
     * domains.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTokenDomains} method.
     * </p>
     * 
     * @return Specifies the domains that WAF should accept in a web request token. This enables the use of tokens
     *         across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web
     *         Services resource that the web ACL is protecting. If you don't specify a list of token domains, WAF
     *         accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the
     *         resource's host domain plus all domains in the token domain list, including their prefixed
     *         subdomains.</p>
     *         <p>
     *         Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code>
     *         </p>
     *         <p>
     *         Public suffixes aren't allowed. For example, you can't use <code>gov.au</code> or <code>co.uk</code> as
     *         token domains.
     */
    public final List<String> tokenDomains() {
        return tokenDomains;
    }

    /**
     * <p>
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     * </p>
     * <p>
     * Use this to customize the maximum size of the request body that your protected resources forward to WAF for
     * inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified
     * Access resources. The default setting is 16 KB (16,384 bytes).
     * </p>
     * <note>
     * <p>
     * You are charged additional fees when your protected resources forward body sizes that are larger than the
     * default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     * </p>
     * </note>
     * <p>
     * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
     * </p>
     * 
     * @return Specifies custom configurations for the associations between the web ACL and protected resources. </p>
     *         <p>
     *         Use this to customize the maximum size of the request body that your protected resources forward to WAF
     *         for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner,
     *         or Verified Access resources. The default setting is 16 KB (16,384 bytes).
     *         </p>
     *         <note>
     *         <p>
     *         You are charged additional fees when your protected resources forward body sizes that are larger than the
     *         default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     *         </p>
     *         </note>
     *         <p>
     *         For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
     */
    public final AssociationConfig associationConfig() {
        return associationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visibilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(lockToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomResponseBodies() ? customResponseBodies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(captchaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(challengeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenDomains() ? tokenDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(associationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAclRequest)) {
            return false;
        }
        UpdateWebAclRequest other = (UpdateWebAclRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(defaultAction(), other.defaultAction())
                && Objects.equals(description(), other.description()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && Objects.equals(visibilityConfig(), other.visibilityConfig())
                && Objects.equals(lockToken(), other.lockToken()) && hasCustomResponseBodies() == other.hasCustomResponseBodies()
                && Objects.equals(customResponseBodies(), other.customResponseBodies())
                && Objects.equals(captchaConfig(), other.captchaConfig())
                && Objects.equals(challengeConfig(), other.challengeConfig()) && hasTokenDomains() == other.hasTokenDomains()
                && Objects.equals(tokenDomains(), other.tokenDomains())
                && Objects.equals(associationConfig(), other.associationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWebAclRequest").add("Name", name()).add("Scope", scopeAsString()).add("Id", id())
                .add("DefaultAction", defaultAction()).add("Description", description())
                .add("Rules", hasRules() ? rules() : null).add("VisibilityConfig", visibilityConfig())
                .add("LockToken", lockToken())
                .add("CustomResponseBodies", hasCustomResponseBodies() ? customResponseBodies() : null)
                .add("CaptchaConfig", captchaConfig()).add("ChallengeConfig", challengeConfig())
                .add("TokenDomains", hasTokenDomains() ? tokenDomains() : null).add("AssociationConfig", associationConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultAction()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "VisibilityConfig":
            return Optional.ofNullable(clazz.cast(visibilityConfig()));
        case "LockToken":
            return Optional.ofNullable(clazz.cast(lockToken()));
        case "CustomResponseBodies":
            return Optional.ofNullable(clazz.cast(customResponseBodies()));
        case "CaptchaConfig":
            return Optional.ofNullable(clazz.cast(captchaConfig()));
        case "ChallengeConfig":
            return Optional.ofNullable(clazz.cast(challengeConfig()));
        case "TokenDomains":
            return Optional.ofNullable(clazz.cast(tokenDomains()));
        case "AssociationConfig":
            return Optional.ofNullable(clazz.cast(associationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("VisibilityConfig", VISIBILITY_CONFIG_FIELD);
        map.put("LockToken", LOCK_TOKEN_FIELD);
        map.put("CustomResponseBodies", CUSTOM_RESPONSE_BODIES_FIELD);
        map.put("CaptchaConfig", CAPTCHA_CONFIG_FIELD);
        map.put("ChallengeConfig", CHALLENGE_CONFIG_FIELD);
        map.put("TokenDomains", TOKEN_DOMAINS_FIELD);
        map.put("AssociationConfig", ASSOCIATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAclRequest, T> g) {
        return obj -> g.apply((UpdateWebAclRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWebAclRequest> {
        /**
         * <p>
         * The name of the web ACL. You cannot change the name of a web ACL after you create it.
         * </p>
         * 
         * @param name
         *        The name of the web ACL. You cannot change the name of a web ACL after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
         * API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A
         *        regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an
         *        AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services
         *        Verified Access instance. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL
         * API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A
         *        regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an
         *        AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services
         *        Verified Access instance. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You
         * provide it to operations like update and delete.
         * </p>
         * 
         * @param id
         *        The unique identifier for the web ACL. This ID is returned in the responses to create and list
         *        commands. You provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
         * </p>
         * 
         * @param defaultAction
         *        The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAction(DefaultAction defaultAction);

        /**
         * <p>
         * The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultAction.Builder} avoiding the need
         * to create one manually via {@link DefaultAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultAction.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultAction(DefaultAction)}.
         * 
         * @param defaultAction
         *        a consumer that will call methods on {@link DefaultAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAction(DefaultAction)
         */
        default Builder defaultAction(Consumer<DefaultAction.Builder> defaultAction) {
            return defaultAction(DefaultAction.builder().applyMutation(defaultAction).build());
        }

        /**
         * <p>
         * A description of the web ACL that helps with identification.
         * </p>
         * 
         * @param description
         *        A description of the web ACL that helps with identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one
         * top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF
         * handles them.
         * </p>
         * 
         * @param rules
         *        The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule
         *        includes one top-level statement that WAF uses to identify matching web requests, and parameters that
         *        govern how WAF handles them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one
         * top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF
         * handles them.
         * </p>
         * 
         * @param rules
         *        The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule
         *        includes one top-level statement that WAF uses to identify matching web requests, and parameters that
         *        govern how WAF handles them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one
         * top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF
         * handles them.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.Rule.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.wafv2.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.wafv2.model.Rule.Builder#build()}
         * is called immediately and its result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.wafv2.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * 
         * @param visibilityConfig
         *        Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityConfig(VisibilityConfig visibilityConfig);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisibilityConfig.Builder} avoiding the
         * need to create one manually via {@link VisibilityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisibilityConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #visibilityConfig(VisibilityConfig)}.
         * 
         * @param visibilityConfig
         *        a consumer that will call methods on {@link VisibilityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibilityConfig(VisibilityConfig)
         */
        default Builder visibilityConfig(Consumer<VisibilityConfig.Builder> visibilityConfig) {
            return visibilityConfig(VisibilityConfig.builder().applyMutation(visibilityConfig).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param lockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockToken(String lockToken);

        /**
         * <p>
         * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a
         * custom response to the web request. You define these for the web ACL, and then use them in the rules and
         * default actions that you define in the web ACL.
         * </p>
         * <p>
         * For information about customizing web requests and responses, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
         * requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
         * Developer Guide</i>.
         * </p>
         * 
         * @param customResponseBodies
         *        A map of custom response keys and content bodies. When you create a rule with a block action, you can
         *        send a custom response to the web request. You define these for the web ACL, and then use them in the
         *        rules and default actions that you define in the web ACL. </p>
         *        <p>
         *        For information about customizing web requests and responses, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html"
         *        >Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>.
         *        </p>
         *        <p>
         *        For information about the limits on count and size for custom request and response settings, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customResponseBodies(Map<String, CustomResponseBody> customResponseBodies);

        /**
         * <p>
         * Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own
         * <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for
         * <code>CaptchaConfig</code>.
         * </p>
         * 
         * @param captchaConfig
         *        Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own
         *        <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for
         *        <code>CaptchaConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captchaConfig(CaptchaConfig captchaConfig);

        /**
         * <p>
         * Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own
         * <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for
         * <code>CaptchaConfig</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaptchaConfig.Builder} avoiding the need
         * to create one manually via {@link CaptchaConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptchaConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #captchaConfig(CaptchaConfig)}.
         * 
         * @param captchaConfig
         *        a consumer that will call methods on {@link CaptchaConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captchaConfig(CaptchaConfig)
         */
        default Builder captchaConfig(Consumer<CaptchaConfig.Builder> captchaConfig) {
            return captchaConfig(CaptchaConfig.builder().applyMutation(captchaConfig).build());
        }

        /**
         * <p>
         * Specifies how WAF should handle challenge evaluations for rules that don't have their own
         * <code>ChallengeConfig</code> settings. If you don't specify this, WAF uses its default settings for
         * <code>ChallengeConfig</code>.
         * </p>
         * 
         * @param challengeConfig
         *        Specifies how WAF should handle challenge evaluations for rules that don't have their own
         *        <code>ChallengeConfig</code> settings. If you don't specify this, WAF uses its default settings for
         *        <code>ChallengeConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeConfig(ChallengeConfig challengeConfig);

        /**
         * <p>
         * Specifies how WAF should handle challenge evaluations for rules that don't have their own
         * <code>ChallengeConfig</code> settings. If you don't specify this, WAF uses its default settings for
         * <code>ChallengeConfig</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChallengeConfig.Builder} avoiding the
         * need to create one manually via {@link ChallengeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChallengeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #challengeConfig(ChallengeConfig)}.
         * 
         * @param challengeConfig
         *        a consumer that will call methods on {@link ChallengeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challengeConfig(ChallengeConfig)
         */
        default Builder challengeConfig(Consumer<ChallengeConfig.Builder> challengeConfig) {
            return challengeConfig(ChallengeConfig.builder().applyMutation(challengeConfig).build());
        }

        /**
         * <p>
         * Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across
         * multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services
         * resource that the web ACL is protecting. If you don't specify a list of token domains, WAF accepts tokens
         * only for the domain of the protected resource. With a token domain list, WAF accepts the resource's host
         * domain plus all domains in the token domain list, including their prefixed subdomains.
         * </p>
         * <p>
         * Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code>
         * </p>
         * <p>
         * Public suffixes aren't allowed. For example, you can't use <code>gov.au</code> or <code>co.uk</code> as token
         * domains.
         * </p>
         * 
         * @param tokenDomains
         *        Specifies the domains that WAF should accept in a web request token. This enables the use of tokens
         *        across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web
         *        Services resource that the web ACL is protecting. If you don't specify a list of token domains, WAF
         *        accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts
         *        the resource's host domain plus all domains in the token domain list, including their prefixed
         *        subdomains.</p>
         *        <p>
         *        Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code>
         *        </p>
         *        <p>
         *        Public suffixes aren't allowed. For example, you can't use <code>gov.au</code> or <code>co.uk</code>
         *        as token domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenDomains(Collection<String> tokenDomains);

        /**
         * <p>
         * Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across
         * multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services
         * resource that the web ACL is protecting. If you don't specify a list of token domains, WAF accepts tokens
         * only for the domain of the protected resource. With a token domain list, WAF accepts the resource's host
         * domain plus all domains in the token domain list, including their prefixed subdomains.
         * </p>
         * <p>
         * Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code>
         * </p>
         * <p>
         * Public suffixes aren't allowed. For example, you can't use <code>gov.au</code> or <code>co.uk</code> as token
         * domains.
         * </p>
         * 
         * @param tokenDomains
         *        Specifies the domains that WAF should accept in a web request token. This enables the use of tokens
         *        across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web
         *        Services resource that the web ACL is protecting. If you don't specify a list of token domains, WAF
         *        accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts
         *        the resource's host domain plus all domains in the token domain list, including their prefixed
         *        subdomains.</p>
         *        <p>
         *        Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code>
         *        </p>
         *        <p>
         *        Public suffixes aren't allowed. For example, you can't use <code>gov.au</code> or <code>co.uk</code>
         *        as token domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenDomains(String... tokenDomains);

        /**
         * <p>
         * Specifies custom configurations for the associations between the web ACL and protected resources.
         * </p>
         * <p>
         * Use this to customize the maximum size of the request body that your protected resources forward to WAF for
         * inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or
         * Verified Access resources. The default setting is 16 KB (16,384 bytes).
         * </p>
         * <note>
         * <p>
         * You are charged additional fees when your protected resources forward body sizes that are larger than the
         * default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         * </p>
         * </note>
         * <p>
         * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         * </p>
         * 
         * @param associationConfig
         *        Specifies custom configurations for the associations between the web ACL and protected resources. </p>
         *        <p>
         *        Use this to customize the maximum size of the request body that your protected resources forward to
         *        WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App
         *        Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes).
         *        </p>
         *        <note>
         *        <p>
         *        You are charged additional fees when your protected resources forward body sizes that are larger than
         *        the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         *        </p>
         *        </note>
         *        <p>
         *        For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfig(AssociationConfig associationConfig);

        /**
         * <p>
         * Specifies custom configurations for the associations between the web ACL and protected resources.
         * </p>
         * <p>
         * Use this to customize the maximum size of the request body that your protected resources forward to WAF for
         * inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or
         * Verified Access resources. The default setting is 16 KB (16,384 bytes).
         * </p>
         * <note>
         * <p>
         * You are charged additional fees when your protected resources forward body sizes that are larger than the
         * default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         * </p>
         * </note>
         * <p>
         * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociationConfig.Builder} avoiding the
         * need to create one manually via {@link AssociationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #associationConfig(AssociationConfig)}.
         * 
         * @param associationConfig
         *        a consumer that will call methods on {@link AssociationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationConfig(AssociationConfig)
         */
        default Builder associationConfig(Consumer<AssociationConfig.Builder> associationConfig) {
            return associationConfig(AssociationConfig.builder().applyMutation(associationConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String name;

        private String scope;

        private String id;

        private DefaultAction defaultAction;

        private String description;

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private VisibilityConfig visibilityConfig;

        private String lockToken;

        private Map<String, CustomResponseBody> customResponseBodies = DefaultSdkAutoConstructMap.getInstance();

        private CaptchaConfig captchaConfig;

        private ChallengeConfig challengeConfig;

        private List<String> tokenDomains = DefaultSdkAutoConstructList.getInstance();

        private AssociationConfig associationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAclRequest model) {
            super(model);
            name(model.name);
            scope(model.scope);
            id(model.id);
            defaultAction(model.defaultAction);
            description(model.description);
            rules(model.rules);
            visibilityConfig(model.visibilityConfig);
            lockToken(model.lockToken);
            customResponseBodies(model.customResponseBodies);
            captchaConfig(model.captchaConfig);
            challengeConfig(model.challengeConfig);
            tokenDomains(model.tokenDomains);
            associationConfig(model.associationConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DefaultAction.Builder getDefaultAction() {
            return defaultAction != null ? defaultAction.toBuilder() : null;
        }

        public final void setDefaultAction(DefaultAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public final Builder defaultAction(DefaultAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisibilityConfig.Builder getVisibilityConfig() {
            return visibilityConfig != null ? visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(VisibilityConfig.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(VisibilityConfig visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public final String getLockToken() {
            return lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final Map<String, CustomResponseBody.Builder> getCustomResponseBodies() {
            Map<String, CustomResponseBody.Builder> result = CustomResponseBodiesCopier.copyToBuilder(this.customResponseBodies);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCustomResponseBodies(Map<String, CustomResponseBody.BuilderImpl> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copyFromBuilder(customResponseBodies);
        }

        @Override
        public final Builder customResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copy(customResponseBodies);
            return this;
        }

        public final CaptchaConfig.Builder getCaptchaConfig() {
            return captchaConfig != null ? captchaConfig.toBuilder() : null;
        }

        public final void setCaptchaConfig(CaptchaConfig.BuilderImpl captchaConfig) {
            this.captchaConfig = captchaConfig != null ? captchaConfig.build() : null;
        }

        @Override
        public final Builder captchaConfig(CaptchaConfig captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        public final ChallengeConfig.Builder getChallengeConfig() {
            return challengeConfig != null ? challengeConfig.toBuilder() : null;
        }

        public final void setChallengeConfig(ChallengeConfig.BuilderImpl challengeConfig) {
            this.challengeConfig = challengeConfig != null ? challengeConfig.build() : null;
        }

        @Override
        public final Builder challengeConfig(ChallengeConfig challengeConfig) {
            this.challengeConfig = challengeConfig;
            return this;
        }

        public final Collection<String> getTokenDomains() {
            if (tokenDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return tokenDomains;
        }

        public final void setTokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
        }

        @Override
        public final Builder tokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenDomains(String... tokenDomains) {
            tokenDomains(Arrays.asList(tokenDomains));
            return this;
        }

        public final AssociationConfig.Builder getAssociationConfig() {
            return associationConfig != null ? associationConfig.toBuilder() : null;
        }

        public final void setAssociationConfig(AssociationConfig.BuilderImpl associationConfig) {
            this.associationConfig = associationConfig != null ? associationConfig.build() : null;
        }

        @Override
        public final Builder associationConfig(AssociationConfig associationConfig) {
            this.associationConfig = associationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAclRequest build() {
            return new UpdateWebAclRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
