/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.Statement;
import software.amazon.awssdk.services.wafv2.model.StatementsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrStatement> {
    private static final SdkField<List<Statement>> STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statements").getter(OrStatement.getter(OrStatement::statements)).setter(OrStatement.setter(Builder::statements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrStatement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Statement> statements;

    private OrStatement(BuilderImpl builder) {
        this.statements = builder.statements;
    }

    public final boolean hasStatements() {
        return this.statements != null && !(this.statements instanceof SdkAutoConstructList);
    }

    public final List<Statement> statements() {
        return this.statements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatements() ? this.statements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrStatement)) {
            return false;
        }
        OrStatement other = (OrStatement)obj;
        return this.hasStatements() == other.hasStatements() && Objects.equals(this.statements(), other.statements());
    }

    public final String toString() {
        return ToString.builder((String)"OrStatement").add("Statements", this.hasStatements() ? this.statements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Statement>>> map = new HashMap<String, SdkField<List<Statement>>>();
        map.put("Statements", STATEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrStatement, T> g) {
        return obj -> g.apply((OrStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Statement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrStatement model) {
            this.statements(model.statements);
        }

        public final List<Statement.Builder> getStatements() {
            List<Statement.Builder> result = StatementsCopier.copyToBuilder(this.statements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatements(Collection<Statement.BuilderImpl> statements) {
            this.statements = StatementsCopier.copyFromBuilder(statements);
        }

        @Override
        public final Builder statements(Collection<Statement> statements) {
            this.statements = StatementsCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Statement ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<Statement.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (Statement)((Statement.Builder)Statement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OrStatement build() {
            return new OrStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrStatement> {
        public Builder statements(Collection<Statement> var1);

        public Builder statements(Statement ... var1);

        public Builder statements(Consumer<Statement.Builder> ... var1);
    }
}

