/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wafv2.model.AssociationConfig;
import software.amazon.awssdk.services.wafv2.model.CaptchaConfig;
import software.amazon.awssdk.services.wafv2.model.ChallengeConfig;
import software.amazon.awssdk.services.wafv2.model.CustomResponseBodiesCopier;
import software.amazon.awssdk.services.wafv2.model.CustomResponseBody;
import software.amazon.awssdk.services.wafv2.model.DataProtectionConfig;
import software.amazon.awssdk.services.wafv2.model.DefaultAction;
import software.amazon.awssdk.services.wafv2.model.Rule;
import software.amazon.awssdk.services.wafv2.model.RulesCopier;
import software.amazon.awssdk.services.wafv2.model.Scope;
import software.amazon.awssdk.services.wafv2.model.TokenDomainsCopier;
import software.amazon.awssdk.services.wafv2.model.VisibilityConfig;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWebAclRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, UpdateWebAclRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::name)).setter(UpdateWebAclRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::scopeAsString)).setter(UpdateWebAclRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::id)).setter(UpdateWebAclRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<DefaultAction> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultAction").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::defaultAction)).setter(UpdateWebAclRequest.setter(Builder::defaultAction)).constructor(DefaultAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::description)).setter(UpdateWebAclRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::rules)).setter(UpdateWebAclRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisibilityConfig> VISIBILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibilityConfig").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::visibilityConfig)).setter(UpdateWebAclRequest.setter(Builder::visibilityConfig)).constructor(VisibilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()}).build();
    private static final SdkField<DataProtectionConfig> DATA_PROTECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataProtectionConfig").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::dataProtectionConfig)).setter(UpdateWebAclRequest.setter(Builder::dataProtectionConfig)).constructor(DataProtectionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProtectionConfig").build()}).build();
    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockToken").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::lockToken)).setter(UpdateWebAclRequest.setter(Builder::lockToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()}).build();
    private static final SdkField<Map<String, CustomResponseBody>> CUSTOM_RESPONSE_BODIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomResponseBodies").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::customResponseBodies)).setter(UpdateWebAclRequest.setter(Builder::customResponseBodies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponseBodies").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomResponseBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<CaptchaConfig> CAPTCHA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CaptchaConfig").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::captchaConfig)).setter(UpdateWebAclRequest.setter(Builder::captchaConfig)).constructor(CaptchaConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptchaConfig").build()}).build();
    private static final SdkField<ChallengeConfig> CHALLENGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChallengeConfig").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::challengeConfig)).setter(UpdateWebAclRequest.setter(Builder::challengeConfig)).constructor(ChallengeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeConfig").build()}).build();
    private static final SdkField<List<String>> TOKEN_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenDomains").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::tokenDomains)).setter(UpdateWebAclRequest.setter(Builder::tokenDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssociationConfig> ASSOCIATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationConfig").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::associationConfig)).setter(UpdateWebAclRequest.setter(Builder::associationConfig)).constructor(AssociationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD, ID_FIELD, DEFAULT_ACTION_FIELD, DESCRIPTION_FIELD, RULES_FIELD, VISIBILITY_CONFIG_FIELD, DATA_PROTECTION_CONFIG_FIELD, LOCK_TOKEN_FIELD, CUSTOM_RESPONSE_BODIES_FIELD, CAPTCHA_CONFIG_FIELD, CHALLENGE_CONFIG_FIELD, TOKEN_DOMAINS_FIELD, ASSOCIATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWebAclRequest.memberNameToFieldInitializer();
    private final String name;
    private final String scope;
    private final String id;
    private final DefaultAction defaultAction;
    private final String description;
    private final List<Rule> rules;
    private final VisibilityConfig visibilityConfig;
    private final DataProtectionConfig dataProtectionConfig;
    private final String lockToken;
    private final Map<String, CustomResponseBody> customResponseBodies;
    private final CaptchaConfig captchaConfig;
    private final ChallengeConfig challengeConfig;
    private final List<String> tokenDomains;
    private final AssociationConfig associationConfig;

    private UpdateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.id = builder.id;
        this.defaultAction = builder.defaultAction;
        this.description = builder.description;
        this.rules = builder.rules;
        this.visibilityConfig = builder.visibilityConfig;
        this.dataProtectionConfig = builder.dataProtectionConfig;
        this.lockToken = builder.lockToken;
        this.customResponseBodies = builder.customResponseBodies;
        this.captchaConfig = builder.captchaConfig;
        this.challengeConfig = builder.challengeConfig;
        this.tokenDomains = builder.tokenDomains;
        this.associationConfig = builder.associationConfig;
    }

    public final String name() {
        return this.name;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String id() {
        return this.id;
    }

    public final DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final VisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public final DataProtectionConfig dataProtectionConfig() {
        return this.dataProtectionConfig;
    }

    public final String lockToken() {
        return this.lockToken;
    }

    public final boolean hasCustomResponseBodies() {
        return this.customResponseBodies != null && !(this.customResponseBodies instanceof SdkAutoConstructMap);
    }

    public final Map<String, CustomResponseBody> customResponseBodies() {
        return this.customResponseBodies;
    }

    public final CaptchaConfig captchaConfig() {
        return this.captchaConfig;
    }

    public final ChallengeConfig challengeConfig() {
        return this.challengeConfig;
    }

    public final boolean hasTokenDomains() {
        return this.tokenDomains != null && !(this.tokenDomains instanceof SdkAutoConstructList);
    }

    public final List<String> tokenDomains() {
        return this.tokenDomains;
    }

    public final AssociationConfig associationConfig() {
        return this.associationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProtectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomResponseBodies() ? this.customResponseBodies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.captchaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenDomains() ? this.tokenDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.associationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAclRequest)) {
            return false;
        }
        UpdateWebAclRequest other = (UpdateWebAclRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.defaultAction(), other.defaultAction()) && Objects.equals(this.description(), other.description()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.visibilityConfig(), other.visibilityConfig()) && Objects.equals(this.dataProtectionConfig(), other.dataProtectionConfig()) && Objects.equals(this.lockToken(), other.lockToken()) && this.hasCustomResponseBodies() == other.hasCustomResponseBodies() && Objects.equals(this.customResponseBodies(), other.customResponseBodies()) && Objects.equals(this.captchaConfig(), other.captchaConfig()) && Objects.equals(this.challengeConfig(), other.challengeConfig()) && this.hasTokenDomains() == other.hasTokenDomains() && Objects.equals(this.tokenDomains(), other.tokenDomains()) && Objects.equals(this.associationConfig(), other.associationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWebAclRequest").add("Name", (Object)this.name()).add("Scope", (Object)this.scopeAsString()).add("Id", (Object)this.id()).add("DefaultAction", (Object)this.defaultAction()).add("Description", (Object)this.description()).add("Rules", this.hasRules() ? this.rules() : null).add("VisibilityConfig", (Object)this.visibilityConfig()).add("DataProtectionConfig", (Object)this.dataProtectionConfig()).add("LockToken", (Object)this.lockToken()).add("CustomResponseBodies", this.hasCustomResponseBodies() ? this.customResponseBodies() : null).add("CaptchaConfig", (Object)this.captchaConfig()).add("ChallengeConfig", (Object)this.challengeConfig()).add("TokenDomains", this.hasTokenDomains() ? this.tokenDomains() : null).add("AssociationConfig", (Object)this.associationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultAction()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "VisibilityConfig": {
                return Optional.ofNullable(clazz.cast(this.visibilityConfig()));
            }
            case "DataProtectionConfig": {
                return Optional.ofNullable(clazz.cast(this.dataProtectionConfig()));
            }
            case "LockToken": {
                return Optional.ofNullable(clazz.cast(this.lockToken()));
            }
            case "CustomResponseBodies": {
                return Optional.ofNullable(clazz.cast(this.customResponseBodies()));
            }
            case "CaptchaConfig": {
                return Optional.ofNullable(clazz.cast(this.captchaConfig()));
            }
            case "ChallengeConfig": {
                return Optional.ofNullable(clazz.cast(this.challengeConfig()));
            }
            case "TokenDomains": {
                return Optional.ofNullable(clazz.cast(this.tokenDomains()));
            }
            case "AssociationConfig": {
                return Optional.ofNullable(clazz.cast(this.associationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("VisibilityConfig", VISIBILITY_CONFIG_FIELD);
        map.put("DataProtectionConfig", DATA_PROTECTION_CONFIG_FIELD);
        map.put("LockToken", LOCK_TOKEN_FIELD);
        map.put("CustomResponseBodies", CUSTOM_RESPONSE_BODIES_FIELD);
        map.put("CaptchaConfig", CAPTCHA_CONFIG_FIELD);
        map.put("ChallengeConfig", CHALLENGE_CONFIG_FIELD);
        map.put("TokenDomains", TOKEN_DOMAINS_FIELD);
        map.put("AssociationConfig", ASSOCIATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAclRequest, T> g) {
        return obj -> g.apply((UpdateWebAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String name;
        private String scope;
        private String id;
        private DefaultAction defaultAction;
        private String description;
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private VisibilityConfig visibilityConfig;
        private DataProtectionConfig dataProtectionConfig;
        private String lockToken;
        private Map<String, CustomResponseBody> customResponseBodies = DefaultSdkAutoConstructMap.getInstance();
        private CaptchaConfig captchaConfig;
        private ChallengeConfig challengeConfig;
        private List<String> tokenDomains = DefaultSdkAutoConstructList.getInstance();
        private AssociationConfig associationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAclRequest model) {
            super(model);
            this.name(model.name);
            this.scope(model.scope);
            this.id(model.id);
            this.defaultAction(model.defaultAction);
            this.description(model.description);
            this.rules(model.rules);
            this.visibilityConfig(model.visibilityConfig);
            this.dataProtectionConfig(model.dataProtectionConfig);
            this.lockToken(model.lockToken);
            this.customResponseBodies(model.customResponseBodies);
            this.captchaConfig(model.captchaConfig);
            this.challengeConfig(model.challengeConfig);
            this.tokenDomains(model.tokenDomains);
            this.associationConfig(model.associationConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DefaultAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        public final void setDefaultAction(DefaultAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public final Builder defaultAction(DefaultAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisibilityConfig.Builder getVisibilityConfig() {
            return this.visibilityConfig != null ? this.visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(VisibilityConfig.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(VisibilityConfig visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public final DataProtectionConfig.Builder getDataProtectionConfig() {
            return this.dataProtectionConfig != null ? this.dataProtectionConfig.toBuilder() : null;
        }

        public final void setDataProtectionConfig(DataProtectionConfig.BuilderImpl dataProtectionConfig) {
            this.dataProtectionConfig = dataProtectionConfig != null ? dataProtectionConfig.build() : null;
        }

        @Override
        public final Builder dataProtectionConfig(DataProtectionConfig dataProtectionConfig) {
            this.dataProtectionConfig = dataProtectionConfig;
            return this;
        }

        public final String getLockToken() {
            return this.lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final Map<String, CustomResponseBody.Builder> getCustomResponseBodies() {
            Map<String, CustomResponseBody.Builder> result = CustomResponseBodiesCopier.copyToBuilder(this.customResponseBodies);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCustomResponseBodies(Map<String, CustomResponseBody.BuilderImpl> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copyFromBuilder(customResponseBodies);
        }

        @Override
        public final Builder customResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copy(customResponseBodies);
            return this;
        }

        public final CaptchaConfig.Builder getCaptchaConfig() {
            return this.captchaConfig != null ? this.captchaConfig.toBuilder() : null;
        }

        public final void setCaptchaConfig(CaptchaConfig.BuilderImpl captchaConfig) {
            this.captchaConfig = captchaConfig != null ? captchaConfig.build() : null;
        }

        @Override
        public final Builder captchaConfig(CaptchaConfig captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        public final ChallengeConfig.Builder getChallengeConfig() {
            return this.challengeConfig != null ? this.challengeConfig.toBuilder() : null;
        }

        public final void setChallengeConfig(ChallengeConfig.BuilderImpl challengeConfig) {
            this.challengeConfig = challengeConfig != null ? challengeConfig.build() : null;
        }

        @Override
        public final Builder challengeConfig(ChallengeConfig challengeConfig) {
            this.challengeConfig = challengeConfig;
            return this;
        }

        public final Collection<String> getTokenDomains() {
            if (this.tokenDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenDomains;
        }

        public final void setTokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
        }

        @Override
        public final Builder tokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenDomains(String ... tokenDomains) {
            this.tokenDomains(Arrays.asList(tokenDomains));
            return this;
        }

        public final AssociationConfig.Builder getAssociationConfig() {
            return this.associationConfig != null ? this.associationConfig.toBuilder() : null;
        }

        public final void setAssociationConfig(AssociationConfig.BuilderImpl associationConfig) {
            this.associationConfig = associationConfig != null ? associationConfig.build() : null;
        }

        @Override
        public final Builder associationConfig(AssociationConfig associationConfig) {
            this.associationConfig = associationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAclRequest build() {
            return new UpdateWebAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWebAclRequest> {
        public Builder name(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder id(String var1);

        public Builder defaultAction(DefaultAction var1);

        default public Builder defaultAction(Consumer<DefaultAction.Builder> defaultAction) {
            return this.defaultAction((DefaultAction)((DefaultAction.Builder)DefaultAction.builder().applyMutation(defaultAction)).build());
        }

        public Builder description(String var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder visibilityConfig(VisibilityConfig var1);

        default public Builder visibilityConfig(Consumer<VisibilityConfig.Builder> visibilityConfig) {
            return this.visibilityConfig((VisibilityConfig)((VisibilityConfig.Builder)VisibilityConfig.builder().applyMutation(visibilityConfig)).build());
        }

        public Builder dataProtectionConfig(DataProtectionConfig var1);

        default public Builder dataProtectionConfig(Consumer<DataProtectionConfig.Builder> dataProtectionConfig) {
            return this.dataProtectionConfig((DataProtectionConfig)((DataProtectionConfig.Builder)DataProtectionConfig.builder().applyMutation(dataProtectionConfig)).build());
        }

        public Builder lockToken(String var1);

        public Builder customResponseBodies(Map<String, CustomResponseBody> var1);

        public Builder captchaConfig(CaptchaConfig var1);

        default public Builder captchaConfig(Consumer<CaptchaConfig.Builder> captchaConfig) {
            return this.captchaConfig((CaptchaConfig)((CaptchaConfig.Builder)CaptchaConfig.builder().applyMutation(captchaConfig)).build());
        }

        public Builder challengeConfig(ChallengeConfig var1);

        default public Builder challengeConfig(Consumer<ChallengeConfig.Builder> challengeConfig) {
            return this.challengeConfig((ChallengeConfig)((ChallengeConfig.Builder)ChallengeConfig.builder().applyMutation(challengeConfig)).build());
        }

        public Builder tokenDomains(Collection<String> var1);

        public Builder tokenDomains(String ... var1);

        public Builder associationConfig(AssociationConfig var1);

        default public Builder associationConfig(Consumer<AssociationConfig.Builder> associationConfig) {
            return this.associationConfig((AssociationConfig)((AssociationConfig.Builder)AssociationConfig.builder().applyMutation(associationConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

