/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.IPAddressVersion;
import software.amazon.awssdk.services.wafv2.model.IPAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RateBasedStatementManagedKeysIPSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RateBasedStatementManagedKeysIPSet> {
    private static final SdkField<String> IP_ADDRESS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPAddressVersion").getter(RateBasedStatementManagedKeysIPSet.getter(RateBasedStatementManagedKeysIPSet::ipAddressVersionAsString)).setter(RateBasedStatementManagedKeysIPSet.setter(Builder::ipAddressVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressVersion").build()}).build();
    private static final SdkField<List<String>> ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Addresses").getter(RateBasedStatementManagedKeysIPSet.getter(RateBasedStatementManagedKeysIPSet::addresses)).setter(RateBasedStatementManagedKeysIPSet.setter(Builder::addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_VERSION_FIELD, ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RateBasedStatementManagedKeysIPSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipAddressVersion;
    private final List<String> addresses;

    private RateBasedStatementManagedKeysIPSet(BuilderImpl builder) {
        this.ipAddressVersion = builder.ipAddressVersion;
        this.addresses = builder.addresses;
    }

    public final IPAddressVersion ipAddressVersion() {
        return IPAddressVersion.fromValue(this.ipAddressVersion);
    }

    public final String ipAddressVersionAsString() {
        return this.ipAddressVersion;
    }

    public final boolean hasAddresses() {
        return this.addresses != null && !(this.addresses instanceof SdkAutoConstructList);
    }

    public final List<String> addresses() {
        return this.addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddresses() ? this.addresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedStatementManagedKeysIPSet)) {
            return false;
        }
        RateBasedStatementManagedKeysIPSet other = (RateBasedStatementManagedKeysIPSet)obj;
        return Objects.equals(this.ipAddressVersionAsString(), other.ipAddressVersionAsString()) && this.hasAddresses() == other.hasAddresses() && Objects.equals(this.addresses(), other.addresses());
    }

    public final String toString() {
        return ToString.builder((String)"RateBasedStatementManagedKeysIPSet").add("IPAddressVersion", (Object)this.ipAddressVersionAsString()).add("Addresses", this.hasAddresses() ? this.addresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPAddressVersion": {
                return Optional.ofNullable(clazz.cast(this.ipAddressVersionAsString()));
            }
            case "Addresses": {
                return Optional.ofNullable(clazz.cast(this.addresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IPAddressVersion", IP_ADDRESS_VERSION_FIELD);
        map.put("Addresses", ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RateBasedStatementManagedKeysIPSet, T> g) {
        return obj -> g.apply((RateBasedStatementManagedKeysIPSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddressVersion;
        private List<String> addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedStatementManagedKeysIPSet model) {
            this.ipAddressVersion(model.ipAddressVersion);
            this.addresses(model.addresses);
        }

        public final String getIpAddressVersion() {
            return this.ipAddressVersion;
        }

        public final void setIpAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
        }

        @Override
        public final Builder ipAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
            return this;
        }

        @Override
        public final Builder ipAddressVersion(IPAddressVersion ipAddressVersion) {
            this.ipAddressVersion(ipAddressVersion == null ? null : ipAddressVersion.toString());
            return this;
        }

        public final Collection<String> getAddresses() {
            if (this.addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addresses;
        }

        public final void setAddresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
        }

        @Override
        public final Builder addresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(String ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        public RateBasedStatementManagedKeysIPSet build() {
            return new RateBasedStatementManagedKeysIPSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RateBasedStatementManagedKeysIPSet> {
        public Builder ipAddressVersion(String var1);

        public Builder ipAddressVersion(IPAddressVersion var1);

        public Builder addresses(Collection<String> var1);

        public Builder addresses(String ... var1);
    }
}

