/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is part of the <code>AWSManagedRulesAntiDDoSRuleSet</code> <code>ClientSideActionConfig</code> configuration in
 * <code>ManagedRuleGroupConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientSideAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientSideAction.Builder, ClientSideAction> {
    private static final SdkField<String> USAGE_OF_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageOfAction").getter(getter(ClientSideAction::usageOfActionAsString))
            .setter(setter(Builder::usageOfAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOfAction").build()).build();

    private static final SdkField<String> SENSITIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sensitivity").getter(getter(ClientSideAction::sensitivityAsString)).setter(setter(Builder::sensitivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sensitivity").build()).build();

    private static final SdkField<List<Regex>> EXEMPT_URI_REGULAR_EXPRESSIONS_FIELD = SdkField
            .<List<Regex>> builder(MarshallingType.LIST)
            .memberName("ExemptUriRegularExpressions")
            .getter(getter(ClientSideAction::exemptUriRegularExpressions))
            .setter(setter(Builder::exemptUriRegularExpressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExemptUriRegularExpressions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Regex> builder(MarshallingType.SDK_POJO)
                                            .constructor(Regex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_OF_ACTION_FIELD,
            SENSITIVITY_FIELD, EXEMPT_URI_REGULAR_EXPRESSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String usageOfAction;

    private final String sensitivity;

    private final List<Regex> exemptUriRegularExpressions;

    private ClientSideAction(BuilderImpl builder) {
        this.usageOfAction = builder.usageOfAction;
        this.sensitivity = builder.sensitivity;
        this.exemptUriRegularExpressions = builder.exemptUriRegularExpressions;
    }

    /**
     * <p>
     * Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
     * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation and the
     * related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If usage is enabled:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web
     * request whose URL does <i>NOT</i> match the regular expressions provided in the <code>ClientSideAction</code>
     * setting <code>ExemptUriRegularExpressions</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The two rules are evaluated against web requests for protected resources that are experiencing a DDoS attack. The
     * two rules only apply their action to matching requests that have the label
     * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If usage is disabled:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The managed rule group doesn't add the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to
     * any web requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * The two rules are not evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the other <code>ClientSideAction</code> settings have any effect.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This setting only enables or disables the use of the two anti-DDOS rules <code>ChallengeAllDuringEvent</code> and
     * <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule group.
     * </p>
     * <p>
     * This setting doesn't alter the action setting in the two rules. To override the actions used by the rules
     * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this setting, and then
     * override the rule actions in the usual way, in your managed rule group configuration.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageOfAction}
     * will return {@link UsageOfAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageOfActionAsString}.
     * </p>
     * 
     * @return Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation
     *         and the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If usage is enabled:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to
     *         any web request whose URL does <i>NOT</i> match the regular expressions provided in the
     *         <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The two rules are evaluated against web requests for protected resources that are experiencing a DDoS
     *         attack. The two rules only apply their action to matching requests that have the label
     *         <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         If usage is disabled:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The managed rule group doesn't add the label
     *         <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The two rules are not evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         None of the other <code>ClientSideAction</code> settings have any effect.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This setting only enables or disables the use of the two anti-DDOS rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule
     *         group.
     *         </p>
     *         <p>
     *         This setting doesn't alter the action setting in the two rules. To override the actions used by the rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this setting, and
     *         then override the rule actions in the usual way, in your managed rule group configuration.
     *         </p>
     * @see UsageOfAction
     */
    public final UsageOfAction usageOfAction() {
        return UsageOfAction.fromValue(usageOfAction);
    }

    /**
     * <p>
     * Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
     * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation and the
     * related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If usage is enabled:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web
     * request whose URL does <i>NOT</i> match the regular expressions provided in the <code>ClientSideAction</code>
     * setting <code>ExemptUriRegularExpressions</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The two rules are evaluated against web requests for protected resources that are experiencing a DDoS attack. The
     * two rules only apply their action to matching requests that have the label
     * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If usage is disabled:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The managed rule group doesn't add the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to
     * any web requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * The two rules are not evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the other <code>ClientSideAction</code> settings have any effect.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This setting only enables or disables the use of the two anti-DDOS rules <code>ChallengeAllDuringEvent</code> and
     * <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule group.
     * </p>
     * <p>
     * This setting doesn't alter the action setting in the two rules. To override the actions used by the rules
     * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this setting, and then
     * override the rule actions in the usual way, in your managed rule group configuration.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageOfAction}
     * will return {@link UsageOfAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageOfActionAsString}.
     * </p>
     * 
     * @return Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation
     *         and the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If usage is enabled:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to
     *         any web request whose URL does <i>NOT</i> match the regular expressions provided in the
     *         <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The two rules are evaluated against web requests for protected resources that are experiencing a DDoS
     *         attack. The two rules only apply their action to matching requests that have the label
     *         <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         If usage is disabled:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The managed rule group doesn't add the label
     *         <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The two rules are not evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         None of the other <code>ClientSideAction</code> settings have any effect.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This setting only enables or disables the use of the two anti-DDOS rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule
     *         group.
     *         </p>
     *         <p>
     *         This setting doesn't alter the action setting in the two rules. To override the actions used by the rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this setting, and
     *         then override the rule actions in the usual way, in your managed rule group configuration.
     *         </p>
     * @see UsageOfAction
     */
    public final String usageOfActionAsString() {
        return usageOfAction;
    }

    /**
     * <p>
     * The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against the DDoS
     * suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
     * <code>ChallengeDDoSRequests</code> rule runs.
     * </p>
     * <p>
     * The higher the sensitivity, the more levels of labeling that the rule matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack,
     * which are the requests with the high suspicion label
     * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>HIGH</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sensitivity} will
     * return {@link SensitivityToAct#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sensitivityAsString}.
     * </p>
     * 
     * @return The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against
     *         the DDoS suspicion labeling on a request. The managed rule group adds the labeling during DDoS events,
     *         before the <code>ChallengeDDoSRequests</code> rule runs. </p>
     *         <p>
     *         The higher the sensitivity, the more levels of labeling that the rule matches:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
     *         attack, which are the requests with the high suspicion label
     *         <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>HIGH</code>
     * @see SensitivityToAct
     */
    public final SensitivityToAct sensitivity() {
        return SensitivityToAct.fromValue(sensitivity);
    }

    /**
     * <p>
     * The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against the DDoS
     * suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
     * <code>ChallengeDDoSRequests</code> rule runs.
     * </p>
     * <p>
     * The higher the sensitivity, the more levels of labeling that the rule matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack,
     * which are the requests with the high suspicion label
     * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>HIGH</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sensitivity} will
     * return {@link SensitivityToAct#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sensitivityAsString}.
     * </p>
     * 
     * @return The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against
     *         the DDoS suspicion labeling on a request. The managed rule group adds the labeling during DDoS events,
     *         before the <code>ChallengeDDoSRequests</code> rule runs. </p>
     *         <p>
     *         The higher the sensitivity, the more levels of labeling that the rule matches:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
     *         attack, which are the requests with the high suspicion label
     *         <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>HIGH</code>
     * @see SensitivityToAct
     */
    public final String sensitivityAsString() {
        return sensitivity;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExemptUriRegularExpressions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExemptUriRegularExpressions() {
        return exemptUriRegularExpressions != null && !(exemptUriRegularExpressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The regular expression to match against the web request URI, used to identify requests that can't handle a silent
     * browser challenge. When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is enabled, the
     * managed rule group uses this setting to determine which requests to label with
     * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. If <code>UsageOfAction</code> is disabled, this
     * setting has no effect and the managed rule group doesn't add the label to any requests.
     * </p>
     * <p>
     * The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or
     * <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true regardless of
     * whether you override the rule action for either of the rules in your web ACL configuration.
     * </p>
     * <p>
     * Amazon Web Services recommends using a regular expression.
     * </p>
     * <p>
     * This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code>. If required, you can
     * provide between 1 and 5 regex objects in the array of settings.
     * </p>
     * <p>
     * Amazon Web Services recommends starting with the following setting. Review and update it for your application's
     * needs:
     * </p>
     * <p>
     * <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExemptUriRegularExpressions} method.
     * </p>
     * 
     * @return The regular expression to match against the web request URI, used to identify requests that can't handle
     *         a silent browser challenge. When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is
     *         enabled, the managed rule group uses this setting to determine which requests to label with
     *         <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. If <code>UsageOfAction</code> is
     *         disabled, this setting has no effect and the managed rule group doesn't add the label to any
     *         requests.</p>
     *         <p>
     *         The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or
     *         <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true
     *         regardless of whether you override the rule action for either of the rules in your web ACL configuration.
     *         </p>
     *         <p>
     *         Amazon Web Services recommends using a regular expression.
     *         </p>
     *         <p>
     *         This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code>. If required, you
     *         can provide between 1 and 5 regex objects in the array of settings.
     *         </p>
     *         <p>
     *         Amazon Web Services recommends starting with the following setting. Review and update it for your
     *         application's needs:
     *         </p>
     *         <p>
     *         <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
     */
    public final List<Regex> exemptUriRegularExpressions() {
        return exemptUriRegularExpressions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageOfActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasExemptUriRegularExpressions() ? exemptUriRegularExpressions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientSideAction)) {
            return false;
        }
        ClientSideAction other = (ClientSideAction) obj;
        return Objects.equals(usageOfActionAsString(), other.usageOfActionAsString())
                && Objects.equals(sensitivityAsString(), other.sensitivityAsString())
                && hasExemptUriRegularExpressions() == other.hasExemptUriRegularExpressions()
                && Objects.equals(exemptUriRegularExpressions(), other.exemptUriRegularExpressions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientSideAction").add("UsageOfAction", usageOfActionAsString())
                .add("Sensitivity", sensitivityAsString())
                .add("ExemptUriRegularExpressions", hasExemptUriRegularExpressions() ? exemptUriRegularExpressions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageOfAction":
            return Optional.ofNullable(clazz.cast(usageOfActionAsString()));
        case "Sensitivity":
            return Optional.ofNullable(clazz.cast(sensitivityAsString()));
        case "ExemptUriRegularExpressions":
            return Optional.ofNullable(clazz.cast(exemptUriRegularExpressions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UsageOfAction", USAGE_OF_ACTION_FIELD);
        map.put("Sensitivity", SENSITIVITY_FIELD);
        map.put("ExemptUriRegularExpressions", EXEMPT_URI_REGULAR_EXPRESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientSideAction, T> g) {
        return obj -> g.apply((ClientSideAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientSideAction> {
        /**
         * <p>
         * Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation and
         * the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If usage is enabled:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any
         * web request whose URL does <i>NOT</i> match the regular expressions provided in the
         * <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The two rules are evaluated against web requests for protected resources that are experiencing a DDoS attack.
         * The two rules only apply their action to matching requests that have the label
         * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * If usage is disabled:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The managed rule group doesn't add the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>
         * to any web requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * The two rules are not evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * None of the other <code>ClientSideAction</code> settings have any effect.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This setting only enables or disables the use of the two anti-DDOS rules <code>ChallengeAllDuringEvent</code>
         * and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule group.
         * </p>
         * <p>
         * This setting doesn't alter the action setting in the two rules. To override the actions used by the rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this setting, and then
         * override the rule actions in the usual way, in your managed rule group configuration.
         * </p>
         * </note>
         * 
         * @param usageOfAction
         *        Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
         *        <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group
         *        evaluation and the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If usage is enabled:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>
         *        to any web request whose URL does <i>NOT</i> match the regular expressions provided in the
         *        <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The two rules are evaluated against web requests for protected resources that are experiencing a DDoS
         *        attack. The two rules only apply their action to matching requests that have the label
         *        <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        If usage is disabled:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The managed rule group doesn't add the label
         *        <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The two rules are not evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        None of the other <code>ClientSideAction</code> settings have any effect.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This setting only enables or disables the use of the two anti-DDOS rules
         *        <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed
         *        rule group.
         *        </p>
         *        <p>
         *        This setting doesn't alter the action setting in the two rules. To override the actions used by the
         *        rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this
         *        setting, and then override the rule actions in the usual way, in your managed rule group
         *        configuration.
         *        </p>
         * @see UsageOfAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageOfAction
         */
        Builder usageOfAction(String usageOfAction);

        /**
         * <p>
         * Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation and
         * the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If usage is enabled:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any
         * web request whose URL does <i>NOT</i> match the regular expressions provided in the
         * <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The two rules are evaluated against web requests for protected resources that are experiencing a DDoS attack.
         * The two rules only apply their action to matching requests that have the label
         * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * If usage is disabled:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The managed rule group doesn't add the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>
         * to any web requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * The two rules are not evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * None of the other <code>ClientSideAction</code> settings have any effect.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This setting only enables or disables the use of the two anti-DDOS rules <code>ChallengeAllDuringEvent</code>
         * and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule group.
         * </p>
         * <p>
         * This setting doesn't alter the action setting in the two rules. To override the actions used by the rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this setting, and then
         * override the rule actions in the usual way, in your managed rule group configuration.
         * </p>
         * </note>
         * 
         * @param usageOfAction
         *        Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
         *        <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group
         *        evaluation and the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If usage is enabled:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>
         *        to any web request whose URL does <i>NOT</i> match the regular expressions provided in the
         *        <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The two rules are evaluated against web requests for protected resources that are experiencing a DDoS
         *        attack. The two rules only apply their action to matching requests that have the label
         *        <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        If usage is disabled:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The managed rule group doesn't add the label
         *        <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The two rules are not evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        None of the other <code>ClientSideAction</code> settings have any effect.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This setting only enables or disables the use of the two anti-DDOS rules
         *        <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed
         *        rule group.
         *        </p>
         *        <p>
         *        This setting doesn't alter the action setting in the two rules. To override the actions used by the
         *        rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>, enable this
         *        setting, and then override the rule actions in the usual way, in your managed rule group
         *        configuration.
         *        </p>
         * @see UsageOfAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageOfAction
         */
        Builder usageOfAction(UsageOfAction usageOfAction);

        /**
         * <p>
         * The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against the
         * DDoS suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
         * <code>ChallengeDDoSRequests</code> rule runs.
         * </p>
         * <p>
         * The higher the sensitivity, the more levels of labeling that the rule matches:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
         * attack, which are the requests with the high suspicion label
         * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         * </p>
         * </li>
         * <li>
         * <p>
         * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>HIGH</code>
         * </p>
         * 
         * @param sensitivity
         *        The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against
         *        the DDoS suspicion labeling on a request. The managed rule group adds the labeling during DDoS events,
         *        before the <code>ChallengeDDoSRequests</code> rule runs. </p>
         *        <p>
         *        The higher the sensitivity, the more levels of labeling that the rule matches:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in
         *        an attack, which are the requests with the high suspicion label
         *        <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>HIGH</code>
         * @see SensitivityToAct
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SensitivityToAct
         */
        Builder sensitivity(String sensitivity);

        /**
         * <p>
         * The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against the
         * DDoS suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
         * <code>ChallengeDDoSRequests</code> rule runs.
         * </p>
         * <p>
         * The higher the sensitivity, the more levels of labeling that the rule matches:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
         * attack, which are the requests with the high suspicion label
         * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         * </p>
         * </li>
         * <li>
         * <p>
         * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>HIGH</code>
         * </p>
         * 
         * @param sensitivity
         *        The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against
         *        the DDoS suspicion labeling on a request. The managed rule group adds the labeling during DDoS events,
         *        before the <code>ChallengeDDoSRequests</code> rule runs. </p>
         *        <p>
         *        The higher the sensitivity, the more levels of labeling that the rule matches:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in
         *        an attack, which are the requests with the high suspicion label
         *        <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>HIGH</code>
         * @see SensitivityToAct
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SensitivityToAct
         */
        Builder sensitivity(SensitivityToAct sensitivity);

        /**
         * <p>
         * The regular expression to match against the web request URI, used to identify requests that can't handle a
         * silent browser challenge. When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is
         * enabled, the managed rule group uses this setting to determine which requests to label with
         * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. If <code>UsageOfAction</code> is disabled,
         * this setting has no effect and the managed rule group doesn't add the label to any requests.
         * </p>
         * <p>
         * The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or
         * <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true regardless of
         * whether you override the rule action for either of the rules in your web ACL configuration.
         * </p>
         * <p>
         * Amazon Web Services recommends using a regular expression.
         * </p>
         * <p>
         * This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code>. If required, you can
         * provide between 1 and 5 regex objects in the array of settings.
         * </p>
         * <p>
         * Amazon Web Services recommends starting with the following setting. Review and update it for your
         * application's needs:
         * </p>
         * <p>
         * <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
         * </p>
         * 
         * @param exemptUriRegularExpressions
         *        The regular expression to match against the web request URI, used to identify requests that can't
         *        handle a silent browser challenge. When the <code>ClientSideAction</code> setting
         *        <code>UsageOfAction</code> is enabled, the managed rule group uses this setting to determine which
         *        requests to label with <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. If
         *        <code>UsageOfAction</code> is disabled, this setting has no effect and the managed rule group doesn't
         *        add the label to any requests.</p>
         *        <p>
         *        The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or
         *        <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true
         *        regardless of whether you override the rule action for either of the rules in your web ACL
         *        configuration.
         *        </p>
         *        <p>
         *        Amazon Web Services recommends using a regular expression.
         *        </p>
         *        <p>
         *        This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code>. If required,
         *        you can provide between 1 and 5 regex objects in the array of settings.
         *        </p>
         *        <p>
         *        Amazon Web Services recommends starting with the following setting. Review and update it for your
         *        application's needs:
         *        </p>
         *        <p>
         *        <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exemptUriRegularExpressions(Collection<Regex> exemptUriRegularExpressions);

        /**
         * <p>
         * The regular expression to match against the web request URI, used to identify requests that can't handle a
         * silent browser challenge. When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is
         * enabled, the managed rule group uses this setting to determine which requests to label with
         * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. If <code>UsageOfAction</code> is disabled,
         * this setting has no effect and the managed rule group doesn't add the label to any requests.
         * </p>
         * <p>
         * The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or
         * <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true regardless of
         * whether you override the rule action for either of the rules in your web ACL configuration.
         * </p>
         * <p>
         * Amazon Web Services recommends using a regular expression.
         * </p>
         * <p>
         * This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code>. If required, you can
         * provide between 1 and 5 regex objects in the array of settings.
         * </p>
         * <p>
         * Amazon Web Services recommends starting with the following setting. Review and update it for your
         * application's needs:
         * </p>
         * <p>
         * <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
         * </p>
         * 
         * @param exemptUriRegularExpressions
         *        The regular expression to match against the web request URI, used to identify requests that can't
         *        handle a silent browser challenge. When the <code>ClientSideAction</code> setting
         *        <code>UsageOfAction</code> is enabled, the managed rule group uses this setting to determine which
         *        requests to label with <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. If
         *        <code>UsageOfAction</code> is disabled, this setting has no effect and the managed rule group doesn't
         *        add the label to any requests.</p>
         *        <p>
         *        The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or
         *        <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true
         *        regardless of whether you override the rule action for either of the rules in your web ACL
         *        configuration.
         *        </p>
         *        <p>
         *        Amazon Web Services recommends using a regular expression.
         *        </p>
         *        <p>
         *        This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code>. If required,
         *        you can provide between 1 and 5 regex objects in the array of settings.
         *        </p>
         *        <p>
         *        Amazon Web Services recommends starting with the following setting. Review and update it for your
         *        application's needs:
         *        </p>
         *        <p>
         *        <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exemptUriRegularExpressions(Regex... exemptUriRegularExpressions);

        /**
         * <p>
         * The regular expression to match against the web request URI, used to identify requests that can't handle a
         * silent browser challenge. When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is
         * enabled, the managed rule group uses this setting to determine which requests to label with
         * <code>awswaf:managed:aws:anti-ddos:challengeable-request</code>. If <code>UsageOfAction</code> is disabled,
         * this setting has no effect and the managed rule group doesn't add the label to any requests.
         * </p>
         * <p>
         * The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or
         * <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true regardless of
         * whether you override the rule action for either of the rules in your web ACL configuration.
         * </p>
         * <p>
         * Amazon Web Services recommends using a regular expression.
         * </p>
         * <p>
         * This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code>. If required, you can
         * provide between 1 and 5 regex objects in the array of settings.
         * </p>
         * <p>
         * Amazon Web Services recommends starting with the following setting. Review and update it for your
         * application's needs:
         * </p>
         * <p>
         * <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.wafv2.model.Regex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder#build()} is called immediately and its
         * result is passed to {@link #exemptUriRegularExpressions(List<Regex>)}.
         * 
         * @param exemptUriRegularExpressions
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exemptUriRegularExpressions(java.util.Collection<Regex>)
         */
        Builder exemptUriRegularExpressions(Consumer<Regex.Builder>... exemptUriRegularExpressions);
    }

    static final class BuilderImpl implements Builder {
        private String usageOfAction;

        private String sensitivity;

        private List<Regex> exemptUriRegularExpressions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClientSideAction model) {
            usageOfAction(model.usageOfAction);
            sensitivity(model.sensitivity);
            exemptUriRegularExpressions(model.exemptUriRegularExpressions);
        }

        public final String getUsageOfAction() {
            return usageOfAction;
        }

        public final void setUsageOfAction(String usageOfAction) {
            this.usageOfAction = usageOfAction;
        }

        @Override
        public final Builder usageOfAction(String usageOfAction) {
            this.usageOfAction = usageOfAction;
            return this;
        }

        @Override
        public final Builder usageOfAction(UsageOfAction usageOfAction) {
            this.usageOfAction(usageOfAction == null ? null : usageOfAction.toString());
            return this;
        }

        public final String getSensitivity() {
            return sensitivity;
        }

        public final void setSensitivity(String sensitivity) {
            this.sensitivity = sensitivity;
        }

        @Override
        public final Builder sensitivity(String sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        @Override
        public final Builder sensitivity(SensitivityToAct sensitivity) {
            this.sensitivity(sensitivity == null ? null : sensitivity.toString());
            return this;
        }

        public final List<Regex.Builder> getExemptUriRegularExpressions() {
            List<Regex.Builder> result = RegularExpressionListCopier.copyToBuilder(this.exemptUriRegularExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExemptUriRegularExpressions(Collection<Regex.BuilderImpl> exemptUriRegularExpressions) {
            this.exemptUriRegularExpressions = RegularExpressionListCopier.copyFromBuilder(exemptUriRegularExpressions);
        }

        @Override
        public final Builder exemptUriRegularExpressions(Collection<Regex> exemptUriRegularExpressions) {
            this.exemptUriRegularExpressions = RegularExpressionListCopier.copy(exemptUriRegularExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exemptUriRegularExpressions(Regex... exemptUriRegularExpressions) {
            exemptUriRegularExpressions(Arrays.asList(exemptUriRegularExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exemptUriRegularExpressions(Consumer<Regex.Builder>... exemptUriRegularExpressions) {
            exemptUriRegularExpressions(Stream.of(exemptUriRegularExpressions).map(c -> Regex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClientSideAction build() {
            return new ClientSideAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
