/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A version of the named managed rule group, that the rule group's vendor publishes for use by customers.
 * </p>
 * <note>
 * <p>
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
 * Services Marketplace sellers.
 * </p>
 * <p>
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group
 * offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>,
 * <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersionToPublish implements SdkPojo, Serializable,
        ToCopyableBuilder<VersionToPublish.Builder, VersionToPublish> {
    private static final SdkField<String> ASSOCIATED_RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedRuleGroupArn").getter(getter(VersionToPublish::associatedRuleGroupArn))
            .setter(setter(Builder::associatedRuleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRuleGroupArn").build())
            .build();

    private static final SdkField<Integer> FORECASTED_LIFETIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ForecastedLifetime").getter(getter(VersionToPublish::forecastedLifetime))
            .setter(setter(Builder::forecastedLifetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastedLifetime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATED_RULE_GROUP_ARN_FIELD, FORECASTED_LIFETIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associatedRuleGroupArn;

    private final Integer forecastedLifetime;

    private VersionToPublish(BuilderImpl builder) {
        this.associatedRuleGroupArn = builder.associatedRuleGroupArn;
        this.forecastedLifetime = builder.forecastedLifetime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vendor's rule group that's used in the published managed rule group
     * version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vendor's rule group that's used in the published managed rule group
     *         version.
     */
    public final String associatedRuleGroupArn() {
        return associatedRuleGroupArn;
    }

    /**
     * <p>
     * The amount of time the vendor expects this version of the managed rule group to last, in days.
     * </p>
     * 
     * @return The amount of time the vendor expects this version of the managed rule group to last, in days.
     */
    public final Integer forecastedLifetime() {
        return forecastedLifetime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatedRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(forecastedLifetime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionToPublish)) {
            return false;
        }
        VersionToPublish other = (VersionToPublish) obj;
        return Objects.equals(associatedRuleGroupArn(), other.associatedRuleGroupArn())
                && Objects.equals(forecastedLifetime(), other.forecastedLifetime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VersionToPublish").add("AssociatedRuleGroupArn", associatedRuleGroupArn())
                .add("ForecastedLifetime", forecastedLifetime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedRuleGroupArn":
            return Optional.ofNullable(clazz.cast(associatedRuleGroupArn()));
        case "ForecastedLifetime":
            return Optional.ofNullable(clazz.cast(forecastedLifetime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociatedRuleGroupArn", ASSOCIATED_RULE_GROUP_ARN_FIELD);
        map.put("ForecastedLifetime", FORECASTED_LIFETIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VersionToPublish, T> g) {
        return obj -> g.apply((VersionToPublish) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersionToPublish> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vendor's rule group that's used in the published managed rule group
         * version.
         * </p>
         * 
         * @param associatedRuleGroupArn
         *        The Amazon Resource Name (ARN) of the vendor's rule group that's used in the published managed rule
         *        group version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRuleGroupArn(String associatedRuleGroupArn);

        /**
         * <p>
         * The amount of time the vendor expects this version of the managed rule group to last, in days.
         * </p>
         * 
         * @param forecastedLifetime
         *        The amount of time the vendor expects this version of the managed rule group to last, in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedLifetime(Integer forecastedLifetime);
    }

    static final class BuilderImpl implements Builder {
        private String associatedRuleGroupArn;

        private Integer forecastedLifetime;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionToPublish model) {
            associatedRuleGroupArn(model.associatedRuleGroupArn);
            forecastedLifetime(model.forecastedLifetime);
        }

        public final String getAssociatedRuleGroupArn() {
            return associatedRuleGroupArn;
        }

        public final void setAssociatedRuleGroupArn(String associatedRuleGroupArn) {
            this.associatedRuleGroupArn = associatedRuleGroupArn;
        }

        @Override
        public final Builder associatedRuleGroupArn(String associatedRuleGroupArn) {
            this.associatedRuleGroupArn = associatedRuleGroupArn;
            return this;
        }

        public final Integer getForecastedLifetime() {
            return forecastedLifetime;
        }

        public final void setForecastedLifetime(Integer forecastedLifetime) {
            this.forecastedLifetime = forecastedLifetime;
        }

        @Override
        public final Builder forecastedLifetime(Integer forecastedLifetime) {
            this.forecastedLifetime = forecastedLifetime;
            return this;
        }

        @Override
        public VersionToPublish build() {
            return new VersionToPublish(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
