/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An improvement summary of a lens review in a workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImprovementSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ImprovementSummary.Builder, ImprovementSummary> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(ImprovementSummary::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(ImprovementSummary::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionTitle").getter(getter(ImprovementSummary::questionTitle)).setter(setter(Builder::questionTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()).build();

    private static final SdkField<String> RISK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Risk")
            .getter(getter(ImprovementSummary::riskAsString)).setter(setter(Builder::risk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()).build();

    private static final SdkField<String> IMPROVEMENT_PLAN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImprovementPlanUrl").getter(getter(ImprovementSummary::improvementPlanUrl))
            .setter(setter(Builder::improvementPlanUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlanUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD,
            PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, RISK_FIELD, IMPROVEMENT_PLAN_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final String pillarId;

    private final String questionTitle;

    private final String risk;

    private final String improvementPlanUrl;

    private ImprovementSummary(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.risk = builder.risk;
        this.improvementPlanUrl = builder.improvementPlanUrl;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the QuestionTitle property for this object.
     * 
     * @return The value of the QuestionTitle property for this object.
     */
    public final String questionTitle() {
        return questionTitle;
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final Risk risk() {
        return Risk.fromValue(risk);
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final String riskAsString() {
        return risk;
    }

    /**
     * Returns the value of the ImprovementPlanUrl property for this object.
     * 
     * @return The value of the ImprovementPlanUrl property for this object.
     */
    public final String improvementPlanUrl() {
        return improvementPlanUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(improvementPlanUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImprovementSummary)) {
            return false;
        }
        ImprovementSummary other = (ImprovementSummary) obj;
        return Objects.equals(questionId(), other.questionId()) && Objects.equals(pillarId(), other.pillarId())
                && Objects.equals(questionTitle(), other.questionTitle()) && Objects.equals(riskAsString(), other.riskAsString())
                && Objects.equals(improvementPlanUrl(), other.improvementPlanUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImprovementSummary").add("QuestionId", questionId()).add("PillarId", pillarId())
                .add("QuestionTitle", questionTitle()).add("Risk", riskAsString())
                .add("ImprovementPlanUrl", improvementPlanUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "QuestionTitle":
            return Optional.ofNullable(clazz.cast(questionTitle()));
        case "Risk":
            return Optional.ofNullable(clazz.cast(riskAsString()));
        case "ImprovementPlanUrl":
            return Optional.ofNullable(clazz.cast(improvementPlanUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImprovementSummary, T> g) {
        return obj -> g.apply((ImprovementSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImprovementSummary> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the QuestionTitle property for this object.
         *
         * @param questionTitle
         *        The new value for the QuestionTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionTitle(String questionTitle);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(String risk);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(Risk risk);

        /**
         * Sets the value of the ImprovementPlanUrl property for this object.
         *
         * @param improvementPlanUrl
         *        The new value for the ImprovementPlanUrl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder improvementPlanUrl(String improvementPlanUrl);
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private String pillarId;

        private String questionTitle;

        private String risk;

        private String improvementPlanUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ImprovementSummary model) {
            questionId(model.questionId);
            pillarId(model.pillarId);
            questionTitle(model.questionTitle);
            risk(model.risk);
            improvementPlanUrl(model.improvementPlanUrl);
        }

        public final String getQuestionId() {
            return questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final String getPillarId() {
            return pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        public final String getQuestionTitle() {
            return questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        public final String getRisk() {
            return risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        public final String getImprovementPlanUrl() {
            return improvementPlanUrl;
        }

        @Override
        public final Builder improvementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
            return this;
        }

        public final void setImprovementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
        }

        @Override
        public ImprovementSummary build() {
            return new ImprovementSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
