/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lens summary of a lens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LensSummary implements SdkPojo, Serializable, ToCopyableBuilder<LensSummary.Builder, LensSummary> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(LensSummary::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensVersion").getter(getter(LensSummary::lensVersion)).setter(setter(Builder::lensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()).build();

    private static final SdkField<String> LENS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensName").getter(getter(LensSummary::lensName)).setter(setter(Builder::lensName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LensSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD,
            LENS_VERSION_FIELD, LENS_NAME_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lensAlias;

    private final String lensVersion;

    private final String lensName;

    private final String description;

    private LensSummary(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.lensVersion = builder.lensVersion;
        this.lensName = builder.lensName;
        this.description = builder.description;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The version of the lens.
     * </p>
     * 
     * @return The version of the lens.
     */
    public final String lensVersion() {
        return lensVersion;
    }

    /**
     * Returns the value of the LensName property for this object.
     * 
     * @return The value of the LensName property for this object.
     */
    public final String lensName() {
        return lensName;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lensName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensSummary)) {
            return false;
        }
        LensSummary other = (LensSummary) obj;
        return Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(lensVersion(), other.lensVersion())
                && Objects.equals(lensName(), other.lensName()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LensSummary").add("LensAlias", lensAlias()).add("LensVersion", lensVersion())
                .add("LensName", lensName()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensVersion":
            return Optional.ofNullable(clazz.cast(lensVersion()));
        case "LensName":
            return Optional.ofNullable(clazz.cast(lensName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LensSummary, T> g) {
        return obj -> g.apply((LensSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LensSummary> {
        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The version of the lens.
         * </p>
         * 
         * @param lensVersion
         *        The version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensVersion(String lensVersion);

        /**
         * Sets the value of the LensName property for this object.
         *
         * @param lensName
         *        The new value for the LensName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensName(String lensName);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String lensAlias;

        private String lensVersion;

        private String lensName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(LensSummary model) {
            lensAlias(model.lensAlias);
            lensVersion(model.lensVersion);
            lensName(model.lensName);
            description(model.description);
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getLensVersion() {
            return lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        public final String getLensName() {
            return lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public LensSummary build() {
            return new LensSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
