/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to associate lens reviews.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateLensesRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<AssociateLensesRequest.Builder, AssociateLensesRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(AssociateLensesRequest::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()).build();

    private static final SdkField<List<String>> LENS_ALIASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LensAliases")
            .getter(getter(AssociateLensesRequest::lensAliases))
            .setter(setter(Builder::lensAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            LENS_ALIASES_FIELD));

    private final String workloadId;

    private final List<String> lensAliases;

    private AssociateLensesRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensAliases = builder.lensAliases;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns true if the LensAliases property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLensAliases() {
        return lensAliases != null && !(lensAliases instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the LensAliases property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLensAliases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the LensAliases property for this object.
     */
    public final List<String> lensAliases() {
        return lensAliases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLensAliases() ? lensAliases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateLensesRequest)) {
            return false;
        }
        AssociateLensesRequest other = (AssociateLensesRequest) obj;
        return Objects.equals(workloadId(), other.workloadId()) && hasLensAliases() == other.hasLensAliases()
                && Objects.equals(lensAliases(), other.lensAliases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateLensesRequest").add("WorkloadId", workloadId())
                .add("LensAliases", hasLensAliases() ? lensAliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "LensAliases":
            return Optional.ofNullable(clazz.cast(lensAliases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateLensesRequest, T> g) {
        return obj -> g.apply((AssociateLensesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateLensesRequest> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the LensAliases property for this object.
         *
         * @param lensAliases
         *        The new value for the LensAliases property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAliases(Collection<String> lensAliases);

        /**
         * Sets the value of the LensAliases property for this object.
         *
         * @param lensAliases
         *        The new value for the LensAliases property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAliases(String... lensAliases);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String workloadId;

        private List<String> lensAliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateLensesRequest model) {
            super(model);
            workloadId(model.workloadId);
            lensAliases(model.lensAliases);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final Collection<String> getLensAliases() {
            if (lensAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return lensAliases;
        }

        @Override
        public final Builder lensAliases(Collection<String> lensAliases) {
            this.lensAliases = LensAliasesCopier.copy(lensAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensAliases(String... lensAliases) {
            lensAliases(Arrays.asList(lensAliases));
            return this;
        }

        public final void setLensAliases(Collection<String> lensAliases) {
            this.lensAliases = LensAliasesCopier.copy(lensAliases);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateLensesRequest build() {
            return new AssociateLensesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
