/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for List Share Invitations
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListShareInvitationsResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListShareInvitationsResponse.Builder, ListShareInvitationsResponse> {
    private static final SdkField<List<ShareInvitationSummary>> SHARE_INVITATION_SUMMARIES_FIELD = SdkField
            .<List<ShareInvitationSummary>> builder(MarshallingType.LIST)
            .memberName("ShareInvitationSummaries")
            .getter(getter(ListShareInvitationsResponse::shareInvitationSummaries))
            .setter(setter(Builder::shareInvitationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ShareInvitationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ShareInvitationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListShareInvitationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SHARE_INVITATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ShareInvitationSummary> shareInvitationSummaries;

    private final String nextToken;

    private ListShareInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.shareInvitationSummaries = builder.shareInvitationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ShareInvitationSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasShareInvitationSummaries() {
        return shareInvitationSummaries != null && !(shareInvitationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of share invitation summaries in a workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasShareInvitationSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of share invitation summaries in a workload.
     */
    public final List<ShareInvitationSummary> shareInvitationSummaries() {
        return shareInvitationSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasShareInvitationSummaries() ? shareInvitationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShareInvitationsResponse)) {
            return false;
        }
        ListShareInvitationsResponse other = (ListShareInvitationsResponse) obj;
        return hasShareInvitationSummaries() == other.hasShareInvitationSummaries()
                && Objects.equals(shareInvitationSummaries(), other.shareInvitationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListShareInvitationsResponse")
                .add("ShareInvitationSummaries", hasShareInvitationSummaries() ? shareInvitationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShareInvitationSummaries":
            return Optional.ofNullable(clazz.cast(shareInvitationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListShareInvitationsResponse, T> g) {
        return obj -> g.apply((ListShareInvitationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListShareInvitationsResponse> {
        /**
         * <p>
         * List of share invitation summaries in a workload.
         * </p>
         * 
         * @param shareInvitationSummaries
         *        List of share invitation summaries in a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationSummaries(Collection<ShareInvitationSummary> shareInvitationSummaries);

        /**
         * <p>
         * List of share invitation summaries in a workload.
         * </p>
         * 
         * @param shareInvitationSummaries
         *        List of share invitation summaries in a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationSummaries(ShareInvitationSummary... shareInvitationSummaries);

        /**
         * <p>
         * List of share invitation summaries in a workload.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ShareInvitationSummary>.Builder} avoiding
         * the need to create one manually via {@link List<ShareInvitationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ShareInvitationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #shareInvitationSummaries(List<ShareInvitationSummary>)}.
         * 
         * @param shareInvitationSummaries
         *        a consumer that will call methods on {@link List<ShareInvitationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareInvitationSummaries(List<ShareInvitationSummary>)
         */
        Builder shareInvitationSummaries(Consumer<ShareInvitationSummary.Builder>... shareInvitationSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private List<ShareInvitationSummary> shareInvitationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShareInvitationsResponse model) {
            super(model);
            shareInvitationSummaries(model.shareInvitationSummaries);
            nextToken(model.nextToken);
        }

        public final List<ShareInvitationSummary.Builder> getShareInvitationSummaries() {
            List<ShareInvitationSummary.Builder> result = ShareInvitationSummariesCopier
                    .copyToBuilder(this.shareInvitationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder shareInvitationSummaries(Collection<ShareInvitationSummary> shareInvitationSummaries) {
            this.shareInvitationSummaries = ShareInvitationSummariesCopier.copy(shareInvitationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareInvitationSummaries(ShareInvitationSummary... shareInvitationSummaries) {
            shareInvitationSummaries(Arrays.asList(shareInvitationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareInvitationSummaries(Consumer<ShareInvitationSummary.Builder>... shareInvitationSummaries) {
            shareInvitationSummaries(Stream.of(shareInvitationSummaries)
                    .map(c -> ShareInvitationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setShareInvitationSummaries(Collection<ShareInvitationSummary.BuilderImpl> shareInvitationSummaries) {
            this.shareInvitationSummaries = ShareInvitationSummariesCopier.copyFromBuilder(shareInvitationSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListShareInvitationsResponse build() {
            return new ListShareInvitationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
