/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lens return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Lens implements SdkPojo, Serializable, ToCopyableBuilder<Lens.Builder, Lens> {
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(Lens::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensVersion").getter(getter(Lens::lensVersion)).setter(setter(Builder::lensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Lens::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Lens::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(Lens::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationId").getter(getter(Lens::shareInvitationId)).setter(setter(Builder::shareInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ARN_FIELD,
            LENS_VERSION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, OWNER_FIELD, SHARE_INVITATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lensArn;

    private final String lensVersion;

    private final String name;

    private final String description;

    private final String owner;

    private final String shareInvitationId;

    private Lens(BuilderImpl builder) {
        this.lensArn = builder.lensArn;
        this.lensVersion = builder.lensVersion;
        this.name = builder.name;
        this.description = builder.description;
        this.owner = builder.owner;
        this.shareInvitationId = builder.shareInvitationId;
    }

    /**
     * <p>
     * The ARN of a lens.
     * </p>
     * 
     * @return The ARN of a lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * <p>
     * The version of a lens.
     * </p>
     * 
     * @return The version of a lens.
     */
    public final String lensVersion() {
        return lensVersion;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the lens.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the lens.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The ID assigned to the share invitation.
     * </p>
     * 
     * @return The ID assigned to the share invitation.
     */
    public final String shareInvitationId() {
        return shareInvitationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Lens)) {
            return false;
        }
        Lens other = (Lens) obj;
        return Objects.equals(lensArn(), other.lensArn()) && Objects.equals(lensVersion(), other.lensVersion())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(owner(), other.owner()) && Objects.equals(shareInvitationId(), other.shareInvitationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Lens").add("LensArn", lensArn()).add("LensVersion", lensVersion()).add("Name", name())
                .add("Description", description()).add("Owner", owner()).add("ShareInvitationId", shareInvitationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "LensVersion":
            return Optional.ofNullable(clazz.cast(lensVersion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ShareInvitationId":
            return Optional.ofNullable(clazz.cast(shareInvitationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Lens, T> g) {
        return obj -> g.apply((Lens) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Lens> {
        /**
         * <p>
         * The ARN of a lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN of a lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * <p>
         * The version of a lens.
         * </p>
         * 
         * @param lensVersion
         *        The version of a lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensVersion(String lensVersion);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the lens.
         * </p>
         * 
         * @param owner
         *        The Amazon Web Services account ID that owns the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The ID assigned to the share invitation.
         * </p>
         * 
         * @param shareInvitationId
         *        The ID assigned to the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationId(String shareInvitationId);
    }

    static final class BuilderImpl implements Builder {
        private String lensArn;

        private String lensVersion;

        private String name;

        private String description;

        private String owner;

        private String shareInvitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(Lens model) {
            lensArn(model.lensArn);
            lensVersion(model.lensVersion);
            name(model.name);
            description(model.description);
            owner(model.owner);
            shareInvitationId(model.shareInvitationId);
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        @Transient
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getLensVersion() {
            return lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        @Transient
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getShareInvitationId() {
            return shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        @Transient
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        @Override
        public Lens build() {
            return new Lens(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
