/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lens review summary of a workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LensReviewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LensReviewSummary.Builder, LensReviewSummary> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(LensReviewSummary::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(LensReviewSummary::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensVersion").getter(getter(LensReviewSummary::lensVersion)).setter(setter(Builder::lensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()).build();

    private static final SdkField<String> LENS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensName").getter(getter(LensReviewSummary::lensName)).setter(setter(Builder::lensName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()).build();

    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensStatus").getter(getter(LensReviewSummary::lensStatusAsString)).setter(setter(Builder::lensStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensStatus").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(LensReviewSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("RiskCounts")
            .getter(getter(LensReviewSummary::riskCountsAsStrings))
            .setter(setter(Builder::riskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD,
            LENS_ARN_FIELD, LENS_VERSION_FIELD, LENS_NAME_FIELD, LENS_STATUS_FIELD, UPDATED_AT_FIELD, RISK_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lensAlias;

    private final String lensArn;

    private final String lensVersion;

    private final String lensName;

    private final String lensStatus;

    private final Instant updatedAt;

    private final Map<String, Integer> riskCounts;

    private LensReviewSummary(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.lensVersion = builder.lensVersion;
        this.lensName = builder.lensName;
        this.lensStatus = builder.lensStatus;
        this.updatedAt = builder.updatedAt;
        this.riskCounts = builder.riskCounts;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The ARN for the lens.
     * </p>
     * 
     * @return The ARN for the lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * <p>
     * The version of the lens.
     * </p>
     * 
     * @return The version of the lens.
     */
    public final String lensVersion() {
        return lensVersion;
    }

    /**
     * Returns the value of the LensName property for this object.
     * 
     * @return The value of the LensName property for this object.
     */
    public final String lensName() {
        return lensName;
    }

    /**
     * <p>
     * The status of the lens.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of the lens.
     * @see LensStatus
     */
    public final LensStatus lensStatus() {
        return LensStatus.fromValue(lensStatus);
    }

    /**
     * <p>
     * The status of the lens.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of the lens.
     * @see LensStatus
     */
    public final String lensStatusAsString() {
        return lensStatus;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(riskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskCounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRiskCounts() {
        return riskCounts != null && !(riskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<String, Integer> riskCountsAsStrings() {
        return riskCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lensName());
        hashCode = 31 * hashCode + Objects.hashCode(lensStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskCounts() ? riskCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensReviewSummary)) {
            return false;
        }
        LensReviewSummary other = (LensReviewSummary) obj;
        return Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(lensArn(), other.lensArn())
                && Objects.equals(lensVersion(), other.lensVersion()) && Objects.equals(lensName(), other.lensName())
                && Objects.equals(lensStatusAsString(), other.lensStatusAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasRiskCounts() == other.hasRiskCounts()
                && Objects.equals(riskCountsAsStrings(), other.riskCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LensReviewSummary").add("LensAlias", lensAlias()).add("LensArn", lensArn())
                .add("LensVersion", lensVersion()).add("LensName", lensName()).add("LensStatus", lensStatusAsString())
                .add("UpdatedAt", updatedAt()).add("RiskCounts", hasRiskCounts() ? riskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "LensVersion":
            return Optional.ofNullable(clazz.cast(lensVersion()));
        case "LensName":
            return Optional.ofNullable(clazz.cast(lensName()));
        case "LensStatus":
            return Optional.ofNullable(clazz.cast(lensStatusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "RiskCounts":
            return Optional.ofNullable(clazz.cast(riskCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LensReviewSummary, T> g) {
        return obj -> g.apply((LensReviewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LensReviewSummary> {
        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The ARN for the lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN for the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * <p>
         * The version of the lens.
         * </p>
         * 
         * @param lensVersion
         *        The version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensVersion(String lensVersion);

        /**
         * Sets the value of the LensName property for this object.
         *
         * @param lensName
         *        The new value for the LensName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensName(String lensName);

        /**
         * <p>
         * The status of the lens.
         * </p>
         * 
         * @param lensStatus
         *        The status of the lens.
         * @see LensStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatus
         */
        Builder lensStatus(String lensStatus);

        /**
         * <p>
         * The status of the lens.
         * </p>
         * 
         * @param lensStatus
         *        The status of the lens.
         * @see LensStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatus
         */
        Builder lensStatus(LensStatus lensStatus);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCountsWithStrings(Map<String, Integer> riskCounts);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCounts(Map<Risk, Integer> riskCounts);
    }

    static final class BuilderImpl implements Builder {
        private String lensAlias;

        private String lensArn;

        private String lensVersion;

        private String lensName;

        private String lensStatus;

        private Instant updatedAt;

        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LensReviewSummary model) {
            lensAlias(model.lensAlias);
            lensArn(model.lensArn);
            lensVersion(model.lensVersion);
            lensName(model.lensName);
            lensStatus(model.lensStatus);
            updatedAt(model.updatedAt);
            riskCountsWithStrings(model.riskCounts);
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        @Transient
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        @Transient
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getLensVersion() {
            return lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        @Transient
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final String getLensName() {
            return lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        @Transient
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final String getLensStatus() {
            return lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        @Transient
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder lensStatus(LensStatus lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        @Transient
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        @Transient
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        @Override
        public LensReviewSummary build() {
            return new LensReviewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
