/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A milestone summary return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MilestoneSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MilestoneSummary.Builder, MilestoneSummary> {
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MilestoneNumber").getter(getter(MilestoneSummary::milestoneNumber))
            .setter(setter(Builder::milestoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()).build();

    private static final SdkField<String> MILESTONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MilestoneName").getter(getter(MilestoneSummary::milestoneName)).setter(setter(Builder::milestoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneName").build()).build();

    private static final SdkField<Instant> RECORDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecordedAt").getter(getter(MilestoneSummary::recordedAt)).setter(setter(Builder::recordedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedAt").build()).build();

    private static final SdkField<WorkloadSummary> WORKLOAD_SUMMARY_FIELD = SdkField
            .<WorkloadSummary> builder(MarshallingType.SDK_POJO).memberName("WorkloadSummary")
            .getter(getter(MilestoneSummary::workloadSummary)).setter(setter(Builder::workloadSummary))
            .constructor(WorkloadSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MILESTONE_NUMBER_FIELD,
            MILESTONE_NAME_FIELD, RECORDED_AT_FIELD, WORKLOAD_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer milestoneNumber;

    private final String milestoneName;

    private final Instant recordedAt;

    private final WorkloadSummary workloadSummary;

    private MilestoneSummary(BuilderImpl builder) {
        this.milestoneNumber = builder.milestoneNumber;
        this.milestoneName = builder.milestoneName;
        this.recordedAt = builder.recordedAt;
        this.workloadSummary = builder.workloadSummary;
    }

    /**
     * Returns the value of the MilestoneNumber property for this object.
     * 
     * @return The value of the MilestoneNumber property for this object.
     */
    public final Integer milestoneNumber() {
        return milestoneNumber;
    }

    /**
     * Returns the value of the MilestoneName property for this object.
     * 
     * @return The value of the MilestoneName property for this object.
     */
    public final String milestoneName() {
        return milestoneName;
    }

    /**
     * Returns the value of the RecordedAt property for this object.
     * 
     * @return The value of the RecordedAt property for this object.
     */
    public final Instant recordedAt() {
        return recordedAt;
    }

    /**
     * Returns the value of the WorkloadSummary property for this object.
     * 
     * @return The value of the WorkloadSummary property for this object.
     */
    public final WorkloadSummary workloadSummary() {
        return workloadSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(milestoneName());
        hashCode = 31 * hashCode + Objects.hashCode(recordedAt());
        hashCode = 31 * hashCode + Objects.hashCode(workloadSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MilestoneSummary)) {
            return false;
        }
        MilestoneSummary other = (MilestoneSummary) obj;
        return Objects.equals(milestoneNumber(), other.milestoneNumber())
                && Objects.equals(milestoneName(), other.milestoneName()) && Objects.equals(recordedAt(), other.recordedAt())
                && Objects.equals(workloadSummary(), other.workloadSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MilestoneSummary").add("MilestoneNumber", milestoneNumber())
                .add("MilestoneName", milestoneName()).add("RecordedAt", recordedAt()).add("WorkloadSummary", workloadSummary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MilestoneNumber":
            return Optional.ofNullable(clazz.cast(milestoneNumber()));
        case "MilestoneName":
            return Optional.ofNullable(clazz.cast(milestoneName()));
        case "RecordedAt":
            return Optional.ofNullable(clazz.cast(recordedAt()));
        case "WorkloadSummary":
            return Optional.ofNullable(clazz.cast(workloadSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MilestoneSummary, T> g) {
        return obj -> g.apply((MilestoneSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MilestoneSummary> {
        /**
         * Sets the value of the MilestoneNumber property for this object.
         *
         * @param milestoneNumber
         *        The new value for the MilestoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneNumber(Integer milestoneNumber);

        /**
         * Sets the value of the MilestoneName property for this object.
         *
         * @param milestoneName
         *        The new value for the MilestoneName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneName(String milestoneName);

        /**
         * Sets the value of the RecordedAt property for this object.
         *
         * @param recordedAt
         *        The new value for the RecordedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordedAt(Instant recordedAt);

        /**
         * Sets the value of the WorkloadSummary property for this object.
         *
         * @param workloadSummary
         *        The new value for the WorkloadSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadSummary(WorkloadSummary workloadSummary);

        /**
         * Sets the value of the WorkloadSummary property for this object.
         *
         * This is a convenience that creates an instance of the {@link WorkloadSummary.Builder} avoiding the need to
         * create one manually via {@link WorkloadSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkloadSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #workloadSummary(WorkloadSummary)}.
         * 
         * @param workloadSummary
         *        a consumer that will call methods on {@link WorkloadSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadSummary(WorkloadSummary)
         */
        default Builder workloadSummary(Consumer<WorkloadSummary.Builder> workloadSummary) {
            return workloadSummary(WorkloadSummary.builder().applyMutation(workloadSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer milestoneNumber;

        private String milestoneName;

        private Instant recordedAt;

        private WorkloadSummary workloadSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(MilestoneSummary model) {
            milestoneNumber(model.milestoneNumber);
            milestoneName(model.milestoneName);
            recordedAt(model.recordedAt);
            workloadSummary(model.workloadSummary);
        }

        public final Integer getMilestoneNumber() {
            return milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        @Transient
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final String getMilestoneName() {
            return milestoneName;
        }

        public final void setMilestoneName(String milestoneName) {
            this.milestoneName = milestoneName;
        }

        @Override
        @Transient
        public final Builder milestoneName(String milestoneName) {
            this.milestoneName = milestoneName;
            return this;
        }

        public final Instant getRecordedAt() {
            return recordedAt;
        }

        public final void setRecordedAt(Instant recordedAt) {
            this.recordedAt = recordedAt;
        }

        @Override
        @Transient
        public final Builder recordedAt(Instant recordedAt) {
            this.recordedAt = recordedAt;
            return this;
        }

        public final WorkloadSummary.Builder getWorkloadSummary() {
            return workloadSummary != null ? workloadSummary.toBuilder() : null;
        }

        public final void setWorkloadSummary(WorkloadSummary.BuilderImpl workloadSummary) {
            this.workloadSummary = workloadSummary != null ? workloadSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder workloadSummary(WorkloadSummary workloadSummary) {
            this.workloadSummary = workloadSummary;
            return this;
        }

        @Override
        public MilestoneSummary build() {
            return new MilestoneSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
