/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to update a workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkloadRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateWorkloadRequest.Builder, UpdateWorkloadRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(UpdateWorkloadRequest::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(UpdateWorkloadRequest::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWorkloadRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Environment").getter(getter(UpdateWorkloadRequest::environmentAsString))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(UpdateWorkloadRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AwsRegions")
            .getter(getter(UpdateWorkloadRequest::awsRegions))
            .setter(setter(Builder::awsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NON_AWS_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NonAwsRegions")
            .getter(getter(UpdateWorkloadRequest::nonAwsRegions))
            .setter(setter(Builder::nonAwsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PILLAR_PRIORITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PillarPriorities")
            .getter(getter(UpdateWorkloadRequest::pillarPriorities))
            .setter(setter(Builder::pillarPriorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarPriorities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARCHITECTURAL_DESIGN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchitecturalDesign").getter(getter(UpdateWorkloadRequest::architecturalDesign))
            .setter(setter(Builder::architecturalDesign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitecturalDesign").build())
            .build();

    private static final SdkField<String> REVIEW_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewOwner").getter(getter(UpdateWorkloadRequest::reviewOwner)).setter(setter(Builder::reviewOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewOwner").build()).build();

    private static final SdkField<Boolean> IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsReviewOwnerUpdateAcknowledged")
            .getter(getter(UpdateWorkloadRequest::isReviewOwnerUpdateAcknowledged))
            .setter(setter(Builder::isReviewOwnerUpdateAcknowledged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsReviewOwnerUpdateAcknowledged")
                    .build()).build();

    private static final SdkField<String> INDUSTRY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndustryType").getter(getter(UpdateWorkloadRequest::industryType)).setter(setter(Builder::industryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndustryType").build()).build();

    private static final SdkField<String> INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Industry").getter(getter(UpdateWorkloadRequest::industry)).setter(setter(Builder::industry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(UpdateWorkloadRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<String> IMPROVEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImprovementStatus").getter(getter(UpdateWorkloadRequest::improvementStatusAsString))
            .setter(setter(Builder::improvementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WORKLOAD_ID_FIELD, WORKLOAD_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_FIELD, ACCOUNT_IDS_FIELD,
                    AWS_REGIONS_FIELD, NON_AWS_REGIONS_FIELD, PILLAR_PRIORITIES_FIELD, ARCHITECTURAL_DESIGN_FIELD,
                    REVIEW_OWNER_FIELD, IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD, INDUSTRY_TYPE_FIELD, INDUSTRY_FIELD,
                    NOTES_FIELD, IMPROVEMENT_STATUS_FIELD));

    private final String workloadId;

    private final String workloadName;

    private final String description;

    private final String environment;

    private final List<String> accountIds;

    private final List<String> awsRegions;

    private final List<String> nonAwsRegions;

    private final List<String> pillarPriorities;

    private final String architecturalDesign;

    private final String reviewOwner;

    private final Boolean isReviewOwnerUpdateAcknowledged;

    private final String industryType;

    private final String industry;

    private final String notes;

    private final String improvementStatus;

    private UpdateWorkloadRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
        this.description = builder.description;
        this.environment = builder.environment;
        this.accountIds = builder.accountIds;
        this.awsRegions = builder.awsRegions;
        this.nonAwsRegions = builder.nonAwsRegions;
        this.pillarPriorities = builder.pillarPriorities;
        this.architecturalDesign = builder.architecturalDesign;
        this.reviewOwner = builder.reviewOwner;
        this.isReviewOwnerUpdateAcknowledged = builder.isReviewOwnerUpdateAcknowledged;
        this.industryType = builder.industryType;
        this.industry = builder.industry;
        this.notes = builder.notes;
        this.improvementStatus = builder.improvementStatus;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the Environment property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environment} will
     * return {@link WorkloadEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentAsString}.
     * </p>
     * 
     * @return The value of the Environment property for this object.
     * @see WorkloadEnvironment
     */
    public final WorkloadEnvironment environment() {
        return WorkloadEnvironment.fromValue(environment);
    }

    /**
     * Returns the value of the Environment property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environment} will
     * return {@link WorkloadEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentAsString}.
     * </p>
     * 
     * @return The value of the Environment property for this object.
     * @see WorkloadEnvironment
     */
    public final String environmentAsString() {
        return environment;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AccountIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The value of the AccountIds property for this object.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsRegions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAwsRegions() {
        return awsRegions != null && !(awsRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AwsRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsRegions} method.
     * </p>
     * 
     * @return The value of the AwsRegions property for this object.
     */
    public final List<String> awsRegions() {
        return awsRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the NonAwsRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNonAwsRegions() {
        return nonAwsRegions != null && !(nonAwsRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the NonAwsRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNonAwsRegions} method.
     * </p>
     * 
     * @return The value of the NonAwsRegions property for this object.
     */
    public final List<String> nonAwsRegions() {
        return nonAwsRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the PillarPriorities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPillarPriorities() {
        return pillarPriorities != null && !(pillarPriorities instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the PillarPriorities property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillarPriorities} method.
     * </p>
     * 
     * @return The value of the PillarPriorities property for this object.
     */
    public final List<String> pillarPriorities() {
        return pillarPriorities;
    }

    /**
     * Returns the value of the ArchitecturalDesign property for this object.
     * 
     * @return The value of the ArchitecturalDesign property for this object.
     */
    public final String architecturalDesign() {
        return architecturalDesign;
    }

    /**
     * Returns the value of the ReviewOwner property for this object.
     * 
     * @return The value of the ReviewOwner property for this object.
     */
    public final String reviewOwner() {
        return reviewOwner;
    }

    /**
     * <p>
     * Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.
     * </p>
     * <p>
     * If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload
     * is restricted until an owner is added.
     * </p>
     * 
     * @return Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is
     *         required.</p>
     *         <p>
     *         If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the
     *         workload is restricted until an owner is added.
     */
    public final Boolean isReviewOwnerUpdateAcknowledged() {
        return isReviewOwnerUpdateAcknowledged;
    }

    /**
     * Returns the value of the IndustryType property for this object.
     * 
     * @return The value of the IndustryType property for this object.
     */
    public final String industryType() {
        return industryType;
    }

    /**
     * Returns the value of the Industry property for this object.
     * 
     * @return The value of the Industry property for this object.
     */
    public final String industry() {
        return industry;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * Returns the value of the ImprovementStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #improvementStatus}
     * will return {@link WorkloadImprovementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #improvementStatusAsString}.
     * </p>
     * 
     * @return The value of the ImprovementStatus property for this object.
     * @see WorkloadImprovementStatus
     */
    public final WorkloadImprovementStatus improvementStatus() {
        return WorkloadImprovementStatus.fromValue(improvementStatus);
    }

    /**
     * Returns the value of the ImprovementStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #improvementStatus}
     * will return {@link WorkloadImprovementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #improvementStatusAsString}.
     * </p>
     * 
     * @return The value of the ImprovementStatus property for this object.
     * @see WorkloadImprovementStatus
     */
    public final String improvementStatusAsString() {
        return improvementStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsRegions() ? awsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNonAwsRegions() ? nonAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPillarPriorities() ? pillarPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(architecturalDesign());
        hashCode = 31 * hashCode + Objects.hashCode(reviewOwner());
        hashCode = 31 * hashCode + Objects.hashCode(isReviewOwnerUpdateAcknowledged());
        hashCode = 31 * hashCode + Objects.hashCode(industryType());
        hashCode = 31 * hashCode + Objects.hashCode(industry());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(improvementStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadRequest)) {
            return false;
        }
        UpdateWorkloadRequest other = (UpdateWorkloadRequest) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(workloadName(), other.workloadName())
                && Objects.equals(description(), other.description())
                && Objects.equals(environmentAsString(), other.environmentAsString()) && hasAccountIds() == other.hasAccountIds()
                && Objects.equals(accountIds(), other.accountIds()) && hasAwsRegions() == other.hasAwsRegions()
                && Objects.equals(awsRegions(), other.awsRegions()) && hasNonAwsRegions() == other.hasNonAwsRegions()
                && Objects.equals(nonAwsRegions(), other.nonAwsRegions()) && hasPillarPriorities() == other.hasPillarPriorities()
                && Objects.equals(pillarPriorities(), other.pillarPriorities())
                && Objects.equals(architecturalDesign(), other.architecturalDesign())
                && Objects.equals(reviewOwner(), other.reviewOwner())
                && Objects.equals(isReviewOwnerUpdateAcknowledged(), other.isReviewOwnerUpdateAcknowledged())
                && Objects.equals(industryType(), other.industryType()) && Objects.equals(industry(), other.industry())
                && Objects.equals(notes(), other.notes())
                && Objects.equals(improvementStatusAsString(), other.improvementStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkloadRequest").add("WorkloadId", workloadId()).add("WorkloadName", workloadName())
                .add("Description", description()).add("Environment", environmentAsString())
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("AwsRegions", hasAwsRegions() ? awsRegions() : null)
                .add("NonAwsRegions", hasNonAwsRegions() ? nonAwsRegions() : null)
                .add("PillarPriorities", hasPillarPriorities() ? pillarPriorities() : null)
                .add("ArchitecturalDesign", architecturalDesign()).add("ReviewOwner", reviewOwner())
                .add("IsReviewOwnerUpdateAcknowledged", isReviewOwnerUpdateAcknowledged()).add("IndustryType", industryType())
                .add("Industry", industry()).add("Notes", notes()).add("ImprovementStatus", improvementStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environmentAsString()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "AwsRegions":
            return Optional.ofNullable(clazz.cast(awsRegions()));
        case "NonAwsRegions":
            return Optional.ofNullable(clazz.cast(nonAwsRegions()));
        case "PillarPriorities":
            return Optional.ofNullable(clazz.cast(pillarPriorities()));
        case "ArchitecturalDesign":
            return Optional.ofNullable(clazz.cast(architecturalDesign()));
        case "ReviewOwner":
            return Optional.ofNullable(clazz.cast(reviewOwner()));
        case "IsReviewOwnerUpdateAcknowledged":
            return Optional.ofNullable(clazz.cast(isReviewOwnerUpdateAcknowledged()));
        case "IndustryType":
            return Optional.ofNullable(clazz.cast(industryType()));
        case "Industry":
            return Optional.ofNullable(clazz.cast(industry()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "ImprovementStatus":
            return Optional.ofNullable(clazz.cast(improvementStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadRequest, T> g) {
        return obj -> g.apply((UpdateWorkloadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkloadRequest> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Environment property for this object.
         *
         * @param environment
         *        The new value for the Environment property for this object.
         * @see WorkloadEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEnvironment
         */
        Builder environment(String environment);

        /**
         * Sets the value of the Environment property for this object.
         *
         * @param environment
         *        The new value for the Environment property for this object.
         * @see WorkloadEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEnvironment
         */
        Builder environment(WorkloadEnvironment environment);

        /**
         * Sets the value of the AccountIds property for this object.
         *
         * @param accountIds
         *        The new value for the AccountIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * Sets the value of the AccountIds property for this object.
         *
         * @param accountIds
         *        The new value for the AccountIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * Sets the value of the AwsRegions property for this object.
         *
         * @param awsRegions
         *        The new value for the AwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(Collection<String> awsRegions);

        /**
         * Sets the value of the AwsRegions property for this object.
         *
         * @param awsRegions
         *        The new value for the AwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(String... awsRegions);

        /**
         * Sets the value of the NonAwsRegions property for this object.
         *
         * @param nonAwsRegions
         *        The new value for the NonAwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAwsRegions(Collection<String> nonAwsRegions);

        /**
         * Sets the value of the NonAwsRegions property for this object.
         *
         * @param nonAwsRegions
         *        The new value for the NonAwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAwsRegions(String... nonAwsRegions);

        /**
         * Sets the value of the PillarPriorities property for this object.
         *
         * @param pillarPriorities
         *        The new value for the PillarPriorities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarPriorities(Collection<String> pillarPriorities);

        /**
         * Sets the value of the PillarPriorities property for this object.
         *
         * @param pillarPriorities
         *        The new value for the PillarPriorities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarPriorities(String... pillarPriorities);

        /**
         * Sets the value of the ArchitecturalDesign property for this object.
         *
         * @param architecturalDesign
         *        The new value for the ArchitecturalDesign property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturalDesign(String architecturalDesign);

        /**
         * Sets the value of the ReviewOwner property for this object.
         *
         * @param reviewOwner
         *        The new value for the ReviewOwner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewOwner(String reviewOwner);

        /**
         * <p>
         * Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.
         * </p>
         * <p>
         * If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the
         * workload is restricted until an owner is added.
         * </p>
         * 
         * @param isReviewOwnerUpdateAcknowledged
         *        Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is
         *        required.</p>
         *        <p>
         *        If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the
         *        workload is restricted until an owner is added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged);

        /**
         * Sets the value of the IndustryType property for this object.
         *
         * @param industryType
         *        The new value for the IndustryType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder industryType(String industryType);

        /**
         * Sets the value of the Industry property for this object.
         *
         * @param industry
         *        The new value for the Industry property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder industry(String industry);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * Sets the value of the ImprovementStatus property for this object.
         *
         * @param improvementStatus
         *        The new value for the ImprovementStatus property for this object.
         * @see WorkloadImprovementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadImprovementStatus
         */
        Builder improvementStatus(String improvementStatus);

        /**
         * Sets the value of the ImprovementStatus property for this object.
         *
         * @param improvementStatus
         *        The new value for the ImprovementStatus property for this object.
         * @see WorkloadImprovementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadImprovementStatus
         */
        Builder improvementStatus(WorkloadImprovementStatus improvementStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String workloadId;

        private String workloadName;

        private String description;

        private String environment;

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();

        private List<String> nonAwsRegions = DefaultSdkAutoConstructList.getInstance();

        private List<String> pillarPriorities = DefaultSdkAutoConstructList.getInstance();

        private String architecturalDesign;

        private String reviewOwner;

        private Boolean isReviewOwnerUpdateAcknowledged;

        private String industryType;

        private String industry;

        private String notes;

        private String improvementStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadRequest model) {
            super(model);
            workloadId(model.workloadId);
            workloadName(model.workloadName);
            description(model.description);
            environment(model.environment);
            accountIds(model.accountIds);
            awsRegions(model.awsRegions);
            nonAwsRegions(model.nonAwsRegions);
            pillarPriorities(model.pillarPriorities);
            architecturalDesign(model.architecturalDesign);
            reviewOwner(model.reviewOwner);
            isReviewOwnerUpdateAcknowledged(model.isReviewOwnerUpdateAcknowledged);
            industryType(model.industryType);
            industry(model.industry);
            notes(model.notes);
            improvementStatus(model.improvementStatus);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        @Transient
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        @Transient
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironment() {
            return environment;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        @Override
        @Transient
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Override
        @Transient
        public final Builder environment(WorkloadEnvironment environment) {
            this.environment(environment == null ? null : environment.toString());
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
        }

        @Override
        @Transient
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getAwsRegions() {
            if (awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return awsRegions;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
        }

        @Override
        @Transient
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder awsRegions(String... awsRegions) {
            awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final Collection<String> getNonAwsRegions() {
            if (nonAwsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return nonAwsRegions;
        }

        public final void setNonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
        }

        @Override
        @Transient
        public final Builder nonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nonAwsRegions(String... nonAwsRegions) {
            nonAwsRegions(Arrays.asList(nonAwsRegions));
            return this;
        }

        public final Collection<String> getPillarPriorities() {
            if (pillarPriorities instanceof SdkAutoConstructList) {
                return null;
            }
            return pillarPriorities;
        }

        public final void setPillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
        }

        @Override
        @Transient
        public final Builder pillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pillarPriorities(String... pillarPriorities) {
            pillarPriorities(Arrays.asList(pillarPriorities));
            return this;
        }

        public final String getArchitecturalDesign() {
            return architecturalDesign;
        }

        public final void setArchitecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
        }

        @Override
        @Transient
        public final Builder architecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
            return this;
        }

        public final String getReviewOwner() {
            return reviewOwner;
        }

        public final void setReviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
        }

        @Override
        @Transient
        public final Builder reviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
            return this;
        }

        public final Boolean getIsReviewOwnerUpdateAcknowledged() {
            return isReviewOwnerUpdateAcknowledged;
        }

        public final void setIsReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
        }

        @Override
        @Transient
        public final Builder isReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
            return this;
        }

        public final String getIndustryType() {
            return industryType;
        }

        public final void setIndustryType(String industryType) {
            this.industryType = industryType;
        }

        @Override
        @Transient
        public final Builder industryType(String industryType) {
            this.industryType = industryType;
            return this;
        }

        public final String getIndustry() {
            return industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        @Transient
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        @Transient
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getImprovementStatus() {
            return improvementStatus;
        }

        public final void setImprovementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
        }

        @Override
        @Transient
        public final Builder improvementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder improvementStatus(WorkloadImprovementStatus improvementStatus) {
            this.improvementStatus(improvementStatus == null ? null : improvementStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkloadRequest build() {
            return new UpdateWorkloadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
