/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workload share summary return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadShareSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadShareSummary.Builder, WorkloadShareSummary> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareId").getter(getter(WorkloadShareSummary::shareId)).setter(setter(Builder::shareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()).build();

    private static final SdkField<String> SHARED_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedWith").getter(getter(WorkloadShareSummary::sharedWith)).setter(setter(Builder::sharedWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedWith").build()).build();

    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionType").getter(getter(WorkloadShareSummary::permissionTypeAsString))
            .setter(setter(Builder::permissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(WorkloadShareSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD,
            SHARED_WITH_FIELD, PERMISSION_TYPE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shareId;

    private final String sharedWith;

    private final String permissionType;

    private final String status;

    private WorkloadShareSummary(BuilderImpl builder) {
        this.shareId = builder.shareId;
        this.sharedWith = builder.sharedWith;
        this.permissionType = builder.permissionType;
        this.status = builder.status;
    }

    /**
     * Returns the value of the ShareId property for this object.
     * 
     * @return The value of the ShareId property for this object.
     */
    public final String shareId() {
        return shareId;
    }

    /**
     * Returns the value of the SharedWith property for this object.
     * 
     * @return The value of the SharedWith property for this object.
     */
    public final String sharedWith() {
        return sharedWith;
    }

    /**
     * Returns the value of the PermissionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The value of the PermissionType property for this object.
     * @see PermissionType
     */
    public final PermissionType permissionType() {
        return PermissionType.fromValue(permissionType);
    }

    /**
     * Returns the value of the PermissionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The value of the PermissionType property for this object.
     * @see PermissionType
     */
    public final String permissionTypeAsString() {
        return permissionType;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see ShareStatus
     */
    public final ShareStatus status() {
        return ShareStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see ShareStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shareId());
        hashCode = 31 * hashCode + Objects.hashCode(sharedWith());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadShareSummary)) {
            return false;
        }
        WorkloadShareSummary other = (WorkloadShareSummary) obj;
        return Objects.equals(shareId(), other.shareId()) && Objects.equals(sharedWith(), other.sharedWith())
                && Objects.equals(permissionTypeAsString(), other.permissionTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadShareSummary").add("ShareId", shareId()).add("SharedWith", sharedWith())
                .add("PermissionType", permissionTypeAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShareId":
            return Optional.ofNullable(clazz.cast(shareId()));
        case "SharedWith":
            return Optional.ofNullable(clazz.cast(sharedWith()));
        case "PermissionType":
            return Optional.ofNullable(clazz.cast(permissionTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadShareSummary, T> g) {
        return obj -> g.apply((WorkloadShareSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadShareSummary> {
        /**
         * Sets the value of the ShareId property for this object.
         *
         * @param shareId
         *        The new value for the ShareId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareId(String shareId);

        /**
         * Sets the value of the SharedWith property for this object.
         *
         * @param sharedWith
         *        The new value for the SharedWith property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedWith(String sharedWith);

        /**
         * Sets the value of the PermissionType property for this object.
         *
         * @param permissionType
         *        The new value for the PermissionType property for this object.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * Sets the value of the PermissionType property for this object.
         *
         * @param permissionType
         *        The new value for the PermissionType property for this object.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(PermissionType permissionType);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(ShareStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String shareId;

        private String sharedWith;

        private String permissionType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadShareSummary model) {
            shareId(model.shareId);
            sharedWith(model.sharedWith);
            permissionType(model.permissionType);
            status(model.status);
        }

        public final String getShareId() {
            return shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        @Transient
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getSharedWith() {
            return sharedWith;
        }

        public final void setSharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
        }

        @Override
        @Transient
        public final Builder sharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
            return this;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        @Transient
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        @Transient
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public WorkloadShareSummary build() {
            return new WorkloadShareSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
