/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.AnswerReason;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceUpdate;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceUpdatesCopier;
import software.amazon.awssdk.services.wellarchitected.model.SelectedChoicesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnswerRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateAnswerRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::workloadId)).setter(UpdateAnswerRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::lensAlias)).setter(UpdateAnswerRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::questionId)).setter(UpdateAnswerRequest.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("QuestionId").build()}).build();
    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedChoices").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::selectedChoices)).setter(UpdateAnswerRequest.setter(Builder::selectedChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ChoiceUpdate>> CHOICE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ChoiceUpdates").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::choiceUpdates)).setter(UpdateAnswerRequest.setter(Builder::choiceUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceUpdates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChoiceUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::notes)).setter(UpdateAnswerRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsApplicable").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::isApplicable)).setter(UpdateAnswerRequest.setter(Builder::isApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::reasonAsString)).setter(UpdateAnswerRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, LENS_ALIAS_FIELD, QUESTION_ID_FIELD, SELECTED_CHOICES_FIELD, CHOICE_UPDATES_FIELD, NOTES_FIELD, IS_APPLICABLE_FIELD, REASON_FIELD));
    private final String workloadId;
    private final String lensAlias;
    private final String questionId;
    private final List<String> selectedChoices;
    private final Map<String, ChoiceUpdate> choiceUpdates;
    private final String notes;
    private final Boolean isApplicable;
    private final String reason;

    private UpdateAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensAlias = builder.lensAlias;
        this.questionId = builder.questionId;
        this.selectedChoices = builder.selectedChoices;
        this.choiceUpdates = builder.choiceUpdates;
        this.notes = builder.notes;
        this.isApplicable = builder.isApplicable;
        this.reason = builder.reason;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final boolean hasSelectedChoices() {
        return this.selectedChoices != null && !(this.selectedChoices instanceof SdkAutoConstructList);
    }

    public final List<String> selectedChoices() {
        return this.selectedChoices;
    }

    public final boolean hasChoiceUpdates() {
        return this.choiceUpdates != null && !(this.choiceUpdates instanceof SdkAutoConstructMap);
    }

    public final Map<String, ChoiceUpdate> choiceUpdates() {
        return this.choiceUpdates;
    }

    public final String notes() {
        return this.notes;
    }

    public final Boolean isApplicable() {
        return this.isApplicable;
    }

    public final AnswerReason reason() {
        return AnswerReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedChoices() ? this.selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChoiceUpdates() ? this.choiceUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnswerRequest)) {
            return false;
        }
        UpdateAnswerRequest other = (UpdateAnswerRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.questionId(), other.questionId()) && this.hasSelectedChoices() == other.hasSelectedChoices() && Objects.equals(this.selectedChoices(), other.selectedChoices()) && this.hasChoiceUpdates() == other.hasChoiceUpdates() && Objects.equals(this.choiceUpdates(), other.choiceUpdates()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.isApplicable(), other.isApplicable()) && Objects.equals(this.reasonAsString(), other.reasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnswerRequest").add("WorkloadId", (Object)this.workloadId()).add("LensAlias", (Object)this.lensAlias()).add("QuestionId", (Object)this.questionId()).add("SelectedChoices", this.hasSelectedChoices() ? this.selectedChoices() : null).add("ChoiceUpdates", this.hasChoiceUpdates() ? this.choiceUpdates() : null).add("Notes", (Object)this.notes()).add("IsApplicable", (Object)this.isApplicable()).add("Reason", (Object)this.reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "SelectedChoices": {
                return Optional.ofNullable(clazz.cast(this.selectedChoices()));
            }
            case "ChoiceUpdates": {
                return Optional.ofNullable(clazz.cast(this.choiceUpdates()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "IsApplicable": {
                return Optional.ofNullable(clazz.cast(this.isApplicable()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnswerRequest, T> g) {
        return obj -> g.apply((UpdateAnswerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String lensAlias;
        private String questionId;
        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();
        private Map<String, ChoiceUpdate> choiceUpdates = DefaultSdkAutoConstructMap.getInstance();
        private String notes;
        private Boolean isApplicable;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnswerRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.lensAlias(model.lensAlias);
            this.questionId(model.questionId);
            this.selectedChoices(model.selectedChoices);
            this.choiceUpdates(model.choiceUpdates);
            this.notes(model.notes);
            this.isApplicable(model.isApplicable);
            this.reason(model.reason);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        @Transient
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        @Transient
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        @Transient
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final Collection<String> getSelectedChoices() {
            if (this.selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedChoices;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        @Override
        @Transient
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder selectedChoices(String ... selectedChoices) {
            this.selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final Map<String, ChoiceUpdate.Builder> getChoiceUpdates() {
            Map<String, ChoiceUpdate.Builder> result = ChoiceUpdatesCopier.copyToBuilder(this.choiceUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setChoiceUpdates(Map<String, ChoiceUpdate.BuilderImpl> choiceUpdates) {
            this.choiceUpdates = ChoiceUpdatesCopier.copyFromBuilder(choiceUpdates);
        }

        @Override
        @Transient
        public final Builder choiceUpdates(Map<String, ChoiceUpdate> choiceUpdates) {
            this.choiceUpdates = ChoiceUpdatesCopier.copy(choiceUpdates);
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        @Transient
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Boolean getIsApplicable() {
            return this.isApplicable;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        @Transient
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        @Transient
        public final Builder reason(AnswerReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnswerRequest build() {
            return new UpdateAnswerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnswerRequest> {
        public Builder workloadId(String var1);

        public Builder lensAlias(String var1);

        public Builder questionId(String var1);

        public Builder selectedChoices(Collection<String> var1);

        public Builder selectedChoices(String ... var1);

        public Builder choiceUpdates(Map<String, ChoiceUpdate> var1);

        public Builder notes(String var1);

        public Builder isApplicable(Boolean var1);

        public Builder reason(String var1);

        public Builder reason(AnswerReason var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

