/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse;

public class ListWorkloadSharesIterable
implements SdkIterable<ListWorkloadSharesResponse> {
    private final WellArchitectedClient client;
    private final ListWorkloadSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkloadSharesIterable(WellArchitectedClient client, ListWorkloadSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkloadSharesResponseFetcher();
    }

    public Iterator<ListWorkloadSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWorkloadSharesResponseFetcher
    implements SyncPageFetcher<ListWorkloadSharesResponse> {
        private ListWorkloadSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkloadSharesResponse nextPage(ListWorkloadSharesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadSharesIterable.this.client.listWorkloadShares(ListWorkloadSharesIterable.this.firstRequest);
            }
            return ListWorkloadSharesIterable.this.client.listWorkloadShares((ListWorkloadSharesRequest)((Object)ListWorkloadSharesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

