/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLensResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<GetLensResponse.Builder, GetLensResponse> {
    private static final SdkField<Lens> LENS_FIELD = SdkField.<Lens> builder(MarshallingType.SDK_POJO).memberName("Lens")
            .getter(getter(GetLensResponse::lens)).setter(setter(Builder::lens)).constructor(Lens::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lens").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_FIELD));

    private final Lens lens;

    private GetLensResponse(BuilderImpl builder) {
        super(builder);
        this.lens = builder.lens;
    }

    /**
     * <p>
     * A lens return object.
     * </p>
     * 
     * @return A lens return object.
     */
    public final Lens lens() {
        return lens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lens());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensResponse)) {
            return false;
        }
        GetLensResponse other = (GetLensResponse) obj;
        return Objects.equals(lens(), other.lens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLensResponse").add("Lens", lens()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lens":
            return Optional.ofNullable(clazz.cast(lens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLensResponse, T> g) {
        return obj -> g.apply((GetLensResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLensResponse> {
        /**
         * <p>
         * A lens return object.
         * </p>
         * 
         * @param lens
         *        A lens return object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lens(Lens lens);

        /**
         * <p>
         * A lens return object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Lens.Builder} avoiding the need to create
         * one manually via {@link Lens#builder()}.
         *
         * When the {@link Consumer} completes, {@link Lens.Builder#build()} is called immediately and its result is
         * passed to {@link #lens(Lens)}.
         * 
         * @param lens
         *        a consumer that will call methods on {@link Lens.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lens(Lens)
         */
        default Builder lens(Consumer<Lens.Builder> lens) {
            return lens(Lens.builder().applyMutation(lens).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private Lens lens;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensResponse model) {
            super(model);
            lens(model.lens);
        }

        public final Lens.Builder getLens() {
            return lens != null ? lens.toBuilder() : null;
        }

        public final void setLens(Lens.BuilderImpl lens) {
            this.lens = lens != null ? lens.build() : null;
        }

        @Override
        public final Builder lens(Lens lens) {
            this.lens = lens;
            return this;
        }

        @Override
        public GetLensResponse build() {
            return new GetLensResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
