/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLensSharesResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListLensSharesResponse.Builder, ListLensSharesResponse> {
    private static final SdkField<List<LensShareSummary>> LENS_SHARE_SUMMARIES_FIELD = SdkField
            .<List<LensShareSummary>> builder(MarshallingType.LIST)
            .memberName("LensShareSummaries")
            .getter(getter(ListLensSharesResponse::lensShareSummaries))
            .setter(setter(Builder::lensShareSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensShareSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LensShareSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LensShareSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLensSharesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_SHARE_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LensShareSummary> lensShareSummaries;

    private final String nextToken;

    private ListLensSharesResponse(BuilderImpl builder) {
        super(builder);
        this.lensShareSummaries = builder.lensShareSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LensShareSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLensShareSummaries() {
        return lensShareSummaries != null && !(lensShareSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lens share summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLensShareSummaries} method.
     * </p>
     * 
     * @return A list of lens share summaries.
     */
    public final List<LensShareSummary> lensShareSummaries() {
        return lensShareSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLensShareSummaries() ? lensShareSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensSharesResponse)) {
            return false;
        }
        ListLensSharesResponse other = (ListLensSharesResponse) obj;
        return hasLensShareSummaries() == other.hasLensShareSummaries()
                && Objects.equals(lensShareSummaries(), other.lensShareSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLensSharesResponse")
                .add("LensShareSummaries", hasLensShareSummaries() ? lensShareSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensShareSummaries":
            return Optional.ofNullable(clazz.cast(lensShareSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLensSharesResponse, T> g) {
        return obj -> g.apply((ListLensSharesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLensSharesResponse> {
        /**
         * <p>
         * A list of lens share summaries.
         * </p>
         * 
         * @param lensShareSummaries
         *        A list of lens share summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensShareSummaries(Collection<LensShareSummary> lensShareSummaries);

        /**
         * <p>
         * A list of lens share summaries.
         * </p>
         * 
         * @param lensShareSummaries
         *        A list of lens share summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensShareSummaries(LensShareSummary... lensShareSummaries);

        /**
         * <p>
         * A list of lens share summaries.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LensShareSummary>.Builder} avoiding
         * the need to create one manually via {@link List<LensShareSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LensShareSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #lensShareSummaries(List<LensShareSummary>)}.
         * 
         * @param lensShareSummaries
         *        a consumer that will call methods on {@link List<LensShareSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lensShareSummaries(List<LensShareSummary>)
         */
        Builder lensShareSummaries(Consumer<LensShareSummary.Builder>... lensShareSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private List<LensShareSummary> lensShareSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensSharesResponse model) {
            super(model);
            lensShareSummaries(model.lensShareSummaries);
            nextToken(model.nextToken);
        }

        public final List<LensShareSummary.Builder> getLensShareSummaries() {
            List<LensShareSummary.Builder> result = LensShareSummariesCopier.copyToBuilder(this.lensShareSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLensShareSummaries(Collection<LensShareSummary.BuilderImpl> lensShareSummaries) {
            this.lensShareSummaries = LensShareSummariesCopier.copyFromBuilder(lensShareSummaries);
        }

        @Override
        public final Builder lensShareSummaries(Collection<LensShareSummary> lensShareSummaries) {
            this.lensShareSummaries = LensShareSummariesCopier.copy(lensShareSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensShareSummaries(LensShareSummary... lensShareSummaries) {
            lensShareSummaries(Arrays.asList(lensShareSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensShareSummaries(Consumer<LensShareSummary.Builder>... lensShareSummaries) {
            lensShareSummaries(Stream.of(lensShareSummaries).map(c -> LensShareSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLensSharesResponse build() {
            return new ListLensSharesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
