/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user input is not valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends WellArchitectedException implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ValidationException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<List<ValidationExceptionField>> FIELDS_FIELD = SdkField
            .<List<ValidationExceptionField>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(ValidationException::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationExceptionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationExceptionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final List<ValidationExceptionField> fields;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.fields = builder.fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see ValidationExceptionReason
     */
    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(reason);
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see ValidationExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Fields property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The value of the Fields property for this object.
     */
    public List<ValidationExceptionField> fields() {
        return fields;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>, WellArchitectedException.Builder {
        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(String reason);

        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(ValidationExceptionReason reason);

        /**
         * Sets the value of the Fields property for this object.
         *
         * @param fields
         *        The new value for the Fields property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<ValidationExceptionField> fields);

        /**
         * Sets the value of the Fields property for this object.
         *
         * @param fields
         *        The new value for the Fields property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(ValidationExceptionField... fields);

        /**
         * Sets the value of the Fields property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<ValidationExceptionField>.Builder}
         * avoiding the need to create one manually via {@link List<ValidationExceptionField>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationExceptionField>.Builder#build()} is called
         * immediately and its result is passed to {@link #fields(List<ValidationExceptionField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on {@link List<ValidationExceptionField>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(List<ValidationExceptionField>)
         */
        Builder fields(Consumer<ValidationExceptionField.Builder>... fields);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends WellArchitectedException.BuilderImpl implements Builder {
        private String reason;

        private List<ValidationExceptionField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            reason(model.reason);
            fields(model.fields);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final List<ValidationExceptionField.Builder> getFields() {
            List<ValidationExceptionField.Builder> result = ValidationExceptionFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<ValidationExceptionField.BuilderImpl> fields) {
            this.fields = ValidationExceptionFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<ValidationExceptionField> fields) {
            this.fields = ValidationExceptionFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(ValidationExceptionField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<ValidationExceptionField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> ValidationExceptionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
