/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.wellarchitected.model.AccessDeniedException;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ConflictException;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensVersionRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensVersionResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ExportLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.ExportLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.ImportLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.ImportLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.InternalServerException;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ResourceNotFoundException;
import software.amazon.awssdk.services.wellarchitected.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.wellarchitected.model.TagResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.TagResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.ThrottlingException;
import software.amazon.awssdk.services.wellarchitected.model.UntagResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.UntagResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.ValidationException;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedException;
import software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable;

/**
 * Service client for accessing Well-Architected. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Well-Architected Tool</fullname>
 * <p>
 * This is the <i>Well-Architected Tool API Reference</i>. The WA Tool API provides programmatic access to the <a
 * href="http://aws.amazon.com/well-architected-tool">Well-Architected Tool</a> in the <a
 * href="https://console.aws.amazon.com/wellarchitected">Amazon Web Services Management Console</a>. For information
 * about the Well-Architected Tool, see the <a
 * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html">Well-Architected Tool User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WellArchitectedClient extends SdkClient {
    String SERVICE_NAME = "wellarchitected";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "wellarchitected";

    /**
     * Create a {@link WellArchitectedClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WellArchitectedClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WellArchitectedClient}.
     */
    static WellArchitectedClientBuilder builder() {
        return new DefaultWellArchitectedClientBuilder();
    }

    /**
     * <p>
     * Associate a lens to a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be
     * associated with a workload.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you
     * acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in
     * the Amazon Web Services Customer Agreement.
     * </p>
     * </note>
     *
     * @param associateLensesRequest
     *        Input to associate lens reviews.
     * @return Result of the AssociateLenses operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.AssociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLensesResponse associateLenses(AssociateLensesRequest associateLensesRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a lens to a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be
     * associated with a workload.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you
     * acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in
     * the Amazon Web Services Customer Agreement.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLensesRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateLensesRequest#builder()}
     * </p>
     *
     * @param associateLensesRequest
     *        A {@link Consumer} that will call methods on {@link AssociateLensesInput.Builder} to create a request.
     *        Input to associate lens reviews.
     * @return Result of the AssociateLenses operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.AssociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLensesResponse associateLenses(Consumer<AssociateLensesRequest.Builder> associateLensesRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return associateLenses(AssociateLensesRequest.builder().applyMutation(associateLensesRequest).build());
    }

    /**
     * <p>
     * Create a lens share.
     * </p>
     * <p>
     * The owner of a lens can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web
     * Services Region. Shared access to a lens is not removed until the lens invitation is deleted.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note>
     *
     * @param createLensShareRequest
     * @return Result of the CreateLensShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLensShareResponse createLensShare(CreateLensShareRequest createLensShareRequest) throws ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a lens share.
     * </p>
     * <p>
     * The owner of a lens can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web
     * Services Region. Shared access to a lens is not removed until the lens invitation is deleted.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLensShareRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLensShareRequest#builder()}
     * </p>
     *
     * @param createLensShareRequest
     *        A {@link Consumer} that will call methods on {@link CreateLensShareInput.Builder} to create a request.
     * @return Result of the CreateLensShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLensShareResponse createLensShare(Consumer<CreateLensShareRequest.Builder> createLensShareRequest)
            throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return createLensShare(CreateLensShareRequest.builder().applyMutation(createLensShareRequest).build());
    }

    /**
     * <p>
     * Create a new lens version.
     * </p>
     * <p>
     * A lens can have up to 100 versions.
     * </p>
     * <p>
     * After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens
     * with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a
     * lens can delete it.
     * </p>
     *
     * @param createLensVersionRequest
     * @return Result of the CreateLensVersion operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateLensVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLensVersionResponse createLensVersion(CreateLensVersionRequest createLensVersionRequest)
            throws ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new lens version.
     * </p>
     * <p>
     * A lens can have up to 100 versions.
     * </p>
     * <p>
     * After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens
     * with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a
     * lens can delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLensVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLensVersionRequest#builder()}
     * </p>
     *
     * @param createLensVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLensVersionInput.Builder} to create a request.
     * @return Result of the CreateLensVersion operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateLensVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLensVersionResponse createLensVersion(Consumer<CreateLensVersionRequest.Builder> createLensVersionRequest)
            throws ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return createLensVersion(CreateLensVersionRequest.builder().applyMutation(createLensVersionRequest).build());
    }

    /**
     * <p>
     * Create a milestone for an existing workload.
     * </p>
     *
     * @param createMilestoneRequest
     *        Input for milestone creation.
     * @return Result of the CreateMilestone operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMilestoneResponse createMilestone(CreateMilestoneRequest createMilestoneRequest) throws ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a milestone for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMilestoneRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMilestoneRequest#builder()}
     * </p>
     *
     * @param createMilestoneRequest
     *        A {@link Consumer} that will call methods on {@link CreateMilestoneInput.Builder} to create a request.
     *        Input for milestone creation.
     * @return Result of the CreateMilestone operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMilestoneResponse createMilestone(Consumer<CreateMilestoneRequest.Builder> createMilestoneRequest)
            throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return createMilestone(CreateMilestoneRequest.builder().applyMutation(createMilestoneRequest).build());
    }

    /**
     * <p>
     * Create a new workload.
     * </p>
     * <p>
     * The owner of a workload can share the workload with other Amazon Web Services accounts and IAM users in the same
     * Amazon Web Services Region. Only the owner of a workload can delete it.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     *
     * @param createWorkloadRequest
     *        Input for workload creation.
     * @return Result of the CreateWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadResponse createWorkload(CreateWorkloadRequest createWorkloadRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new workload.
     * </p>
     * <p>
     * The owner of a workload can share the workload with other Amazon Web Services accounts and IAM users in the same
     * Amazon Web Services Region. Only the owner of a workload can delete it.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkloadRequest#builder()}
     * </p>
     *
     * @param createWorkloadRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkloadInput.Builder} to create a request.
     *        Input for workload creation.
     * @return Result of the CreateWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadResponse createWorkload(Consumer<CreateWorkloadRequest.Builder> createWorkloadRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return createWorkload(CreateWorkloadRequest.builder().applyMutation(createWorkloadRequest).build());
    }

    /**
     * <p>
     * Create a workload share.
     * </p>
     * <p>
     * The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web
     * Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a Workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     *
     * @param createWorkloadShareRequest
     *        Input for Create Workload Share
     * @return Result of the CreateWorkloadShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadShareResponse createWorkloadShare(CreateWorkloadShareRequest createWorkloadShareRequest)
            throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a workload share.
     * </p>
     * <p>
     * The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web
     * Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a Workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkloadShareRequest#builder()}
     * </p>
     *
     * @param createWorkloadShareRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkloadShareInput.Builder} to create a request.
     *        Input for Create Workload Share
     * @return Result of the CreateWorkloadShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.CreateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadShareResponse createWorkloadShare(
            Consumer<CreateWorkloadShareRequest.Builder> createWorkloadShareRequest) throws ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return createWorkloadShare(CreateWorkloadShareRequest.builder().applyMutation(createWorkloadShareRequest).build());
    }

    /**
     * <p>
     * Delete an existing lens.
     * </p>
     * <p>
     * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users
     * that you shared the lens with can continue to use it, but they will no longer be able to apply it to new
     * workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note>
     *
     * @param deleteLensRequest
     * @return Result of the DeleteLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLens" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLensResponse deleteLens(DeleteLensRequest deleteLensRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing lens.
     * </p>
     * <p>
     * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users
     * that you shared the lens with can continue to use it, but they will no longer be able to apply it to new
     * workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLensRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLensRequest#builder()}
     * </p>
     *
     * @param deleteLensRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLensInput.Builder} to create a request.
     * @return Result of the DeleteLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLens" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLensResponse deleteLens(Consumer<DeleteLensRequest.Builder> deleteLensRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        return deleteLens(DeleteLensRequest.builder().applyMutation(deleteLensRequest).build());
    }

    /**
     * <p>
     * Delete a lens share.
     * </p>
     * <p>
     * After the lens share is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can
     * continue to use it, but they will no longer be able to apply it to new workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note>
     *
     * @param deleteLensShareRequest
     * @return Result of the DeleteLensShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLensShareResponse deleteLensShare(DeleteLensShareRequest deleteLensShareRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a lens share.
     * </p>
     * <p>
     * After the lens share is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can
     * continue to use it, but they will no longer be able to apply it to new workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLensShareRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLensShareRequest#builder()}
     * </p>
     *
     * @param deleteLensShareRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLensShareInput.Builder} to create a request.
     * @return Result of the DeleteLensShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLensShareResponse deleteLensShare(Consumer<DeleteLensShareRequest.Builder> deleteLensShareRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return deleteLensShare(DeleteLensShareRequest.builder().applyMutation(deleteLensShareRequest).build());
    }

    /**
     * <p>
     * Delete an existing workload.
     * </p>
     *
     * @param deleteWorkloadRequest
     *        Input for workload deletion.
     * @return Result of the DeleteWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadResponse deleteWorkload(DeleteWorkloadRequest deleteWorkloadRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkloadRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkloadInput.Builder} to create a request.
     *        Input for workload deletion.
     * @return Result of the DeleteWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadResponse deleteWorkload(Consumer<DeleteWorkloadRequest.Builder> deleteWorkloadRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return deleteWorkload(DeleteWorkloadRequest.builder().applyMutation(deleteWorkloadRequest).build());
    }

    /**
     * <p>
     * Delete a workload share.
     * </p>
     *
     * @param deleteWorkloadShareRequest
     *        Input for Delete Workload Share
     * @return Result of the DeleteWorkloadShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadShareResponse deleteWorkloadShare(DeleteWorkloadShareRequest deleteWorkloadShareRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a workload share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkloadShareRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadShareRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkloadShareInput.Builder} to create a request.
     *        Input for Delete Workload Share
     * @return Result of the DeleteWorkloadShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DeleteWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadShareResponse deleteWorkloadShare(
            Consumer<DeleteWorkloadShareRequest.Builder> deleteWorkloadShareRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        return deleteWorkloadShare(DeleteWorkloadShareRequest.builder().applyMutation(deleteWorkloadShareRequest).build());
    }

    /**
     * <p>
     * Disassociate a lens from a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be disassociated from a workload in a single API operation.
     * </p>
     * <note>
     * <p>
     * The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a
     * workload.
     * </p>
     * </note>
     *
     * @param disassociateLensesRequest
     *        Input to disassociate lens reviews.
     * @return Result of the DisassociateLenses operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DisassociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLensesResponse disassociateLenses(DisassociateLensesRequest disassociateLensesRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate a lens from a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be disassociated from a workload in a single API operation.
     * </p>
     * <note>
     * <p>
     * The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a
     * workload.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLensesRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateLensesRequest#builder()}
     * </p>
     *
     * @param disassociateLensesRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateLensesInput.Builder} to create a request.
     *        Input to disassociate lens reviews.
     * @return Result of the DisassociateLenses operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.DisassociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLensesResponse disassociateLenses(Consumer<DisassociateLensesRequest.Builder> disassociateLensesRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return disassociateLenses(DisassociateLensesRequest.builder().applyMutation(disassociateLensesRequest).build());
    }

    /**
     * <p>
     * Export an existing lens.
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>. Only the owner of a lens can export it.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note>
     *
     * @param exportLensRequest
     * @return Result of the ExportLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ExportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ExportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportLensResponse exportLens(ExportLensRequest exportLensRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Export an existing lens.
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>. Only the owner of a lens can export it.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportLensRequest.Builder} avoiding the need to
     * create one manually via {@link ExportLensRequest#builder()}
     * </p>
     *
     * @param exportLensRequest
     *        A {@link Consumer} that will call methods on {@link ExportLensInput.Builder} to create a request.
     * @return Result of the ExportLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ExportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ExportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportLensResponse exportLens(Consumer<ExportLensRequest.Builder> exportLensRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return exportLens(ExportLensRequest.builder().applyMutation(exportLensRequest).build());
    }

    /**
     * <p>
     * Get the answer to a specific question in a workload review.
     * </p>
     *
     * @param getAnswerRequest
     *        Input to get answer.
     * @return Result of the GetAnswer operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAnswerResponse getAnswer(GetAnswerRequest getAnswerRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the answer to a specific question in a workload review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnswerRequest.Builder} avoiding the need to
     * create one manually via {@link GetAnswerRequest#builder()}
     * </p>
     *
     * @param getAnswerRequest
     *        A {@link Consumer} that will call methods on {@link GetAnswerInput.Builder} to create a request. Input to
     *        get answer.
     * @return Result of the GetAnswer operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAnswerResponse getAnswer(Consumer<GetAnswerRequest.Builder> getAnswerRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return getAnswer(GetAnswerRequest.builder().applyMutation(getAnswerRequest).build());
    }

    /**
     * <p>
     * Get an existing lens.
     * </p>
     *
     * @param getLensRequest
     * @return Result of the GetLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLens" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLensResponse getLens(GetLensRequest getLensRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an existing lens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensRequest.Builder} avoiding the need to create
     * one manually via {@link GetLensRequest#builder()}
     * </p>
     *
     * @param getLensRequest
     *        A {@link Consumer} that will call methods on {@link GetLensInput.Builder} to create a request.
     * @return Result of the GetLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLens" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLensResponse getLens(Consumer<GetLensRequest.Builder> getLensRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return getLens(GetLensRequest.builder().applyMutation(getLensRequest).build());
    }

    /**
     * <p>
     * Get lens review.
     * </p>
     *
     * @param getLensReviewRequest
     *        Input to get lens review.
     * @return Result of the GetLensReview operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLensReviewResponse getLensReview(GetLensReviewRequest getLensReviewRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get lens review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensReviewRequest.Builder} avoiding the need to
     * create one manually via {@link GetLensReviewRequest#builder()}
     * </p>
     *
     * @param getLensReviewRequest
     *        A {@link Consumer} that will call methods on {@link GetLensReviewInput.Builder} to create a request. Input
     *        to get lens review.
     * @return Result of the GetLensReview operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLensReviewResponse getLensReview(Consumer<GetLensReviewRequest.Builder> getLensReviewRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return getLensReview(GetLensReviewRequest.builder().applyMutation(getLensReviewRequest).build());
    }

    /**
     * <p>
     * Get lens review report.
     * </p>
     *
     * @param getLensReviewReportRequest
     *        Input to get lens review report.
     * @return Result of the GetLensReviewReport operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLensReviewReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLensReviewReportResponse getLensReviewReport(GetLensReviewReportRequest getLensReviewReportRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get lens review report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensReviewReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetLensReviewReportRequest#builder()}
     * </p>
     *
     * @param getLensReviewReportRequest
     *        A {@link Consumer} that will call methods on {@link GetLensReviewReportInput.Builder} to create a request.
     *        Input to get lens review report.
     * @return Result of the GetLensReviewReport operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLensReviewReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLensReviewReportResponse getLensReviewReport(
            Consumer<GetLensReviewReportRequest.Builder> getLensReviewReportRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return getLensReviewReport(GetLensReviewReportRequest.builder().applyMutation(getLensReviewReportRequest).build());
    }

    /**
     * <p>
     * Get lens version differences.
     * </p>
     *
     * @param getLensVersionDifferenceRequest
     * @return Result of the GetLensVersionDifference operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLensVersionDifference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLensVersionDifferenceResponse getLensVersionDifference(
            GetLensVersionDifferenceRequest getLensVersionDifferenceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get lens version differences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensVersionDifferenceRequest.Builder} avoiding
     * the need to create one manually via {@link GetLensVersionDifferenceRequest#builder()}
     * </p>
     *
     * @param getLensVersionDifferenceRequest
     *        A {@link Consumer} that will call methods on {@link GetLensVersionDifferenceInput.Builder} to create a
     *        request.
     * @return Result of the GetLensVersionDifference operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetLensVersionDifference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLensVersionDifferenceResponse getLensVersionDifference(
            Consumer<GetLensVersionDifferenceRequest.Builder> getLensVersionDifferenceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return getLensVersionDifference(GetLensVersionDifferenceRequest.builder().applyMutation(getLensVersionDifferenceRequest)
                .build());
    }

    /**
     * <p>
     * Get a milestone for an existing workload.
     * </p>
     *
     * @param getMilestoneRequest
     *        Input to get a milestone.
     * @return Result of the GetMilestone operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMilestoneResponse getMilestone(GetMilestoneRequest getMilestoneRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a milestone for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMilestoneRequest.Builder} avoiding the need to
     * create one manually via {@link GetMilestoneRequest#builder()}
     * </p>
     *
     * @param getMilestoneRequest
     *        A {@link Consumer} that will call methods on {@link GetMilestoneInput.Builder} to create a request. Input
     *        to get a milestone.
     * @return Result of the GetMilestone operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMilestoneResponse getMilestone(Consumer<GetMilestoneRequest.Builder> getMilestoneRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return getMilestone(GetMilestoneRequest.builder().applyMutation(getMilestoneRequest).build());
    }

    /**
     * <p>
     * Get an existing workload.
     * </p>
     *
     * @param getWorkloadRequest
     *        Input to get a workload.
     * @return Result of the GetWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkloadResponse getWorkload(GetWorkloadRequest getWorkloadRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkloadRequest#builder()}
     * </p>
     *
     * @param getWorkloadRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkloadInput.Builder} to create a request. Input
     *        to get a workload.
     * @return Result of the GetWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.GetWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkloadResponse getWorkload(Consumer<GetWorkloadRequest.Builder> getWorkloadRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return getWorkload(GetWorkloadRequest.builder().applyMutation(getWorkloadRequest).build());
    }

    /**
     * <p>
     * Import a new lens.
     * </p>
     * <p>
     * The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published
     * with <a>CreateLensVersion</a>
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <p>
     * A custom lens cannot exceed 500 KB in size.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note>
     *
     * @param importLensRequest
     * @return Result of the ImportLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ImportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ImportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportLensResponse importLens(ImportLensRequest importLensRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import a new lens.
     * </p>
     * <p>
     * The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published
     * with <a>CreateLensVersion</a>
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <p>
     * A custom lens cannot exceed 500 KB in size.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportLensRequest.Builder} avoiding the need to
     * create one manually via {@link ImportLensRequest#builder()}
     * </p>
     *
     * @param importLensRequest
     *        A {@link Consumer} that will call methods on {@link ImportLensInput.Builder} to create a request.
     * @return Result of the ImportLens operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ServiceQuotaExceededException
     *         The user has reached their resource quota.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ImportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ImportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportLensResponse importLens(Consumer<ImportLensRequest.Builder> importLensRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return importLens(ImportLensRequest.builder().applyMutation(importLensRequest).build());
    }

    /**
     * <p>
     * List of answers.
     * </p>
     *
     * @param listAnswersRequest
     *        Input to list answers.
     * @return Result of the ListAnswers operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnswersResponse listAnswers(ListAnswersRequest listAnswersRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of answers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnswersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnswersRequest#builder()}
     * </p>
     *
     * @param listAnswersRequest
     *        A {@link Consumer} that will call methods on {@link ListAnswersInput.Builder} to create a request. Input
     *        to list answers.
     * @return Result of the ListAnswers operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnswersResponse listAnswers(Consumer<ListAnswersRequest.Builder> listAnswersRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listAnswers(ListAnswersRequest.builder().applyMutation(listAnswersRequest).build());
    }

    /**
     * <p>
     * List of answers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable responses = client.listAnswersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable responses = client
     *             .listAnswersPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable responses = client.listAnswersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation.</b>
     * </p>
     *
     * @param listAnswersRequest
     *        Input to list answers.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnswersIterable listAnswersPaginator(ListAnswersRequest listAnswersRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of answers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable responses = client.listAnswersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable responses = client
     *             .listAnswersPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable responses = client.listAnswersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnswersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnswersRequest#builder()}
     * </p>
     *
     * @param listAnswersRequest
     *        A {@link Consumer} that will call methods on {@link ListAnswersInput.Builder} to create a request. Input
     *        to list answers.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnswersIterable listAnswersPaginator(Consumer<ListAnswersRequest.Builder> listAnswersRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listAnswersPaginator(ListAnswersRequest.builder().applyMutation(listAnswersRequest).build());
    }

    /**
     * <p>
     * List lens review improvements.
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        Input to list lens review improvements.
     * @return Result of the ListLensReviewImprovements operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewImprovementsResponse listLensReviewImprovements(
            ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens review improvements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewImprovementsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLensReviewImprovementsRequest#builder()}
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        A {@link Consumer} that will call methods on {@link ListLensReviewImprovementsInput.Builder} to create a
     *        request. Input to list lens review improvements.
     * @return Result of the ListLensReviewImprovements operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewImprovementsResponse listLensReviewImprovements(
            Consumer<ListLensReviewImprovementsRequest.Builder> listLensReviewImprovementsRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listLensReviewImprovements(ListLensReviewImprovementsRequest.builder()
                .applyMutation(listLensReviewImprovementsRequest).build());
    }

    /**
     * <p>
     * List lens review improvements.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable responses = client.listLensReviewImprovementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable responses = client
     *             .listLensReviewImprovementsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable responses = client.listLensReviewImprovementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        Input to list lens review improvements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewImprovementsIterable listLensReviewImprovementsPaginator(
            ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens review improvements.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable responses = client.listLensReviewImprovementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable responses = client
     *             .listLensReviewImprovementsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable responses = client.listLensReviewImprovementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewImprovementsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLensReviewImprovementsRequest#builder()}
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        A {@link Consumer} that will call methods on {@link ListLensReviewImprovementsInput.Builder} to create a
     *        request. Input to list lens review improvements.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewImprovementsIterable listLensReviewImprovementsPaginator(
            Consumer<ListLensReviewImprovementsRequest.Builder> listLensReviewImprovementsRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listLensReviewImprovementsPaginator(ListLensReviewImprovementsRequest.builder()
                .applyMutation(listLensReviewImprovementsRequest).build());
    }

    /**
     * <p>
     * List lens reviews.
     * </p>
     *
     * @param listLensReviewsRequest
     *        Input to list lens reviews.
     * @return Result of the ListLensReviews operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewsResponse listLensReviews(ListLensReviewsRequest listLensReviewsRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens reviews.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLensReviewsRequest#builder()}
     * </p>
     *
     * @param listLensReviewsRequest
     *        A {@link Consumer} that will call methods on {@link ListLensReviewsInput.Builder} to create a request.
     *        Input to list lens reviews.
     * @return Result of the ListLensReviews operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewsResponse listLensReviews(Consumer<ListLensReviewsRequest.Builder> listLensReviewsRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listLensReviews(ListLensReviewsRequest.builder().applyMutation(listLensReviewsRequest).build());
    }

    /**
     * <p>
     * List lens reviews.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable responses = client.listLensReviewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable responses = client
     *             .listLensReviewsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable responses = client.listLensReviewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLensReviewsRequest
     *        Input to list lens reviews.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewsIterable listLensReviewsPaginator(ListLensReviewsRequest listLensReviewsRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens reviews.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable responses = client.listLensReviewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable responses = client
     *             .listLensReviewsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable responses = client.listLensReviewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLensReviewsRequest#builder()}
     * </p>
     *
     * @param listLensReviewsRequest
     *        A {@link Consumer} that will call methods on {@link ListLensReviewsInput.Builder} to create a request.
     *        Input to list lens reviews.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewsIterable listLensReviewsPaginator(Consumer<ListLensReviewsRequest.Builder> listLensReviewsRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listLensReviewsPaginator(ListLensReviewsRequest.builder().applyMutation(listLensReviewsRequest).build());
    }

    /**
     * <p>
     * List the lens shares associated with the lens.
     * </p>
     *
     * @param listLensSharesRequest
     * @return Result of the ListLensShares operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensSharesResponse listLensShares(ListLensSharesRequest listLensSharesRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the lens shares associated with the lens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensSharesRequest#builder()}
     * </p>
     *
     * @param listLensSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListLensSharesInput.Builder} to create a request.
     * @return Result of the ListLensShares operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensSharesResponse listLensShares(Consumer<ListLensSharesRequest.Builder> listLensSharesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listLensShares(ListLensSharesRequest.builder().applyMutation(listLensSharesRequest).build());
    }

    /**
     * <p>
     * List the lens shares associated with the lens.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable responses = client.listLensSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable responses = client
     *             .listLensSharesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable responses = client.listLensSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLensSharesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensSharesIterable listLensSharesPaginator(ListLensSharesRequest listLensSharesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the lens shares associated with the lens.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable responses = client.listLensSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable responses = client
     *             .listLensSharesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable responses = client.listLensSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensSharesRequest#builder()}
     * </p>
     *
     * @param listLensSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListLensSharesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensSharesIterable listLensSharesPaginator(Consumer<ListLensSharesRequest.Builder> listLensSharesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listLensSharesPaginator(ListLensSharesRequest.builder().applyMutation(listLensSharesRequest).build());
    }

    /**
     * <p>
     * List the available lenses.
     * </p>
     *
     * @param listLensesRequest
     *        Input to list lenses.
     * @return Result of the ListLenses operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLensesResponse listLenses(ListLensesRequest listLensesRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the available lenses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensesRequest#builder()}
     * </p>
     *
     * @param listLensesRequest
     *        A {@link Consumer} that will call methods on {@link ListLensesInput.Builder} to create a request. Input to
     *        list lenses.
     * @return Result of the ListLenses operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLensesResponse listLenses(Consumer<ListLensesRequest.Builder> listLensesRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return listLenses(ListLensesRequest.builder().applyMutation(listLensesRequest).build());
    }

    /**
     * <p>
     * List the available lenses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable responses = client.listLensesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable responses = client.listLensesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable responses = client.listLensesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)} operation.</b>
     * </p>
     *
     * @param listLensesRequest
     *        Input to list lenses.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLensesIterable listLensesPaginator(ListLensesRequest listLensesRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the available lenses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable responses = client.listLensesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable responses = client.listLensesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable responses = client.listLensesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensesRequest#builder()}
     * </p>
     *
     * @param listLensesRequest
     *        A {@link Consumer} that will call methods on {@link ListLensesInput.Builder} to create a request. Input to
     *        list lenses.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLensesIterable listLensesPaginator(Consumer<ListLensesRequest.Builder> listLensesRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listLensesPaginator(ListLensesRequest.builder().applyMutation(listLensesRequest).build());
    }

    /**
     * <p>
     * List all milestones for an existing workload.
     * </p>
     *
     * @param listMilestonesRequest
     *        Input to list all milestones for a workload.
     * @return Result of the ListMilestones operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMilestonesResponse listMilestones(ListMilestonesRequest listMilestonesRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all milestones for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMilestonesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMilestonesRequest#builder()}
     * </p>
     *
     * @param listMilestonesRequest
     *        A {@link Consumer} that will call methods on {@link ListMilestonesInput.Builder} to create a request.
     *        Input to list all milestones for a workload.
     * @return Result of the ListMilestones operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMilestonesResponse listMilestones(Consumer<ListMilestonesRequest.Builder> listMilestonesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listMilestones(ListMilestonesRequest.builder().applyMutation(listMilestonesRequest).build());
    }

    /**
     * <p>
     * List all milestones for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable responses = client.listMilestonesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable responses = client
     *             .listMilestonesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable responses = client.listMilestonesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMilestonesRequest
     *        Input to list all milestones for a workload.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMilestonesIterable listMilestonesPaginator(ListMilestonesRequest listMilestonesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all milestones for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable responses = client.listMilestonesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable responses = client
     *             .listMilestonesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable responses = client.listMilestonesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMilestonesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMilestonesRequest#builder()}
     * </p>
     *
     * @param listMilestonesRequest
     *        A {@link Consumer} that will call methods on {@link ListMilestonesInput.Builder} to create a request.
     *        Input to list all milestones for a workload.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMilestonesIterable listMilestonesPaginator(Consumer<ListMilestonesRequest.Builder> listMilestonesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listMilestonesPaginator(ListMilestonesRequest.builder().applyMutation(listMilestonesRequest).build());
    }

    /**
     * <p>
     * List lens notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return Result of the ListNotifications operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsResponse listNotifications(ListNotificationsRequest listNotificationsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotificationsInput.Builder} to create a request.
     * @return Result of the ListNotifications operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsResponse listNotifications(Consumer<ListNotificationsRequest.Builder> listNotificationsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listNotifications(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * List lens notifications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable responses = client
     *             .listNotificationsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsIterable listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens notifications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable responses = client
     *             .listNotificationsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable responses = client.listNotificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotificationsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsIterable listNotificationsPaginator(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return listNotificationsPaginator(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * List the workload invitations.
     * </p>
     *
     * @param listShareInvitationsRequest
     *        Input for List Share Invitations
     * @return Result of the ListShareInvitations operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListShareInvitationsResponse listShareInvitations(ListShareInvitationsRequest listShareInvitationsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the workload invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListShareInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListShareInvitationsRequest#builder()}
     * </p>
     *
     * @param listShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListShareInvitationsInput.Builder} to create a
     *        request. Input for List Share Invitations
     * @return Result of the ListShareInvitations operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListShareInvitationsResponse listShareInvitations(
            Consumer<ListShareInvitationsRequest.Builder> listShareInvitationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return listShareInvitations(ListShareInvitationsRequest.builder().applyMutation(listShareInvitationsRequest).build());
    }

    /**
     * <p>
     * List the workload invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable responses = client.listShareInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable responses = client
     *             .listShareInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable responses = client.listShareInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listShareInvitationsRequest
     *        Input for List Share Invitations
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListShareInvitationsIterable listShareInvitationsPaginator(ListShareInvitationsRequest listShareInvitationsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the workload invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable responses = client.listShareInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable responses = client
     *             .listShareInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable responses = client.listShareInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListShareInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListShareInvitationsRequest#builder()}
     * </p>
     *
     * @param listShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListShareInvitationsInput.Builder} to create a
     *        request. Input for List Share Invitations
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListShareInvitationsIterable listShareInvitationsPaginator(
            Consumer<ListShareInvitationsRequest.Builder> listShareInvitationsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return listShareInvitationsPaginator(ListShareInvitationsRequest.builder().applyMutation(listShareInvitationsRequest)
                .build());
    }

    /**
     * <p>
     * List the tags for a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     * </p>
     * </note>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List the workload shares associated with the workload.
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        Input for List Workload Share
     * @return Result of the ListWorkloadShares operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadSharesResponse listWorkloadShares(ListWorkloadSharesRequest listWorkloadSharesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the workload shares associated with the workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadSharesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadSharesRequest#builder()}
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkloadSharesInput.Builder} to create a request.
     *        Input for List Workload Share
     * @return Result of the ListWorkloadShares operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadSharesResponse listWorkloadShares(Consumer<ListWorkloadSharesRequest.Builder> listWorkloadSharesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return listWorkloadShares(ListWorkloadSharesRequest.builder().applyMutation(listWorkloadSharesRequest).build());
    }

    /**
     * <p>
     * List the workload shares associated with the workload.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable responses = client.listWorkloadSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable responses = client
     *             .listWorkloadSharesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable responses = client.listWorkloadSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        Input for List Workload Share
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadSharesIterable listWorkloadSharesPaginator(ListWorkloadSharesRequest listWorkloadSharesRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the workload shares associated with the workload.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable responses = client.listWorkloadSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable responses = client
     *             .listWorkloadSharesPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable responses = client.listWorkloadSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadSharesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadSharesRequest#builder()}
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkloadSharesInput.Builder} to create a request.
     *        Input for List Workload Share
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadSharesIterable listWorkloadSharesPaginator(
            Consumer<ListWorkloadSharesRequest.Builder> listWorkloadSharesRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listWorkloadSharesPaginator(ListWorkloadSharesRequest.builder().applyMutation(listWorkloadSharesRequest).build());
    }

    /**
     * <p>
     * List workloads. Paginated.
     * </p>
     *
     * @param listWorkloadsRequest
     *        Input to list all workloads.
     * @return Result of the ListWorkloads operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsResponse listWorkloads(ListWorkloadsRequest listWorkloadsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List workloads. Paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkloadsInput.Builder} to create a request. Input
     *        to list all workloads.
     * @return Result of the ListWorkloads operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsResponse listWorkloads(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listWorkloads(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * <p>
     * List workloads. Paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable responses = client
     *             .listWorkloadsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkloadsRequest
     *        Input to list all workloads.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsIterable listWorkloadsPaginator(ListWorkloadsRequest listWorkloadsRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List workloads. Paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable responses = client
     *             .listWorkloadsPaginator(request);
     *     for (software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkloadsInput.Builder} to create a request. Input
     *        to list all workloads.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsIterable listWorkloadsPaginator(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return listWorkloadsPaginator(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     * </p>
     * </note>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     * </p>
     * </note>
     * <p>
     * To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:
     * </p>
     * <p>
     * <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code>
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.
     * </p>
     * </note>
     * <p>
     * To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:
     * </p>
     * <p>
     * <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            WellArchitectedException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the answer to a specific question in a workload review.
     * </p>
     *
     * @param updateAnswerRequest
     *        Input to update answer.
     * @return Result of the UpdateAnswer operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAnswerResponse updateAnswer(UpdateAnswerRequest updateAnswerRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the answer to a specific question in a workload review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnswerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAnswerRequest#builder()}
     * </p>
     *
     * @param updateAnswerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnswerInput.Builder} to create a request. Input
     *        to update answer.
     * @return Result of the UpdateAnswer operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAnswerResponse updateAnswer(Consumer<UpdateAnswerRequest.Builder> updateAnswerRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return updateAnswer(UpdateAnswerRequest.builder().applyMutation(updateAnswerRequest).build());
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted into organization sharing features.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return Result of the UpdateGlobalSettings operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGlobalSettingsResponse updateGlobalSettings(UpdateGlobalSettingsRequest updateGlobalSettingsRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted into organization sharing features.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param updateGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGlobalSettingsInput.Builder} to create a
     *        request.
     * @return Result of the UpdateGlobalSettings operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGlobalSettingsResponse updateGlobalSettings(
            Consumer<UpdateGlobalSettingsRequest.Builder> updateGlobalSettingsRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, WellArchitectedException {
        return updateGlobalSettings(UpdateGlobalSettingsRequest.builder().applyMutation(updateGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Update lens review.
     * </p>
     *
     * @param updateLensReviewRequest
     *        Input for update lens review.
     * @return Result of the UpdateLensReview operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLensReviewResponse updateLensReview(UpdateLensReviewRequest updateLensReviewRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update lens review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLensReviewRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLensReviewRequest#builder()}
     * </p>
     *
     * @param updateLensReviewRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLensReviewInput.Builder} to create a request.
     *        Input for update lens review.
     * @return Result of the UpdateLensReview operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLensReviewResponse updateLensReview(Consumer<UpdateLensReviewRequest.Builder> updateLensReviewRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return updateLensReview(UpdateLensReviewRequest.builder().applyMutation(updateLensReviewRequest).build());
    }

    /**
     * <p>
     * Update a workload invitation.
     * </p>
     *
     * @param updateShareInvitationRequest
     *        Input for Update Share Invitation
     * @return Result of the UpdateShareInvitation operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateShareInvitationResponse updateShareInvitation(UpdateShareInvitationRequest updateShareInvitationRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a workload invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateShareInvitationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateShareInvitationRequest#builder()}
     * </p>
     *
     * @param updateShareInvitationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateShareInvitationInput.Builder} to create a
     *        request. Input for Update Share Invitation
     * @return Result of the UpdateShareInvitation operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateShareInvitationResponse updateShareInvitation(
            Consumer<UpdateShareInvitationRequest.Builder> updateShareInvitationRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        return updateShareInvitation(UpdateShareInvitationRequest.builder().applyMutation(updateShareInvitationRequest).build());
    }

    /**
     * <p>
     * Update an existing workload.
     * </p>
     *
     * @param updateWorkloadRequest
     *        Input to update a workload.
     * @return Result of the UpdateWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadResponse updateWorkload(UpdateWorkloadRequest updateWorkloadRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkloadRequest#builder()}
     * </p>
     *
     * @param updateWorkloadRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkloadInput.Builder} to create a request.
     *        Input to update a workload.
     * @return Result of the UpdateWorkload operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadResponse updateWorkload(Consumer<UpdateWorkloadRequest.Builder> updateWorkloadRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return updateWorkload(UpdateWorkloadRequest.builder().applyMutation(updateWorkloadRequest).build());
    }

    /**
     * <p>
     * Update a workload share.
     * </p>
     *
     * @param updateWorkloadShareRequest
     *        Input for Update Workload Share
     * @return Result of the UpdateWorkloadShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadShareResponse updateWorkloadShare(UpdateWorkloadShareRequest updateWorkloadShareRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a workload share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkloadShareRequest#builder()}
     * </p>
     *
     * @param updateWorkloadShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkloadShareInput.Builder} to create a request.
     *        Input for Update Workload Share
     * @return Result of the UpdateWorkloadShare operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpdateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadShareResponse updateWorkloadShare(
            Consumer<UpdateWorkloadShareRequest.Builder> updateWorkloadShareRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, WellArchitectedException {
        return updateWorkloadShare(UpdateWorkloadShareRequest.builder().applyMutation(updateWorkloadShareRequest).build());
    }

    /**
     * <p>
     * Upgrade lens review.
     * </p>
     *
     * @param upgradeLensReviewRequest
     * @return Result of the UpgradeLensReview operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpgradeLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default UpgradeLensReviewResponse upgradeLensReview(UpgradeLensReviewRequest upgradeLensReviewRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upgrade lens review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeLensReviewRequest.Builder} avoiding the need
     * to create one manually via {@link UpgradeLensReviewRequest#builder()}
     * </p>
     *
     * @param upgradeLensReviewRequest
     *        A {@link Consumer} that will call methods on {@link UpgradeLensReviewInput.Builder} to create a request.
     * @return Result of the UpgradeLensReview operation returned by the service.
     * @throws ValidationException
     *         The user input is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ConflictException
     *         The resource already exists.
     * @throws InternalServerException
     *         There is a problem with the Well-Architected Tool API service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WellArchitectedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WellArchitectedClient.UpgradeLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default UpgradeLensReviewResponse upgradeLensReview(Consumer<UpgradeLensReviewRequest.Builder> upgradeLensReviewRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return upgradeLensReview(UpgradeLensReviewRequest.builder().applyMutation(upgradeLensReviewRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
